/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ddf.EscherChildAnchorRecord;
import org.apache.poi.ddf.EscherClientAnchorRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.EscherSpgrRecord;
import org.apache.poi.hslf.model.Hyperlink;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.ShapeFactory;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.util.LittleEndian;

public class ShapeGroup
extends Shape {
    public ShapeGroup() {
        this(null, null);
        this._escherContainer = this.createSpContainer(false);
    }

    protected ShapeGroup(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    public Shape[] getShapes() {
        List lst = this._escherContainer.getChildRecords();
        ArrayList<Shape> shapeList = new ArrayList<Shape>();
        for (int i = 1; i < lst.size(); ++i) {
            EscherRecord r = (EscherRecord)lst.get(i);
            if (r instanceof EscherContainerRecord) {
                EscherContainerRecord container = (EscherContainerRecord)r;
                Shape shape = ShapeFactory.createShape(container, this);
                shape.setSheet(this.getSheet());
                shapeList.add(shape);
                continue;
            }
            this.logger.log(7, "Shape contained non container escher record, was " + r.getClass().getName());
        }
        Shape[] shapes = shapeList.toArray(new Shape[shapeList.size()]);
        return shapes;
    }

    public void setAnchor(Rectangle anchor) {
        EscherContainerRecord spContainer = (EscherContainerRecord)this._escherContainer.getChildRecords().get(0);
        EscherClientAnchorRecord clientAnchor = (EscherClientAnchorRecord)ShapeGroup.getEscherChild(spContainer, -4080);
        byte[] header = new byte[16];
        LittleEndian.putUShort(header, 0, 0);
        LittleEndian.putUShort(header, 2, 0);
        LittleEndian.putInt(header, 4, 8);
        clientAnchor.fillFields(header, 0, null);
        clientAnchor.setFlag((short)(anchor.y * 576 / 72));
        clientAnchor.setCol1((short)(anchor.x * 576 / 72));
        clientAnchor.setDx1((short)((anchor.width + anchor.x) * 576 / 72));
        clientAnchor.setRow1((short)((anchor.height + anchor.y) * 576 / 72));
        EscherSpgrRecord spgr = (EscherSpgrRecord)ShapeGroup.getEscherChild(spContainer, -4087);
        spgr.setRectX1(anchor.x * 576 / 72);
        spgr.setRectY1(anchor.y * 576 / 72);
        spgr.setRectX2((anchor.x + anchor.width) * 576 / 72);
        spgr.setRectY2((anchor.y + anchor.height) * 576 / 72);
    }

    public void setCoordinates(Rectangle2D anchor) {
        EscherContainerRecord spContainer = (EscherContainerRecord)this._escherContainer.getChildRecords().get(0);
        EscherSpgrRecord spgr = (EscherSpgrRecord)ShapeGroup.getEscherChild(spContainer, -4087);
        int x1 = (int)Math.round(anchor.getX() * 576.0 / 72.0);
        int y1 = (int)Math.round(anchor.getY() * 576.0 / 72.0);
        int x2 = (int)Math.round((anchor.getX() + anchor.getWidth()) * 576.0 / 72.0);
        int y2 = (int)Math.round((anchor.getY() + anchor.getHeight()) * 576.0 / 72.0);
        spgr.setRectX1(x1);
        spgr.setRectY1(y1);
        spgr.setRectX2(x2);
        spgr.setRectY2(y2);
    }

    public Rectangle2D getCoordinates() {
        EscherContainerRecord spContainer = (EscherContainerRecord)this._escherContainer.getChildRecords().get(0);
        EscherSpgrRecord spgr = (EscherSpgrRecord)ShapeGroup.getEscherChild(spContainer, -4087);
        Rectangle2D.Float anchor = new Rectangle2D.Float();
        anchor.x = (float)spgr.getRectX1() * 72.0f / 576.0f;
        anchor.y = (float)spgr.getRectY1() * 72.0f / 576.0f;
        anchor.width = (float)(spgr.getRectX2() - spgr.getRectX1()) * 72.0f / 576.0f;
        anchor.height = (float)(spgr.getRectY2() - spgr.getRectY1()) * 72.0f / 576.0f;
        return anchor;
    }

    protected EscherContainerRecord createSpContainer(boolean isChild) {
        EscherContainerRecord spgr = new EscherContainerRecord();
        spgr.setRecordId((short)-4093);
        spgr.setOptions((short)15);
        EscherContainerRecord spcont = new EscherContainerRecord();
        spcont.setRecordId((short)-4092);
        spcont.setOptions((short)15);
        EscherSpgrRecord spg = new EscherSpgrRecord();
        spg.setOptions((short)1);
        spcont.addChildRecord(spg);
        EscherSpRecord sp = new EscherSpRecord();
        short type = 2;
        sp.setOptions(type);
        sp.setFlags(513);
        spcont.addChildRecord(sp);
        EscherClientAnchorRecord anchor = new EscherClientAnchorRecord();
        spcont.addChildRecord(anchor);
        spgr.addChildRecord(spcont);
        return spgr;
    }

    public void addShape(Shape shape) {
        this._escherContainer.addChildRecord(shape.getSpContainer());
        Sheet sheet = this.getSheet();
        shape.setSheet(sheet);
        shape.setShapeId(sheet.allocateShapeId());
        shape.afterInsert(sheet);
    }

    public void moveTo(int x, int y) {
        Rectangle anchor = this.getAnchor();
        int dx = x - anchor.x;
        int dy = y - anchor.y;
        anchor.translate(dx, dy);
        this.setAnchor(anchor);
        Shape[] shape = this.getShapes();
        for (int i = 0; i < shape.length; ++i) {
            Rectangle chanchor = shape[i].getAnchor();
            chanchor.translate(dx, dy);
            shape[i].setAnchor(chanchor);
        }
    }

    public Rectangle2D getAnchor2D() {
        EscherContainerRecord spContainer = (EscherContainerRecord)this._escherContainer.getChildRecords().get(0);
        EscherClientAnchorRecord clientAnchor = (EscherClientAnchorRecord)ShapeGroup.getEscherChild(spContainer, -4080);
        Rectangle2D.Float anchor = new Rectangle2D.Float();
        if (clientAnchor == null) {
            this.logger.log(3, "EscherClientAnchorRecord was not found for shape group. Searching for EscherChildAnchorRecord.");
            EscherChildAnchorRecord rec = (EscherChildAnchorRecord)ShapeGroup.getEscherChild(spContainer, -4081);
            anchor = new Rectangle2D.Float((float)rec.getDx1() * 72.0f / 576.0f, (float)rec.getDy1() * 72.0f / 576.0f, (float)(rec.getDx2() - rec.getDx1()) * 72.0f / 576.0f, (float)(rec.getDy2() - rec.getDy1()) * 72.0f / 576.0f);
        } else {
            anchor.x = (float)clientAnchor.getCol1() * 72.0f / 576.0f;
            anchor.y = (float)clientAnchor.getFlag() * 72.0f / 576.0f;
            anchor.width = (float)(clientAnchor.getDx1() - clientAnchor.getCol1()) * 72.0f / 576.0f;
            anchor.height = (float)(clientAnchor.getRow1() - clientAnchor.getFlag()) * 72.0f / 576.0f;
        }
        return anchor;
    }

    public int getShapeType() {
        EscherContainerRecord groupInfoContainer = (EscherContainerRecord)this._escherContainer.getChild(0);
        EscherSpRecord spRecord = groupInfoContainer.getChildById((short)-4086);
        return spRecord.getOptions() >> 4;
    }

    public Hyperlink getHyperlink() {
        return null;
    }

    public void draw(Graphics2D graphics) {
        AffineTransform at = graphics.getTransform();
        Shape[] sh = this.getShapes();
        for (int i = 0; i < sh.length; ++i) {
            sh[i].draw(graphics);
        }
        graphics.setTransform(at);
    }
}

