/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet.jackrabbit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.commons.repository.RepositoryFactory;
import org.apache.jackrabbit.commons.repository.SingletonRepositoryFactory;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.servlet.AbstractRepositoryServlet;

public class JackrabbitRepositoryServlet
extends AbstractRepositoryServlet {
    private static final long serialVersionUID = 7102770011290708450L;
    private JackrabbitRepository repository;

    public void init() throws ServletException {
        try {
            File config;
            File home = new File(this.getInitParameter("repository.home", "jackrabbit-repository"));
            if (!home.exists()) {
                this.log("Creating repository home directory: " + home);
                home.mkdirs();
            }
            if (!(config = new File(this.getInitParameter("repository.config", new File(home, "repository.xml").getPath()))).exists()) {
                this.log("Creating default repository configuration: " + config);
                this.createDefaultConfiguration(config);
            }
            this.repository = RepositoryImpl.create(RepositoryConfig.create(config.toURI(), home.getPath()));
        }
        catch (RepositoryException e) {
            throw new ServletException("Failed to start Jackrabbit", e);
        }
        super.init();
    }

    public void destroy() {
        super.destroy();
        this.repository.shutdown();
    }

    protected RepositoryFactory getRepositoryFactory() {
        return new SingletonRepositoryFactory(this.repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultConfiguration(File config) throws ServletException {
        try {
            FileOutputStream output = new FileOutputStream(config);
            try {
                InputStream input = RepositoryImpl.class.getResourceAsStream("repository.xml");
                try {
                    byte[] buffer = new byte[8192];
                    int n = input.read(buffer);
                    while (n != -1) {
                        ((OutputStream)output).write(buffer, 0, n);
                        n = input.read(buffer);
                    }
                }
                finally {
                    input.close();
                }
            }
            finally {
                ((OutputStream)output).close();
            }
        }
        catch (IOException e) {
            throw new ServletException("Failed to copy default configuration: " + config, e);
        }
    }
}

