/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.AsyncUploadCache;
import org.apache.jackrabbit.core.data.AsyncUploadCacheResult;
import org.apache.jackrabbit.core.data.LazyFileInputStream;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCache {
    static final Logger LOG = LoggerFactory.getLogger(LocalCache.class);
    final Set<String> toBeDeleted = new HashSet<String>();
    LRUCache cache;
    private final File directory;
    private final File tmp;
    private long maxSize;
    private volatile boolean purgeMode;
    private AsyncUploadCache asyncUploadCache;

    public LocalCache(String path, String tmpPath, long size, double cachePurgeTrigFactor, double cachePurgeResizeFactor, AsyncUploadCache asyncUploadCache) throws IOException, ClassNotFoundException {
        this.maxSize = size;
        this.directory = new File(path);
        this.tmp = new File(tmpPath);
        LOG.info("cachePurgeTrigFactor =[{}], cachePurgeResizeFactor =[{}],  cachePurgeTrigFactorSize =[{}], cachePurgeResizeFactorSize =[{}]", new Object[]{cachePurgeTrigFactor, cachePurgeResizeFactor, cachePurgeTrigFactor * (double)size, cachePurgeResizeFactor * (double)size});
        this.cache = new LRUCache(size, cachePurgeTrigFactor, cachePurgeResizeFactor);
        this.asyncUploadCache = asyncUploadCache;
        new Thread(new CacheBuildJob()).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream store(String fileName, InputStream in) throws IOException {
        fileName = fileName.replace("\\", "/");
        File f = this.getFile(fileName);
        long length = 0L;
        LocalCache localCache = this;
        synchronized (localCache) {
            block9: {
                block8: {
                    if (f.exists() && !this.isInPurgeMode()) break block8;
                    BufferedOutputStream out = null;
                    File transFile = null;
                    try {
                        TransientFileFactory tff = TransientFileFactory.getInstance();
                        transFile = tff.createTransientFile("s3-", "tmp", this.tmp);
                        out = new BufferedOutputStream(new FileOutputStream(transFile));
                        length = IOUtils.copyLarge((InputStream)in, (OutputStream)out);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                    if (this.canAdmitFile(length) && (f.getParentFile().exists() || f.getParentFile().mkdirs()) && transFile.renameTo(f) && f.exists()) {
                        if (transFile.exists() && transFile.delete()) {
                            LOG.info("tmp file [{}] not deleted successfully", (Object)transFile.getAbsolutePath());
                        }
                        transFile = null;
                        LOG.debug("file [{}] added to local cache.", (Object)fileName);
                        this.cache.put(fileName, f.length());
                    } else {
                        f = transFile;
                    }
                    break block9;
                }
                f.setLastModified(System.currentTimeMillis());
                this.cache.put(fileName, f.length());
            }
            this.cache.tryPurge();
            return new LazyFileInputStream(f);
        }
    }

    public synchronized File store(String fileName, File src) {
        try {
            return this.store(fileName, src, false).getFile();
        }
        catch (IOException ioe) {
            LOG.warn("Exception in addding file [" + fileName + "] to local cache.", (Throwable)ioe);
            return null;
        }
    }

    public synchronized AsyncUploadCacheResult store(String fileName, File src, boolean tryForAsyncUpload) throws IOException {
        fileName = fileName.replace("\\", "/");
        File dest = this.getFile(fileName);
        File parent = dest.getParentFile();
        AsyncUploadCacheResult result = new AsyncUploadCacheResult();
        result.setFile(src);
        result.setAsyncUpload(false);
        boolean destExists = false;
        destExists = dest.exists();
        if (destExists || src.exists() && !dest.exists() && !src.equals(dest) && this.canAdmitFile(src.length()) && (parent.exists() || parent.mkdirs()) && src.renameTo(dest)) {
            if (destExists) {
                dest.setLastModified(System.currentTimeMillis());
            }
            this.cache.put(fileName, dest.length());
            LOG.debug("file [{}] added to local cache.", (Object)fileName);
            result.setFile(dest);
            if (tryForAsyncUpload) {
                result.setAsyncUpload(this.asyncUploadCache.add(fileName).canAsyncUpload());
            }
        }
        this.cache.tryPurge();
        return result;
    }

    public InputStream getIfStored(String fileName) throws IOException {
        File file = this.getFileIfStored(fileName);
        return file == null ? null : new LazyFileInputStream(file);
    }

    public synchronized File getFileIfStored(String fileName) throws IOException {
        File f = this.getFile(fileName = fileName.replace("\\", "/"));
        if (!f.exists() || this.isInPurgeMode() && !this.asyncUploadCache.hasEntry(fileName, false)) {
            LOG.debug("getFileIfStored returned: purgeMode=[{}], file=[{}] exists=[{}]", new Object[]{this.isInPurgeMode(), fileName, f.exists()});
            return null;
        }
        this.cache.put(fileName, f.length());
        f.setLastModified(System.currentTimeMillis());
        return f;
    }

    public synchronized void delete(String fileName) {
        if (this.isInPurgeMode()) {
            LOG.debug("purgeMode true :delete returned");
            return;
        }
        fileName = fileName.replace("\\", "/");
        this.cache.remove(fileName);
    }

    public synchronized Long getFileLength(String fileName) {
        Long length = null;
        try {
            File f;
            length = (Long)this.cache.get(fileName);
            if (length == null && (f = this.getFileIfStored(fileName)) != null) {
                length = f.length();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return length;
    }

    public void close() {
        LOG.debug("close");
        this.deleteOldFiles();
    }

    private synchronized boolean canAdmitFile(long length) {
        boolean value;
        boolean bl = value = !this.isInPurgeMode() && this.cache.canAdmitFile(length);
        if (!value) {
            LOG.debug("cannot admit file of length=[{}] and currentSizeInBytes=[{}] ", (Object)length, (Object)this.cache.currentSizeInBytes);
        }
        return value;
    }

    synchronized boolean isInPurgeMode() {
        return this.purgeMode;
    }

    synchronized void setPurgeMode(boolean purgeMode) {
        this.purgeMode = purgeMode;
    }

    File getFile(String fileName) {
        return new File(this.directory, fileName);
    }

    private void deleteOldFiles() {
        int initialSize = this.toBeDeleted.size();
        int count = 0;
        for (String n : new ArrayList<String>(this.toBeDeleted)) {
            if (!this.tryDelete(n)) continue;
            ++count;
        }
        LOG.info("deleted [{}]/[{}] files.", (Object)count, (Object)initialSize);
    }

    boolean tryDelete(String fileName) {
        LOG.debug("try deleting file [{}]", (Object)fileName);
        File f = this.getFile(fileName);
        if (f.exists() && f.delete()) {
            LOG.debug("File [{}]  deleted successfully", (Object)fileName);
            this.toBeDeleted.remove(fileName);
            while (!(f = f.getParentFile()).equals(this.directory) && f.list().length <= 0) {
                f.delete();
            }
            return true;
        }
        if (f.exists()) {
            LOG.info("not able to delete file [{}]", (Object)f.getAbsolutePath());
            this.toBeDeleted.add(fileName);
            return false;
        }
        return true;
    }

    static int maxSizeElements(long bytes) {
        int count = (int)(bytes / 65535L);
        count = Math.max(1024, count);
        count = Math.min(65536, count);
        return count;
    }

    private class CacheBuildJob
    implements Runnable {
        private CacheBuildJob() {
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            ArrayList<File> allFiles = new ArrayList<File>();
            Iterator it = FileUtils.iterateFiles((File)LocalCache.this.directory, null, (boolean)true);
            while (it.hasNext()) {
                File f = (File)it.next();
                allFiles.add(f);
            }
            long t1 = System.currentTimeMillis();
            LOG.debug("Time taken to recursive [{}] took [{}] sec", (Object)allFiles.size(), (Object)((t1 - startTime) / 1000L));
            Collections.sort(allFiles, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    long l2;
                    long l1 = o1.lastModified();
                    return l1 < (l2 = o2.lastModified()) ? -1 : (l1 > l2 ? 1 : 0);
                }
            });
            long t2 = System.currentTimeMillis();
            LOG.debug("Time taken to sort [{}] took [{}] sec", (Object)allFiles.size(), (Object)((t2 - t1) / 1000L));
            String dataStorePath = LocalCache.this.directory.getAbsolutePath();
            String tmpPath = LocalCache.this.tmp.getAbsolutePath();
            LOG.debug("tmp path [{}]", (Object)tmpPath);
            long time = System.currentTimeMillis();
            int count = 0;
            for (File f : allFiles) {
                if (!f.exists()) continue;
                ++count;
                String name = f.getPath();
                String filePath = f.getAbsolutePath();
                if (filePath.startsWith(tmpPath)) {
                    LOG.info("tmp file [{}] skipped ", (Object)filePath);
                    continue;
                }
                if (name.startsWith(dataStorePath)) {
                    name = name.substring(dataStorePath.length());
                }
                if ((name = name.replace("\\", "/")).startsWith("/") || name.startsWith("\\")) {
                    name = name.substring(1);
                }
                LocalCache.this.store(name, f);
                long now = System.currentTimeMillis();
                if (now <= time + 10000L) continue;
                LOG.info("Processed {" + count + "}/{" + allFiles.size() + "}");
                time = now;
            }
            LOG.debug("Processed [{}]/[{}], currentSizeInBytes = [{}], maxSizeInBytes = [{}], cache.filecount = [{}]", new Object[]{count, allFiles.size(), LocalCache.this.cache.currentSizeInBytes, LocalCache.this.cache.maxSizeInBytes, LocalCache.this.cache.size()});
            long t3 = System.currentTimeMillis();
            LOG.info("Time to build cache of  [{}] files took [{}] sec", (Object)allFiles.size(), (Object)((t3 - startTime) / 1000L));
        }
    }

    private class PurgeJob
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LRUCache lRUCache = LocalCache.this.cache;
                synchronized (lRUCache) {
                    LOG.info(" cache purge job started");
                    int initialSize = LocalCache.this.cache.size();
                    for (String fileName : new ArrayList<String>(LocalCache.this.toBeDeleted)) {
                        LocalCache.this.cache.remove(fileName);
                    }
                    Iterator itr = LocalCache.this.cache.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = itr.next();
                        if (entry.getKey() == null) continue;
                        if (LocalCache.this.cache.currentSizeInBytes <= LocalCache.this.cache.cachePurgeResize) break;
                        itr.remove();
                    }
                    LOG.info(" cache purge job completed: cleaned [{}] files and currentSizeInBytes = [{}]", (Object)(initialSize - LocalCache.this.cache.size()), (Object)LocalCache.this.cache.currentSizeInBytes);
                }
            }
            catch (Exception e) {
                LOG.error("error in purge jobs:", (Throwable)e);
            }
            finally {
                LocalCache.this.setPurgeMode(false);
            }
        }
    }

    private class LRUCache
    extends LinkedHashMap<String, Long> {
        private static final long serialVersionUID = 1L;
        volatile long currentSizeInBytes;
        final long maxSizeInBytes;
        final long cachePurgeResize;
        final long cachePurgeTrigSize;

        LRUCache(long maxSizeInBytes, double cachePurgeTrigFactor, double cachePurgeResizeFactor) {
            super(LocalCache.maxSizeElements(maxSizeInBytes), 0.75f, true);
            this.maxSizeInBytes = maxSizeInBytes;
            this.cachePurgeTrigSize = new Double(cachePurgeTrigFactor * (double)maxSizeInBytes).longValue();
            this.cachePurgeResize = new Double(cachePurgeResizeFactor * (double)maxSizeInBytes).longValue();
        }

        @Override
        public synchronized Long remove(Object key) {
            String fileName = (String)key;
            fileName = fileName.replace("\\", "/");
            try {
                if (LocalCache.this.asyncUploadCache.hasEntry(fileName, false)) {
                    LOG.info("AsyncUploadCache upload contains file [{}]. Not removing it from LocalCache.", (Object)fileName);
                    return null;
                }
            }
            catch (IOException e) {
                LOG.debug("error: ", (Throwable)e);
                return null;
            }
            Long flength = null;
            if (LocalCache.this.tryDelete(fileName)) {
                flength = (Long)super.remove(key);
                if (flength != null) {
                    LOG.debug("cache entry [{}], with size [{}] removed.", (Object)fileName, (Object)flength);
                    this.currentSizeInBytes -= flength.longValue();
                }
            } else if (!LocalCache.this.getFile(fileName).exists() && (flength = (Long)super.remove(key)) != null) {
                LOG.debug("file not exists. cache entry [{}], with size [{}] removed.", (Object)fileName, (Object)flength);
                this.currentSizeInBytes -= flength.longValue();
            }
            return flength;
        }

        @Override
        public synchronized Long put(String fileName, Long value) {
            Long oldValue = (Long)LocalCache.this.cache.get(fileName);
            if (oldValue == null) {
                long flength = value;
                this.currentSizeInBytes += flength;
                return super.put(fileName.replace("\\", "/"), value);
            }
            LocalCache.this.toBeDeleted.remove(fileName);
            return oldValue;
        }

        synchronized void tryPurge() {
            if (this.currentSizeInBytes > this.cachePurgeTrigSize && !LocalCache.this.isInPurgeMode()) {
                LocalCache.this.setPurgeMode(true);
                LOG.info("currentSizeInBytes=[{}]  exceeds cachePurgeTrigSize=[{}]", (Object)LocalCache.this.cache.currentSizeInBytes, (Object)LocalCache.this.cache.cachePurgeTrigSize);
                new Thread(new PurgeJob()).start();
            } else {
                LOG.debug("currentSizeInBytes=[{}],cachePurgeTrigSize=[{}], isInPurgeMode =[{}]", new Object[]{LocalCache.this.cache.currentSizeInBytes, LocalCache.this.cache.cachePurgeTrigSize, LocalCache.this.isInPurgeMode()});
            }
        }

        synchronized boolean canAdmitFile(long length) {
            return LocalCache.this.cache.currentSizeInBytes + length < LocalCache.this.cache.maxSizeInBytes;
        }
    }
}

