/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.apache.hadoop.hdfs.web.resources.StringParam;
import org.apache.hadoop.security.UserGroupInformation;

public class UserParam
extends StringParam {
    public static final String NAME = "user.name";
    public static final String DEFAULT = "";
    private static final StringParam.Domain DOMAIN = new StringParam.Domain("user.name", Pattern.compile("^[A-Za-z_][A-Za-z0-9._-]*[$]?$"));

    private static String validateLength(String str) {
        if (str == null) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter [{0}], cannot be NULL", NAME));
        }
        int len = str.length();
        if (len < 1) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter [{0}], it's length must be at least 1", NAME));
        }
        return str;
    }

    public UserParam(String str) {
        super(DOMAIN, str == null || str.equals(DEFAULT) ? null : UserParam.validateLength(str));
    }

    public UserParam(UserGroupInformation ugi) {
        this(ugi.getShortUserName());
    }

    @Override
    public String getName() {
        return NAME;
    }
}

