/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedReader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFSDirectory {
    public static final Log LOG = LogFactory.getLog(TestFSDirectory.class);
    private static final long seed = 0L;
    private static final short REPLICATION = 3;
    private final Path dir = new Path("/" + this.getClass().getSimpleName());
    private final Path sub1 = new Path(this.dir, "sub1");
    private final Path file1 = new Path(this.sub1, "file1");
    private final Path file2 = new Path(this.sub1, "file2");
    private final Path sub11 = new Path(this.sub1, "sub11");
    private final Path file3 = new Path(this.sub11, "file3");
    private final Path file5 = new Path(this.sub1, "z_file5");
    private final Path sub2 = new Path(this.dir, "sub2");
    private Configuration conf;
    private MiniDFSCluster cluster;
    private FSNamesystem fsn;
    private FSDirectory fsdir;
    private DistributedFileSystem hdfs;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.fsdir = this.fsn.getFSDirectory();
        this.hdfs = this.cluster.getFileSystem();
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file1, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file2, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file3, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file5, 1024L, (short)3, 0L);
        this.hdfs.mkdirs(this.sub2);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testDumpTree() throws Exception {
        INode root = this.fsdir.getINode("/");
        LOG.info((Object)"Original tree");
        StringBuffer b1 = root.dumpTreeRecursively();
        System.out.println("b1=" + b1);
        BufferedReader in = new BufferedReader(new StringReader(b1.toString()));
        String line = in.readLine();
        TestFSDirectory.checkClassName(line);
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.contains("snapshot")) continue;
            Assert.assertTrue((String)("line=" + line), (line.startsWith("\\-") || line.startsWith("+-") ? 1 : 0) != 0);
            TestFSDirectory.checkClassName(line);
        }
    }

    @Test
    public void testReset() throws Exception {
        this.fsdir.reset();
        Assert.assertFalse((boolean)this.fsdir.isReady());
        INodeDirectory root = (INodeDirectory)this.fsdir.getINode("/");
        Assert.assertTrue((boolean)root.getChildrenList(null).isEmpty());
        this.fsdir.imageLoadComplete();
        Assert.assertTrue((boolean)this.fsdir.isReady());
    }

    static void checkClassName(String line) {
        int j;
        int i = line.lastIndexOf(40);
        String classname = line.substring(i + 1, j = line.lastIndexOf(64));
        Assert.assertTrue((classname.startsWith(INodeFile.class.getSimpleName()) || classname.startsWith(INodeDirectory.class.getSimpleName()) ? 1 : 0) != 0);
    }
}

