/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class TestDatanodeDescriptor {
    @Test
    public void testGetInvalidateBlocks() throws Exception {
        int MAX_BLOCKS = 10;
        int REMAINING_BLOCKS = 2;
        int MAX_LIMIT = 8;
        DatanodeDescriptor dd = DFSTestUtil.getLocalDatanodeDescriptor();
        ArrayList<Block> blockList = new ArrayList<Block>(10);
        for (int i = 0; i < 10; ++i) {
            blockList.add(new Block((long)i, 0L, 1000L));
        }
        dd.addBlocksToBeInvalidated(blockList);
        Block[] bc = dd.getInvalidateBlocks(8);
        Assert.assertEquals((long)bc.length, (long)8L);
        bc = dd.getInvalidateBlocks(8);
        Assert.assertEquals((long)bc.length, (long)2L);
    }

    @Test
    public void testBlocksCounter() throws Exception {
        DatanodeDescriptor dd = DFSTestUtil.getLocalDatanodeDescriptor();
        Assert.assertEquals((long)0L, (long)dd.numBlocks());
        BlockInfo blk = new BlockInfo(new Block(1L), 1);
        BlockInfo blk1 = new BlockInfo(new Block(2L), 2);
        Assert.assertTrue((boolean)dd.addBlock(blk));
        Assert.assertEquals((long)1L, (long)dd.numBlocks());
        Assert.assertFalse((boolean)dd.removeBlock(blk1));
        Assert.assertEquals((long)1L, (long)dd.numBlocks());
        Assert.assertFalse((boolean)dd.addBlock(blk));
        Assert.assertEquals((long)1L, (long)dd.numBlocks());
        Assert.assertTrue((boolean)dd.addBlock(blk1));
        Assert.assertEquals((long)2L, (long)dd.numBlocks());
        Assert.assertTrue((boolean)dd.removeBlock(blk));
        Assert.assertEquals((long)1L, (long)dd.numBlocks());
        Assert.assertTrue((boolean)dd.removeBlock(blk1));
        Assert.assertEquals((long)0L, (long)dd.numBlocks());
    }
}

