/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import org.apache.hadoop.fs.HdfsVolumeId;
import org.apache.hadoop.fs.VolumeId;
import org.junit.Assert;
import org.junit.Test;

public class TestVolumeId {
    @Test
    public void testEquality() {
        HdfsVolumeId id1 = new HdfsVolumeId(new byte[]{0, 0});
        this.testEq(true, (Comparable)id1, (Comparable)id1);
        HdfsVolumeId id2 = new HdfsVolumeId(new byte[]{0, 1});
        this.testEq(true, (Comparable)id2, (Comparable)id2);
        this.testEq(false, (Comparable)id1, (Comparable)id2);
        HdfsVolumeId id3 = new HdfsVolumeId(new byte[]{1, 0});
        this.testEq(true, (Comparable)id3, (Comparable)id3);
        this.testEq(false, (Comparable)id1, (Comparable)id3);
        HdfsVolumeId id2copy1 = new HdfsVolumeId(new byte[]{0, 1});
        this.testEq(true, (Comparable)id2, (Comparable)id2copy1);
        HdfsVolumeId id2copy2 = new HdfsVolumeId(new byte[]{0, 1});
        this.testEq(true, (Comparable)id2, (Comparable)id2copy2);
        this.testEqMany(true, (Comparable<T>[])new VolumeId[]{id2, id2copy1, id2copy2});
        this.testEqMany(false, (Comparable<T>[])new VolumeId[]{id1, id2, id3});
    }

    private <T> void testEq(boolean eq, Comparable<T> id1, Comparable<T> id2) {
        int h1 = id1.hashCode();
        int h2 = id2.hashCode();
        Assert.assertTrue((boolean)id1.equals(id1));
        Assert.assertTrue((boolean)id2.equals(id2));
        Assert.assertEquals((long)0L, (long)id1.compareTo(id1));
        Assert.assertEquals((long)0L, (long)id2.compareTo(id2));
        Assert.assertEquals((Object)eq, (Object)id1.equals(id2));
        Assert.assertEquals((Object)eq, (Object)id2.equals(id1));
        Assert.assertFalse((boolean)id1.equals(null));
        Assert.assertFalse((boolean)id2.equals(null));
        Assert.assertEquals((Object)eq, (Object)(0 == id1.compareTo(id2) ? 1 : 0));
        Assert.assertEquals((Object)eq, (Object)(0 == id2.compareTo(id1) ? 1 : 0));
        Assert.assertEquals((long)TestVolumeId.sign(id1.compareTo(id2)), (long)(-TestVolumeId.sign(id2.compareTo(id1))));
        Assert.assertTrue((id1.compareTo(null) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((id2.compareTo(null) != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)h1, (long)id1.hashCode());
        Assert.assertEquals((long)h2, (long)id2.hashCode());
        if (eq) {
            Assert.assertEquals((long)h1, (long)h2);
        }
    }

    private static int sign(int x) {
        if (x == 0) {
            return 0;
        }
        if (x > 0) {
            return 1;
        }
        return -1;
    }

    private <T> void testEqMany(boolean eq, Comparable<T> ... volumeIds) {
        int sum = 0;
        for (int i = 0; i < volumeIds.length; ++i) {
            Comparable<T> vidNext = i == volumeIds.length - 1 ? volumeIds[0] : volumeIds[i + 1];
            this.testEq(eq, volumeIds[i], vidNext);
            sum += TestVolumeId.sign(volumeIds[i].compareTo(vidNext));
        }
        Assert.assertTrue((sum < volumeIds.length ? 1 : 0) != 0);
    }

    @Test
    public void testIdEmptyBytes() {
        HdfsVolumeId idEmpty1 = new HdfsVolumeId(new byte[0]);
        Assert.assertTrue((boolean)idEmpty1.isValid());
        HdfsVolumeId idEmpty2 = new HdfsVolumeId(new byte[0]);
        Assert.assertTrue((boolean)idEmpty2.isValid());
        HdfsVolumeId idNotEmpty = new HdfsVolumeId(new byte[]{1});
        Assert.assertTrue((boolean)idNotEmpty.isValid());
        this.testEq(true, (Comparable)idEmpty1, (Comparable)idEmpty2);
        this.testEq(false, (Comparable)idEmpty1, (Comparable)idNotEmpty);
        this.testEq(false, (Comparable)idEmpty2, (Comparable)idNotEmpty);
    }

    @Test
    public void testInvalidId() {
        try {
            new HdfsVolumeId(null);
            Assert.assertTrue((String)"NPE expected.", (boolean)false);
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        HdfsVolumeId idEmpty = new HdfsVolumeId(new byte[0]);
        HdfsVolumeId idNotEmpty = new HdfsVolumeId(new byte[]{1});
        this.testEq(false, (Comparable)VolumeId.INVALID_VOLUME_ID, (Comparable)idNotEmpty);
        this.testEq(false, (Comparable)VolumeId.INVALID_VOLUME_ID, (Comparable)idEmpty);
        this.testEqMany(true, (Comparable<T>[])new VolumeId[]{VolumeId.INVALID_VOLUME_ID, VolumeId.INVALID_VOLUME_ID, VolumeId.INVALID_VOLUME_ID});
        this.testEqMany(false, (Comparable<T>[])new VolumeId[]{VolumeId.INVALID_VOLUME_ID, idEmpty, idNotEmpty});
    }

    @Test
    public void testToString() {
        String strInvalid = VolumeId.INVALID_VOLUME_ID.toString();
        Assert.assertNotNull((Object)strInvalid);
        String strEmpty = new HdfsVolumeId(new byte[0]).toString();
        Assert.assertNotNull((Object)strEmpty);
        String strNotEmpty = new HdfsVolumeId(new byte[]{1}).toString();
        Assert.assertNotNull((Object)strNotEmpty);
    }
}

