/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestGlobPaths {
    private static MiniDFSCluster dfsCluster;
    private static FileSystem fs;
    private static final int NUM_OF_PATHS = 4;
    private static String USER_DIR;
    private Path[] path = new Path[4];

    @BeforeClass
    public static void setUp() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        dfsCluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        fs = FileSystem.get((Configuration)conf);
        USER_DIR = fs.getHomeDirectory().toUri().getPath().toString();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
    }

    @Test
    public void testMultiGlob() throws IOException {
        Path d1 = new Path(USER_DIR, "dir1");
        Path d11 = new Path(d1, "subdir1");
        Path d12 = new Path(d1, "subdir2");
        Path f111 = new Path(d11, "f1");
        fs.createNewFile(f111);
        Path f112 = new Path(d11, "f2");
        fs.createNewFile(f112);
        Path f121 = new Path(d12, "f1");
        fs.createNewFile(f121);
        Path d2 = new Path(USER_DIR, "dir2");
        Path d21 = new Path(d2, "subdir1");
        fs.mkdirs(d21);
        Path d22 = new Path(d2, "subdir2");
        Path f221 = new Path(d22, "f1");
        fs.createNewFile(f221);
        Path d3 = new Path(USER_DIR, "dir3");
        Path f31 = new Path(d3, "f1");
        fs.createNewFile(f31);
        Path d32 = new Path(d3, "f2");
        fs.mkdirs(d32);
        Path f32 = new Path(d3, "subdir2");
        fs.createNewFile(f32);
        Path d33 = new Path(d3, "subdir3");
        Path f333 = new Path(d33, "f3");
        fs.createNewFile(f333);
        Path d331 = new Path(d33, "f1");
        Path f3311 = new Path(d331, "f1");
        fs.createNewFile(f3311);
        Path d4 = new Path(USER_DIR, "dir4");
        fs.mkdirs(d4);
        Path root = new Path(USER_DIR);
        FileStatus[] status = fs.globStatus(root);
        this.checkStatus(status, root);
        status = fs.globStatus(new Path(USER_DIR, "x"));
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path("x"));
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path(USER_DIR, "x/x"));
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path("x/x"));
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path(USER_DIR, "*"));
        this.checkStatus(status, d1, d2, d3, d4);
        status = fs.globStatus(new Path("*"));
        this.checkStatus(status, d1, d2, d3, d4);
        status = fs.globStatus(new Path(USER_DIR, "*/x"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("*/x"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "x/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("x/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "x/x/x/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("x/x/x/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "*/*"));
        this.checkStatus(status, d11, d12, d21, d22, f31, d32, f32, d33);
        status = fs.globStatus(new Path("*/*"));
        this.checkStatus(status, d11, d12, d21, d22, f31, d32, f32, d33);
        status = fs.globStatus(new Path(USER_DIR, "dir*/*"));
        this.checkStatus(status, d11, d12, d21, d22, f31, d32, f32, d33);
        status = fs.globStatus(new Path("dir*/*"));
        this.checkStatus(status, d11, d12, d21, d22, f31, d32, f32, d33);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*"));
        this.checkStatus(status, d11, d12, d21, d22, f32, d33);
        status = fs.globStatus(new Path("dir*/subdir*"));
        this.checkStatus(status, d11, d12, d21, d22, f32, d33);
        status = fs.globStatus(new Path(USER_DIR, "dir*/f*"));
        this.checkStatus(status, f31, d32);
        status = fs.globStatus(new Path("dir*/f*"));
        this.checkStatus(status, f31, d32);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1"));
        this.checkStatus(status, d11, d21);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/*"));
        this.checkStatus(status, f111, f112);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/*/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/x"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/x*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir2"));
        this.checkStatus(status, d12, d22, f32);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir2/*"));
        this.checkStatus(status, f121, f221);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir2/*/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir3"));
        this.checkStatus(status, d33);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir3/*"));
        this.checkStatus(status, d331, f333);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir3/*/*"));
        this.checkStatus(status, f3311);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir3/*/*/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/f1"));
        this.checkStatus(status, f111);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/f1*"));
        this.checkStatus(status, f111);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/f1/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/f1*/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f1"));
        this.checkStatus(status, f111, f121, f221, d331);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f1*"));
        this.checkStatus(status, f111, f121, f221, d331);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f1/*"));
        this.checkStatus(status, f3311);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f1*/*"));
        this.checkStatus(status, f3311);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f1*/*"));
        this.checkStatus(status, f3311);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f1*/x"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f1*/*/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*"));
        this.checkStatus(status, d11, d12, d21, d22, f32, d33);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/*"));
        this.checkStatus(status, f111, f112, f121, f221, d331, f333);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f*"));
        this.checkStatus(status, f111, f112, f121, f221, d331, f333);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f*/*"));
        this.checkStatus(status, f3311);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/*/f1"));
        this.checkStatus(status, f3311);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/*/*"));
        this.checkStatus(status, f3311);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/f3"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/f3*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("{x}"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("{x,y}"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("dir*/{x,y}"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("dir*/{f1,y}"));
        this.checkStatus(status, f31);
        status = fs.globStatus(new Path("{x,y}"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("/{x/x,y/y}"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("{x/x,y/y}"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("."));
        this.checkStatus(status, new Path(USER_DIR));
        status = fs.globStatus(new Path(USER_DIR + "{/dir1}"));
        this.checkStatus(status, d1);
        status = fs.globStatus(new Path(USER_DIR + "{/dir*}"));
        this.checkStatus(status, d1, d2, d3, d4);
        PathFilter trueFilter = new PathFilter(){

            public boolean accept(Path path) {
                return true;
            }
        };
        status = fs.globStatus(new Path("/"), trueFilter);
        this.checkStatus(status, new Path("/"));
        status = fs.globStatus(new Path("."), trueFilter);
        this.checkStatus(status, new Path(USER_DIR));
        status = fs.globStatus(d1, trueFilter);
        this.checkStatus(status, d1);
        status = fs.globStatus(new Path(USER_DIR), trueFilter);
        this.checkStatus(status, new Path(USER_DIR));
        status = fs.globStatus(new Path(USER_DIR, "*"), trueFilter);
        this.checkStatus(status, d1, d2, d3, d4);
        status = fs.globStatus(new Path("/x/*"), trueFilter);
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("/x"), trueFilter);
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path("/x/x"), trueFilter);
        Assert.assertNull((Object)status);
        PathFilter falseFilter = new PathFilter(){

            public boolean accept(Path path) {
                return false;
            }
        };
        status = fs.globStatus(new Path("/"), falseFilter);
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path("."), falseFilter);
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path(USER_DIR), falseFilter);
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path(USER_DIR, "*"), falseFilter);
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("/x/*"), falseFilter);
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("/x"), falseFilter);
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path("/x/x"), falseFilter);
        Assert.assertNull((Object)status);
    }

    private void checkStatus(FileStatus[] status, Path ... expectedMatches) {
        Assert.assertNotNull((Object)status);
        Object[] paths = new String[status.length];
        for (int i = 0; i < status.length; ++i) {
            paths[i] = this.getPathFromStatus(status[i]);
        }
        String got = StringUtils.join((Object[])paths, (String)"\n");
        String expected = StringUtils.join((Object[])expectedMatches, (String)"\n");
        Assert.assertEquals((Object)expected, (Object)got);
    }

    private String getPathFromStatus(FileStatus status) {
        return status.getPath().toUri().getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPathFilter() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a", USER_DIR + "/a/b"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/*/*", files, new RegexPathFilter("^.*" + Pattern.quote(USER_DIR) + "/a/b"));
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPathFilterWithFixedLastComponent() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a", USER_DIR + "/a/b", USER_DIR + "/c", USER_DIR + "/c/b"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/*/b", files, new RegexPathFilter("^.*" + Pattern.quote(USER_DIR) + "/a/b"));
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestLiteral() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a2c", USER_DIR + "/abc.d"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/abc.d", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestEscape() throws IOException {
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
        try {
            String[] files = new String[]{USER_DIR + "/ab\\[c.d"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/ab\\[c.d", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestAny() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/abc", USER_DIR + "/a2c", USER_DIR + "/a.c", USER_DIR + "/abcd"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a?c", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[2]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            Assert.assertEquals((Object)matchedPath[2], (Object)this.path[0]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestClosure1() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a", USER_DIR + "/abc", USER_DIR + "/abc.p", USER_DIR + "/bacd"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a*", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            Assert.assertEquals((Object)matchedPath[2], (Object)this.path[2]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestClosure2() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.", USER_DIR + "/a.txt", USER_DIR + "/a.old.java", USER_DIR + "/.java"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a.*", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[2]);
            Assert.assertEquals((Object)matchedPath[2], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestClosure3() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.txt.x", USER_DIR + "/ax", USER_DIR + "/ab37x", USER_DIR + "/bacd"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a*x", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[2]);
            Assert.assertEquals((Object)matchedPath[2], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestClosure4() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/dir1/file1", USER_DIR + "/dir2/file2", USER_DIR + "/dir3/file1"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/*/file1", files);
            Assert.assertEquals((long)matchedPath.length, (long)2L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[2]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestClosure5() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/dir1/file1", USER_DIR + "/file1"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/*/file1", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestSet() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.c", USER_DIR + "/a.cpp", USER_DIR + "/a.hlp", USER_DIR + "/a.hxy"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a.[ch]??", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[1]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[2]);
            Assert.assertEquals((Object)matchedPath[2], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestRange() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.d", USER_DIR + "/a.e", USER_DIR + "/a.f", USER_DIR + "/a.h"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a.[d-fm]", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            Assert.assertEquals((Object)matchedPath[2], (Object)this.path[2]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestSetExcl() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.d", USER_DIR + "/a.e", USER_DIR + "/a.0", USER_DIR + "/a.h"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a.[^a-cg-z0-9]", files);
            Assert.assertEquals((long)matchedPath.length, (long)2L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestCombination() throws IOException {
        try {
            String[] files = new String[]{"/user/aa/a.c", "/user/bb/a.cpp", "/user1/cc/b.hlp", "/user/dd/a.hxy"};
            Path[] matchedPath = this.prepareTesting("/use?/*/a.[ch]{lp,xy}", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestRelativePath() throws IOException {
        try {
            String[] files = new String[]{"a", "abc", "abc.p", "bacd"};
            Path[] matchedPath = this.prepareTesting("a*", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)new Path(USER_DIR, this.path[0]));
            Assert.assertEquals((Object)matchedPath[1], (Object)new Path(USER_DIR, this.path[1]));
            Assert.assertEquals((Object)matchedPath[2], (Object)new Path(USER_DIR, this.path[2]));
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestCurlyBracket() throws IOException {
        Path[] matchedPath;
        String[] files;
        try {
            files = new String[]{USER_DIR + "/a.abcxx", USER_DIR + "/a.abxy", USER_DIR + "/a.hlp", USER_DIR + "/a.jhyy"};
            matchedPath = this.prepareTesting(USER_DIR + "/a.{abc,jh}??", files);
            Assert.assertEquals((long)matchedPath.length, (long)2L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
        try {
            files = new String[]{USER_DIR + "/a.abcxx", USER_DIR + "/a.abdxy", USER_DIR + "/a.hlp", USER_DIR + "/a.jhyy"};
            matchedPath = this.prepareTesting(USER_DIR + "/a.{ab{c,d},jh}??", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            Assert.assertEquals((Object)matchedPath[2], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
        try {
            files = new String[]{USER_DIR + "/a/b", USER_DIR + "/a/d", USER_DIR + "/c/b", USER_DIR + "/c/d"};
            matchedPath = this.prepareTesting(USER_DIR + "/{a/b,c/d}", files);
            Assert.assertEquals((long)matchedPath.length, (long)2L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
        try {
            files = new String[]{"/a/b", "/a/d", "/c/b", "/c/d"};
            matchedPath = this.prepareTesting("{/a/b,/c/d}", files);
            Assert.assertEquals((long)matchedPath.length, (long)2L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
        try {
            files = new String[]{USER_DIR + "/}bc", USER_DIR + "/}c"};
            matchedPath = this.prepareTesting(USER_DIR + "/}{a,b}c", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{b}c", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{}bc", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{,}bc", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{b,}c", files);
            Assert.assertEquals((long)matchedPath.length, (long)2L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{,b}c", files);
            Assert.assertEquals((long)matchedPath.length, (long)2L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{ac,?}", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[1]);
            boolean hasException = false;
            try {
                this.prepareTesting(USER_DIR + "}{bc", files);
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("Illegal file pattern:"));
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestJavaRegexSpecialChars() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/($.|+)bc", USER_DIR + "/abc"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/($.|+)*", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    private Path[] prepareTesting(String pattern, String[] files) throws IOException {
        for (int i = 0; i < Math.min(4, files.length); ++i) {
            this.path[i] = fs.makeQualified(new Path(files[i]));
            if (fs.mkdirs(this.path[i])) continue;
            throw new IOException("Mkdirs failed to create " + this.path[i].toString());
        }
        Path patternPath = new Path(pattern);
        Path[] globResults = FileUtil.stat2Paths((FileStatus[])fs.globStatus(patternPath), (Path)patternPath);
        for (int i = 0; i < globResults.length; ++i) {
            globResults[i] = globResults[i].makeQualified(fs.getUri(), fs.getWorkingDirectory());
        }
        return globResults;
    }

    private Path[] prepareTesting(String pattern, String[] files, PathFilter filter) throws IOException {
        for (int i = 0; i < Math.min(4, files.length); ++i) {
            this.path[i] = fs.makeQualified(new Path(files[i]));
            if (fs.mkdirs(this.path[i])) continue;
            throw new IOException("Mkdirs failed to create " + this.path[i].toString());
        }
        Path patternPath = new Path(pattern);
        Path[] globResults = FileUtil.stat2Paths((FileStatus[])fs.globStatus(patternPath, filter), (Path)patternPath);
        for (int i = 0; i < globResults.length; ++i) {
            globResults[i] = globResults[i].makeQualified(fs.getUri(), fs.getWorkingDirectory());
        }
        return globResults;
    }

    @After
    public void cleanupDFS() throws IOException {
        fs.delete(new Path(USER_DIR), true);
    }

    static class RegexPathFilter
    implements PathFilter {
        private final String regex;

        public RegexPathFilter(String regex) {
            this.regex = regex;
        }

        public boolean accept(Path path) {
            return path.toString().matches(this.regex);
        }
    }
}

