/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthenticatedURL {
    public static final String AUTH_COOKIE = "hadoop.auth";
    private static final String AUTH_COOKIE_EQ = "hadoop.auth=";
    private static Class<? extends Authenticator> DEFAULT_AUTHENTICATOR = KerberosAuthenticator.class;
    private Authenticator authenticator;
    private ConnectionConfigurator connConfigurator;

    public static void setDefaultAuthenticator(Class<? extends Authenticator> authenticator) {
        DEFAULT_AUTHENTICATOR = authenticator;
    }

    public static Class<? extends Authenticator> getDefaultAuthenticator() {
        return DEFAULT_AUTHENTICATOR;
    }

    public AuthenticatedURL() {
        this(null);
    }

    public AuthenticatedURL(Authenticator authenticator) {
        this(authenticator, null);
    }

    public AuthenticatedURL(Authenticator authenticator, ConnectionConfigurator connConfigurator) {
        try {
            this.authenticator = authenticator != null ? authenticator : (Authenticator)DEFAULT_AUTHENTICATOR.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.connConfigurator = connConfigurator;
        this.authenticator.setConnectionConfigurator(connConfigurator);
    }

    public HttpURLConnection openConnection(URL url, Token token) throws IOException, AuthenticationException {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be NULL");
        }
        if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("url must be for a HTTP or HTTPS resource");
        }
        if (token == null) {
            throw new IllegalArgumentException("token cannot be NULL");
        }
        this.authenticator.authenticate(url, token);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (this.connConfigurator != null) {
            conn = this.connConfigurator.configure(conn);
        }
        AuthenticatedURL.injectToken((HttpURLConnection)conn, (Token)token);
        return conn;
    }

    public static void injectToken(HttpURLConnection conn, Token token) {
        String t = Token.access$000((Token)token);
        if (t != null) {
            if (!t.startsWith("\"")) {
                t = "\"" + t + "\"";
            }
            conn.addRequestProperty("Cookie", "hadoop.auth=" + t);
        }
    }

    public static void extractToken(HttpURLConnection conn, Token token) throws IOException, AuthenticationException {
        if (conn.getResponseCode() == 200) {
            Map<String, List<String>> headers = conn.getHeaderFields();
            List<String> cookies = headers.get("Set-Cookie");
            if (cookies != null) {
                for (String cookie : cookies) {
                    if (!cookie.startsWith("hadoop.auth=")) continue;
                    String value = cookie.substring("hadoop.auth=".length());
                    int separator = value.indexOf(";");
                    if (separator > -1) {
                        value = value.substring(0, separator);
                    }
                    if (value.length() <= 0) continue;
                    token.set(value);
                }
            }
        } else {
            token.set(null);
            throw new AuthenticationException("Authentication failed, status: " + conn.getResponseCode() + ", message: " + conn.getResponseMessage());
        }
    }
}

