/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.Remote;
import javax.naming.InitialContext;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.client.ClusterableRequest;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.omg.CORBA.ORB;

public class EJBRequest
implements ClusterableRequest {
    private transient int requestMethod;
    private transient int deploymentCode = 0;
    private transient Object clientIdentity;
    private transient String deploymentId;
    private transient int serverHash;
    private transient Body body;
    private final transient EJBMetaDataImpl ejbMetaData;
    public static final int SESSION_BEAN_STATELESS = 6;
    public static final int SESSION_BEAN_STATEFUL = 7;
    public static final int ENTITY_BM_PERSISTENCE = 8;
    public static final int ENTITY_CM_PERSISTENCE = 9;

    public EJBRequest() {
        this.body = new Body(null);
        this.ejbMetaData = null;
    }

    public EJBRequest(int requestMethod, EJBMetaDataImpl ejb, Method method, Object[] args, Object primaryKey) {
        this.body = new Body(ejb);
        this.ejbMetaData = ejb;
        this.requestMethod = requestMethod;
        this.setDeploymentCode(ejb.deploymentCode);
        this.setDeploymentId(ejb.deploymentID);
        this.setMethodInstance(method);
        this.setMethodParameters(args);
        this.setPrimaryKey(primaryKey);
    }

    public EJBMetaDataImpl getEjbMetaData() {
        return this.ejbMetaData;
    }

    public Class getInterfaceClass() {
        return this.body.getInterfaceClass();
    }

    public Method getMethodInstance() {
        return this.body.getMethodInstance();
    }

    public String getMethodName() {
        return this.body.getMethodName();
    }

    public Object[] getMethodParameters() {
        return this.body.getMethodParameters();
    }

    public Class[] getMethodParamTypes() {
        return this.body.getMethodParamTypes();
    }

    public Object getPrimaryKey() {
        return this.body.getPrimaryKey();
    }

    public void setMethodInstance(Method methodInstance) {
        this.body.setMethodInstance(methodInstance);
    }

    public void setMethodParameters(Object[] methodParameters) {
        this.body.setMethodParameters(methodParameters);
    }

    public void setPrimaryKey(Object primaryKey) {
        this.body.setPrimaryKey(primaryKey);
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public byte getRequestType() {
        return 0;
    }

    public int getRequestMethod() {
        return this.requestMethod;
    }

    public Object getClientIdentity() {
        return this.clientIdentity;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public int getDeploymentCode() {
        return this.deploymentCode;
    }

    public void setRequestMethod(int requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setClientIdentity(Object clientIdentity) {
        this.clientIdentity = clientIdentity;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public void setDeploymentCode(int deploymentCode) {
        this.deploymentCode = deploymentCode;
    }

    public void setServerHash(int serverHash) {
        this.serverHash = serverHash;
    }

    public int getServerHash() {
        return this.serverHash;
    }

    public String toString() {
        StringBuffer s = null;
        switch (this.requestMethod) {
            case 1: {
                s = new StringBuffer("EJB_HOME.GET_EJB_META_DATA");
                break;
            }
            case 2: {
                s = new StringBuffer("EJB_HOME.GET_HOME_HANDLE");
                break;
            }
            case 3: {
                s = new StringBuffer("EJB_HOME.REMOVE_BY_HANDLE");
                break;
            }
            case 4: {
                s = new StringBuffer("EJB_HOME.REMOVE_BY_PKEY");
                break;
            }
            case 9: {
                s = new StringBuffer("EJB_HOME.FIND");
                break;
            }
            case 10: {
                s = new StringBuffer("EJB_HOME.CREATE");
                break;
            }
            case 24: {
                s = new StringBuffer("EJB_HOME.HOME_METHOD");
                break;
            }
            case 14: {
                s = new StringBuffer("EJB_OBJECT.GET_EJB_HOME");
                break;
            }
            case 15: {
                s = new StringBuffer("EJB_OBJECT.GET_HANDLE");
                break;
            }
            case 16: {
                s = new StringBuffer("EJB_OBJECT.GET_PRIMARY_KEY");
                break;
            }
            case 17: {
                s = new StringBuffer("EJB_OBJECT.IS_IDENTICAL");
                break;
            }
            case 18: {
                s = new StringBuffer("EJB_OBJECT.REMOVE");
                break;
            }
            case 23: {
                s = new StringBuffer("EJB_OBJECT.BUSINESS_METHOD");
                break;
            }
            default: {
                s = new StringBuffer("EJB_UKNOWN." + this.requestMethod);
            }
        }
        s.append(':').append(this.deploymentId);
        if (this.body != null) {
            s.append(':').append(this.body.getMethodName());
            s.append(':').append(this.body.getPrimaryKey());
        }
        return s.toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ClassNotFoundException result;
        block5: {
            result = null;
            this.requestMethod = -1;
            this.deploymentId = null;
            this.deploymentCode = -1;
            this.clientIdentity = null;
            this.requestMethod = in.readByte();
            try {
                this.deploymentId = (String)in.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                result = cnfe;
            }
            this.deploymentCode = in.readShort();
            try {
                this.clientIdentity = in.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                if (result != null) break block5;
                result = cnfe;
            }
        }
        this.serverHash = in.readInt();
        if (result != null) {
            throw result;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.requestMethod);
        if (this.deploymentCode > 0) {
            out.writeObject(null);
        } else {
            out.writeObject(this.deploymentId);
        }
        out.writeShort(this.deploymentCode);
        out.writeObject(this.clientIdentity);
        out.writeInt(this.serverHash);
        this.body.writeExternal(out);
    }

    public static class Body
    implements Externalizable {
        private transient EJBMetaDataImpl ejb;
        private transient ORB orb;
        private transient Method methodInstance;
        private transient Class interfaceClass;
        private transient String methodName;
        private transient Class[] methodParamTypes;
        private transient Object[] methodParameters;
        private transient Object primaryKey;
        static final Class[] noArgsC = new Class[0];
        static final Object[] noArgsO = new Object[0];
        private static final int I = 0;
        private static final int B = 1;
        private static final int J = 2;
        private static final int F = 3;
        private static final int D = 4;
        private static final int S = 5;
        private static final int C = 6;
        private static final int Z = 7;
        private static final int L = 8;
        private static final int A = 9;

        public Body(EJBMetaDataImpl ejb) {
            this.ejb = ejb;
        }

        public Method getMethodInstance() {
            return this.methodInstance;
        }

        public Object[] getMethodParameters() {
            return this.methodParameters;
        }

        public Object getPrimaryKey() {
            return this.primaryKey;
        }

        public Class getInterfaceClass() {
            return this.interfaceClass;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class[] getMethodParamTypes() {
            return this.methodParamTypes;
        }

        public void setMethodInstance(Method methodInstance) {
            if (methodInstance == null) {
                throw new NullPointerException("methodInstance input parameter is null");
            }
            this.methodInstance = methodInstance;
            this.methodName = methodInstance.getName();
            this.methodParamTypes = methodInstance.getParameterTypes();
            Class<?> methodClass = methodInstance.getDeclaringClass();
            if (this.ejb.homeClass != null && methodClass.isAssignableFrom(this.ejb.homeClass)) {
                this.interfaceClass = this.ejb.homeClass;
                return;
            }
            if (this.ejb.remoteClass != null && methodClass.isAssignableFrom(this.ejb.remoteClass)) {
                this.interfaceClass = this.ejb.remoteClass;
                return;
            }
            for (Class businessClass : this.ejb.businessClasses) {
                if (!methodClass.isAssignableFrom(businessClass)) continue;
                this.interfaceClass = businessClass;
                return;
            }
        }

        public void setMethodParameters(Object[] methodParameters) {
            this.methodParameters = methodParameters;
        }

        public void setPrimaryKey(Object primaryKey) {
            this.primaryKey = primaryKey;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            ClassNotFoundException result;
            block9: {
                block8: {
                    byte version = in.readByte();
                    result = null;
                    this.primaryKey = null;
                    this.methodName = null;
                    this.methodInstance = null;
                    try {
                        this.primaryKey = in.readObject();
                        this.interfaceClass = (Class)in.readObject();
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (result != null) break block8;
                        result = cnfe;
                    }
                }
                this.methodName = in.readUTF();
                try {
                    this.readMethodParameters(in);
                }
                catch (ClassNotFoundException cnfe) {
                    if (result != null) break block9;
                    result = cnfe;
                }
            }
            if (this.interfaceClass != null) {
                try {
                    this.methodInstance = this.interfaceClass.getMethod(this.methodName, this.methodParamTypes);
                }
                catch (NoSuchMethodException nsme) {
                    // empty catch block
                }
            }
            if (result != null) {
                throw result;
            }
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(1);
            out.writeObject(this.primaryKey);
            out.writeObject(this.interfaceClass);
            out.writeUTF(this.methodName);
            this.writeMethodParameters(out, this.methodParamTypes, this.methodParameters);
        }

        protected void writeMethodParameters(ObjectOutput out, Class[] types, Object[] args) throws IOException {
            out.writeByte(types.length);
            for (int i = 0; i < types.length; ++i) {
                Class type = types[i];
                Object obj = args[i];
                if (type.isPrimitive()) {
                    if (type == Byte.TYPE) {
                        out.write(1);
                        byte bytevalue = (Byte)obj;
                        out.writeByte(bytevalue);
                        continue;
                    }
                    if (type == Character.TYPE) {
                        out.write(6);
                        char charvalue = ((Character)obj).charValue();
                        out.writeChar(charvalue);
                        continue;
                    }
                    if (type == Integer.TYPE) {
                        out.write(0);
                        int intvalue = (Integer)obj;
                        out.writeInt(intvalue);
                        continue;
                    }
                    if (type == Boolean.TYPE) {
                        out.write(7);
                        boolean booleanvalue = (Boolean)obj;
                        out.writeBoolean(booleanvalue);
                        continue;
                    }
                    if (type == Long.TYPE) {
                        out.write(2);
                        long longvalue = (Long)obj;
                        out.writeLong(longvalue);
                        continue;
                    }
                    if (type == Float.TYPE) {
                        out.write(3);
                        float fvalue = ((Float)obj).floatValue();
                        out.writeFloat(fvalue);
                        continue;
                    }
                    if (type == Double.TYPE) {
                        out.write(4);
                        double dvalue = (Double)obj;
                        out.writeDouble(dvalue);
                        continue;
                    }
                    if (type == Short.TYPE) {
                        out.write(5);
                        short shortvalue = (Short)obj;
                        out.writeShort(shortvalue);
                        continue;
                    }
                    throw new IOException("Unkown primitive type: " + type);
                }
                if (obj instanceof PortableRemoteObject && obj instanceof Remote) {
                    Tie tie = Util.getTie((Remote)((Remote)obj));
                    if (tie == null) {
                        throw new IOException("Unable to serialize PortableRemoteObject; object has not been exported: " + obj);
                    }
                    ORB orb = this.getORB();
                    tie.orb(orb);
                    obj = PortableRemoteObject.toStub((Remote)((Remote)obj));
                }
                out.write(8);
                out.writeObject(type);
                out.writeObject(obj);
            }
        }

        protected ORB getORB() throws IOException {
            if (this.orb == null) {
                try {
                    InitialContext initialContext = new InitialContext();
                    this.orb = (ORB)initialContext.lookup("java:comp/ORB");
                }
                catch (Throwable e) {
                    try {
                        this.orb = ORB.init();
                    }
                    catch (Throwable ex) {
                        throw new IOException("Unable to connect PortableRemoteObject stub to an ORB, no ORB bound to java:comp/ORB");
                    }
                }
            }
            return this.orb;
        }

        protected void readMethodParameters(ObjectInput in) throws IOException, ClassNotFoundException {
            int length = in.read();
            if (length < 1) {
                this.methodParamTypes = noArgsC;
                this.methodParameters = noArgsO;
                return;
            }
            Class[] types = new Class[length];
            Object[] args = new Object[length];
            for (int i = 0; i < types.length; ++i) {
                Class clazz = null;
                Object obj = null;
                int type = in.read();
                switch (type) {
                    case 1: {
                        clazz = Byte.TYPE;
                        obj = new Byte(in.readByte());
                        break;
                    }
                    case 6: {
                        clazz = Character.TYPE;
                        obj = new Character(in.readChar());
                        break;
                    }
                    case 0: {
                        clazz = Integer.TYPE;
                        obj = new Integer(in.readInt());
                        break;
                    }
                    case 7: {
                        clazz = Boolean.TYPE;
                        obj = new Boolean(in.readBoolean());
                        break;
                    }
                    case 2: {
                        clazz = Long.TYPE;
                        obj = new Long(in.readLong());
                        break;
                    }
                    case 3: {
                        clazz = Float.TYPE;
                        obj = new Float(in.readFloat());
                        break;
                    }
                    case 4: {
                        clazz = Double.TYPE;
                        obj = new Double(in.readDouble());
                        break;
                    }
                    case 5: {
                        clazz = Short.TYPE;
                        obj = new Short(in.readShort());
                        break;
                    }
                    case 8: {
                        clazz = (Class)in.readObject();
                        obj = in.readObject();
                        if (!(obj instanceof Stub)) break;
                        Stub stub = (Stub)obj;
                        ORB orb = this.getORB();
                        stub.connect(orb);
                        break;
                    }
                    default: {
                        throw new IOException("Unkown data type: " + type);
                    }
                }
                types[i] = clazz;
                args[i] = obj;
            }
            this.methodParamTypes = types;
            this.methodParameters = args;
        }
    }
}

