/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import org.apache.openejb.client.ApplicationException;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.EJBHomeHandler;
import org.apache.openejb.client.EJBHomeProxy;
import org.apache.openejb.client.EJBInvocationHandler;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandle;
import org.apache.openejb.client.EJBObjectProxy;
import org.apache.openejb.client.EJBObjectProxyHandle;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.EJBResponse;
import org.apache.openejb.client.EntityEJBObjectHandler;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.SingletonEJBObjectHandler;
import org.apache.openejb.client.StatefulEJBObjectHandler;
import org.apache.openejb.client.StatelessEJBObjectHandler;
import org.apache.openejb.client.SystemError;
import org.apache.openejb.client.SystemException;
import org.apache.openejb.client.ThrowableArtifact;
import org.apache.openejb.client.proxy.InvocationHandler;
import org.apache.openejb.client.proxy.ProxyManager;

public abstract class EJBObjectHandler
extends EJBInvocationHandler {
    protected static final Method GETEJBHOME = EJBObjectHandler.getMethod(EJBObject.class, "getEJBHome", null);
    protected static final Method GETHANDLE = EJBObjectHandler.getMethod(EJBObject.class, "getHandle", null);
    protected static final Method GETPRIMARYKEY = EJBObjectHandler.getMethod(EJBObject.class, "getPrimaryKey", null);
    protected static final Method ISIDENTICAL = EJBObjectHandler.getMethod(EJBObject.class, "isIdentical", EJBObject.class);
    protected static final Method REMOVE = EJBObjectHandler.getMethod(EJBObject.class, "remove", null);
    protected static final Method GETHANDLER = EJBObjectHandler.getMethod(EJBObjectProxy.class, "getEJBObjectHandler", null);
    public Object registryId;
    EJBHomeProxy ejbHome = null;

    public EJBObjectHandler() {
    }

    public EJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client) {
        super(ejb, server, client);
    }

    public EJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, Object primaryKey) {
        super(ejb, server, client, primaryKey);
    }

    protected void setEJBHomeProxy(EJBHomeProxy ejbHome) {
        this.ejbHome = ejbHome;
    }

    public static EJBObjectHandler createEJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, Object primaryKey) {
        switch (ejb.type) {
            case 8: 
            case 9: {
                return new EntityEJBObjectHandler(ejb, server, client, primaryKey);
            }
            case 6: {
                return new StatefulEJBObjectHandler(ejb, server, client, primaryKey);
            }
            case 7: {
                return new StatelessEJBObjectHandler(ejb, server, client, primaryKey);
            }
            case 10: {
                return new SingletonEJBObjectHandler(ejb, server, client, primaryKey);
            }
        }
        throw new IllegalStateException("Uknown bean type code '" + ejb.type + "' : " + ejb.toString());
    }

    public abstract Object getRegistryId();

    public EJBObjectProxy createEJBObjectProxy() {
        EJBObjectProxy ejbObject = null;
        try {
            ArrayList<Class<EJBObjectProxy>> interfaces = new ArrayList<Class<EJBObjectProxy>>();
            if (this.ejb.remoteClass != null) {
                interfaces.add(this.ejb.remoteClass);
            } else if (this.ejb.businessClasses.size() > 0) {
                interfaces.addAll(this.ejb.businessClasses);
            }
            interfaces.add(EJBObjectProxy.class);
            ejbObject = (EJBObjectProxy)ProxyManager.newProxyInstance(interfaces.toArray(new Class[0]), (InvocationHandler)this);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return ejbObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Object _invoke(Object p, Method m, Object[] a) throws Throwable {
        Object retValue = null;
        try {
            String methodName = m.getName();
            if (m.getDeclaringClass().equals(Object.class)) {
                if (m.equals(TOSTRING)) {
                    return "proxy=" + this;
                }
                if (m.equals(EQUALS)) {
                    return this.equals(m, a, p);
                }
                if (!m.equals(HASHCODE)) throw new UnsupportedOperationException("Unkown method: " + m);
                return new Integer(this.hashCode());
            }
            if (m.getDeclaringClass() == EJBObjectProxy.class) {
                if (m.equals(GETHANDLER)) {
                    return this;
                }
                if (methodName.equals("writeReplace")) {
                    return new EJBObjectProxyHandle(this);
                }
                if (!methodName.equals("readResolve")) throw new UnsupportedOperationException("Unkown method: " + m);
                return retValue;
            }
            if (m.getDeclaringClass() != EJBObject.class) return this.businessMethod(m, a, p);
            if (m.equals(GETHANDLE)) {
                return this.getHandle(m, a, p);
            }
            if (m.equals(GETPRIMARYKEY)) {
                return this.getPrimaryKey(m, a, p);
            }
            if (m.equals(ISIDENTICAL)) {
                return this.isIdentical(m, a, p);
            }
            if (m.equals(GETEJBHOME)) {
                return this.getEJBHome(m, a, p);
            }
            if (!m.equals(REMOVE)) throw new UnsupportedOperationException("Unkown method: " + m);
            return this.remove(m, a, p);
        }
        catch (SystemException e) {
            EJBObjectHandler.invalidateAllHandlers(this.getRegistryId());
            throw this.convertException(EJBObjectHandler.getCause(e), m);
        }
        catch (ApplicationException ae) {
            throw this.convertException(EJBObjectHandler.getCause(ae), m);
        }
        catch (SystemError se) {
            this.invalidateReference();
            if (!this.remote) throw new EJBException("Container has suffered a SystemException").initCause(EJBObjectHandler.getCause(se));
            throw new RemoteException("Container has suffered a SystemException", EJBObjectHandler.getCause(se));
        }
        catch (Throwable oe) {
            if (!this.remote) throw new EJBException("Unknown Container Exception: " + oe.getClass().getName() + ": " + oe.getMessage()).initCause(EJBObjectHandler.getCause(oe));
            throw new RemoteException("Unknown Container Exception: " + oe.getClass().getName() + ": " + oe.getMessage(), EJBObjectHandler.getCause(oe));
        }
    }

    protected Object getEJBHome(Method method, Object[] args, Object proxy) throws Throwable {
        if (this.ejbHome == null) {
            this.ejbHome = EJBHomeHandler.createEJBHomeHandler(this.ejb, this.server, this.client).createEJBHomeProxy();
        }
        return this.ejbHome;
    }

    protected Object getHandle(Method method, Object[] args, Object proxy) throws Throwable {
        return new EJBObjectHandle((EJBObjectProxy)proxy);
    }

    protected abstract Object getPrimaryKey(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object isIdentical(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object equals(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object remove(Method var1, Object[] var2, Object var3) throws Throwable;

    protected Object businessMethod(Method method, Object[] args, Object proxy) throws Throwable {
        EJBRequest req = new EJBRequest(23, this.ejb, method, args, this.primaryKey);
        EJBResponse res = this.request(req);
        switch (res.getResponseCode()) {
            case 11: {
                throw new SystemError((ThrowableArtifact)res.getResult());
            }
            case 10: {
                throw new SystemException((ThrowableArtifact)res.getResult());
            }
            case 9: {
                throw new ApplicationException((ThrowableArtifact)res.getResult());
            }
            case 4: {
                return res.getResult();
            }
        }
        throw new RemoteException("Received invalid response code from server: " + res.getResponseCode());
    }
}

