/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import javax.naming.NamingException;
import javax.naming.directory.InvalidAttributeValueException;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;

public class RegexSyntaxChecker
implements SyntaxChecker {
    private final String oid;
    private final String[] expressions;

    public RegexSyntaxChecker(String oid, String[] matchExprArray) {
        this.expressions = matchExprArray;
        this.oid = oid;
    }

    public String getSyntaxOid() {
        return this.oid;
    }

    public boolean isValidSyntax(Object value) {
        String str = null;
        boolean match = true;
        if (value instanceof String) {
            str = (String)value;
            for (int i = 0; i < this.expressions.length; ++i) {
                boolean bl = match = match && str.matches(this.expressions[i]);
                if (!match) break;
            }
        }
        return match;
    }

    public void assertSyntax(Object value) throws NamingException {
        if (this.isValidSyntax(value)) {
            return;
        }
        throw new InvalidAttributeValueException(value + " does not conform to the syntax specified by " + this.oid);
    }
}

