/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;

public class LdapResultImpl
implements LdapResult {
    static final long serialVersionUID = -1446626887394613213L;
    private LdapDN matchedDn;
    private Referral referral;
    private String errorMessage;
    private ResultCodeEnum resultCode = ResultCodeEnum.SUCCESS;

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public LdapDN getMatchedDn() {
        return this.matchedDn;
    }

    public void setMatchedDn(LdapDN matchedDn) {
        this.matchedDn = matchedDn;
    }

    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public Referral getReferral() {
        return this.referral;
    }

    public boolean isReferral() {
        return this.referral != null;
    }

    public void setReferral(Referral referral) {
        this.referral = referral;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LdapResult)) {
            return false;
        }
        LdapResult result = (LdapResult)obj;
        if (this.referral == null && result.getReferral() != null) {
            return false;
        }
        if (result.getReferral() == null && this.referral != null) {
            return false;
        }
        if (this.referral != null && result.getReferral() != null && !this.referral.equals(result.getReferral())) {
            return false;
        }
        if (!this.resultCode.equals(result.getResultCode())) {
            return false;
        }
        String errMsg0 = this.errorMessage;
        String errMsg1 = result.getErrorMessage();
        if (errMsg0 == null) {
            errMsg0 = "";
        }
        if (errMsg1 == null) {
            errMsg1 = "";
        }
        if (!errMsg0.equals(errMsg1)) {
            return false;
        }
        return !(this.matchedDn != null ? !this.matchedDn.equals(result.getMatchedDn()) : result.getMatchedDn() != null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("        Ldap Result\n");
        sb.append("            Result code : (").append(this.resultCode).append(')');
        if (this.resultCode != null) {
            if (this.resultCode.getValue() == 0) {
                sb.append(" success\n");
            } else if (this.resultCode.getValue() == 1) {
                sb.append(" operationsError\n");
            } else if (this.resultCode.getValue() == 2) {
                sb.append(" protocolError\n");
            } else if (this.resultCode.getValue() == 3) {
                sb.append(" timeLimitExceeded\n");
            } else if (this.resultCode.getValue() == 4) {
                sb.append(" sizeLimitExceeded\n");
            } else if (this.resultCode.getValue() == 5) {
                sb.append(" compareFalse\n");
            } else if (this.resultCode.getValue() == 6) {
                sb.append(" compareTrue\n");
            } else if (this.resultCode.getValue() == 7) {
                sb.append(" authMethodNotSupported\n");
            } else if (this.resultCode.getValue() == 8) {
                sb.append(" strongAuthRequired\n");
            } else if (this.resultCode.getValue() == 9) {
                sb.append(" -- 9 reserved --\n");
            } else if (this.resultCode.getValue() == 10) {
                sb.append(" referral -- new\n");
            } else if (this.resultCode.getValue() == 11) {
                sb.append(" adminLimitExceeded -- new\n");
            } else if (this.resultCode.getValue() == 12) {
                sb.append(" unavailableCriticalExtension -- new\n");
            } else if (this.resultCode.getValue() == 13) {
                sb.append(" confidentialityRequired -- new\n");
            } else if (this.resultCode.getValue() == 14) {
                sb.append(" saslBindInProgress -- new\n");
            } else if (this.resultCode.getValue() == 16) {
                sb.append(" noSuchAttribute\n");
            } else if (this.resultCode.getValue() == 17) {
                sb.append(" undefinedAttributeType\n");
            } else if (this.resultCode.getValue() == 18) {
                sb.append(" inappropriateMatching\n");
            } else if (this.resultCode.getValue() == 19) {
                sb.append(" constraintViolation\n");
            } else if (this.resultCode.getValue() == 20) {
                sb.append(" attributeOrValueExists\n");
            } else if (this.resultCode.getValue() == 21) {
                sb.append(" invalidAttributeSyntax\n");
            } else if (this.resultCode.getValue() >= 22 && this.resultCode.getValue() <= 31) {
                sb.append(" -- 22-31 unused --\n");
            } else if (this.resultCode.getValue() == 32) {
                sb.append(" noSuchObject\n");
            } else if (this.resultCode.getValue() == 33) {
                sb.append(" aliasProblem\n");
            } else if (this.resultCode.getValue() == 34) {
                sb.append(" invalidDNSyntax\n");
            } else if (this.resultCode.getValue() == 35) {
                sb.append(" -- 35 reserved for undefined isLeaf --\n");
            } else if (this.resultCode.getValue() == 36) {
                sb.append(" aliasDereferencingProblem\n");
            } else if (this.resultCode.getValue() >= 37 && this.resultCode.getValue() <= 47) {
                sb.append(" -- 37-47 unused --\n");
            } else if (this.resultCode.getValue() == 48) {
                sb.append(" inappropriateAuthentication\n");
            } else if (this.resultCode.getValue() == 49) {
                sb.append(" invalidCredentials\n");
            } else if (this.resultCode.getValue() == 50) {
                sb.append(" insufficientAccessRights\n");
            } else if (this.resultCode.getValue() == 51) {
                sb.append(" busy\n");
            } else if (this.resultCode.getValue() == 52) {
                sb.append(" unavailable\n");
            } else if (this.resultCode.getValue() == 53) {
                sb.append(" unwillingToPerform\n");
            } else if (this.resultCode.getValue() == 54) {
                sb.append(" loopDetect\n");
            } else if (this.resultCode.getValue() >= 55 && this.resultCode.getValue() <= 63) {
                sb.append(" -- 55-63 unused --\n");
            } else if (this.resultCode.getValue() == 64) {
                sb.append(" namingViolation\n");
            } else if (this.resultCode.getValue() == 65) {
                sb.append(" objectClassViolation\n");
            } else if (this.resultCode.getValue() == 66) {
                sb.append(" notAllowedOnNonLeaf\n");
            } else if (this.resultCode.getValue() == 67) {
                sb.append(" notAllowedOnRDN\n");
            } else if (this.resultCode.getValue() == 68) {
                sb.append(" entryAlreadyExists\n");
            } else if (this.resultCode.getValue() == 69) {
                sb.append(" objectClassModsProhibited\n");
            } else if (this.resultCode.getValue() == 70) {
                sb.append(" -- 70 reserved for CLDAP --\n");
            } else if (this.resultCode.getValue() == 71) {
                sb.append(" affectsMultipleDSAs -- new\n");
            } else if (this.resultCode.getValue() >= 72 && this.resultCode.getValue() <= 79) {
                sb.append(" -- 72-79 unused --\n");
            } else if (this.resultCode.getValue() == 80) {
                sb.append(" other\n");
            } else if (this.resultCode.getValue() >= 81 && this.resultCode.getValue() <= 90) {
                sb.append(" -- 81-90 reserved for APIs --");
            } else {
                sb.append("Unknown error code : ").append(this.resultCode);
            }
        }
        sb.append("            Matched DN : '").append(this.matchedDn).append("'\n");
        sb.append("            Error message : '").append(this.errorMessage).append("'\n");
        if (this.referral != null) {
            sb.append("            Referrals :\n");
            sb.append("                Referral :").append(this.referral.toString()).append('\n');
        }
        return sb.toString();
    }
}

