/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IAction;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.BooleanDecoder;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.ldap.codec.search.controls.PSearchControl;
import org.apache.directory.shared.ldap.codec.search.controls.PSearchControlContainer;
import org.apache.directory.shared.ldap.codec.search.controls.PSearchControlStatesEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSearchControlGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)PSearchControlGrammar.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new PSearchControlGrammar();

    private PSearchControlGrammar() {
        this.name = PSearchControlGrammar.class.getName();
        this.statesEnum = PSearchControlStatesEnum.getInstance();
        this.transitions = new GrammarTransition[PSearchControlStatesEnum.LAST_PSEARCH_STATE][256];
        this.transitions[0][48] = new GrammarTransition(0, PSearchControlStatesEnum.PSEARCH_SEQUENCE_STATE, 48, (IAction)new GrammarAction("Init PSearchControl"){

            public void action(IAsn1Container container) {
                PSearchControlContainer psearchContainer = (PSearchControlContainer)container;
                PSearchControl control = new PSearchControl();
                psearchContainer.setPSearchControl(control);
            }
        });
        this.transitions[PSearchControlStatesEnum.PSEARCH_SEQUENCE_STATE][2] = new GrammarTransition(PSearchControlStatesEnum.PSEARCH_SEQUENCE_STATE, PSearchControlStatesEnum.CHANGE_TYPES_STATE, 2, (IAction)new GrammarAction("Set PSearchControl changeTypes"){

            public void action(IAsn1Container container) throws DecoderException {
                PSearchControlContainer psearchContainer = (PSearchControlContainer)container;
                Value value = psearchContainer.getCurrentTLV().getValue();
                try {
                    int changeTypes = IntegerDecoder.parse((Value)value, (int)1, (int)15);
                    if (IS_DEBUG) {
                        log.debug("changeTypes = " + changeTypes);
                    }
                    psearchContainer.getPSearchControl().setChangeTypes(changeTypes);
                }
                catch (IntegerDecoderException e) {
                    String msg = "failed to decode the changeTypes for PSearchControl";
                    log.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[PSearchControlStatesEnum.CHANGE_TYPES_STATE][1] = new GrammarTransition(PSearchControlStatesEnum.CHANGE_TYPES_STATE, PSearchControlStatesEnum.CHANGES_ONLY_STATE, 1, (IAction)new GrammarAction("Set PSearchControl changesOnly"){

            public void action(IAsn1Container container) throws DecoderException {
                PSearchControlContainer psearchContainer = (PSearchControlContainer)container;
                Value value = psearchContainer.getCurrentTLV().getValue();
                try {
                    boolean changesOnly = BooleanDecoder.parse((Value)value);
                    if (IS_DEBUG) {
                        log.debug("changesOnly = " + changesOnly);
                    }
                    psearchContainer.getPSearchControl().setChangesOnly(changesOnly);
                }
                catch (BooleanDecoderException e) {
                    String msg = "failed to decode the changesOnly for PSearchControl";
                    log.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[PSearchControlStatesEnum.CHANGES_ONLY_STATE][1] = new GrammarTransition(PSearchControlStatesEnum.CHANGES_ONLY_STATE, PSearchControlStatesEnum.RETURN_ECS_STATE, 1, (IAction)new GrammarAction("Set PSearchControl returnECs"){

            public void action(IAsn1Container container) throws DecoderException {
                PSearchControlContainer psearchContainer = (PSearchControlContainer)container;
                Value value = psearchContainer.getCurrentTLV().getValue();
                try {
                    boolean returnECs = BooleanDecoder.parse((Value)value);
                    if (IS_DEBUG) {
                        log.debug("returnECs = " + returnECs);
                    }
                    psearchContainer.getPSearchControl().setReturnECs(returnECs);
                    psearchContainer.grammarEndAllowed(true);
                }
                catch (BooleanDecoderException e) {
                    String msg = "failed to decode the returnECs for PSearchControl";
                    log.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

