/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapResponse;
import org.apache.directory.shared.ldap.codec.LdapResult;
import org.apache.directory.shared.ldap.codec.util.LdapResultEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultCodeAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger((Class)ResultCodeAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public ResultCodeAction() {
        super("Store resultCode");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage message = ldapMessageContainer.getLdapMessage();
        LdapResponse response = message.getLdapResponse();
        LdapResult ldapResult = new LdapResult();
        response.setLdapResult(ldapResult);
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        Value value = tlv.getValue();
        int resultCode = 0;
        try {
            resultCode = IntegerDecoder.parse((Value)value, (int)0, (int)90);
        }
        catch (IntegerDecoderException ide) {
            log.error("The result code " + StringTools.dumpBytes(value.getData()) + " is invalid : " + ide.getMessage() + ". The result code must be between (0 .. 90)");
            throw new DecoderException(ide.getMessage());
        }
        switch (resultCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: {
                ldapResult.setResultCode(resultCode);
                break;
            }
            default: {
                log.warn("The resultCode " + resultCode + " is unknown.");
                ldapResult.setResultCode(80);
            }
        }
        if (IS_DEBUG) {
            log.debug("The result code is set to " + LdapResultEnum.errorCode(resultCode));
        }
    }
}

