/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import java.util.Iterator;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapResponse;
import org.apache.directory.shared.ldap.codec.LdapResult;
import org.apache.directory.shared.ldap.codec.util.LdapURL;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferralAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger((Class)ReferralAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public ReferralAction() {
        super("Add a referral");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        LdapResponse response = ldapMessage.getLdapResponse();
        LdapResult ldapResult = response.getLdapResult();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            ldapResult.addReferral(LdapURL.EMPTY_URL);
        } else if (ldapResult.getResultCode() == 10) {
            try {
                ldapResult.addReferral(new LdapURL(tlv.getValue().getData()));
            }
            catch (LdapURLEncodingException luee) {
                String badUrl = new String(tlv.getValue().getData());
                log.error("The URL " + badUrl + " is not valid : " + luee.getMessage());
                throw new DecoderException("Invalid URL : " + luee.getMessage());
            }
        } else {
            log.warn("The Referral error message is not allowed when havind an error code no equals to REFERRAL");
            ldapResult.addReferral(LdapURL.EMPTY_URL);
        }
        ldapMessageContainer.grammarEndAllowed(true);
        if (IS_DEBUG) {
            Iterator urls = ldapResult.getReferrals().iterator();
            StringBuffer sb = new StringBuffer();
            boolean isFirst = true;
            while (urls.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(urls.next());
            }
            log.debug("The referral error message is set to " + sb.toString());
        }
    }
}

