/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.DITContentRuleRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDitContentRuleRegistry
implements DITContentRuleRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDitContentRuleRegistry.class);
    private final Map<String, DITContentRule> byOidDitContentRule = new ConcurrentHashMap<String, DITContentRule>();
    private final OidRegistry oidRegistry;

    public DefaultDitContentRuleRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
    }

    @Override
    public void register(DITContentRule dITContentRule) throws NamingException {
        String oid = dITContentRule.getOid();
        if (this.byOidDitContentRule.containsKey(oid)) {
            String msg = "dITContentRule w/ OID " + oid + " has already been registered!";
            LOG.warn(msg);
            throw new NamingException(msg);
        }
        this.oidRegistry.register(dITContentRule.getName(), oid);
        this.byOidDitContentRule.put(oid, dITContentRule);
        if (LOG.isDebugEnabled()) {
            LOG.debug("registed dITContentRule: {}", dITContentRule);
        }
    }

    @Override
    public DITContentRule lookup(String id) throws NamingException {
        String oid = this.oidRegistry.getOid(id);
        DITContentRule dITContentRule = this.byOidDitContentRule.get(oid);
        if (dITContentRule == null) {
            String msg = "dITContentRule w/ OID " + oid + " not registered!";
            LOG.debug(msg);
            throw new NamingException(msg);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("lookup with id '{}' of dITContentRule: {}", (Object)oid, (Object)dITContentRule);
        }
        return dITContentRule;
    }

    @Override
    public boolean hasDITContentRule(String id) {
        try {
            String oid = this.oidRegistry.getOid(id);
            if (oid != null) {
                return this.byOidDitContentRule.containsKey(oid);
            }
            return false;
        }
        catch (NamingException e) {
            return false;
        }
    }

    @Override
    public String getSchemaName(String id) throws NamingException {
        String oid = this.oidRegistry.getOid(id);
        DITContentRule dcr = this.byOidDitContentRule.get(oid);
        if (dcr != null) {
            return dcr.getSchema();
        }
        String msg = "OID " + oid + " not found in oid to " + "DITContentRule map!";
        LOG.error(msg);
        throw new NamingException(msg);
    }

    @Override
    public Iterator<DITContentRule> iterator() {
        return this.byOidDitContentRule.values().iterator();
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!OID.isOID(numericOid)) {
            String msg = "OID " + numericOid + " is not a numeric OID";
            LOG.error(msg);
            throw new NamingException(msg);
        }
        this.byOidDitContentRule.remove(numericOid);
    }
}

