/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.net.URL;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolException;
import org.xml.sax.InputSource;

public final class StAXUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(StAXUtil.class);
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();

    private StAXUtil() {
    }

    public static void toStartTag(XMLStreamReader r) throws XMLStreamException {
        while (!r.isStartElement() && r.hasNext()) {
            r.next();
        }
    }

    public static XMLStreamReader createFreshXMLStreamReader(InputSource source) {
        try {
            if (source.getCharacterStream() != null) {
                return XML_INPUT_FACTORY.createXMLStreamReader(source.getSystemId(), source.getCharacterStream());
            }
            if (source.getByteStream() != null) {
                return XML_INPUT_FACTORY.createXMLStreamReader(source.getSystemId(), source.getByteStream());
            }
            return XML_INPUT_FACTORY.createXMLStreamReader(source.getSystemId(), new URL(source.getSystemId()).openStream());
        }
        catch (Exception e) {
            Message msg = new Message("FAIL_TO_CREATE_STAX", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)e);
        }
    }

    static {
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
    }
}

