/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.TokenPolicyValidator;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.policy.model.Wss11;
import org.w3c.dom.Element;

public class WSS11PolicyValidator
extends AbstractTokenPolicyValidator
implements TokenPolicyValidator {
    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "Wss11");
        if (!ais.isEmpty()) {
            this.parsePolicies(ais, message, results);
            this.assertPolicy(aim, "MustSupportRefThumbprint");
            this.assertPolicy(aim, "MustSupportRefEncryptedKey");
            this.assertPolicy(aim, "RequireSignatureConfirmation");
            this.assertPolicy(aim, "MustSupportRefKeyIdentifier");
            this.assertPolicy(aim, "MustSupportRefIssuerSerial");
            this.assertPolicy(aim, "MustSupportRefExternalURI");
            this.assertPolicy(aim, "MustSupportRefEmbeddedToken");
        }
        return true;
    }

    private void parsePolicies(Collection<AssertionInfo> ais, Message message, List<WSSecurityEngineResult> results) {
        List scResults = WSSecurityUtil.fetchAllActionResults(results, (int)128);
        for (AssertionInfo ai : ais) {
            Wss11 wss11 = (Wss11)ai.getAssertion();
            ai.setAsserted(true);
            if (!MessageUtils.isRequestor((Message)message) || (!wss11.isRequireSignatureConfirmation() || !scResults.isEmpty()) && (wss11.isRequireSignatureConfirmation() || scResults.isEmpty())) continue;
            ai.setNotAsserted("Signature Confirmation policy validation failed");
        }
    }
}

