/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.AegisContext;
import org.apache.cxf.aegis.AegisReader;
import org.apache.cxf.aegis.AegisWriter;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.jaxrs.provider.AbstractAegisProvider;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/xml", "application/*+xml", "text/xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml"})
public class AegisElementProvider<T>
extends AbstractAegisProvider<T> {
    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType m, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        if (genericType == null) {
            genericType = type;
        }
        if (type == null) {
            type = this.messyCastToRawType(genericType);
        }
        AegisContext context = this.getAegisContext(type, genericType);
        AegisType typeToRead = context.getTypeMapping().getType(genericType);
        AegisReader aegisReader = context.createXMLStreamReader();
        try {
            XMLStreamReader xmlStreamReader = this.createStreamReader(typeToRead, is);
            return type.cast(aegisReader.read((Object)xmlStreamReader, typeToRead));
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private Class<T> messyCastToRawType(Type genericType) {
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)genericType;
            return (Class)pType.getRawType();
        }
        return null;
    }

    protected XMLStreamReader createStreamReader(AegisType topType, InputStream is) throws Exception {
        return StaxUtils.createXMLStreamReader((InputStream)is);
    }

    public void writeTo(T obj, Class<?> type, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        if (type == null) {
            type = obj.getClass();
        }
        if (genericType == null) {
            genericType = type;
        }
        AegisContext context = this.getAegisContext(type, genericType);
        AegisType aegisType = context.getTypeMapping().getType(genericType);
        AegisWriter aegisWriter = context.createXMLStreamWriter();
        try {
            XMLStreamWriter xmlStreamWriter = this.createStreamWriter(aegisType.getSchemaType(), os);
            xmlStreamWriter.writeStartDocument();
            aegisWriter.write(obj, aegisType.getSchemaType(), false, (Object)xmlStreamWriter, aegisType);
            xmlStreamWriter.writeEndDocument();
            xmlStreamWriter.close();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected XMLStreamWriter createStreamWriter(QName typeQName, OutputStream os) throws Exception {
        return StaxUtils.createXMLStreamWriter((OutputStream)os);
    }
}

