/**
 * Autogenerated by Thrift Compiler (0.7.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package org.apache.cassandra.thrift;
/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */


import org.apache.commons.lang.builder.HashCodeBuilder;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cassandra {

  public interface Iface {

    public void login(AuthenticationRequest auth_request) throws AuthenticationException, AuthorizationException, org.apache.thrift.TException;

    public void set_keyspace(String keyspace) throws InvalidRequestException, org.apache.thrift.TException;

    /**
     * Get the Column or SuperColumn at the given column_path. If no value is present, NotFoundException is thrown. (This is
     * the only method that can throw an exception under non-failure conditions.)
     *
     * @param key
     * @param column_path
     * @param consistency_level
     */
    public ColumnOrSuperColumn get(ByteBuffer key, ColumnPath column_path, ConsistencyLevel consistency_level) throws InvalidRequestException, NotFoundException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     * Get the group of columns contained by column_parent (either a ColumnFamily name or a ColumnFamily/SuperColumn name
     * pair) specified by the given SlicePredicate. If no matching values are found, an empty list is returned.
     *
     * @param key
     * @param column_parent
     * @param predicate
     * @param consistency_level
     */
    public List<ColumnOrSuperColumn> get_slice(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     * returns the number of columns matching <code>predicate</code> for a particular <code>key</code>,
     * <code>ColumnFamily</code> and optionally <code>SuperColumn</code>.
     *
     * @param key
     * @param column_parent
     * @param predicate
     * @param consistency_level
     */
    public int get_count(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     * Performs a get_slice for column_parent and predicate for the given keys in parallel.
     *
     * @param keys
     * @param column_parent
     * @param predicate
     * @param consistency_level
     */
    public Map<ByteBuffer,List<ColumnOrSuperColumn>> multiget_slice(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     * Perform a get_count in parallel on the given list<binary> keys. The return value maps keys to the count found.
     *
     * @param keys
     * @param column_parent
     * @param predicate
     * @param consistency_level
     */
    public Map<ByteBuffer,Integer> multiget_count(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     * returns a subset of columns for a contiguous range of keys.
     *
     * @param column_parent
     * @param predicate
     * @param range
     * @param consistency_level
     */
    public List<KeySlice> get_range_slices(ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     * returns a range of columns, wrapping to the next rows if necessary to collect max_results.
     *
     * @param column_family
     * @param range
     * @param start_column
     * @param consistency_level
     */
    public List<KeySlice> get_paged_slice(String column_family, KeyRange range, ByteBuffer start_column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     * Returns the subset of columns specified in SlicePredicate for the rows matching the IndexClause
     * @deprecated; use get_range_slices instead with range.row_filter specified
     *
     * @param column_parent
     * @param index_clause
     * @param column_predicate
     * @param consistency_level
     */
    public List<KeySlice> get_indexed_slices(ColumnParent column_parent, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     * Insert a Column at the given column_parent.column_family and optional column_parent.super_column.
     *
     * @param key
     * @param column_parent
     * @param column
     * @param consistency_level
     */
    public void insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     * Increment or decrement a counter.
     *
     * @param key
     * @param column_parent
     * @param column
     * @param consistency_level
     */
    public void add(ByteBuffer key, ColumnParent column_parent, CounterColumn column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     * Remove data from the row specified by key at the granularity specified by column_path, and the given timestamp. Note
     * that all the values in column_path besides column_path.column_family are truly optional: you can remove the entire
     * row by just specifying the ColumnFamily, or you can remove a SuperColumn or a single Column by specifying those levels too.
     *
     * @param key
     * @param column_path
     * @param timestamp
     * @param consistency_level
     */
    public void remove(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     * Remove a counter at the specified location.
     * Note that counters have limited support for deletes: if you remove a counter, you must wait to issue any following update
     * until the delete has reached all the nodes and all of them have been fully compacted.
     *
     * @param key
     * @param path
     * @param consistency_level
     */
    public void remove_counter(ByteBuffer key, ColumnPath path, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     *   Mutate many columns or super columns for many row keys. See also: Mutation.
     *
     *   mutation_map maps key to column family to a list of Mutation objects to take place at that scope.
     * *
     *
     * @param mutation_map
     * @param consistency_level
     */
    public void batch_mutate(Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     *   Atomically mutate many columns or super columns for many row keys. See also: Mutation.
     *
     *   mutation_map maps key to column family to a list of Mutation objects to take place at that scope.
     * *
     *
     * @param mutation_map
     * @param consistency_level
     */
    public void atomic_batch_mutate(Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     * Truncate will mark and entire column family as deleted.
     * From the user's perspective a successful call to truncate will result complete data deletion from cfname.
     * Internally, however, disk space will not be immediatily released, as with all deletes in cassandra, this one
     * only marks the data as deleted.
     * The operation succeeds only if all hosts in the cluster at available and will throw an UnavailableException if
     * some hosts are down.
     *
     * @param cfname
     */
    public void truncate(String cfname) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException;

    /**
     * for each schema version present in the cluster, returns a list of nodes at that version.
     * hosts that do not respond will be under the key DatabaseDescriptor.INITIAL_VERSION.
     * the cluster is all on the same version if the size of the map is 1.
     */
    public Map<String,List<String>> describe_schema_versions() throws InvalidRequestException, org.apache.thrift.TException;

    /**
     * list the defined keyspaces in this cluster
     */
    public List<KsDef> describe_keyspaces() throws InvalidRequestException, org.apache.thrift.TException;

    /**
     * get the cluster name
     */
    public String describe_cluster_name() throws org.apache.thrift.TException;

    /**
     * get the thrift api version
     */
    public String describe_version() throws org.apache.thrift.TException;

    /**
     * get the token ring: a map of ranges to host addresses,
     * represented as a set of TokenRange instead of a map from range
     * to list of endpoints, because you can't use Thrift structs as
     * map keys:
     * https://issues.apache.org/jira/browse/THRIFT-162
     *
     * for the same reason, we can't return a set here, even though
     * order is neither important nor predictable.
     *
     * @param keyspace
     */
    public List<TokenRange> describe_ring(String keyspace) throws InvalidRequestException, org.apache.thrift.TException;

    /**
     * get the mapping between token->node ip
     * without taking replication into consideration
     * https://issues.apache.org/jira/browse/CASSANDRA-4092
     */
    public Map<String,String> describe_token_map() throws InvalidRequestException, org.apache.thrift.TException;

    /**
     * returns the partitioner used by this cluster
     */
    public String describe_partitioner() throws org.apache.thrift.TException;

    /**
     * returns the snitch used by this cluster
     */
    public String describe_snitch() throws org.apache.thrift.TException;

    /**
     * describe specified keyspace
     *
     * @param keyspace
     */
    public KsDef describe_keyspace(String keyspace) throws NotFoundException, InvalidRequestException, org.apache.thrift.TException;

    /**
     * experimental API for hadoop/parallel query support.
     * may change violently and without warning.
     *
     * returns list of token strings such that first subrange is (list[0], list[1]],
     * next is (list[1], list[2]], etc.
     *
     * @param cfName
     * @param start_token
     * @param end_token
     * @param keys_per_split
     */
    public List<String> describe_splits(String cfName, String start_token, String end_token, int keys_per_split) throws InvalidRequestException, org.apache.thrift.TException;

    /**
     * Enables tracing for the next query in this connection and returns the UUID for that trace session
     * The next query will be traced idependently of trace probability and the returned UUID can be used to query the trace keyspace
     */
    public ByteBuffer trace_next_query() throws org.apache.thrift.TException;

    public List<CfSplit> describe_splits_ex(String cfName, String start_token, String end_token, int keys_per_split) throws InvalidRequestException, org.apache.thrift.TException;

    /**
     * adds a column family. returns the new schema id.
     *
     * @param cf_def
     */
    public String system_add_column_family(CfDef cf_def) throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException;

    /**
     * drops a column family. returns the new schema id.
     *
     * @param column_family
     */
    public String system_drop_column_family(String column_family) throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException;

    /**
     * adds a keyspace and any column families that are part of it. returns the new schema id.
     *
     * @param ks_def
     */
    public String system_add_keyspace(KsDef ks_def) throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException;

    /**
     * drops a keyspace and any column families that are part of it. returns the new schema id.
     *
     * @param keyspace
     */
    public String system_drop_keyspace(String keyspace) throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException;

    /**
     * updates properties of a keyspace. returns the new schema id.
     *
     * @param ks_def
     */
    public String system_update_keyspace(KsDef ks_def) throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException;

    /**
     * updates properties of a column family. returns the new schema id.
     *
     * @param cf_def
     */
    public String system_update_column_family(CfDef cf_def) throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException;

    /**
     * Executes a CQL (Cassandra Query Language) statement and returns a
     * CqlResult containing the results.
     *
     * @param query
     * @param compression
     */
    public CqlResult execute_cql_query(ByteBuffer query, Compression compression) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException;

    public CqlResult execute_cql3_query(ByteBuffer query, Compression compression, ConsistencyLevel consistency) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException;

    /**
     * Prepare a CQL (Cassandra Query Language) statement by compiling and returning
     * - the type of CQL statement
     * - an id token of the compiled CQL stored on the server side.
     * - a count of the discovered bound markers in the statement
     *
     * @param query
     * @param compression
     */
    public CqlPreparedResult prepare_cql_query(ByteBuffer query, Compression compression) throws InvalidRequestException, org.apache.thrift.TException;

    public CqlPreparedResult prepare_cql3_query(ByteBuffer query, Compression compression) throws InvalidRequestException, org.apache.thrift.TException;

    /**
     * Executes a prepared CQL (Cassandra Query Language) statement by passing an id token and  a list of variables
     * to bind and returns a CqlResult containing the results.
     *
     * @param itemId
     * @param values
     */
    public CqlResult execute_prepared_cql_query(int itemId, List<ByteBuffer> values) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException;

    public CqlResult execute_prepared_cql3_query(int itemId, List<ByteBuffer> values, ConsistencyLevel consistency) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException;

    /**
     * @deprecated This is now a no-op. Please use the CQL3 specific methods instead.
     *
     * @param version
     */
    public void set_cql_version(String version) throws InvalidRequestException, org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void login(AuthenticationRequest auth_request, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.login_call> resultHandler) throws org.apache.thrift.TException;

    public void set_keyspace(String keyspace, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.set_keyspace_call> resultHandler) throws org.apache.thrift.TException;

    public void get(ByteBuffer key, ColumnPath column_path, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.get_call> resultHandler) throws org.apache.thrift.TException;

    public void get_slice(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.get_slice_call> resultHandler) throws org.apache.thrift.TException;

    public void get_count(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.get_count_call> resultHandler) throws org.apache.thrift.TException;

    public void multiget_slice(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.multiget_slice_call> resultHandler) throws org.apache.thrift.TException;

    public void multiget_count(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.multiget_count_call> resultHandler) throws org.apache.thrift.TException;

    public void get_range_slices(ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.get_range_slices_call> resultHandler) throws org.apache.thrift.TException;

    public void get_paged_slice(String column_family, KeyRange range, ByteBuffer start_column, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.get_paged_slice_call> resultHandler) throws org.apache.thrift.TException;

    public void get_indexed_slices(ColumnParent column_parent, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.get_indexed_slices_call> resultHandler) throws org.apache.thrift.TException;

    public void insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.insert_call> resultHandler) throws org.apache.thrift.TException;

    public void add(ByteBuffer key, ColumnParent column_parent, CounterColumn column, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.add_call> resultHandler) throws org.apache.thrift.TException;

    public void remove(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.remove_call> resultHandler) throws org.apache.thrift.TException;

    public void remove_counter(ByteBuffer key, ColumnPath path, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.remove_counter_call> resultHandler) throws org.apache.thrift.TException;

    public void batch_mutate(Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.batch_mutate_call> resultHandler) throws org.apache.thrift.TException;

    public void atomic_batch_mutate(Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.atomic_batch_mutate_call> resultHandler) throws org.apache.thrift.TException;

    public void truncate(String cfname, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.truncate_call> resultHandler) throws org.apache.thrift.TException;

    public void describe_schema_versions(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.describe_schema_versions_call> resultHandler) throws org.apache.thrift.TException;

    public void describe_keyspaces(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.describe_keyspaces_call> resultHandler) throws org.apache.thrift.TException;

    public void describe_cluster_name(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.describe_cluster_name_call> resultHandler) throws org.apache.thrift.TException;

    public void describe_version(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.describe_version_call> resultHandler) throws org.apache.thrift.TException;

    public void describe_ring(String keyspace, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.describe_ring_call> resultHandler) throws org.apache.thrift.TException;

    public void describe_token_map(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.describe_token_map_call> resultHandler) throws org.apache.thrift.TException;

    public void describe_partitioner(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.describe_partitioner_call> resultHandler) throws org.apache.thrift.TException;

    public void describe_snitch(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.describe_snitch_call> resultHandler) throws org.apache.thrift.TException;

    public void describe_keyspace(String keyspace, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.describe_keyspace_call> resultHandler) throws org.apache.thrift.TException;

    public void describe_splits(String cfName, String start_token, String end_token, int keys_per_split, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.describe_splits_call> resultHandler) throws org.apache.thrift.TException;

    public void trace_next_query(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.trace_next_query_call> resultHandler) throws org.apache.thrift.TException;

    public void describe_splits_ex(String cfName, String start_token, String end_token, int keys_per_split, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.describe_splits_ex_call> resultHandler) throws org.apache.thrift.TException;

    public void system_add_column_family(CfDef cf_def, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.system_add_column_family_call> resultHandler) throws org.apache.thrift.TException;

    public void system_drop_column_family(String column_family, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.system_drop_column_family_call> resultHandler) throws org.apache.thrift.TException;

    public void system_add_keyspace(KsDef ks_def, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.system_add_keyspace_call> resultHandler) throws org.apache.thrift.TException;

    public void system_drop_keyspace(String keyspace, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.system_drop_keyspace_call> resultHandler) throws org.apache.thrift.TException;

    public void system_update_keyspace(KsDef ks_def, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.system_update_keyspace_call> resultHandler) throws org.apache.thrift.TException;

    public void system_update_column_family(CfDef cf_def, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.system_update_column_family_call> resultHandler) throws org.apache.thrift.TException;

    public void execute_cql_query(ByteBuffer query, Compression compression, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.execute_cql_query_call> resultHandler) throws org.apache.thrift.TException;

    public void execute_cql3_query(ByteBuffer query, Compression compression, ConsistencyLevel consistency, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.execute_cql3_query_call> resultHandler) throws org.apache.thrift.TException;

    public void prepare_cql_query(ByteBuffer query, Compression compression, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.prepare_cql_query_call> resultHandler) throws org.apache.thrift.TException;

    public void prepare_cql3_query(ByteBuffer query, Compression compression, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.prepare_cql3_query_call> resultHandler) throws org.apache.thrift.TException;

    public void execute_prepared_cql_query(int itemId, List<ByteBuffer> values, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.execute_prepared_cql_query_call> resultHandler) throws org.apache.thrift.TException;

    public void execute_prepared_cql3_query(int itemId, List<ByteBuffer> values, ConsistencyLevel consistency, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.execute_prepared_cql3_query_call> resultHandler) throws org.apache.thrift.TException;

    public void set_cql_version(String version, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.set_cql_version_call> resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public void login(AuthenticationRequest auth_request) throws AuthenticationException, AuthorizationException, org.apache.thrift.TException
    {
      send_login(auth_request);
      recv_login();
    }

    public void send_login(AuthenticationRequest auth_request) throws org.apache.thrift.TException
    {
      login_args args = new login_args();
      args.setAuth_request(auth_request);
      sendBase("login", args);
    }

    public void recv_login() throws AuthenticationException, AuthorizationException, org.apache.thrift.TException
    {
      login_result result = new login_result();
      receiveBase(result, "login");
      if (result.authnx != null) {
        throw result.authnx;
      }
      if (result.authzx != null) {
        throw result.authzx;
      }
      return;
    }

    public void set_keyspace(String keyspace) throws InvalidRequestException, org.apache.thrift.TException
    {
      send_set_keyspace(keyspace);
      recv_set_keyspace();
    }

    public void send_set_keyspace(String keyspace) throws org.apache.thrift.TException
    {
      set_keyspace_args args = new set_keyspace_args();
      args.setKeyspace(keyspace);
      sendBase("set_keyspace", args);
    }

    public void recv_set_keyspace() throws InvalidRequestException, org.apache.thrift.TException
    {
      set_keyspace_result result = new set_keyspace_result();
      receiveBase(result, "set_keyspace");
      if (result.ire != null) {
        throw result.ire;
      }
      return;
    }

    public ColumnOrSuperColumn get(ByteBuffer key, ColumnPath column_path, ConsistencyLevel consistency_level) throws InvalidRequestException, NotFoundException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_get(key, column_path, consistency_level);
      return recv_get();
    }

    public void send_get(ByteBuffer key, ColumnPath column_path, ConsistencyLevel consistency_level) throws org.apache.thrift.TException
    {
      get_args args = new get_args();
      args.setKey(key);
      args.setColumn_path(column_path);
      args.setConsistency_level(consistency_level);
      sendBase("get", args);
    }

    public ColumnOrSuperColumn recv_get() throws InvalidRequestException, NotFoundException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      get_result result = new get_result();
      receiveBase(result, "get");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.nfe != null) {
        throw result.nfe;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "get failed: unknown result");
    }

    public List<ColumnOrSuperColumn> get_slice(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_get_slice(key, column_parent, predicate, consistency_level);
      return recv_get_slice();
    }

    public void send_get_slice(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws org.apache.thrift.TException
    {
      get_slice_args args = new get_slice_args();
      args.setKey(key);
      args.setColumn_parent(column_parent);
      args.setPredicate(predicate);
      args.setConsistency_level(consistency_level);
      sendBase("get_slice", args);
    }

    public List<ColumnOrSuperColumn> recv_get_slice() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      get_slice_result result = new get_slice_result();
      receiveBase(result, "get_slice");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "get_slice failed: unknown result");
    }

    public int get_count(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_get_count(key, column_parent, predicate, consistency_level);
      return recv_get_count();
    }

    public void send_get_count(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws org.apache.thrift.TException
    {
      get_count_args args = new get_count_args();
      args.setKey(key);
      args.setColumn_parent(column_parent);
      args.setPredicate(predicate);
      args.setConsistency_level(consistency_level);
      sendBase("get_count", args);
    }

    public int recv_get_count() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      get_count_result result = new get_count_result();
      receiveBase(result, "get_count");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "get_count failed: unknown result");
    }

    public Map<ByteBuffer,List<ColumnOrSuperColumn>> multiget_slice(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_multiget_slice(keys, column_parent, predicate, consistency_level);
      return recv_multiget_slice();
    }

    public void send_multiget_slice(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws org.apache.thrift.TException
    {
      multiget_slice_args args = new multiget_slice_args();
      args.setKeys(keys);
      args.setColumn_parent(column_parent);
      args.setPredicate(predicate);
      args.setConsistency_level(consistency_level);
      sendBase("multiget_slice", args);
    }

    public Map<ByteBuffer,List<ColumnOrSuperColumn>> recv_multiget_slice() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      multiget_slice_result result = new multiget_slice_result();
      receiveBase(result, "multiget_slice");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "multiget_slice failed: unknown result");
    }

    public Map<ByteBuffer,Integer> multiget_count(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_multiget_count(keys, column_parent, predicate, consistency_level);
      return recv_multiget_count();
    }

    public void send_multiget_count(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws org.apache.thrift.TException
    {
      multiget_count_args args = new multiget_count_args();
      args.setKeys(keys);
      args.setColumn_parent(column_parent);
      args.setPredicate(predicate);
      args.setConsistency_level(consistency_level);
      sendBase("multiget_count", args);
    }

    public Map<ByteBuffer,Integer> recv_multiget_count() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      multiget_count_result result = new multiget_count_result();
      receiveBase(result, "multiget_count");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "multiget_count failed: unknown result");
    }

    public List<KeySlice> get_range_slices(ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_get_range_slices(column_parent, predicate, range, consistency_level);
      return recv_get_range_slices();
    }

    public void send_get_range_slices(ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level) throws org.apache.thrift.TException
    {
      get_range_slices_args args = new get_range_slices_args();
      args.setColumn_parent(column_parent);
      args.setPredicate(predicate);
      args.setRange(range);
      args.setConsistency_level(consistency_level);
      sendBase("get_range_slices", args);
    }

    public List<KeySlice> recv_get_range_slices() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      get_range_slices_result result = new get_range_slices_result();
      receiveBase(result, "get_range_slices");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "get_range_slices failed: unknown result");
    }

    public List<KeySlice> get_paged_slice(String column_family, KeyRange range, ByteBuffer start_column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_get_paged_slice(column_family, range, start_column, consistency_level);
      return recv_get_paged_slice();
    }

    public void send_get_paged_slice(String column_family, KeyRange range, ByteBuffer start_column, ConsistencyLevel consistency_level) throws org.apache.thrift.TException
    {
      get_paged_slice_args args = new get_paged_slice_args();
      args.setColumn_family(column_family);
      args.setRange(range);
      args.setStart_column(start_column);
      args.setConsistency_level(consistency_level);
      sendBase("get_paged_slice", args);
    }

    public List<KeySlice> recv_get_paged_slice() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      get_paged_slice_result result = new get_paged_slice_result();
      receiveBase(result, "get_paged_slice");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "get_paged_slice failed: unknown result");
    }

    public List<KeySlice> get_indexed_slices(ColumnParent column_parent, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_get_indexed_slices(column_parent, index_clause, column_predicate, consistency_level);
      return recv_get_indexed_slices();
    }

    public void send_get_indexed_slices(ColumnParent column_parent, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level) throws org.apache.thrift.TException
    {
      get_indexed_slices_args args = new get_indexed_slices_args();
      args.setColumn_parent(column_parent);
      args.setIndex_clause(index_clause);
      args.setColumn_predicate(column_predicate);
      args.setConsistency_level(consistency_level);
      sendBase("get_indexed_slices", args);
    }

    public List<KeySlice> recv_get_indexed_slices() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      get_indexed_slices_result result = new get_indexed_slices_result();
      receiveBase(result, "get_indexed_slices");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "get_indexed_slices failed: unknown result");
    }

    public void insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_insert(key, column_parent, column, consistency_level);
      recv_insert();
    }

    public void send_insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level) throws org.apache.thrift.TException
    {
      insert_args args = new insert_args();
      args.setKey(key);
      args.setColumn_parent(column_parent);
      args.setColumn(column);
      args.setConsistency_level(consistency_level);
      sendBase("insert", args);
    }

    public void recv_insert() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      insert_result result = new insert_result();
      receiveBase(result, "insert");
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      return;
    }

    public void add(ByteBuffer key, ColumnParent column_parent, CounterColumn column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_add(key, column_parent, column, consistency_level);
      recv_add();
    }

    public void send_add(ByteBuffer key, ColumnParent column_parent, CounterColumn column, ConsistencyLevel consistency_level) throws org.apache.thrift.TException
    {
      add_args args = new add_args();
      args.setKey(key);
      args.setColumn_parent(column_parent);
      args.setColumn(column);
      args.setConsistency_level(consistency_level);
      sendBase("add", args);
    }

    public void recv_add() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      add_result result = new add_result();
      receiveBase(result, "add");
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      return;
    }

    public void remove(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_remove(key, column_path, timestamp, consistency_level);
      recv_remove();
    }

    public void send_remove(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level) throws org.apache.thrift.TException
    {
      remove_args args = new remove_args();
      args.setKey(key);
      args.setColumn_path(column_path);
      args.setTimestamp(timestamp);
      args.setConsistency_level(consistency_level);
      sendBase("remove", args);
    }

    public void recv_remove() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      remove_result result = new remove_result();
      receiveBase(result, "remove");
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      return;
    }

    public void remove_counter(ByteBuffer key, ColumnPath path, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_remove_counter(key, path, consistency_level);
      recv_remove_counter();
    }

    public void send_remove_counter(ByteBuffer key, ColumnPath path, ConsistencyLevel consistency_level) throws org.apache.thrift.TException
    {
      remove_counter_args args = new remove_counter_args();
      args.setKey(key);
      args.setPath(path);
      args.setConsistency_level(consistency_level);
      sendBase("remove_counter", args);
    }

    public void recv_remove_counter() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      remove_counter_result result = new remove_counter_result();
      receiveBase(result, "remove_counter");
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      return;
    }

    public void batch_mutate(Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_batch_mutate(mutation_map, consistency_level);
      recv_batch_mutate();
    }

    public void send_batch_mutate(Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws org.apache.thrift.TException
    {
      batch_mutate_args args = new batch_mutate_args();
      args.setMutation_map(mutation_map);
      args.setConsistency_level(consistency_level);
      sendBase("batch_mutate", args);
    }

    public void recv_batch_mutate() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      batch_mutate_result result = new batch_mutate_result();
      receiveBase(result, "batch_mutate");
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      return;
    }

    public void atomic_batch_mutate(Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_atomic_batch_mutate(mutation_map, consistency_level);
      recv_atomic_batch_mutate();
    }

    public void send_atomic_batch_mutate(Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws org.apache.thrift.TException
    {
      atomic_batch_mutate_args args = new atomic_batch_mutate_args();
      args.setMutation_map(mutation_map);
      args.setConsistency_level(consistency_level);
      sendBase("atomic_batch_mutate", args);
    }

    public void recv_atomic_batch_mutate() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      atomic_batch_mutate_result result = new atomic_batch_mutate_result();
      receiveBase(result, "atomic_batch_mutate");
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      return;
    }

    public void truncate(String cfname) throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      send_truncate(cfname);
      recv_truncate();
    }

    public void send_truncate(String cfname) throws org.apache.thrift.TException
    {
      truncate_args args = new truncate_args();
      args.setCfname(cfname);
      sendBase("truncate", args);
    }

    public void recv_truncate() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException
    {
      truncate_result result = new truncate_result();
      receiveBase(result, "truncate");
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      return;
    }

    public Map<String,List<String>> describe_schema_versions() throws InvalidRequestException, org.apache.thrift.TException
    {
      send_describe_schema_versions();
      return recv_describe_schema_versions();
    }

    public void send_describe_schema_versions() throws org.apache.thrift.TException
    {
      describe_schema_versions_args args = new describe_schema_versions_args();
      sendBase("describe_schema_versions", args);
    }

    public Map<String,List<String>> recv_describe_schema_versions() throws InvalidRequestException, org.apache.thrift.TException
    {
      describe_schema_versions_result result = new describe_schema_versions_result();
      receiveBase(result, "describe_schema_versions");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "describe_schema_versions failed: unknown result");
    }

    public List<KsDef> describe_keyspaces() throws InvalidRequestException, org.apache.thrift.TException
    {
      send_describe_keyspaces();
      return recv_describe_keyspaces();
    }

    public void send_describe_keyspaces() throws org.apache.thrift.TException
    {
      describe_keyspaces_args args = new describe_keyspaces_args();
      sendBase("describe_keyspaces", args);
    }

    public List<KsDef> recv_describe_keyspaces() throws InvalidRequestException, org.apache.thrift.TException
    {
      describe_keyspaces_result result = new describe_keyspaces_result();
      receiveBase(result, "describe_keyspaces");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "describe_keyspaces failed: unknown result");
    }

    public String describe_cluster_name() throws org.apache.thrift.TException
    {
      send_describe_cluster_name();
      return recv_describe_cluster_name();
    }

    public void send_describe_cluster_name() throws org.apache.thrift.TException
    {
      describe_cluster_name_args args = new describe_cluster_name_args();
      sendBase("describe_cluster_name", args);
    }

    public String recv_describe_cluster_name() throws org.apache.thrift.TException
    {
      describe_cluster_name_result result = new describe_cluster_name_result();
      receiveBase(result, "describe_cluster_name");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "describe_cluster_name failed: unknown result");
    }

    public String describe_version() throws org.apache.thrift.TException
    {
      send_describe_version();
      return recv_describe_version();
    }

    public void send_describe_version() throws org.apache.thrift.TException
    {
      describe_version_args args = new describe_version_args();
      sendBase("describe_version", args);
    }

    public String recv_describe_version() throws org.apache.thrift.TException
    {
      describe_version_result result = new describe_version_result();
      receiveBase(result, "describe_version");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "describe_version failed: unknown result");
    }

    public List<TokenRange> describe_ring(String keyspace) throws InvalidRequestException, org.apache.thrift.TException
    {
      send_describe_ring(keyspace);
      return recv_describe_ring();
    }

    public void send_describe_ring(String keyspace) throws org.apache.thrift.TException
    {
      describe_ring_args args = new describe_ring_args();
      args.setKeyspace(keyspace);
      sendBase("describe_ring", args);
    }

    public List<TokenRange> recv_describe_ring() throws InvalidRequestException, org.apache.thrift.TException
    {
      describe_ring_result result = new describe_ring_result();
      receiveBase(result, "describe_ring");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "describe_ring failed: unknown result");
    }

    public Map<String,String> describe_token_map() throws InvalidRequestException, org.apache.thrift.TException
    {
      send_describe_token_map();
      return recv_describe_token_map();
    }

    public void send_describe_token_map() throws org.apache.thrift.TException
    {
      describe_token_map_args args = new describe_token_map_args();
      sendBase("describe_token_map", args);
    }

    public Map<String,String> recv_describe_token_map() throws InvalidRequestException, org.apache.thrift.TException
    {
      describe_token_map_result result = new describe_token_map_result();
      receiveBase(result, "describe_token_map");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "describe_token_map failed: unknown result");
    }

    public String describe_partitioner() throws org.apache.thrift.TException
    {
      send_describe_partitioner();
      return recv_describe_partitioner();
    }

    public void send_describe_partitioner() throws org.apache.thrift.TException
    {
      describe_partitioner_args args = new describe_partitioner_args();
      sendBase("describe_partitioner", args);
    }

    public String recv_describe_partitioner() throws org.apache.thrift.TException
    {
      describe_partitioner_result result = new describe_partitioner_result();
      receiveBase(result, "describe_partitioner");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "describe_partitioner failed: unknown result");
    }

    public String describe_snitch() throws org.apache.thrift.TException
    {
      send_describe_snitch();
      return recv_describe_snitch();
    }

    public void send_describe_snitch() throws org.apache.thrift.TException
    {
      describe_snitch_args args = new describe_snitch_args();
      sendBase("describe_snitch", args);
    }

    public String recv_describe_snitch() throws org.apache.thrift.TException
    {
      describe_snitch_result result = new describe_snitch_result();
      receiveBase(result, "describe_snitch");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "describe_snitch failed: unknown result");
    }

    public KsDef describe_keyspace(String keyspace) throws NotFoundException, InvalidRequestException, org.apache.thrift.TException
    {
      send_describe_keyspace(keyspace);
      return recv_describe_keyspace();
    }

    public void send_describe_keyspace(String keyspace) throws org.apache.thrift.TException
    {
      describe_keyspace_args args = new describe_keyspace_args();
      args.setKeyspace(keyspace);
      sendBase("describe_keyspace", args);
    }

    public KsDef recv_describe_keyspace() throws NotFoundException, InvalidRequestException, org.apache.thrift.TException
    {
      describe_keyspace_result result = new describe_keyspace_result();
      receiveBase(result, "describe_keyspace");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.nfe != null) {
        throw result.nfe;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "describe_keyspace failed: unknown result");
    }

    public List<String> describe_splits(String cfName, String start_token, String end_token, int keys_per_split) throws InvalidRequestException, org.apache.thrift.TException
    {
      send_describe_splits(cfName, start_token, end_token, keys_per_split);
      return recv_describe_splits();
    }

    public void send_describe_splits(String cfName, String start_token, String end_token, int keys_per_split) throws org.apache.thrift.TException
    {
      describe_splits_args args = new describe_splits_args();
      args.setCfName(cfName);
      args.setStart_token(start_token);
      args.setEnd_token(end_token);
      args.setKeys_per_split(keys_per_split);
      sendBase("describe_splits", args);
    }

    public List<String> recv_describe_splits() throws InvalidRequestException, org.apache.thrift.TException
    {
      describe_splits_result result = new describe_splits_result();
      receiveBase(result, "describe_splits");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "describe_splits failed: unknown result");
    }

    public ByteBuffer trace_next_query() throws org.apache.thrift.TException
    {
      send_trace_next_query();
      return recv_trace_next_query();
    }

    public void send_trace_next_query() throws org.apache.thrift.TException
    {
      trace_next_query_args args = new trace_next_query_args();
      sendBase("trace_next_query", args);
    }

    public ByteBuffer recv_trace_next_query() throws org.apache.thrift.TException
    {
      trace_next_query_result result = new trace_next_query_result();
      receiveBase(result, "trace_next_query");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "trace_next_query failed: unknown result");
    }

    public List<CfSplit> describe_splits_ex(String cfName, String start_token, String end_token, int keys_per_split) throws InvalidRequestException, org.apache.thrift.TException
    {
      send_describe_splits_ex(cfName, start_token, end_token, keys_per_split);
      return recv_describe_splits_ex();
    }

    public void send_describe_splits_ex(String cfName, String start_token, String end_token, int keys_per_split) throws org.apache.thrift.TException
    {
      describe_splits_ex_args args = new describe_splits_ex_args();
      args.setCfName(cfName);
      args.setStart_token(start_token);
      args.setEnd_token(end_token);
      args.setKeys_per_split(keys_per_split);
      sendBase("describe_splits_ex", args);
    }

    public List<CfSplit> recv_describe_splits_ex() throws InvalidRequestException, org.apache.thrift.TException
    {
      describe_splits_ex_result result = new describe_splits_ex_result();
      receiveBase(result, "describe_splits_ex");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "describe_splits_ex failed: unknown result");
    }

    public String system_add_column_family(CfDef cf_def) throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException
    {
      send_system_add_column_family(cf_def);
      return recv_system_add_column_family();
    }

    public void send_system_add_column_family(CfDef cf_def) throws org.apache.thrift.TException
    {
      system_add_column_family_args args = new system_add_column_family_args();
      args.setCf_def(cf_def);
      sendBase("system_add_column_family", args);
    }

    public String recv_system_add_column_family() throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException
    {
      system_add_column_family_result result = new system_add_column_family_result();
      receiveBase(result, "system_add_column_family");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.sde != null) {
        throw result.sde;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "system_add_column_family failed: unknown result");
    }

    public String system_drop_column_family(String column_family) throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException
    {
      send_system_drop_column_family(column_family);
      return recv_system_drop_column_family();
    }

    public void send_system_drop_column_family(String column_family) throws org.apache.thrift.TException
    {
      system_drop_column_family_args args = new system_drop_column_family_args();
      args.setColumn_family(column_family);
      sendBase("system_drop_column_family", args);
    }

    public String recv_system_drop_column_family() throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException
    {
      system_drop_column_family_result result = new system_drop_column_family_result();
      receiveBase(result, "system_drop_column_family");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.sde != null) {
        throw result.sde;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "system_drop_column_family failed: unknown result");
    }

    public String system_add_keyspace(KsDef ks_def) throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException
    {
      send_system_add_keyspace(ks_def);
      return recv_system_add_keyspace();
    }

    public void send_system_add_keyspace(KsDef ks_def) throws org.apache.thrift.TException
    {
      system_add_keyspace_args args = new system_add_keyspace_args();
      args.setKs_def(ks_def);
      sendBase("system_add_keyspace", args);
    }

    public String recv_system_add_keyspace() throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException
    {
      system_add_keyspace_result result = new system_add_keyspace_result();
      receiveBase(result, "system_add_keyspace");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.sde != null) {
        throw result.sde;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "system_add_keyspace failed: unknown result");
    }

    public String system_drop_keyspace(String keyspace) throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException
    {
      send_system_drop_keyspace(keyspace);
      return recv_system_drop_keyspace();
    }

    public void send_system_drop_keyspace(String keyspace) throws org.apache.thrift.TException
    {
      system_drop_keyspace_args args = new system_drop_keyspace_args();
      args.setKeyspace(keyspace);
      sendBase("system_drop_keyspace", args);
    }

    public String recv_system_drop_keyspace() throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException
    {
      system_drop_keyspace_result result = new system_drop_keyspace_result();
      receiveBase(result, "system_drop_keyspace");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.sde != null) {
        throw result.sde;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "system_drop_keyspace failed: unknown result");
    }

    public String system_update_keyspace(KsDef ks_def) throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException
    {
      send_system_update_keyspace(ks_def);
      return recv_system_update_keyspace();
    }

    public void send_system_update_keyspace(KsDef ks_def) throws org.apache.thrift.TException
    {
      system_update_keyspace_args args = new system_update_keyspace_args();
      args.setKs_def(ks_def);
      sendBase("system_update_keyspace", args);
    }

    public String recv_system_update_keyspace() throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException
    {
      system_update_keyspace_result result = new system_update_keyspace_result();
      receiveBase(result, "system_update_keyspace");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.sde != null) {
        throw result.sde;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "system_update_keyspace failed: unknown result");
    }

    public String system_update_column_family(CfDef cf_def) throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException
    {
      send_system_update_column_family(cf_def);
      return recv_system_update_column_family();
    }

    public void send_system_update_column_family(CfDef cf_def) throws org.apache.thrift.TException
    {
      system_update_column_family_args args = new system_update_column_family_args();
      args.setCf_def(cf_def);
      sendBase("system_update_column_family", args);
    }

    public String recv_system_update_column_family() throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException
    {
      system_update_column_family_result result = new system_update_column_family_result();
      receiveBase(result, "system_update_column_family");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.sde != null) {
        throw result.sde;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "system_update_column_family failed: unknown result");
    }

    public CqlResult execute_cql_query(ByteBuffer query, Compression compression) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException
    {
      send_execute_cql_query(query, compression);
      return recv_execute_cql_query();
    }

    public void send_execute_cql_query(ByteBuffer query, Compression compression) throws org.apache.thrift.TException
    {
      execute_cql_query_args args = new execute_cql_query_args();
      args.setQuery(query);
      args.setCompression(compression);
      sendBase("execute_cql_query", args);
    }

    public CqlResult recv_execute_cql_query() throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException
    {
      execute_cql_query_result result = new execute_cql_query_result();
      receiveBase(result, "execute_cql_query");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      if (result.sde != null) {
        throw result.sde;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "execute_cql_query failed: unknown result");
    }

    public CqlResult execute_cql3_query(ByteBuffer query, Compression compression, ConsistencyLevel consistency) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException
    {
      send_execute_cql3_query(query, compression, consistency);
      return recv_execute_cql3_query();
    }

    public void send_execute_cql3_query(ByteBuffer query, Compression compression, ConsistencyLevel consistency) throws org.apache.thrift.TException
    {
      execute_cql3_query_args args = new execute_cql3_query_args();
      args.setQuery(query);
      args.setCompression(compression);
      args.setConsistency(consistency);
      sendBase("execute_cql3_query", args);
    }

    public CqlResult recv_execute_cql3_query() throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException
    {
      execute_cql3_query_result result = new execute_cql3_query_result();
      receiveBase(result, "execute_cql3_query");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      if (result.sde != null) {
        throw result.sde;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "execute_cql3_query failed: unknown result");
    }

    public CqlPreparedResult prepare_cql_query(ByteBuffer query, Compression compression) throws InvalidRequestException, org.apache.thrift.TException
    {
      send_prepare_cql_query(query, compression);
      return recv_prepare_cql_query();
    }

    public void send_prepare_cql_query(ByteBuffer query, Compression compression) throws org.apache.thrift.TException
    {
      prepare_cql_query_args args = new prepare_cql_query_args();
      args.setQuery(query);
      args.setCompression(compression);
      sendBase("prepare_cql_query", args);
    }

    public CqlPreparedResult recv_prepare_cql_query() throws InvalidRequestException, org.apache.thrift.TException
    {
      prepare_cql_query_result result = new prepare_cql_query_result();
      receiveBase(result, "prepare_cql_query");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "prepare_cql_query failed: unknown result");
    }

    public CqlPreparedResult prepare_cql3_query(ByteBuffer query, Compression compression) throws InvalidRequestException, org.apache.thrift.TException
    {
      send_prepare_cql3_query(query, compression);
      return recv_prepare_cql3_query();
    }

    public void send_prepare_cql3_query(ByteBuffer query, Compression compression) throws org.apache.thrift.TException
    {
      prepare_cql3_query_args args = new prepare_cql3_query_args();
      args.setQuery(query);
      args.setCompression(compression);
      sendBase("prepare_cql3_query", args);
    }

    public CqlPreparedResult recv_prepare_cql3_query() throws InvalidRequestException, org.apache.thrift.TException
    {
      prepare_cql3_query_result result = new prepare_cql3_query_result();
      receiveBase(result, "prepare_cql3_query");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "prepare_cql3_query failed: unknown result");
    }

    public CqlResult execute_prepared_cql_query(int itemId, List<ByteBuffer> values) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException
    {
      send_execute_prepared_cql_query(itemId, values);
      return recv_execute_prepared_cql_query();
    }

    public void send_execute_prepared_cql_query(int itemId, List<ByteBuffer> values) throws org.apache.thrift.TException
    {
      execute_prepared_cql_query_args args = new execute_prepared_cql_query_args();
      args.setItemId(itemId);
      args.setValues(values);
      sendBase("execute_prepared_cql_query", args);
    }

    public CqlResult recv_execute_prepared_cql_query() throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException
    {
      execute_prepared_cql_query_result result = new execute_prepared_cql_query_result();
      receiveBase(result, "execute_prepared_cql_query");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      if (result.sde != null) {
        throw result.sde;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "execute_prepared_cql_query failed: unknown result");
    }

    public CqlResult execute_prepared_cql3_query(int itemId, List<ByteBuffer> values, ConsistencyLevel consistency) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException
    {
      send_execute_prepared_cql3_query(itemId, values, consistency);
      return recv_execute_prepared_cql3_query();
    }

    public void send_execute_prepared_cql3_query(int itemId, List<ByteBuffer> values, ConsistencyLevel consistency) throws org.apache.thrift.TException
    {
      execute_prepared_cql3_query_args args = new execute_prepared_cql3_query_args();
      args.setItemId(itemId);
      args.setValues(values);
      args.setConsistency(consistency);
      sendBase("execute_prepared_cql3_query", args);
    }

    public CqlResult recv_execute_prepared_cql3_query() throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException
    {
      execute_prepared_cql3_query_result result = new execute_prepared_cql3_query_result();
      receiveBase(result, "execute_prepared_cql3_query");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ue != null) {
        throw result.ue;
      }
      if (result.te != null) {
        throw result.te;
      }
      if (result.sde != null) {
        throw result.sde;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "execute_prepared_cql3_query failed: unknown result");
    }

    public void set_cql_version(String version) throws InvalidRequestException, org.apache.thrift.TException
    {
      send_set_cql_version(version);
      recv_set_cql_version();
    }

    public void send_set_cql_version(String version) throws org.apache.thrift.TException
    {
      set_cql_version_args args = new set_cql_version_args();
      args.setVersion(version);
      sendBase("set_cql_version", args);
    }

    public void recv_set_cql_version() throws InvalidRequestException, org.apache.thrift.TException
    {
      set_cql_version_result result = new set_cql_version_result();
      receiveBase(result, "set_cql_version");
      if (result.ire != null) {
        throw result.ire;
      }
      return;
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void login(AuthenticationRequest auth_request, org.apache.thrift.async.AsyncMethodCallback<login_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      login_call method_call = new login_call(auth_request, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class login_call extends org.apache.thrift.async.TAsyncMethodCall {
      private AuthenticationRequest auth_request;
      public login_call(AuthenticationRequest auth_request, org.apache.thrift.async.AsyncMethodCallback<login_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.auth_request = auth_request;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("login", org.apache.thrift.protocol.TMessageType.CALL, 0));
        login_args args = new login_args();
        args.setAuth_request(auth_request);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AuthenticationException, AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_login();
      }
    }

    public void set_keyspace(String keyspace, org.apache.thrift.async.AsyncMethodCallback<set_keyspace_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      set_keyspace_call method_call = new set_keyspace_call(keyspace, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class set_keyspace_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String keyspace;
      public set_keyspace_call(String keyspace, org.apache.thrift.async.AsyncMethodCallback<set_keyspace_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.keyspace = keyspace;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("set_keyspace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        set_keyspace_args args = new set_keyspace_args();
        args.setKeyspace(keyspace);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws InvalidRequestException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_set_keyspace();
      }
    }

    public void get(ByteBuffer key, ColumnPath column_path, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<get_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      get_call method_call = new get_call(key, column_path, consistency_level, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class get_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer key;
      private ColumnPath column_path;
      private ConsistencyLevel consistency_level;
      public get_call(ByteBuffer key, ColumnPath column_path, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<get_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.column_path = column_path;
        this.consistency_level = consistency_level;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("get", org.apache.thrift.protocol.TMessageType.CALL, 0));
        get_args args = new get_args();
        args.setKey(key);
        args.setColumn_path(column_path);
        args.setConsistency_level(consistency_level);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ColumnOrSuperColumn getResult() throws InvalidRequestException, NotFoundException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_get();
      }
    }

    public void get_slice(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<get_slice_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      get_slice_call method_call = new get_slice_call(key, column_parent, predicate, consistency_level, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class get_slice_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer key;
      private ColumnParent column_parent;
      private SlicePredicate predicate;
      private ConsistencyLevel consistency_level;
      public get_slice_call(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<get_slice_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.column_parent = column_parent;
        this.predicate = predicate;
        this.consistency_level = consistency_level;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("get_slice", org.apache.thrift.protocol.TMessageType.CALL, 0));
        get_slice_args args = new get_slice_args();
        args.setKey(key);
        args.setColumn_parent(column_parent);
        args.setPredicate(predicate);
        args.setConsistency_level(consistency_level);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ColumnOrSuperColumn> getResult() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_get_slice();
      }
    }

    public void get_count(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<get_count_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      get_count_call method_call = new get_count_call(key, column_parent, predicate, consistency_level, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class get_count_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer key;
      private ColumnParent column_parent;
      private SlicePredicate predicate;
      private ConsistencyLevel consistency_level;
      public get_count_call(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<get_count_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.column_parent = column_parent;
        this.predicate = predicate;
        this.consistency_level = consistency_level;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("get_count", org.apache.thrift.protocol.TMessageType.CALL, 0));
        get_count_args args = new get_count_args();
        args.setKey(key);
        args.setColumn_parent(column_parent);
        args.setPredicate(predicate);
        args.setConsistency_level(consistency_level);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_get_count();
      }
    }

    public void multiget_slice(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<multiget_slice_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      multiget_slice_call method_call = new multiget_slice_call(keys, column_parent, predicate, consistency_level, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class multiget_slice_call extends org.apache.thrift.async.TAsyncMethodCall {
      private List<ByteBuffer> keys;
      private ColumnParent column_parent;
      private SlicePredicate predicate;
      private ConsistencyLevel consistency_level;
      public multiget_slice_call(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<multiget_slice_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.keys = keys;
        this.column_parent = column_parent;
        this.predicate = predicate;
        this.consistency_level = consistency_level;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("multiget_slice", org.apache.thrift.protocol.TMessageType.CALL, 0));
        multiget_slice_args args = new multiget_slice_args();
        args.setKeys(keys);
        args.setColumn_parent(column_parent);
        args.setPredicate(predicate);
        args.setConsistency_level(consistency_level);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<ByteBuffer,List<ColumnOrSuperColumn>> getResult() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_multiget_slice();
      }
    }

    public void multiget_count(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<multiget_count_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      multiget_count_call method_call = new multiget_count_call(keys, column_parent, predicate, consistency_level, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class multiget_count_call extends org.apache.thrift.async.TAsyncMethodCall {
      private List<ByteBuffer> keys;
      private ColumnParent column_parent;
      private SlicePredicate predicate;
      private ConsistencyLevel consistency_level;
      public multiget_count_call(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<multiget_count_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.keys = keys;
        this.column_parent = column_parent;
        this.predicate = predicate;
        this.consistency_level = consistency_level;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("multiget_count", org.apache.thrift.protocol.TMessageType.CALL, 0));
        multiget_count_args args = new multiget_count_args();
        args.setKeys(keys);
        args.setColumn_parent(column_parent);
        args.setPredicate(predicate);
        args.setConsistency_level(consistency_level);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<ByteBuffer,Integer> getResult() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_multiget_count();
      }
    }

    public void get_range_slices(ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<get_range_slices_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      get_range_slices_call method_call = new get_range_slices_call(column_parent, predicate, range, consistency_level, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class get_range_slices_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ColumnParent column_parent;
      private SlicePredicate predicate;
      private KeyRange range;
      private ConsistencyLevel consistency_level;
      public get_range_slices_call(ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<get_range_slices_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.column_parent = column_parent;
        this.predicate = predicate;
        this.range = range;
        this.consistency_level = consistency_level;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("get_range_slices", org.apache.thrift.protocol.TMessageType.CALL, 0));
        get_range_slices_args args = new get_range_slices_args();
        args.setColumn_parent(column_parent);
        args.setPredicate(predicate);
        args.setRange(range);
        args.setConsistency_level(consistency_level);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<KeySlice> getResult() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_get_range_slices();
      }
    }

    public void get_paged_slice(String column_family, KeyRange range, ByteBuffer start_column, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<get_paged_slice_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      get_paged_slice_call method_call = new get_paged_slice_call(column_family, range, start_column, consistency_level, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class get_paged_slice_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String column_family;
      private KeyRange range;
      private ByteBuffer start_column;
      private ConsistencyLevel consistency_level;
      public get_paged_slice_call(String column_family, KeyRange range, ByteBuffer start_column, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<get_paged_slice_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.column_family = column_family;
        this.range = range;
        this.start_column = start_column;
        this.consistency_level = consistency_level;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("get_paged_slice", org.apache.thrift.protocol.TMessageType.CALL, 0));
        get_paged_slice_args args = new get_paged_slice_args();
        args.setColumn_family(column_family);
        args.setRange(range);
        args.setStart_column(start_column);
        args.setConsistency_level(consistency_level);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<KeySlice> getResult() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_get_paged_slice();
      }
    }

    public void get_indexed_slices(ColumnParent column_parent, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<get_indexed_slices_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      get_indexed_slices_call method_call = new get_indexed_slices_call(column_parent, index_clause, column_predicate, consistency_level, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class get_indexed_slices_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ColumnParent column_parent;
      private IndexClause index_clause;
      private SlicePredicate column_predicate;
      private ConsistencyLevel consistency_level;
      public get_indexed_slices_call(ColumnParent column_parent, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<get_indexed_slices_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.column_parent = column_parent;
        this.index_clause = index_clause;
        this.column_predicate = column_predicate;
        this.consistency_level = consistency_level;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("get_indexed_slices", org.apache.thrift.protocol.TMessageType.CALL, 0));
        get_indexed_slices_args args = new get_indexed_slices_args();
        args.setColumn_parent(column_parent);
        args.setIndex_clause(index_clause);
        args.setColumn_predicate(column_predicate);
        args.setConsistency_level(consistency_level);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<KeySlice> getResult() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_get_indexed_slices();
      }
    }

    public void insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<insert_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      insert_call method_call = new insert_call(key, column_parent, column, consistency_level, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class insert_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer key;
      private ColumnParent column_parent;
      private Column column;
      private ConsistencyLevel consistency_level;
      public insert_call(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<insert_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.column_parent = column_parent;
        this.column = column;
        this.consistency_level = consistency_level;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("insert", org.apache.thrift.protocol.TMessageType.CALL, 0));
        insert_args args = new insert_args();
        args.setKey(key);
        args.setColumn_parent(column_parent);
        args.setColumn(column);
        args.setConsistency_level(consistency_level);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_insert();
      }
    }

    public void add(ByteBuffer key, ColumnParent column_parent, CounterColumn column, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<add_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      add_call method_call = new add_call(key, column_parent, column, consistency_level, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class add_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer key;
      private ColumnParent column_parent;
      private CounterColumn column;
      private ConsistencyLevel consistency_level;
      public add_call(ByteBuffer key, ColumnParent column_parent, CounterColumn column, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<add_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.column_parent = column_parent;
        this.column = column;
        this.consistency_level = consistency_level;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("add", org.apache.thrift.protocol.TMessageType.CALL, 0));
        add_args args = new add_args();
        args.setKey(key);
        args.setColumn_parent(column_parent);
        args.setColumn(column);
        args.setConsistency_level(consistency_level);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_add();
      }
    }

    public void remove(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<remove_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      remove_call method_call = new remove_call(key, column_path, timestamp, consistency_level, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class remove_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer key;
      private ColumnPath column_path;
      private long timestamp;
      private ConsistencyLevel consistency_level;
      public remove_call(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<remove_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.column_path = column_path;
        this.timestamp = timestamp;
        this.consistency_level = consistency_level;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("remove", org.apache.thrift.protocol.TMessageType.CALL, 0));
        remove_args args = new remove_args();
        args.setKey(key);
        args.setColumn_path(column_path);
        args.setTimestamp(timestamp);
        args.setConsistency_level(consistency_level);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_remove();
      }
    }

    public void remove_counter(ByteBuffer key, ColumnPath path, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<remove_counter_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      remove_counter_call method_call = new remove_counter_call(key, path, consistency_level, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class remove_counter_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer key;
      private ColumnPath path;
      private ConsistencyLevel consistency_level;
      public remove_counter_call(ByteBuffer key, ColumnPath path, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<remove_counter_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.path = path;
        this.consistency_level = consistency_level;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("remove_counter", org.apache.thrift.protocol.TMessageType.CALL, 0));
        remove_counter_args args = new remove_counter_args();
        args.setKey(key);
        args.setPath(path);
        args.setConsistency_level(consistency_level);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_remove_counter();
      }
    }

    public void batch_mutate(Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<batch_mutate_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      batch_mutate_call method_call = new batch_mutate_call(mutation_map, consistency_level, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class batch_mutate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map;
      private ConsistencyLevel consistency_level;
      public batch_mutate_call(Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<batch_mutate_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.mutation_map = mutation_map;
        this.consistency_level = consistency_level;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("batch_mutate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        batch_mutate_args args = new batch_mutate_args();
        args.setMutation_map(mutation_map);
        args.setConsistency_level(consistency_level);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_batch_mutate();
      }
    }

    public void atomic_batch_mutate(Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<atomic_batch_mutate_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      atomic_batch_mutate_call method_call = new atomic_batch_mutate_call(mutation_map, consistency_level, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class atomic_batch_mutate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map;
      private ConsistencyLevel consistency_level;
      public atomic_batch_mutate_call(Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map, ConsistencyLevel consistency_level, org.apache.thrift.async.AsyncMethodCallback<atomic_batch_mutate_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.mutation_map = mutation_map;
        this.consistency_level = consistency_level;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("atomic_batch_mutate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        atomic_batch_mutate_args args = new atomic_batch_mutate_args();
        args.setMutation_map(mutation_map);
        args.setConsistency_level(consistency_level);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_atomic_batch_mutate();
      }
    }

    public void truncate(String cfname, org.apache.thrift.async.AsyncMethodCallback<truncate_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      truncate_call method_call = new truncate_call(cfname, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class truncate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String cfname;
      public truncate_call(String cfname, org.apache.thrift.async.AsyncMethodCallback<truncate_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.cfname = cfname;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("truncate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        truncate_args args = new truncate_args();
        args.setCfname(cfname);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws InvalidRequestException, UnavailableException, TimedOutException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_truncate();
      }
    }

    public void describe_schema_versions(org.apache.thrift.async.AsyncMethodCallback<describe_schema_versions_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      describe_schema_versions_call method_call = new describe_schema_versions_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class describe_schema_versions_call extends org.apache.thrift.async.TAsyncMethodCall {
      public describe_schema_versions_call(org.apache.thrift.async.AsyncMethodCallback<describe_schema_versions_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("describe_schema_versions", org.apache.thrift.protocol.TMessageType.CALL, 0));
        describe_schema_versions_args args = new describe_schema_versions_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,List<String>> getResult() throws InvalidRequestException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_describe_schema_versions();
      }
    }

    public void describe_keyspaces(org.apache.thrift.async.AsyncMethodCallback<describe_keyspaces_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      describe_keyspaces_call method_call = new describe_keyspaces_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class describe_keyspaces_call extends org.apache.thrift.async.TAsyncMethodCall {
      public describe_keyspaces_call(org.apache.thrift.async.AsyncMethodCallback<describe_keyspaces_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("describe_keyspaces", org.apache.thrift.protocol.TMessageType.CALL, 0));
        describe_keyspaces_args args = new describe_keyspaces_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<KsDef> getResult() throws InvalidRequestException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_describe_keyspaces();
      }
    }

    public void describe_cluster_name(org.apache.thrift.async.AsyncMethodCallback<describe_cluster_name_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      describe_cluster_name_call method_call = new describe_cluster_name_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class describe_cluster_name_call extends org.apache.thrift.async.TAsyncMethodCall {
      public describe_cluster_name_call(org.apache.thrift.async.AsyncMethodCallback<describe_cluster_name_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("describe_cluster_name", org.apache.thrift.protocol.TMessageType.CALL, 0));
        describe_cluster_name_args args = new describe_cluster_name_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_describe_cluster_name();
      }
    }

    public void describe_version(org.apache.thrift.async.AsyncMethodCallback<describe_version_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      describe_version_call method_call = new describe_version_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class describe_version_call extends org.apache.thrift.async.TAsyncMethodCall {
      public describe_version_call(org.apache.thrift.async.AsyncMethodCallback<describe_version_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("describe_version", org.apache.thrift.protocol.TMessageType.CALL, 0));
        describe_version_args args = new describe_version_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_describe_version();
      }
    }

    public void describe_ring(String keyspace, org.apache.thrift.async.AsyncMethodCallback<describe_ring_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      describe_ring_call method_call = new describe_ring_call(keyspace, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class describe_ring_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String keyspace;
      public describe_ring_call(String keyspace, org.apache.thrift.async.AsyncMethodCallback<describe_ring_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.keyspace = keyspace;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("describe_ring", org.apache.thrift.protocol.TMessageType.CALL, 0));
        describe_ring_args args = new describe_ring_args();
        args.setKeyspace(keyspace);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TokenRange> getResult() throws InvalidRequestException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_describe_ring();
      }
    }

    public void describe_token_map(org.apache.thrift.async.AsyncMethodCallback<describe_token_map_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      describe_token_map_call method_call = new describe_token_map_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class describe_token_map_call extends org.apache.thrift.async.TAsyncMethodCall {
      public describe_token_map_call(org.apache.thrift.async.AsyncMethodCallback<describe_token_map_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("describe_token_map", org.apache.thrift.protocol.TMessageType.CALL, 0));
        describe_token_map_args args = new describe_token_map_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws InvalidRequestException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_describe_token_map();
      }
    }

    public void describe_partitioner(org.apache.thrift.async.AsyncMethodCallback<describe_partitioner_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      describe_partitioner_call method_call = new describe_partitioner_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class describe_partitioner_call extends org.apache.thrift.async.TAsyncMethodCall {
      public describe_partitioner_call(org.apache.thrift.async.AsyncMethodCallback<describe_partitioner_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("describe_partitioner", org.apache.thrift.protocol.TMessageType.CALL, 0));
        describe_partitioner_args args = new describe_partitioner_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_describe_partitioner();
      }
    }

    public void describe_snitch(org.apache.thrift.async.AsyncMethodCallback<describe_snitch_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      describe_snitch_call method_call = new describe_snitch_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class describe_snitch_call extends org.apache.thrift.async.TAsyncMethodCall {
      public describe_snitch_call(org.apache.thrift.async.AsyncMethodCallback<describe_snitch_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("describe_snitch", org.apache.thrift.protocol.TMessageType.CALL, 0));
        describe_snitch_args args = new describe_snitch_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_describe_snitch();
      }
    }

    public void describe_keyspace(String keyspace, org.apache.thrift.async.AsyncMethodCallback<describe_keyspace_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      describe_keyspace_call method_call = new describe_keyspace_call(keyspace, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class describe_keyspace_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String keyspace;
      public describe_keyspace_call(String keyspace, org.apache.thrift.async.AsyncMethodCallback<describe_keyspace_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.keyspace = keyspace;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("describe_keyspace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        describe_keyspace_args args = new describe_keyspace_args();
        args.setKeyspace(keyspace);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public KsDef getResult() throws NotFoundException, InvalidRequestException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_describe_keyspace();
      }
    }

    public void describe_splits(String cfName, String start_token, String end_token, int keys_per_split, org.apache.thrift.async.AsyncMethodCallback<describe_splits_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      describe_splits_call method_call = new describe_splits_call(cfName, start_token, end_token, keys_per_split, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class describe_splits_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String cfName;
      private String start_token;
      private String end_token;
      private int keys_per_split;
      public describe_splits_call(String cfName, String start_token, String end_token, int keys_per_split, org.apache.thrift.async.AsyncMethodCallback<describe_splits_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.cfName = cfName;
        this.start_token = start_token;
        this.end_token = end_token;
        this.keys_per_split = keys_per_split;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("describe_splits", org.apache.thrift.protocol.TMessageType.CALL, 0));
        describe_splits_args args = new describe_splits_args();
        args.setCfName(cfName);
        args.setStart_token(start_token);
        args.setEnd_token(end_token);
        args.setKeys_per_split(keys_per_split);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<String> getResult() throws InvalidRequestException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_describe_splits();
      }
    }

    public void trace_next_query(org.apache.thrift.async.AsyncMethodCallback<trace_next_query_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      trace_next_query_call method_call = new trace_next_query_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class trace_next_query_call extends org.apache.thrift.async.TAsyncMethodCall {
      public trace_next_query_call(org.apache.thrift.async.AsyncMethodCallback<trace_next_query_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("trace_next_query", org.apache.thrift.protocol.TMessageType.CALL, 0));
        trace_next_query_args args = new trace_next_query_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ByteBuffer getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_trace_next_query();
      }
    }

    public void describe_splits_ex(String cfName, String start_token, String end_token, int keys_per_split, org.apache.thrift.async.AsyncMethodCallback<describe_splits_ex_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      describe_splits_ex_call method_call = new describe_splits_ex_call(cfName, start_token, end_token, keys_per_split, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class describe_splits_ex_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String cfName;
      private String start_token;
      private String end_token;
      private int keys_per_split;
      public describe_splits_ex_call(String cfName, String start_token, String end_token, int keys_per_split, org.apache.thrift.async.AsyncMethodCallback<describe_splits_ex_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.cfName = cfName;
        this.start_token = start_token;
        this.end_token = end_token;
        this.keys_per_split = keys_per_split;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("describe_splits_ex", org.apache.thrift.protocol.TMessageType.CALL, 0));
        describe_splits_ex_args args = new describe_splits_ex_args();
        args.setCfName(cfName);
        args.setStart_token(start_token);
        args.setEnd_token(end_token);
        args.setKeys_per_split(keys_per_split);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<CfSplit> getResult() throws InvalidRequestException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_describe_splits_ex();
      }
    }

    public void system_add_column_family(CfDef cf_def, org.apache.thrift.async.AsyncMethodCallback<system_add_column_family_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      system_add_column_family_call method_call = new system_add_column_family_call(cf_def, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class system_add_column_family_call extends org.apache.thrift.async.TAsyncMethodCall {
      private CfDef cf_def;
      public system_add_column_family_call(CfDef cf_def, org.apache.thrift.async.AsyncMethodCallback<system_add_column_family_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.cf_def = cf_def;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("system_add_column_family", org.apache.thrift.protocol.TMessageType.CALL, 0));
        system_add_column_family_args args = new system_add_column_family_args();
        args.setCf_def(cf_def);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_system_add_column_family();
      }
    }

    public void system_drop_column_family(String column_family, org.apache.thrift.async.AsyncMethodCallback<system_drop_column_family_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      system_drop_column_family_call method_call = new system_drop_column_family_call(column_family, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class system_drop_column_family_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String column_family;
      public system_drop_column_family_call(String column_family, org.apache.thrift.async.AsyncMethodCallback<system_drop_column_family_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.column_family = column_family;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("system_drop_column_family", org.apache.thrift.protocol.TMessageType.CALL, 0));
        system_drop_column_family_args args = new system_drop_column_family_args();
        args.setColumn_family(column_family);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_system_drop_column_family();
      }
    }

    public void system_add_keyspace(KsDef ks_def, org.apache.thrift.async.AsyncMethodCallback<system_add_keyspace_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      system_add_keyspace_call method_call = new system_add_keyspace_call(ks_def, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class system_add_keyspace_call extends org.apache.thrift.async.TAsyncMethodCall {
      private KsDef ks_def;
      public system_add_keyspace_call(KsDef ks_def, org.apache.thrift.async.AsyncMethodCallback<system_add_keyspace_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ks_def = ks_def;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("system_add_keyspace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        system_add_keyspace_args args = new system_add_keyspace_args();
        args.setKs_def(ks_def);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_system_add_keyspace();
      }
    }

    public void system_drop_keyspace(String keyspace, org.apache.thrift.async.AsyncMethodCallback<system_drop_keyspace_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      system_drop_keyspace_call method_call = new system_drop_keyspace_call(keyspace, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class system_drop_keyspace_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String keyspace;
      public system_drop_keyspace_call(String keyspace, org.apache.thrift.async.AsyncMethodCallback<system_drop_keyspace_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.keyspace = keyspace;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("system_drop_keyspace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        system_drop_keyspace_args args = new system_drop_keyspace_args();
        args.setKeyspace(keyspace);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_system_drop_keyspace();
      }
    }

    public void system_update_keyspace(KsDef ks_def, org.apache.thrift.async.AsyncMethodCallback<system_update_keyspace_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      system_update_keyspace_call method_call = new system_update_keyspace_call(ks_def, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class system_update_keyspace_call extends org.apache.thrift.async.TAsyncMethodCall {
      private KsDef ks_def;
      public system_update_keyspace_call(KsDef ks_def, org.apache.thrift.async.AsyncMethodCallback<system_update_keyspace_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.ks_def = ks_def;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("system_update_keyspace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        system_update_keyspace_args args = new system_update_keyspace_args();
        args.setKs_def(ks_def);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_system_update_keyspace();
      }
    }

    public void system_update_column_family(CfDef cf_def, org.apache.thrift.async.AsyncMethodCallback<system_update_column_family_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      system_update_column_family_call method_call = new system_update_column_family_call(cf_def, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class system_update_column_family_call extends org.apache.thrift.async.TAsyncMethodCall {
      private CfDef cf_def;
      public system_update_column_family_call(CfDef cf_def, org.apache.thrift.async.AsyncMethodCallback<system_update_column_family_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.cf_def = cf_def;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("system_update_column_family", org.apache.thrift.protocol.TMessageType.CALL, 0));
        system_update_column_family_args args = new system_update_column_family_args();
        args.setCf_def(cf_def);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws InvalidRequestException, SchemaDisagreementException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_system_update_column_family();
      }
    }

    public void execute_cql_query(ByteBuffer query, Compression compression, org.apache.thrift.async.AsyncMethodCallback<execute_cql_query_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      execute_cql_query_call method_call = new execute_cql_query_call(query, compression, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class execute_cql_query_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer query;
      private Compression compression;
      public execute_cql_query_call(ByteBuffer query, Compression compression, org.apache.thrift.async.AsyncMethodCallback<execute_cql_query_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.query = query;
        this.compression = compression;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("execute_cql_query", org.apache.thrift.protocol.TMessageType.CALL, 0));
        execute_cql_query_args args = new execute_cql_query_args();
        args.setQuery(query);
        args.setCompression(compression);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public CqlResult getResult() throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_execute_cql_query();
      }
    }

    public void execute_cql3_query(ByteBuffer query, Compression compression, ConsistencyLevel consistency, org.apache.thrift.async.AsyncMethodCallback<execute_cql3_query_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      execute_cql3_query_call method_call = new execute_cql3_query_call(query, compression, consistency, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class execute_cql3_query_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer query;
      private Compression compression;
      private ConsistencyLevel consistency;
      public execute_cql3_query_call(ByteBuffer query, Compression compression, ConsistencyLevel consistency, org.apache.thrift.async.AsyncMethodCallback<execute_cql3_query_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.query = query;
        this.compression = compression;
        this.consistency = consistency;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("execute_cql3_query", org.apache.thrift.protocol.TMessageType.CALL, 0));
        execute_cql3_query_args args = new execute_cql3_query_args();
        args.setQuery(query);
        args.setCompression(compression);
        args.setConsistency(consistency);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public CqlResult getResult() throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_execute_cql3_query();
      }
    }

    public void prepare_cql_query(ByteBuffer query, Compression compression, org.apache.thrift.async.AsyncMethodCallback<prepare_cql_query_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      prepare_cql_query_call method_call = new prepare_cql_query_call(query, compression, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class prepare_cql_query_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer query;
      private Compression compression;
      public prepare_cql_query_call(ByteBuffer query, Compression compression, org.apache.thrift.async.AsyncMethodCallback<prepare_cql_query_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.query = query;
        this.compression = compression;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("prepare_cql_query", org.apache.thrift.protocol.TMessageType.CALL, 0));
        prepare_cql_query_args args = new prepare_cql_query_args();
        args.setQuery(query);
        args.setCompression(compression);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public CqlPreparedResult getResult() throws InvalidRequestException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_prepare_cql_query();
      }
    }

    public void prepare_cql3_query(ByteBuffer query, Compression compression, org.apache.thrift.async.AsyncMethodCallback<prepare_cql3_query_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      prepare_cql3_query_call method_call = new prepare_cql3_query_call(query, compression, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class prepare_cql3_query_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer query;
      private Compression compression;
      public prepare_cql3_query_call(ByteBuffer query, Compression compression, org.apache.thrift.async.AsyncMethodCallback<prepare_cql3_query_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.query = query;
        this.compression = compression;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("prepare_cql3_query", org.apache.thrift.protocol.TMessageType.CALL, 0));
        prepare_cql3_query_args args = new prepare_cql3_query_args();
        args.setQuery(query);
        args.setCompression(compression);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public CqlPreparedResult getResult() throws InvalidRequestException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_prepare_cql3_query();
      }
    }

    public void execute_prepared_cql_query(int itemId, List<ByteBuffer> values, org.apache.thrift.async.AsyncMethodCallback<execute_prepared_cql_query_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      execute_prepared_cql_query_call method_call = new execute_prepared_cql_query_call(itemId, values, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class execute_prepared_cql_query_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int itemId;
      private List<ByteBuffer> values;
      public execute_prepared_cql_query_call(int itemId, List<ByteBuffer> values, org.apache.thrift.async.AsyncMethodCallback<execute_prepared_cql_query_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.itemId = itemId;
        this.values = values;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("execute_prepared_cql_query", org.apache.thrift.protocol.TMessageType.CALL, 0));
        execute_prepared_cql_query_args args = new execute_prepared_cql_query_args();
        args.setItemId(itemId);
        args.setValues(values);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public CqlResult getResult() throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_execute_prepared_cql_query();
      }
    }

    public void execute_prepared_cql3_query(int itemId, List<ByteBuffer> values, ConsistencyLevel consistency, org.apache.thrift.async.AsyncMethodCallback<execute_prepared_cql3_query_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      execute_prepared_cql3_query_call method_call = new execute_prepared_cql3_query_call(itemId, values, consistency, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class execute_prepared_cql3_query_call extends org.apache.thrift.async.TAsyncMethodCall {
      private int itemId;
      private List<ByteBuffer> values;
      private ConsistencyLevel consistency;
      public execute_prepared_cql3_query_call(int itemId, List<ByteBuffer> values, ConsistencyLevel consistency, org.apache.thrift.async.AsyncMethodCallback<execute_prepared_cql3_query_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.itemId = itemId;
        this.values = values;
        this.consistency = consistency;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("execute_prepared_cql3_query", org.apache.thrift.protocol.TMessageType.CALL, 0));
        execute_prepared_cql3_query_args args = new execute_prepared_cql3_query_args();
        args.setItemId(itemId);
        args.setValues(values);
        args.setConsistency(consistency);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public CqlResult getResult() throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_execute_prepared_cql3_query();
      }
    }

    public void set_cql_version(String version, org.apache.thrift.async.AsyncMethodCallback<set_cql_version_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      set_cql_version_call method_call = new set_cql_version_call(version, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class set_cql_version_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String version;
      public set_cql_version_call(String version, org.apache.thrift.async.AsyncMethodCallback<set_cql_version_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.version = version;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("set_cql_version", org.apache.thrift.protocol.TMessageType.CALL, 0));
        set_cql_version_args args = new set_cql_version_args();
        args.setVersion(version);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws InvalidRequestException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_set_cql_version();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("login", new login());
      processMap.put("set_keyspace", new set_keyspace());
      processMap.put("get", new get());
      processMap.put("get_slice", new get_slice());
      processMap.put("get_count", new get_count());
      processMap.put("multiget_slice", new multiget_slice());
      processMap.put("multiget_count", new multiget_count());
      processMap.put("get_range_slices", new get_range_slices());
      processMap.put("get_paged_slice", new get_paged_slice());
      processMap.put("get_indexed_slices", new get_indexed_slices());
      processMap.put("insert", new insert());
      processMap.put("add", new add());
      processMap.put("remove", new remove());
      processMap.put("remove_counter", new remove_counter());
      processMap.put("batch_mutate", new batch_mutate());
      processMap.put("atomic_batch_mutate", new atomic_batch_mutate());
      processMap.put("truncate", new truncate());
      processMap.put("describe_schema_versions", new describe_schema_versions());
      processMap.put("describe_keyspaces", new describe_keyspaces());
      processMap.put("describe_cluster_name", new describe_cluster_name());
      processMap.put("describe_version", new describe_version());
      processMap.put("describe_ring", new describe_ring());
      processMap.put("describe_token_map", new describe_token_map());
      processMap.put("describe_partitioner", new describe_partitioner());
      processMap.put("describe_snitch", new describe_snitch());
      processMap.put("describe_keyspace", new describe_keyspace());
      processMap.put("describe_splits", new describe_splits());
      processMap.put("trace_next_query", new trace_next_query());
      processMap.put("describe_splits_ex", new describe_splits_ex());
      processMap.put("system_add_column_family", new system_add_column_family());
      processMap.put("system_drop_column_family", new system_drop_column_family());
      processMap.put("system_add_keyspace", new system_add_keyspace());
      processMap.put("system_drop_keyspace", new system_drop_keyspace());
      processMap.put("system_update_keyspace", new system_update_keyspace());
      processMap.put("system_update_column_family", new system_update_column_family());
      processMap.put("execute_cql_query", new execute_cql_query());
      processMap.put("execute_cql3_query", new execute_cql3_query());
      processMap.put("prepare_cql_query", new prepare_cql_query());
      processMap.put("prepare_cql3_query", new prepare_cql3_query());
      processMap.put("execute_prepared_cql_query", new execute_prepared_cql_query());
      processMap.put("execute_prepared_cql3_query", new execute_prepared_cql3_query());
      processMap.put("set_cql_version", new set_cql_version());
      return processMap;
    }

    private static class login<I extends Iface> extends org.apache.thrift.ProcessFunction<I, login_args> {
      public login() {
        super("login");
      }

      protected login_args getEmptyArgsInstance() {
        return new login_args();
      }

      protected login_result getResult(I iface, login_args args) throws org.apache.thrift.TException {
        login_result result = new login_result();
        try {
          iface.login(args.auth_request);
        } catch (AuthenticationException authnx) {
          result.authnx = authnx;
        } catch (AuthorizationException authzx) {
          result.authzx = authzx;
        }
        return result;
      }
    }

    private static class set_keyspace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, set_keyspace_args> {
      public set_keyspace() {
        super("set_keyspace");
      }

      protected set_keyspace_args getEmptyArgsInstance() {
        return new set_keyspace_args();
      }

      protected set_keyspace_result getResult(I iface, set_keyspace_args args) throws org.apache.thrift.TException {
        set_keyspace_result result = new set_keyspace_result();
        try {
          iface.set_keyspace(args.keyspace);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        }
        return result;
      }
    }

    private static class get<I extends Iface> extends org.apache.thrift.ProcessFunction<I, get_args> {
      public get() {
        super("get");
      }

      protected get_args getEmptyArgsInstance() {
        return new get_args();
      }

      protected get_result getResult(I iface, get_args args) throws org.apache.thrift.TException {
        get_result result = new get_result();
        try {
          result.success = iface.get(args.key, args.column_path, args.consistency_level);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (NotFoundException nfe) {
          result.nfe = nfe;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class get_slice<I extends Iface> extends org.apache.thrift.ProcessFunction<I, get_slice_args> {
      public get_slice() {
        super("get_slice");
      }

      protected get_slice_args getEmptyArgsInstance() {
        return new get_slice_args();
      }

      protected get_slice_result getResult(I iface, get_slice_args args) throws org.apache.thrift.TException {
        get_slice_result result = new get_slice_result();
        try {
          result.success = iface.get_slice(args.key, args.column_parent, args.predicate, args.consistency_level);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class get_count<I extends Iface> extends org.apache.thrift.ProcessFunction<I, get_count_args> {
      public get_count() {
        super("get_count");
      }

      protected get_count_args getEmptyArgsInstance() {
        return new get_count_args();
      }

      protected get_count_result getResult(I iface, get_count_args args) throws org.apache.thrift.TException {
        get_count_result result = new get_count_result();
        try {
          result.success = iface.get_count(args.key, args.column_parent, args.predicate, args.consistency_level);
          result.setSuccessIsSet(true);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class multiget_slice<I extends Iface> extends org.apache.thrift.ProcessFunction<I, multiget_slice_args> {
      public multiget_slice() {
        super("multiget_slice");
      }

      protected multiget_slice_args getEmptyArgsInstance() {
        return new multiget_slice_args();
      }

      protected multiget_slice_result getResult(I iface, multiget_slice_args args) throws org.apache.thrift.TException {
        multiget_slice_result result = new multiget_slice_result();
        try {
          result.success = iface.multiget_slice(args.keys, args.column_parent, args.predicate, args.consistency_level);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class multiget_count<I extends Iface> extends org.apache.thrift.ProcessFunction<I, multiget_count_args> {
      public multiget_count() {
        super("multiget_count");
      }

      protected multiget_count_args getEmptyArgsInstance() {
        return new multiget_count_args();
      }

      protected multiget_count_result getResult(I iface, multiget_count_args args) throws org.apache.thrift.TException {
        multiget_count_result result = new multiget_count_result();
        try {
          result.success = iface.multiget_count(args.keys, args.column_parent, args.predicate, args.consistency_level);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class get_range_slices<I extends Iface> extends org.apache.thrift.ProcessFunction<I, get_range_slices_args> {
      public get_range_slices() {
        super("get_range_slices");
      }

      protected get_range_slices_args getEmptyArgsInstance() {
        return new get_range_slices_args();
      }

      protected get_range_slices_result getResult(I iface, get_range_slices_args args) throws org.apache.thrift.TException {
        get_range_slices_result result = new get_range_slices_result();
        try {
          result.success = iface.get_range_slices(args.column_parent, args.predicate, args.range, args.consistency_level);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class get_paged_slice<I extends Iface> extends org.apache.thrift.ProcessFunction<I, get_paged_slice_args> {
      public get_paged_slice() {
        super("get_paged_slice");
      }

      protected get_paged_slice_args getEmptyArgsInstance() {
        return new get_paged_slice_args();
      }

      protected get_paged_slice_result getResult(I iface, get_paged_slice_args args) throws org.apache.thrift.TException {
        get_paged_slice_result result = new get_paged_slice_result();
        try {
          result.success = iface.get_paged_slice(args.column_family, args.range, args.start_column, args.consistency_level);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class get_indexed_slices<I extends Iface> extends org.apache.thrift.ProcessFunction<I, get_indexed_slices_args> {
      public get_indexed_slices() {
        super("get_indexed_slices");
      }

      protected get_indexed_slices_args getEmptyArgsInstance() {
        return new get_indexed_slices_args();
      }

      protected get_indexed_slices_result getResult(I iface, get_indexed_slices_args args) throws org.apache.thrift.TException {
        get_indexed_slices_result result = new get_indexed_slices_result();
        try {
          result.success = iface.get_indexed_slices(args.column_parent, args.index_clause, args.column_predicate, args.consistency_level);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class insert<I extends Iface> extends org.apache.thrift.ProcessFunction<I, insert_args> {
      public insert() {
        super("insert");
      }

      protected insert_args getEmptyArgsInstance() {
        return new insert_args();
      }

      protected insert_result getResult(I iface, insert_args args) throws org.apache.thrift.TException {
        insert_result result = new insert_result();
        try {
          iface.insert(args.key, args.column_parent, args.column, args.consistency_level);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class add<I extends Iface> extends org.apache.thrift.ProcessFunction<I, add_args> {
      public add() {
        super("add");
      }

      protected add_args getEmptyArgsInstance() {
        return new add_args();
      }

      protected add_result getResult(I iface, add_args args) throws org.apache.thrift.TException {
        add_result result = new add_result();
        try {
          iface.add(args.key, args.column_parent, args.column, args.consistency_level);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class remove<I extends Iface> extends org.apache.thrift.ProcessFunction<I, remove_args> {
      public remove() {
        super("remove");
      }

      protected remove_args getEmptyArgsInstance() {
        return new remove_args();
      }

      protected remove_result getResult(I iface, remove_args args) throws org.apache.thrift.TException {
        remove_result result = new remove_result();
        try {
          iface.remove(args.key, args.column_path, args.timestamp, args.consistency_level);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class remove_counter<I extends Iface> extends org.apache.thrift.ProcessFunction<I, remove_counter_args> {
      public remove_counter() {
        super("remove_counter");
      }

      protected remove_counter_args getEmptyArgsInstance() {
        return new remove_counter_args();
      }

      protected remove_counter_result getResult(I iface, remove_counter_args args) throws org.apache.thrift.TException {
        remove_counter_result result = new remove_counter_result();
        try {
          iface.remove_counter(args.key, args.path, args.consistency_level);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class batch_mutate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, batch_mutate_args> {
      public batch_mutate() {
        super("batch_mutate");
      }

      protected batch_mutate_args getEmptyArgsInstance() {
        return new batch_mutate_args();
      }

      protected batch_mutate_result getResult(I iface, batch_mutate_args args) throws org.apache.thrift.TException {
        batch_mutate_result result = new batch_mutate_result();
        try {
          iface.batch_mutate(args.mutation_map, args.consistency_level);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class atomic_batch_mutate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, atomic_batch_mutate_args> {
      public atomic_batch_mutate() {
        super("atomic_batch_mutate");
      }

      protected atomic_batch_mutate_args getEmptyArgsInstance() {
        return new atomic_batch_mutate_args();
      }

      protected atomic_batch_mutate_result getResult(I iface, atomic_batch_mutate_args args) throws org.apache.thrift.TException {
        atomic_batch_mutate_result result = new atomic_batch_mutate_result();
        try {
          iface.atomic_batch_mutate(args.mutation_map, args.consistency_level);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class truncate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, truncate_args> {
      public truncate() {
        super("truncate");
      }

      protected truncate_args getEmptyArgsInstance() {
        return new truncate_args();
      }

      protected truncate_result getResult(I iface, truncate_args args) throws org.apache.thrift.TException {
        truncate_result result = new truncate_result();
        try {
          iface.truncate(args.cfname);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        }
        return result;
      }
    }

    private static class describe_schema_versions<I extends Iface> extends org.apache.thrift.ProcessFunction<I, describe_schema_versions_args> {
      public describe_schema_versions() {
        super("describe_schema_versions");
      }

      protected describe_schema_versions_args getEmptyArgsInstance() {
        return new describe_schema_versions_args();
      }

      protected describe_schema_versions_result getResult(I iface, describe_schema_versions_args args) throws org.apache.thrift.TException {
        describe_schema_versions_result result = new describe_schema_versions_result();
        try {
          result.success = iface.describe_schema_versions();
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        }
        return result;
      }
    }

    private static class describe_keyspaces<I extends Iface> extends org.apache.thrift.ProcessFunction<I, describe_keyspaces_args> {
      public describe_keyspaces() {
        super("describe_keyspaces");
      }

      protected describe_keyspaces_args getEmptyArgsInstance() {
        return new describe_keyspaces_args();
      }

      protected describe_keyspaces_result getResult(I iface, describe_keyspaces_args args) throws org.apache.thrift.TException {
        describe_keyspaces_result result = new describe_keyspaces_result();
        try {
          result.success = iface.describe_keyspaces();
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        }
        return result;
      }
    }

    private static class describe_cluster_name<I extends Iface> extends org.apache.thrift.ProcessFunction<I, describe_cluster_name_args> {
      public describe_cluster_name() {
        super("describe_cluster_name");
      }

      protected describe_cluster_name_args getEmptyArgsInstance() {
        return new describe_cluster_name_args();
      }

      protected describe_cluster_name_result getResult(I iface, describe_cluster_name_args args) throws org.apache.thrift.TException {
        describe_cluster_name_result result = new describe_cluster_name_result();
        result.success = iface.describe_cluster_name();
        return result;
      }
    }

    private static class describe_version<I extends Iface> extends org.apache.thrift.ProcessFunction<I, describe_version_args> {
      public describe_version() {
        super("describe_version");
      }

      protected describe_version_args getEmptyArgsInstance() {
        return new describe_version_args();
      }

      protected describe_version_result getResult(I iface, describe_version_args args) throws org.apache.thrift.TException {
        describe_version_result result = new describe_version_result();
        result.success = iface.describe_version();
        return result;
      }
    }

    private static class describe_ring<I extends Iface> extends org.apache.thrift.ProcessFunction<I, describe_ring_args> {
      public describe_ring() {
        super("describe_ring");
      }

      protected describe_ring_args getEmptyArgsInstance() {
        return new describe_ring_args();
      }

      protected describe_ring_result getResult(I iface, describe_ring_args args) throws org.apache.thrift.TException {
        describe_ring_result result = new describe_ring_result();
        try {
          result.success = iface.describe_ring(args.keyspace);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        }
        return result;
      }
    }

    private static class describe_token_map<I extends Iface> extends org.apache.thrift.ProcessFunction<I, describe_token_map_args> {
      public describe_token_map() {
        super("describe_token_map");
      }

      protected describe_token_map_args getEmptyArgsInstance() {
        return new describe_token_map_args();
      }

      protected describe_token_map_result getResult(I iface, describe_token_map_args args) throws org.apache.thrift.TException {
        describe_token_map_result result = new describe_token_map_result();
        try {
          result.success = iface.describe_token_map();
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        }
        return result;
      }
    }

    private static class describe_partitioner<I extends Iface> extends org.apache.thrift.ProcessFunction<I, describe_partitioner_args> {
      public describe_partitioner() {
        super("describe_partitioner");
      }

      protected describe_partitioner_args getEmptyArgsInstance() {
        return new describe_partitioner_args();
      }

      protected describe_partitioner_result getResult(I iface, describe_partitioner_args args) throws org.apache.thrift.TException {
        describe_partitioner_result result = new describe_partitioner_result();
        result.success = iface.describe_partitioner();
        return result;
      }
    }

    private static class describe_snitch<I extends Iface> extends org.apache.thrift.ProcessFunction<I, describe_snitch_args> {
      public describe_snitch() {
        super("describe_snitch");
      }

      protected describe_snitch_args getEmptyArgsInstance() {
        return new describe_snitch_args();
      }

      protected describe_snitch_result getResult(I iface, describe_snitch_args args) throws org.apache.thrift.TException {
        describe_snitch_result result = new describe_snitch_result();
        result.success = iface.describe_snitch();
        return result;
      }
    }

    private static class describe_keyspace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, describe_keyspace_args> {
      public describe_keyspace() {
        super("describe_keyspace");
      }

      protected describe_keyspace_args getEmptyArgsInstance() {
        return new describe_keyspace_args();
      }

      protected describe_keyspace_result getResult(I iface, describe_keyspace_args args) throws org.apache.thrift.TException {
        describe_keyspace_result result = new describe_keyspace_result();
        try {
          result.success = iface.describe_keyspace(args.keyspace);
        } catch (NotFoundException nfe) {
          result.nfe = nfe;
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        }
        return result;
      }
    }

    private static class describe_splits<I extends Iface> extends org.apache.thrift.ProcessFunction<I, describe_splits_args> {
      public describe_splits() {
        super("describe_splits");
      }

      protected describe_splits_args getEmptyArgsInstance() {
        return new describe_splits_args();
      }

      protected describe_splits_result getResult(I iface, describe_splits_args args) throws org.apache.thrift.TException {
        describe_splits_result result = new describe_splits_result();
        try {
          result.success = iface.describe_splits(args.cfName, args.start_token, args.end_token, args.keys_per_split);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        }
        return result;
      }
    }

    private static class trace_next_query<I extends Iface> extends org.apache.thrift.ProcessFunction<I, trace_next_query_args> {
      public trace_next_query() {
        super("trace_next_query");
      }

      protected trace_next_query_args getEmptyArgsInstance() {
        return new trace_next_query_args();
      }

      protected trace_next_query_result getResult(I iface, trace_next_query_args args) throws org.apache.thrift.TException {
        trace_next_query_result result = new trace_next_query_result();
        result.success = iface.trace_next_query();
        return result;
      }
    }

    private static class describe_splits_ex<I extends Iface> extends org.apache.thrift.ProcessFunction<I, describe_splits_ex_args> {
      public describe_splits_ex() {
        super("describe_splits_ex");
      }

      protected describe_splits_ex_args getEmptyArgsInstance() {
        return new describe_splits_ex_args();
      }

      protected describe_splits_ex_result getResult(I iface, describe_splits_ex_args args) throws org.apache.thrift.TException {
        describe_splits_ex_result result = new describe_splits_ex_result();
        try {
          result.success = iface.describe_splits_ex(args.cfName, args.start_token, args.end_token, args.keys_per_split);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        }
        return result;
      }
    }

    private static class system_add_column_family<I extends Iface> extends org.apache.thrift.ProcessFunction<I, system_add_column_family_args> {
      public system_add_column_family() {
        super("system_add_column_family");
      }

      protected system_add_column_family_args getEmptyArgsInstance() {
        return new system_add_column_family_args();
      }

      protected system_add_column_family_result getResult(I iface, system_add_column_family_args args) throws org.apache.thrift.TException {
        system_add_column_family_result result = new system_add_column_family_result();
        try {
          result.success = iface.system_add_column_family(args.cf_def);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (SchemaDisagreementException sde) {
          result.sde = sde;
        }
        return result;
      }
    }

    private static class system_drop_column_family<I extends Iface> extends org.apache.thrift.ProcessFunction<I, system_drop_column_family_args> {
      public system_drop_column_family() {
        super("system_drop_column_family");
      }

      protected system_drop_column_family_args getEmptyArgsInstance() {
        return new system_drop_column_family_args();
      }

      protected system_drop_column_family_result getResult(I iface, system_drop_column_family_args args) throws org.apache.thrift.TException {
        system_drop_column_family_result result = new system_drop_column_family_result();
        try {
          result.success = iface.system_drop_column_family(args.column_family);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (SchemaDisagreementException sde) {
          result.sde = sde;
        }
        return result;
      }
    }

    private static class system_add_keyspace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, system_add_keyspace_args> {
      public system_add_keyspace() {
        super("system_add_keyspace");
      }

      protected system_add_keyspace_args getEmptyArgsInstance() {
        return new system_add_keyspace_args();
      }

      protected system_add_keyspace_result getResult(I iface, system_add_keyspace_args args) throws org.apache.thrift.TException {
        system_add_keyspace_result result = new system_add_keyspace_result();
        try {
          result.success = iface.system_add_keyspace(args.ks_def);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (SchemaDisagreementException sde) {
          result.sde = sde;
        }
        return result;
      }
    }

    private static class system_drop_keyspace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, system_drop_keyspace_args> {
      public system_drop_keyspace() {
        super("system_drop_keyspace");
      }

      protected system_drop_keyspace_args getEmptyArgsInstance() {
        return new system_drop_keyspace_args();
      }

      protected system_drop_keyspace_result getResult(I iface, system_drop_keyspace_args args) throws org.apache.thrift.TException {
        system_drop_keyspace_result result = new system_drop_keyspace_result();
        try {
          result.success = iface.system_drop_keyspace(args.keyspace);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (SchemaDisagreementException sde) {
          result.sde = sde;
        }
        return result;
      }
    }

    private static class system_update_keyspace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, system_update_keyspace_args> {
      public system_update_keyspace() {
        super("system_update_keyspace");
      }

      protected system_update_keyspace_args getEmptyArgsInstance() {
        return new system_update_keyspace_args();
      }

      protected system_update_keyspace_result getResult(I iface, system_update_keyspace_args args) throws org.apache.thrift.TException {
        system_update_keyspace_result result = new system_update_keyspace_result();
        try {
          result.success = iface.system_update_keyspace(args.ks_def);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (SchemaDisagreementException sde) {
          result.sde = sde;
        }
        return result;
      }
    }

    private static class system_update_column_family<I extends Iface> extends org.apache.thrift.ProcessFunction<I, system_update_column_family_args> {
      public system_update_column_family() {
        super("system_update_column_family");
      }

      protected system_update_column_family_args getEmptyArgsInstance() {
        return new system_update_column_family_args();
      }

      protected system_update_column_family_result getResult(I iface, system_update_column_family_args args) throws org.apache.thrift.TException {
        system_update_column_family_result result = new system_update_column_family_result();
        try {
          result.success = iface.system_update_column_family(args.cf_def);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (SchemaDisagreementException sde) {
          result.sde = sde;
        }
        return result;
      }
    }

    private static class execute_cql_query<I extends Iface> extends org.apache.thrift.ProcessFunction<I, execute_cql_query_args> {
      public execute_cql_query() {
        super("execute_cql_query");
      }

      protected execute_cql_query_args getEmptyArgsInstance() {
        return new execute_cql_query_args();
      }

      protected execute_cql_query_result getResult(I iface, execute_cql_query_args args) throws org.apache.thrift.TException {
        execute_cql_query_result result = new execute_cql_query_result();
        try {
          result.success = iface.execute_cql_query(args.query, args.compression);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        } catch (SchemaDisagreementException sde) {
          result.sde = sde;
        }
        return result;
      }
    }

    private static class execute_cql3_query<I extends Iface> extends org.apache.thrift.ProcessFunction<I, execute_cql3_query_args> {
      public execute_cql3_query() {
        super("execute_cql3_query");
      }

      protected execute_cql3_query_args getEmptyArgsInstance() {
        return new execute_cql3_query_args();
      }

      protected execute_cql3_query_result getResult(I iface, execute_cql3_query_args args) throws org.apache.thrift.TException {
        execute_cql3_query_result result = new execute_cql3_query_result();
        try {
          result.success = iface.execute_cql3_query(args.query, args.compression, args.consistency);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        } catch (SchemaDisagreementException sde) {
          result.sde = sde;
        }
        return result;
      }
    }

    private static class prepare_cql_query<I extends Iface> extends org.apache.thrift.ProcessFunction<I, prepare_cql_query_args> {
      public prepare_cql_query() {
        super("prepare_cql_query");
      }

      protected prepare_cql_query_args getEmptyArgsInstance() {
        return new prepare_cql_query_args();
      }

      protected prepare_cql_query_result getResult(I iface, prepare_cql_query_args args) throws org.apache.thrift.TException {
        prepare_cql_query_result result = new prepare_cql_query_result();
        try {
          result.success = iface.prepare_cql_query(args.query, args.compression);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        }
        return result;
      }
    }

    private static class prepare_cql3_query<I extends Iface> extends org.apache.thrift.ProcessFunction<I, prepare_cql3_query_args> {
      public prepare_cql3_query() {
        super("prepare_cql3_query");
      }

      protected prepare_cql3_query_args getEmptyArgsInstance() {
        return new prepare_cql3_query_args();
      }

      protected prepare_cql3_query_result getResult(I iface, prepare_cql3_query_args args) throws org.apache.thrift.TException {
        prepare_cql3_query_result result = new prepare_cql3_query_result();
        try {
          result.success = iface.prepare_cql3_query(args.query, args.compression);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        }
        return result;
      }
    }

    private static class execute_prepared_cql_query<I extends Iface> extends org.apache.thrift.ProcessFunction<I, execute_prepared_cql_query_args> {
      public execute_prepared_cql_query() {
        super("execute_prepared_cql_query");
      }

      protected execute_prepared_cql_query_args getEmptyArgsInstance() {
        return new execute_prepared_cql_query_args();
      }

      protected execute_prepared_cql_query_result getResult(I iface, execute_prepared_cql_query_args args) throws org.apache.thrift.TException {
        execute_prepared_cql_query_result result = new execute_prepared_cql_query_result();
        try {
          result.success = iface.execute_prepared_cql_query(args.itemId, args.values);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        } catch (SchemaDisagreementException sde) {
          result.sde = sde;
        }
        return result;
      }
    }

    private static class execute_prepared_cql3_query<I extends Iface> extends org.apache.thrift.ProcessFunction<I, execute_prepared_cql3_query_args> {
      public execute_prepared_cql3_query() {
        super("execute_prepared_cql3_query");
      }

      protected execute_prepared_cql3_query_args getEmptyArgsInstance() {
        return new execute_prepared_cql3_query_args();
      }

      protected execute_prepared_cql3_query_result getResult(I iface, execute_prepared_cql3_query_args args) throws org.apache.thrift.TException {
        execute_prepared_cql3_query_result result = new execute_prepared_cql3_query_result();
        try {
          result.success = iface.execute_prepared_cql3_query(args.itemId, args.values, args.consistency);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        } catch (UnavailableException ue) {
          result.ue = ue;
        } catch (TimedOutException te) {
          result.te = te;
        } catch (SchemaDisagreementException sde) {
          result.sde = sde;
        }
        return result;
      }
    }

    private static class set_cql_version<I extends Iface> extends org.apache.thrift.ProcessFunction<I, set_cql_version_args> {
      public set_cql_version() {
        super("set_cql_version");
      }

      protected set_cql_version_args getEmptyArgsInstance() {
        return new set_cql_version_args();
      }

      protected set_cql_version_result getResult(I iface, set_cql_version_args args) throws org.apache.thrift.TException {
        set_cql_version_result result = new set_cql_version_result();
        try {
          iface.set_cql_version(args.version);
        } catch (InvalidRequestException ire) {
          result.ire = ire;
        }
        return result;
      }
    }

  }

  public static class login_args implements org.apache.thrift.TBase<login_args, login_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("login_args");

    private static final org.apache.thrift.protocol.TField AUTH_REQUEST_FIELD_DESC = new org.apache.thrift.protocol.TField("auth_request", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public AuthenticationRequest auth_request; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      AUTH_REQUEST((short)1, "auth_request");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // AUTH_REQUEST
            return AUTH_REQUEST;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.AUTH_REQUEST, new org.apache.thrift.meta_data.FieldMetaData("auth_request", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, AuthenticationRequest.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(login_args.class, metaDataMap);
    }

    public login_args() {
    }

    public login_args(
      AuthenticationRequest auth_request)
    {
      this();
      this.auth_request = auth_request;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public login_args(login_args other) {
      if (other.isSetAuth_request()) {
        this.auth_request = new AuthenticationRequest(other.auth_request);
      }
    }

    public login_args deepCopy() {
      return new login_args(this);
    }

    @Override
    public void clear() {
      this.auth_request = null;
    }

    public AuthenticationRequest getAuth_request() {
      return this.auth_request;
    }

    public login_args setAuth_request(AuthenticationRequest auth_request) {
      this.auth_request = auth_request;
      return this;
    }

    public void unsetAuth_request() {
      this.auth_request = null;
    }

    /** Returns true if field auth_request is set (has been assigned a value) and false otherwise */
    public boolean isSetAuth_request() {
      return this.auth_request != null;
    }

    public void setAuth_requestIsSet(boolean value) {
      if (!value) {
        this.auth_request = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case AUTH_REQUEST:
        if (value == null) {
          unsetAuth_request();
        } else {
          setAuth_request((AuthenticationRequest)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case AUTH_REQUEST:
        return getAuth_request();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case AUTH_REQUEST:
        return isSetAuth_request();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof login_args)
        return this.equals((login_args)that);
      return false;
    }

    public boolean equals(login_args that) {
      if (that == null)
        return false;

      boolean this_present_auth_request = true && this.isSetAuth_request();
      boolean that_present_auth_request = true && that.isSetAuth_request();
      if (this_present_auth_request || that_present_auth_request) {
        if (!(this_present_auth_request && that_present_auth_request))
          return false;
        if (!this.auth_request.equals(that.auth_request))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_auth_request = true && (isSetAuth_request());
      builder.append(present_auth_request);
      if (present_auth_request)
        builder.append(auth_request);

      return builder.toHashCode();
    }

    public int compareTo(login_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      login_args typedOther = (login_args)other;

      lastComparison = Boolean.valueOf(isSetAuth_request()).compareTo(typedOther.isSetAuth_request());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAuth_request()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.auth_request, typedOther.auth_request);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // AUTH_REQUEST
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.auth_request = new AuthenticationRequest();
              this.auth_request.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.auth_request != null) {
        oprot.writeFieldBegin(AUTH_REQUEST_FIELD_DESC);
        this.auth_request.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("login_args(");
      boolean first = true;

      sb.append("auth_request:");
      if (this.auth_request == null) {
        sb.append("null");
      } else {
        sb.append(this.auth_request);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (auth_request == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'auth_request' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class login_result implements org.apache.thrift.TBase<login_result, login_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("login_result");

    private static final org.apache.thrift.protocol.TField AUTHNX_FIELD_DESC = new org.apache.thrift.protocol.TField("authnx", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField AUTHZX_FIELD_DESC = new org.apache.thrift.protocol.TField("authzx", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    public AuthenticationException authnx; // required
    public AuthorizationException authzx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      AUTHNX((short)1, "authnx"),
      AUTHZX((short)2, "authzx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // AUTHNX
            return AUTHNX;
          case 2: // AUTHZX
            return AUTHZX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.AUTHNX, new org.apache.thrift.meta_data.FieldMetaData("authnx", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.AUTHZX, new org.apache.thrift.meta_data.FieldMetaData("authzx", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(login_result.class, metaDataMap);
    }

    public login_result() {
    }

    public login_result(
      AuthenticationException authnx,
      AuthorizationException authzx)
    {
      this();
      this.authnx = authnx;
      this.authzx = authzx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public login_result(login_result other) {
      if (other.isSetAuthnx()) {
        this.authnx = new AuthenticationException(other.authnx);
      }
      if (other.isSetAuthzx()) {
        this.authzx = new AuthorizationException(other.authzx);
      }
    }

    public login_result deepCopy() {
      return new login_result(this);
    }

    @Override
    public void clear() {
      this.authnx = null;
      this.authzx = null;
    }

    public AuthenticationException getAuthnx() {
      return this.authnx;
    }

    public login_result setAuthnx(AuthenticationException authnx) {
      this.authnx = authnx;
      return this;
    }

    public void unsetAuthnx() {
      this.authnx = null;
    }

    /** Returns true if field authnx is set (has been assigned a value) and false otherwise */
    public boolean isSetAuthnx() {
      return this.authnx != null;
    }

    public void setAuthnxIsSet(boolean value) {
      if (!value) {
        this.authnx = null;
      }
    }

    public AuthorizationException getAuthzx() {
      return this.authzx;
    }

    public login_result setAuthzx(AuthorizationException authzx) {
      this.authzx = authzx;
      return this;
    }

    public void unsetAuthzx() {
      this.authzx = null;
    }

    /** Returns true if field authzx is set (has been assigned a value) and false otherwise */
    public boolean isSetAuthzx() {
      return this.authzx != null;
    }

    public void setAuthzxIsSet(boolean value) {
      if (!value) {
        this.authzx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case AUTHNX:
        if (value == null) {
          unsetAuthnx();
        } else {
          setAuthnx((AuthenticationException)value);
        }
        break;

      case AUTHZX:
        if (value == null) {
          unsetAuthzx();
        } else {
          setAuthzx((AuthorizationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case AUTHNX:
        return getAuthnx();

      case AUTHZX:
        return getAuthzx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case AUTHNX:
        return isSetAuthnx();
      case AUTHZX:
        return isSetAuthzx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof login_result)
        return this.equals((login_result)that);
      return false;
    }

    public boolean equals(login_result that) {
      if (that == null)
        return false;

      boolean this_present_authnx = true && this.isSetAuthnx();
      boolean that_present_authnx = true && that.isSetAuthnx();
      if (this_present_authnx || that_present_authnx) {
        if (!(this_present_authnx && that_present_authnx))
          return false;
        if (!this.authnx.equals(that.authnx))
          return false;
      }

      boolean this_present_authzx = true && this.isSetAuthzx();
      boolean that_present_authzx = true && that.isSetAuthzx();
      if (this_present_authzx || that_present_authzx) {
        if (!(this_present_authzx && that_present_authzx))
          return false;
        if (!this.authzx.equals(that.authzx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_authnx = true && (isSetAuthnx());
      builder.append(present_authnx);
      if (present_authnx)
        builder.append(authnx);

      boolean present_authzx = true && (isSetAuthzx());
      builder.append(present_authzx);
      if (present_authzx)
        builder.append(authzx);

      return builder.toHashCode();
    }

    public int compareTo(login_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      login_result typedOther = (login_result)other;

      lastComparison = Boolean.valueOf(isSetAuthnx()).compareTo(typedOther.isSetAuthnx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAuthnx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.authnx, typedOther.authnx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAuthzx()).compareTo(typedOther.isSetAuthzx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAuthzx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.authzx, typedOther.authzx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // AUTHNX
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.authnx = new AuthenticationException();
              this.authnx.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // AUTHZX
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.authzx = new AuthorizationException();
              this.authzx.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetAuthnx()) {
        oprot.writeFieldBegin(AUTHNX_FIELD_DESC);
        this.authnx.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetAuthzx()) {
        oprot.writeFieldBegin(AUTHZX_FIELD_DESC);
        this.authzx.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("login_result(");
      boolean first = true;

      sb.append("authnx:");
      if (this.authnx == null) {
        sb.append("null");
      } else {
        sb.append(this.authnx);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("authzx:");
      if (this.authzx == null) {
        sb.append("null");
      } else {
        sb.append(this.authzx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class set_keyspace_args implements org.apache.thrift.TBase<set_keyspace_args, set_keyspace_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("set_keyspace_args");

    private static final org.apache.thrift.protocol.TField KEYSPACE_FIELD_DESC = new org.apache.thrift.protocol.TField("keyspace", org.apache.thrift.protocol.TType.STRING, (short)1);

    public String keyspace; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEYSPACE((short)1, "keyspace");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEYSPACE
            return KEYSPACE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEYSPACE, new org.apache.thrift.meta_data.FieldMetaData("keyspace", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(set_keyspace_args.class, metaDataMap);
    }

    public set_keyspace_args() {
    }

    public set_keyspace_args(
      String keyspace)
    {
      this();
      this.keyspace = keyspace;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public set_keyspace_args(set_keyspace_args other) {
      if (other.isSetKeyspace()) {
        this.keyspace = other.keyspace;
      }
    }

    public set_keyspace_args deepCopy() {
      return new set_keyspace_args(this);
    }

    @Override
    public void clear() {
      this.keyspace = null;
    }

    public String getKeyspace() {
      return this.keyspace;
    }

    public set_keyspace_args setKeyspace(String keyspace) {
      this.keyspace = keyspace;
      return this;
    }

    public void unsetKeyspace() {
      this.keyspace = null;
    }

    /** Returns true if field keyspace is set (has been assigned a value) and false otherwise */
    public boolean isSetKeyspace() {
      return this.keyspace != null;
    }

    public void setKeyspaceIsSet(boolean value) {
      if (!value) {
        this.keyspace = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEYSPACE:
        if (value == null) {
          unsetKeyspace();
        } else {
          setKeyspace((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEYSPACE:
        return getKeyspace();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEYSPACE:
        return isSetKeyspace();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof set_keyspace_args)
        return this.equals((set_keyspace_args)that);
      return false;
    }

    public boolean equals(set_keyspace_args that) {
      if (that == null)
        return false;

      boolean this_present_keyspace = true && this.isSetKeyspace();
      boolean that_present_keyspace = true && that.isSetKeyspace();
      if (this_present_keyspace || that_present_keyspace) {
        if (!(this_present_keyspace && that_present_keyspace))
          return false;
        if (!this.keyspace.equals(that.keyspace))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_keyspace = true && (isSetKeyspace());
      builder.append(present_keyspace);
      if (present_keyspace)
        builder.append(keyspace);

      return builder.toHashCode();
    }

    public int compareTo(set_keyspace_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      set_keyspace_args typedOther = (set_keyspace_args)other;

      lastComparison = Boolean.valueOf(isSetKeyspace()).compareTo(typedOther.isSetKeyspace());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKeyspace()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.keyspace, typedOther.keyspace);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // KEYSPACE
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.keyspace = iprot.readString();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.keyspace != null) {
        oprot.writeFieldBegin(KEYSPACE_FIELD_DESC);
        oprot.writeString(this.keyspace);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("set_keyspace_args(");
      boolean first = true;

      sb.append("keyspace:");
      if (this.keyspace == null) {
        sb.append("null");
      } else {
        sb.append(this.keyspace);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (keyspace == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'keyspace' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class set_keyspace_result implements org.apache.thrift.TBase<set_keyspace_result, set_keyspace_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("set_keyspace_result");

    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public InvalidRequestException ire; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IRE((short)1, "ire");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IRE
            return IRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(set_keyspace_result.class, metaDataMap);
    }

    public set_keyspace_result() {
    }

    public set_keyspace_result(
      InvalidRequestException ire)
    {
      this();
      this.ire = ire;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public set_keyspace_result(set_keyspace_result other) {
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
    }

    public set_keyspace_result deepCopy() {
      return new set_keyspace_result(this);
    }

    @Override
    public void clear() {
      this.ire = null;
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public set_keyspace_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case IRE:
        return getIre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case IRE:
        return isSetIre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof set_keyspace_result)
        return this.equals((set_keyspace_result)that);
      return false;
    }

    public boolean equals(set_keyspace_result that) {
      if (that == null)
        return false;

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      return builder.toHashCode();
    }

    public int compareTo(set_keyspace_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      set_keyspace_result typedOther = (set_keyspace_result)other;

      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("set_keyspace_result(");
      boolean first = true;

      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_args implements org.apache.thrift.TBase<get_args, get_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField COLUMN_PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("column_path", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField CONSISTENCY_LEVEL_FIELD_DESC = new org.apache.thrift.protocol.TField("consistency_level", org.apache.thrift.protocol.TType.I32, (short)3);

    public ByteBuffer key; // required
    public ColumnPath column_path; // required
    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistency_level; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key"),
      COLUMN_PATH((short)2, "column_path"),
      /**
       *
       * @see ConsistencyLevel
       */
      CONSISTENCY_LEVEL((short)3, "consistency_level");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          case 2: // COLUMN_PATH
            return COLUMN_PATH;
          case 3: // CONSISTENCY_LEVEL
            return CONSISTENCY_LEVEL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.COLUMN_PATH, new org.apache.thrift.meta_data.FieldMetaData("column_path", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnPath.class)));
      tmpMap.put(_Fields.CONSISTENCY_LEVEL, new org.apache.thrift.meta_data.FieldMetaData("consistency_level", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ConsistencyLevel.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_args.class, metaDataMap);
    }

    public get_args() {
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public get_args(
      ByteBuffer key,
      ColumnPath column_path,
      ConsistencyLevel consistency_level)
    {
      this();
      this.key = key;
      this.column_path = column_path;
      this.consistency_level = consistency_level;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_args(get_args other) {
      if (other.isSetKey()) {
        this.key = org.apache.thrift.TBaseHelper.copyBinary(other.key);
;
      }
      if (other.isSetColumn_path()) {
        this.column_path = new ColumnPath(other.column_path);
      }
      if (other.isSetConsistency_level()) {
        this.consistency_level = other.consistency_level;
      }
    }

    public get_args deepCopy() {
      return new get_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
      this.column_path = null;
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public byte[] getKey() {
      setKey(org.apache.thrift.TBaseHelper.rightSize(key));
      return key == null ? null : key.array();
    }

    public ByteBuffer bufferForKey() {
      return key;
    }

    public get_args setKey(byte[] key) {
      setKey(key == null ? (ByteBuffer)null : ByteBuffer.wrap(key));
      return this;
    }

    public get_args setKey(ByteBuffer key) {
      this.key = key;
      return this;
    }

    public void unsetKey() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean isSetKey() {
      return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public ColumnPath getColumn_path() {
      return this.column_path;
    }

    public get_args setColumn_path(ColumnPath column_path) {
      this.column_path = column_path;
      return this;
    }

    public void unsetColumn_path() {
      this.column_path = null;
    }

    /** Returns true if field column_path is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn_path() {
      return this.column_path != null;
    }

    public void setColumn_pathIsSet(boolean value) {
      if (!value) {
        this.column_path = null;
      }
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel getConsistency_level() {
      return this.consistency_level;
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public get_args setConsistency_level(ConsistencyLevel consistency_level) {
      this.consistency_level = consistency_level;
      return this;
    }

    public void unsetConsistency_level() {
      this.consistency_level = null;
    }

    /** Returns true if field consistency_level is set (has been assigned a value) and false otherwise */
    public boolean isSetConsistency_level() {
      return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
      if (!value) {
        this.consistency_level = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unsetKey();
        } else {
          setKey((ByteBuffer)value);
        }
        break;

      case COLUMN_PATH:
        if (value == null) {
          unsetColumn_path();
        } else {
          setColumn_path((ColumnPath)value);
        }
        break;

      case CONSISTENCY_LEVEL:
        if (value == null) {
          unsetConsistency_level();
        } else {
          setConsistency_level((ConsistencyLevel)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return getKey();

      case COLUMN_PATH:
        return getColumn_path();

      case CONSISTENCY_LEVEL:
        return getConsistency_level();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return isSetKey();
      case COLUMN_PATH:
        return isSetColumn_path();
      case CONSISTENCY_LEVEL:
        return isSetConsistency_level();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_args)
        return this.equals((get_args)that);
      return false;
    }

    public boolean equals(get_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.isSetKey();
      boolean that_present_key = true && that.isSetKey();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      boolean this_present_column_path = true && this.isSetColumn_path();
      boolean that_present_column_path = true && that.isSetColumn_path();
      if (this_present_column_path || that_present_column_path) {
        if (!(this_present_column_path && that_present_column_path))
          return false;
        if (!this.column_path.equals(that.column_path))
          return false;
      }

      boolean this_present_consistency_level = true && this.isSetConsistency_level();
      boolean that_present_consistency_level = true && that.isSetConsistency_level();
      if (this_present_consistency_level || that_present_consistency_level) {
        if (!(this_present_consistency_level && that_present_consistency_level))
          return false;
        if (!this.consistency_level.equals(that.consistency_level))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_key = true && (isSetKey());
      builder.append(present_key);
      if (present_key)
        builder.append(key);

      boolean present_column_path = true && (isSetColumn_path());
      builder.append(present_column_path);
      if (present_column_path)
        builder.append(column_path);

      boolean present_consistency_level = true && (isSetConsistency_level());
      builder.append(present_consistency_level);
      if (present_consistency_level)
        builder.append(consistency_level.getValue());

      return builder.toHashCode();
    }

    public int compareTo(get_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_args typedOther = (get_args)other;

      lastComparison = Boolean.valueOf(isSetKey()).compareTo(typedOther.isSetKey());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKey()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, typedOther.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumn_path()).compareTo(typedOther.isSetColumn_path());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn_path()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column_path, typedOther.column_path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConsistency_level()).compareTo(typedOther.isSetConsistency_level());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConsistency_level()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.consistency_level, typedOther.consistency_level);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // KEY
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.key = iprot.readBinary();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // COLUMN_PATH
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.column_path = new ColumnPath();
              this.column_path.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // CONSISTENCY_LEVEL
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.key != null) {
        oprot.writeFieldBegin(KEY_FIELD_DESC);
        oprot.writeBinary(this.key);
        oprot.writeFieldEnd();
      }
      if (this.column_path != null) {
        oprot.writeFieldBegin(COLUMN_PATH_FIELD_DESC);
        this.column_path.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.consistency_level != null) {
        oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
        oprot.writeI32(this.consistency_level.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.key, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column_path:");
      if (this.column_path == null) {
        sb.append("null");
      } else {
        sb.append(this.column_path);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("consistency_level:");
      if (this.consistency_level == null) {
        sb.append("null");
      } else {
        sb.append(this.consistency_level);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (key == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'key' was not present! Struct: " + toString());
      }
      if (column_path == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'column_path' was not present! Struct: " + toString());
      }
      if (consistency_level == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'consistency_level' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_result implements org.apache.thrift.TBase<get_result, get_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField NFE_FIELD_DESC = new org.apache.thrift.protocol.TField("nfe", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)4);

    public ColumnOrSuperColumn success; // required
    public InvalidRequestException ire; // required
    public NotFoundException nfe; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IRE((short)1, "ire"),
      NFE((short)2, "nfe"),
      UE((short)3, "ue"),
      TE((short)4, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IRE
            return IRE;
          case 2: // NFE
            return NFE;
          case 3: // UE
            return UE;
          case 4: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnOrSuperColumn.class)));
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.NFE, new org.apache.thrift.meta_data.FieldMetaData("nfe", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_result.class, metaDataMap);
    }

    public get_result() {
    }

    public get_result(
      ColumnOrSuperColumn success,
      InvalidRequestException ire,
      NotFoundException nfe,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.success = success;
      this.ire = ire;
      this.nfe = nfe;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_result(get_result other) {
      if (other.isSetSuccess()) {
        this.success = new ColumnOrSuperColumn(other.success);
      }
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetNfe()) {
        this.nfe = new NotFoundException(other.nfe);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public get_result deepCopy() {
      return new get_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.ire = null;
      this.nfe = null;
      this.ue = null;
      this.te = null;
    }

    public ColumnOrSuperColumn getSuccess() {
      return this.success;
    }

    public get_result setSuccess(ColumnOrSuperColumn success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public get_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public NotFoundException getNfe() {
      return this.nfe;
    }

    public get_result setNfe(NotFoundException nfe) {
      this.nfe = nfe;
      return this;
    }

    public void unsetNfe() {
      this.nfe = null;
    }

    /** Returns true if field nfe is set (has been assigned a value) and false otherwise */
    public boolean isSetNfe() {
      return this.nfe != null;
    }

    public void setNfeIsSet(boolean value) {
      if (!value) {
        this.nfe = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public get_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public get_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ColumnOrSuperColumn)value);
        }
        break;

      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case NFE:
        if (value == null) {
          unsetNfe();
        } else {
          setNfe((NotFoundException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IRE:
        return getIre();

      case NFE:
        return getNfe();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IRE:
        return isSetIre();
      case NFE:
        return isSetNfe();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_result)
        return this.equals((get_result)that);
      return false;
    }

    public boolean equals(get_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_nfe = true && this.isSetNfe();
      boolean that_present_nfe = true && that.isSetNfe();
      if (this_present_nfe || that_present_nfe) {
        if (!(this_present_nfe && that_present_nfe))
          return false;
        if (!this.nfe.equals(that.nfe))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_nfe = true && (isSetNfe());
      builder.append(present_nfe);
      if (present_nfe)
        builder.append(nfe);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(get_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_result typedOther = (get_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNfe()).compareTo(typedOther.isSetNfe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNfe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nfe, typedOther.nfe);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.success = new ColumnOrSuperColumn();
              this.success.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // NFE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.nfe = new NotFoundException();
              this.nfe.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        this.success.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetNfe()) {
        oprot.writeFieldBegin(NFE_FIELD_DESC);
        this.nfe.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("nfe:");
      if (this.nfe == null) {
        sb.append("null");
      } else {
        sb.append(this.nfe);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_slice_args implements org.apache.thrift.TBase<get_slice_args, get_slice_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_slice_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField COLUMN_PARENT_FIELD_DESC = new org.apache.thrift.protocol.TField("column_parent", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField PREDICATE_FIELD_DESC = new org.apache.thrift.protocol.TField("predicate", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField CONSISTENCY_LEVEL_FIELD_DESC = new org.apache.thrift.protocol.TField("consistency_level", org.apache.thrift.protocol.TType.I32, (short)4);

    public ByteBuffer key; // required
    public ColumnParent column_parent; // required
    public SlicePredicate predicate; // required
    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistency_level; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key"),
      COLUMN_PARENT((short)2, "column_parent"),
      PREDICATE((short)3, "predicate"),
      /**
       *
       * @see ConsistencyLevel
       */
      CONSISTENCY_LEVEL((short)4, "consistency_level");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          case 2: // COLUMN_PARENT
            return COLUMN_PARENT;
          case 3: // PREDICATE
            return PREDICATE;
          case 4: // CONSISTENCY_LEVEL
            return CONSISTENCY_LEVEL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.COLUMN_PARENT, new org.apache.thrift.meta_data.FieldMetaData("column_parent", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnParent.class)));
      tmpMap.put(_Fields.PREDICATE, new org.apache.thrift.meta_data.FieldMetaData("predicate", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, SlicePredicate.class)));
      tmpMap.put(_Fields.CONSISTENCY_LEVEL, new org.apache.thrift.meta_data.FieldMetaData("consistency_level", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ConsistencyLevel.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_slice_args.class, metaDataMap);
    }

    public get_slice_args() {
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public get_slice_args(
      ByteBuffer key,
      ColumnParent column_parent,
      SlicePredicate predicate,
      ConsistencyLevel consistency_level)
    {
      this();
      this.key = key;
      this.column_parent = column_parent;
      this.predicate = predicate;
      this.consistency_level = consistency_level;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_slice_args(get_slice_args other) {
      if (other.isSetKey()) {
        this.key = org.apache.thrift.TBaseHelper.copyBinary(other.key);
;
      }
      if (other.isSetColumn_parent()) {
        this.column_parent = new ColumnParent(other.column_parent);
      }
      if (other.isSetPredicate()) {
        this.predicate = new SlicePredicate(other.predicate);
      }
      if (other.isSetConsistency_level()) {
        this.consistency_level = other.consistency_level;
      }
    }

    public get_slice_args deepCopy() {
      return new get_slice_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
      this.column_parent = null;
      this.predicate = null;
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public byte[] getKey() {
      setKey(org.apache.thrift.TBaseHelper.rightSize(key));
      return key == null ? null : key.array();
    }

    public ByteBuffer bufferForKey() {
      return key;
    }

    public get_slice_args setKey(byte[] key) {
      setKey(key == null ? (ByteBuffer)null : ByteBuffer.wrap(key));
      return this;
    }

    public get_slice_args setKey(ByteBuffer key) {
      this.key = key;
      return this;
    }

    public void unsetKey() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean isSetKey() {
      return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public ColumnParent getColumn_parent() {
      return this.column_parent;
    }

    public get_slice_args setColumn_parent(ColumnParent column_parent) {
      this.column_parent = column_parent;
      return this;
    }

    public void unsetColumn_parent() {
      this.column_parent = null;
    }

    /** Returns true if field column_parent is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn_parent() {
      return this.column_parent != null;
    }

    public void setColumn_parentIsSet(boolean value) {
      if (!value) {
        this.column_parent = null;
      }
    }

    public SlicePredicate getPredicate() {
      return this.predicate;
    }

    public get_slice_args setPredicate(SlicePredicate predicate) {
      this.predicate = predicate;
      return this;
    }

    public void unsetPredicate() {
      this.predicate = null;
    }

    /** Returns true if field predicate is set (has been assigned a value) and false otherwise */
    public boolean isSetPredicate() {
      return this.predicate != null;
    }

    public void setPredicateIsSet(boolean value) {
      if (!value) {
        this.predicate = null;
      }
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel getConsistency_level() {
      return this.consistency_level;
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public get_slice_args setConsistency_level(ConsistencyLevel consistency_level) {
      this.consistency_level = consistency_level;
      return this;
    }

    public void unsetConsistency_level() {
      this.consistency_level = null;
    }

    /** Returns true if field consistency_level is set (has been assigned a value) and false otherwise */
    public boolean isSetConsistency_level() {
      return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
      if (!value) {
        this.consistency_level = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unsetKey();
        } else {
          setKey((ByteBuffer)value);
        }
        break;

      case COLUMN_PARENT:
        if (value == null) {
          unsetColumn_parent();
        } else {
          setColumn_parent((ColumnParent)value);
        }
        break;

      case PREDICATE:
        if (value == null) {
          unsetPredicate();
        } else {
          setPredicate((SlicePredicate)value);
        }
        break;

      case CONSISTENCY_LEVEL:
        if (value == null) {
          unsetConsistency_level();
        } else {
          setConsistency_level((ConsistencyLevel)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return getKey();

      case COLUMN_PARENT:
        return getColumn_parent();

      case PREDICATE:
        return getPredicate();

      case CONSISTENCY_LEVEL:
        return getConsistency_level();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return isSetKey();
      case COLUMN_PARENT:
        return isSetColumn_parent();
      case PREDICATE:
        return isSetPredicate();
      case CONSISTENCY_LEVEL:
        return isSetConsistency_level();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_slice_args)
        return this.equals((get_slice_args)that);
      return false;
    }

    public boolean equals(get_slice_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.isSetKey();
      boolean that_present_key = true && that.isSetKey();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      boolean this_present_column_parent = true && this.isSetColumn_parent();
      boolean that_present_column_parent = true && that.isSetColumn_parent();
      if (this_present_column_parent || that_present_column_parent) {
        if (!(this_present_column_parent && that_present_column_parent))
          return false;
        if (!this.column_parent.equals(that.column_parent))
          return false;
      }

      boolean this_present_predicate = true && this.isSetPredicate();
      boolean that_present_predicate = true && that.isSetPredicate();
      if (this_present_predicate || that_present_predicate) {
        if (!(this_present_predicate && that_present_predicate))
          return false;
        if (!this.predicate.equals(that.predicate))
          return false;
      }

      boolean this_present_consistency_level = true && this.isSetConsistency_level();
      boolean that_present_consistency_level = true && that.isSetConsistency_level();
      if (this_present_consistency_level || that_present_consistency_level) {
        if (!(this_present_consistency_level && that_present_consistency_level))
          return false;
        if (!this.consistency_level.equals(that.consistency_level))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_key = true && (isSetKey());
      builder.append(present_key);
      if (present_key)
        builder.append(key);

      boolean present_column_parent = true && (isSetColumn_parent());
      builder.append(present_column_parent);
      if (present_column_parent)
        builder.append(column_parent);

      boolean present_predicate = true && (isSetPredicate());
      builder.append(present_predicate);
      if (present_predicate)
        builder.append(predicate);

      boolean present_consistency_level = true && (isSetConsistency_level());
      builder.append(present_consistency_level);
      if (present_consistency_level)
        builder.append(consistency_level.getValue());

      return builder.toHashCode();
    }

    public int compareTo(get_slice_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_slice_args typedOther = (get_slice_args)other;

      lastComparison = Boolean.valueOf(isSetKey()).compareTo(typedOther.isSetKey());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKey()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, typedOther.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumn_parent()).compareTo(typedOther.isSetColumn_parent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn_parent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column_parent, typedOther.column_parent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPredicate()).compareTo(typedOther.isSetPredicate());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPredicate()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.predicate, typedOther.predicate);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConsistency_level()).compareTo(typedOther.isSetConsistency_level());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConsistency_level()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.consistency_level, typedOther.consistency_level);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // KEY
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.key = iprot.readBinary();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // COLUMN_PARENT
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.column_parent = new ColumnParent();
              this.column_parent.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // PREDICATE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.predicate = new SlicePredicate();
              this.predicate.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4: // CONSISTENCY_LEVEL
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.key != null) {
        oprot.writeFieldBegin(KEY_FIELD_DESC);
        oprot.writeBinary(this.key);
        oprot.writeFieldEnd();
      }
      if (this.column_parent != null) {
        oprot.writeFieldBegin(COLUMN_PARENT_FIELD_DESC);
        this.column_parent.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.predicate != null) {
        oprot.writeFieldBegin(PREDICATE_FIELD_DESC);
        this.predicate.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.consistency_level != null) {
        oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
        oprot.writeI32(this.consistency_level.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_slice_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.key, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column_parent:");
      if (this.column_parent == null) {
        sb.append("null");
      } else {
        sb.append(this.column_parent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("predicate:");
      if (this.predicate == null) {
        sb.append("null");
      } else {
        sb.append(this.predicate);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("consistency_level:");
      if (this.consistency_level == null) {
        sb.append("null");
      } else {
        sb.append(this.consistency_level);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (key == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'key' was not present! Struct: " + toString());
      }
      if (column_parent == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'column_parent' was not present! Struct: " + toString());
      }
      if (predicate == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'predicate' was not present! Struct: " + toString());
      }
      if (consistency_level == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'consistency_level' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_slice_result implements org.apache.thrift.TBase<get_slice_result, get_slice_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_slice_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    public List<ColumnOrSuperColumn> success; // required
    public InvalidRequestException ire; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IRE((short)1, "ire"),
      UE((short)2, "ue"),
      TE((short)3, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IRE
            return IRE;
          case 2: // UE
            return UE;
          case 3: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST,
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnOrSuperColumn.class))));
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_slice_result.class, metaDataMap);
    }

    public get_slice_result() {
    }

    public get_slice_result(
      List<ColumnOrSuperColumn> success,
      InvalidRequestException ire,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.success = success;
      this.ire = ire;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_slice_result(get_slice_result other) {
      if (other.isSetSuccess()) {
        List<ColumnOrSuperColumn> __this__success = new ArrayList<ColumnOrSuperColumn>();
        for (ColumnOrSuperColumn other_element : other.success) {
          __this__success.add(new ColumnOrSuperColumn(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public get_slice_result deepCopy() {
      return new get_slice_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.ire = null;
      this.ue = null;
      this.te = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<ColumnOrSuperColumn> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(ColumnOrSuperColumn elem) {
      if (this.success == null) {
        this.success = new ArrayList<ColumnOrSuperColumn>();
      }
      this.success.add(elem);
    }

    public List<ColumnOrSuperColumn> getSuccess() {
      return this.success;
    }

    public get_slice_result setSuccess(List<ColumnOrSuperColumn> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public get_slice_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public get_slice_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public get_slice_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<ColumnOrSuperColumn>)value);
        }
        break;

      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IRE:
        return getIre();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IRE:
        return isSetIre();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_slice_result)
        return this.equals((get_slice_result)that);
      return false;
    }

    public boolean equals(get_slice_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(get_slice_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_slice_result typedOther = (get_slice_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list95 = iprot.readListBegin();
                this.success = new ArrayList<ColumnOrSuperColumn>(_list95.size);
                for (int _i96 = 0; _i96 < _list95.size; ++_i96)
                {
                  ColumnOrSuperColumn _elem97; // required
                  _elem97 = new ColumnOrSuperColumn();
                  _elem97.read(iprot);
                  this.success.add(_elem97);
                }
                iprot.readListEnd();
              }
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        {
          oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, this.success.size()));
          for (ColumnOrSuperColumn _iter98 : this.success)
          {
            _iter98.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      } else if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_slice_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_count_args implements org.apache.thrift.TBase<get_count_args, get_count_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_count_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField COLUMN_PARENT_FIELD_DESC = new org.apache.thrift.protocol.TField("column_parent", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField PREDICATE_FIELD_DESC = new org.apache.thrift.protocol.TField("predicate", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField CONSISTENCY_LEVEL_FIELD_DESC = new org.apache.thrift.protocol.TField("consistency_level", org.apache.thrift.protocol.TType.I32, (short)4);

    public ByteBuffer key; // required
    public ColumnParent column_parent; // required
    public SlicePredicate predicate; // required
    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistency_level; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key"),
      COLUMN_PARENT((short)2, "column_parent"),
      PREDICATE((short)3, "predicate"),
      /**
       *
       * @see ConsistencyLevel
       */
      CONSISTENCY_LEVEL((short)4, "consistency_level");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          case 2: // COLUMN_PARENT
            return COLUMN_PARENT;
          case 3: // PREDICATE
            return PREDICATE;
          case 4: // CONSISTENCY_LEVEL
            return CONSISTENCY_LEVEL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.COLUMN_PARENT, new org.apache.thrift.meta_data.FieldMetaData("column_parent", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnParent.class)));
      tmpMap.put(_Fields.PREDICATE, new org.apache.thrift.meta_data.FieldMetaData("predicate", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, SlicePredicate.class)));
      tmpMap.put(_Fields.CONSISTENCY_LEVEL, new org.apache.thrift.meta_data.FieldMetaData("consistency_level", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ConsistencyLevel.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_count_args.class, metaDataMap);
    }

    public get_count_args() {
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public get_count_args(
      ByteBuffer key,
      ColumnParent column_parent,
      SlicePredicate predicate,
      ConsistencyLevel consistency_level)
    {
      this();
      this.key = key;
      this.column_parent = column_parent;
      this.predicate = predicate;
      this.consistency_level = consistency_level;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_count_args(get_count_args other) {
      if (other.isSetKey()) {
        this.key = org.apache.thrift.TBaseHelper.copyBinary(other.key);
;
      }
      if (other.isSetColumn_parent()) {
        this.column_parent = new ColumnParent(other.column_parent);
      }
      if (other.isSetPredicate()) {
        this.predicate = new SlicePredicate(other.predicate);
      }
      if (other.isSetConsistency_level()) {
        this.consistency_level = other.consistency_level;
      }
    }

    public get_count_args deepCopy() {
      return new get_count_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
      this.column_parent = null;
      this.predicate = null;
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public byte[] getKey() {
      setKey(org.apache.thrift.TBaseHelper.rightSize(key));
      return key == null ? null : key.array();
    }

    public ByteBuffer bufferForKey() {
      return key;
    }

    public get_count_args setKey(byte[] key) {
      setKey(key == null ? (ByteBuffer)null : ByteBuffer.wrap(key));
      return this;
    }

    public get_count_args setKey(ByteBuffer key) {
      this.key = key;
      return this;
    }

    public void unsetKey() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean isSetKey() {
      return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public ColumnParent getColumn_parent() {
      return this.column_parent;
    }

    public get_count_args setColumn_parent(ColumnParent column_parent) {
      this.column_parent = column_parent;
      return this;
    }

    public void unsetColumn_parent() {
      this.column_parent = null;
    }

    /** Returns true if field column_parent is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn_parent() {
      return this.column_parent != null;
    }

    public void setColumn_parentIsSet(boolean value) {
      if (!value) {
        this.column_parent = null;
      }
    }

    public SlicePredicate getPredicate() {
      return this.predicate;
    }

    public get_count_args setPredicate(SlicePredicate predicate) {
      this.predicate = predicate;
      return this;
    }

    public void unsetPredicate() {
      this.predicate = null;
    }

    /** Returns true if field predicate is set (has been assigned a value) and false otherwise */
    public boolean isSetPredicate() {
      return this.predicate != null;
    }

    public void setPredicateIsSet(boolean value) {
      if (!value) {
        this.predicate = null;
      }
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel getConsistency_level() {
      return this.consistency_level;
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public get_count_args setConsistency_level(ConsistencyLevel consistency_level) {
      this.consistency_level = consistency_level;
      return this;
    }

    public void unsetConsistency_level() {
      this.consistency_level = null;
    }

    /** Returns true if field consistency_level is set (has been assigned a value) and false otherwise */
    public boolean isSetConsistency_level() {
      return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
      if (!value) {
        this.consistency_level = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unsetKey();
        } else {
          setKey((ByteBuffer)value);
        }
        break;

      case COLUMN_PARENT:
        if (value == null) {
          unsetColumn_parent();
        } else {
          setColumn_parent((ColumnParent)value);
        }
        break;

      case PREDICATE:
        if (value == null) {
          unsetPredicate();
        } else {
          setPredicate((SlicePredicate)value);
        }
        break;

      case CONSISTENCY_LEVEL:
        if (value == null) {
          unsetConsistency_level();
        } else {
          setConsistency_level((ConsistencyLevel)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return getKey();

      case COLUMN_PARENT:
        return getColumn_parent();

      case PREDICATE:
        return getPredicate();

      case CONSISTENCY_LEVEL:
        return getConsistency_level();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return isSetKey();
      case COLUMN_PARENT:
        return isSetColumn_parent();
      case PREDICATE:
        return isSetPredicate();
      case CONSISTENCY_LEVEL:
        return isSetConsistency_level();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_count_args)
        return this.equals((get_count_args)that);
      return false;
    }

    public boolean equals(get_count_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.isSetKey();
      boolean that_present_key = true && that.isSetKey();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      boolean this_present_column_parent = true && this.isSetColumn_parent();
      boolean that_present_column_parent = true && that.isSetColumn_parent();
      if (this_present_column_parent || that_present_column_parent) {
        if (!(this_present_column_parent && that_present_column_parent))
          return false;
        if (!this.column_parent.equals(that.column_parent))
          return false;
      }

      boolean this_present_predicate = true && this.isSetPredicate();
      boolean that_present_predicate = true && that.isSetPredicate();
      if (this_present_predicate || that_present_predicate) {
        if (!(this_present_predicate && that_present_predicate))
          return false;
        if (!this.predicate.equals(that.predicate))
          return false;
      }

      boolean this_present_consistency_level = true && this.isSetConsistency_level();
      boolean that_present_consistency_level = true && that.isSetConsistency_level();
      if (this_present_consistency_level || that_present_consistency_level) {
        if (!(this_present_consistency_level && that_present_consistency_level))
          return false;
        if (!this.consistency_level.equals(that.consistency_level))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_key = true && (isSetKey());
      builder.append(present_key);
      if (present_key)
        builder.append(key);

      boolean present_column_parent = true && (isSetColumn_parent());
      builder.append(present_column_parent);
      if (present_column_parent)
        builder.append(column_parent);

      boolean present_predicate = true && (isSetPredicate());
      builder.append(present_predicate);
      if (present_predicate)
        builder.append(predicate);

      boolean present_consistency_level = true && (isSetConsistency_level());
      builder.append(present_consistency_level);
      if (present_consistency_level)
        builder.append(consistency_level.getValue());

      return builder.toHashCode();
    }

    public int compareTo(get_count_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_count_args typedOther = (get_count_args)other;

      lastComparison = Boolean.valueOf(isSetKey()).compareTo(typedOther.isSetKey());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKey()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, typedOther.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumn_parent()).compareTo(typedOther.isSetColumn_parent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn_parent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column_parent, typedOther.column_parent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPredicate()).compareTo(typedOther.isSetPredicate());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPredicate()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.predicate, typedOther.predicate);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConsistency_level()).compareTo(typedOther.isSetConsistency_level());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConsistency_level()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.consistency_level, typedOther.consistency_level);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // KEY
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.key = iprot.readBinary();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // COLUMN_PARENT
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.column_parent = new ColumnParent();
              this.column_parent.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // PREDICATE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.predicate = new SlicePredicate();
              this.predicate.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4: // CONSISTENCY_LEVEL
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.key != null) {
        oprot.writeFieldBegin(KEY_FIELD_DESC);
        oprot.writeBinary(this.key);
        oprot.writeFieldEnd();
      }
      if (this.column_parent != null) {
        oprot.writeFieldBegin(COLUMN_PARENT_FIELD_DESC);
        this.column_parent.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.predicate != null) {
        oprot.writeFieldBegin(PREDICATE_FIELD_DESC);
        this.predicate.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.consistency_level != null) {
        oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
        oprot.writeI32(this.consistency_level.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_count_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.key, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column_parent:");
      if (this.column_parent == null) {
        sb.append("null");
      } else {
        sb.append(this.column_parent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("predicate:");
      if (this.predicate == null) {
        sb.append("null");
      } else {
        sb.append(this.predicate);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("consistency_level:");
      if (this.consistency_level == null) {
        sb.append("null");
      } else {
        sb.append(this.consistency_level);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (key == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'key' was not present! Struct: " + toString());
      }
      if (column_parent == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'column_parent' was not present! Struct: " + toString());
      }
      if (predicate == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'predicate' was not present! Struct: " + toString());
      }
      if (consistency_level == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'consistency_level' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_count_result implements org.apache.thrift.TBase<get_count_result, get_count_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_count_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I32, (short)0);
    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    public int success; // required
    public InvalidRequestException ire; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IRE((short)1, "ire"),
      UE((short)2, "ue"),
      TE((short)3, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IRE
            return IRE;
          case 2: // UE
            return UE;
          case 3: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_count_result.class, metaDataMap);
    }

    public get_count_result() {
    }

    public get_count_result(
      int success,
      InvalidRequestException ire,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.ire = ire;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_count_result(get_count_result other) {
      __isset_bit_vector.clear();
      __isset_bit_vector.or(other.__isset_bit_vector);
      this.success = other.success;
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public get_count_result deepCopy() {
      return new get_count_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
      this.ire = null;
      this.ue = null;
      this.te = null;
    }

    public int getSuccess() {
      return this.success;
    }

    public get_count_result setSuccess(int success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bit_vector.clear(__SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return __isset_bit_vector.get(__SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bit_vector.set(__SUCCESS_ISSET_ID, value);
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public get_count_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public get_count_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public get_count_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Integer)value);
        }
        break;

      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return Integer.valueOf(getSuccess());

      case IRE:
        return getIre();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IRE:
        return isSetIre();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_count_result)
        return this.equals((get_count_result)that);
      return false;
    }

    public boolean equals(get_count_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true;
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(get_count_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_count_result typedOther = (get_count_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.success = iprot.readI32();
              setSuccessIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        oprot.writeI32(this.success);
        oprot.writeFieldEnd();
      } else if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_count_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class multiget_slice_args implements org.apache.thrift.TBase<multiget_slice_args, multiget_slice_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("multiget_slice_args");

    private static final org.apache.thrift.protocol.TField KEYS_FIELD_DESC = new org.apache.thrift.protocol.TField("keys", org.apache.thrift.protocol.TType.LIST, (short)1);
    private static final org.apache.thrift.protocol.TField COLUMN_PARENT_FIELD_DESC = new org.apache.thrift.protocol.TField("column_parent", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField PREDICATE_FIELD_DESC = new org.apache.thrift.protocol.TField("predicate", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField CONSISTENCY_LEVEL_FIELD_DESC = new org.apache.thrift.protocol.TField("consistency_level", org.apache.thrift.protocol.TType.I32, (short)4);

    public List<ByteBuffer> keys; // required
    public ColumnParent column_parent; // required
    public SlicePredicate predicate; // required
    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistency_level; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEYS((short)1, "keys"),
      COLUMN_PARENT((short)2, "column_parent"),
      PREDICATE((short)3, "predicate"),
      /**
       *
       * @see ConsistencyLevel
       */
      CONSISTENCY_LEVEL((short)4, "consistency_level");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEYS
            return KEYS;
          case 2: // COLUMN_PARENT
            return COLUMN_PARENT;
          case 3: // PREDICATE
            return PREDICATE;
          case 4: // CONSISTENCY_LEVEL
            return CONSISTENCY_LEVEL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEYS, new org.apache.thrift.meta_data.FieldMetaData("keys", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST,
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true))));
      tmpMap.put(_Fields.COLUMN_PARENT, new org.apache.thrift.meta_data.FieldMetaData("column_parent", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnParent.class)));
      tmpMap.put(_Fields.PREDICATE, new org.apache.thrift.meta_data.FieldMetaData("predicate", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, SlicePredicate.class)));
      tmpMap.put(_Fields.CONSISTENCY_LEVEL, new org.apache.thrift.meta_data.FieldMetaData("consistency_level", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ConsistencyLevel.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(multiget_slice_args.class, metaDataMap);
    }

    public multiget_slice_args() {
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public multiget_slice_args(
      List<ByteBuffer> keys,
      ColumnParent column_parent,
      SlicePredicate predicate,
      ConsistencyLevel consistency_level)
    {
      this();
      this.keys = keys;
      this.column_parent = column_parent;
      this.predicate = predicate;
      this.consistency_level = consistency_level;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public multiget_slice_args(multiget_slice_args other) {
      if (other.isSetKeys()) {
        List<ByteBuffer> __this__keys = new ArrayList<ByteBuffer>();
        for (ByteBuffer other_element : other.keys) {
          ByteBuffer temp_binary_element = org.apache.thrift.TBaseHelper.copyBinary(other_element);
;
          __this__keys.add(temp_binary_element);
        }
        this.keys = __this__keys;
      }
      if (other.isSetColumn_parent()) {
        this.column_parent = new ColumnParent(other.column_parent);
      }
      if (other.isSetPredicate()) {
        this.predicate = new SlicePredicate(other.predicate);
      }
      if (other.isSetConsistency_level()) {
        this.consistency_level = other.consistency_level;
      }
    }

    public multiget_slice_args deepCopy() {
      return new multiget_slice_args(this);
    }

    @Override
    public void clear() {
      this.keys = null;
      this.column_parent = null;
      this.predicate = null;
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public int getKeysSize() {
      return (this.keys == null) ? 0 : this.keys.size();
    }

    public java.util.Iterator<ByteBuffer> getKeysIterator() {
      return (this.keys == null) ? null : this.keys.iterator();
    }

    public void addToKeys(ByteBuffer elem) {
      if (this.keys == null) {
        this.keys = new ArrayList<ByteBuffer>();
      }
      this.keys.add(elem);
    }

    public List<ByteBuffer> getKeys() {
      return this.keys;
    }

    public multiget_slice_args setKeys(List<ByteBuffer> keys) {
      this.keys = keys;
      return this;
    }

    public void unsetKeys() {
      this.keys = null;
    }

    /** Returns true if field keys is set (has been assigned a value) and false otherwise */
    public boolean isSetKeys() {
      return this.keys != null;
    }

    public void setKeysIsSet(boolean value) {
      if (!value) {
        this.keys = null;
      }
    }

    public ColumnParent getColumn_parent() {
      return this.column_parent;
    }

    public multiget_slice_args setColumn_parent(ColumnParent column_parent) {
      this.column_parent = column_parent;
      return this;
    }

    public void unsetColumn_parent() {
      this.column_parent = null;
    }

    /** Returns true if field column_parent is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn_parent() {
      return this.column_parent != null;
    }

    public void setColumn_parentIsSet(boolean value) {
      if (!value) {
        this.column_parent = null;
      }
    }

    public SlicePredicate getPredicate() {
      return this.predicate;
    }

    public multiget_slice_args setPredicate(SlicePredicate predicate) {
      this.predicate = predicate;
      return this;
    }

    public void unsetPredicate() {
      this.predicate = null;
    }

    /** Returns true if field predicate is set (has been assigned a value) and false otherwise */
    public boolean isSetPredicate() {
      return this.predicate != null;
    }

    public void setPredicateIsSet(boolean value) {
      if (!value) {
        this.predicate = null;
      }
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel getConsistency_level() {
      return this.consistency_level;
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public multiget_slice_args setConsistency_level(ConsistencyLevel consistency_level) {
      this.consistency_level = consistency_level;
      return this;
    }

    public void unsetConsistency_level() {
      this.consistency_level = null;
    }

    /** Returns true if field consistency_level is set (has been assigned a value) and false otherwise */
    public boolean isSetConsistency_level() {
      return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
      if (!value) {
        this.consistency_level = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEYS:
        if (value == null) {
          unsetKeys();
        } else {
          setKeys((List<ByteBuffer>)value);
        }
        break;

      case COLUMN_PARENT:
        if (value == null) {
          unsetColumn_parent();
        } else {
          setColumn_parent((ColumnParent)value);
        }
        break;

      case PREDICATE:
        if (value == null) {
          unsetPredicate();
        } else {
          setPredicate((SlicePredicate)value);
        }
        break;

      case CONSISTENCY_LEVEL:
        if (value == null) {
          unsetConsistency_level();
        } else {
          setConsistency_level((ConsistencyLevel)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEYS:
        return getKeys();

      case COLUMN_PARENT:
        return getColumn_parent();

      case PREDICATE:
        return getPredicate();

      case CONSISTENCY_LEVEL:
        return getConsistency_level();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEYS:
        return isSetKeys();
      case COLUMN_PARENT:
        return isSetColumn_parent();
      case PREDICATE:
        return isSetPredicate();
      case CONSISTENCY_LEVEL:
        return isSetConsistency_level();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof multiget_slice_args)
        return this.equals((multiget_slice_args)that);
      return false;
    }

    public boolean equals(multiget_slice_args that) {
      if (that == null)
        return false;

      boolean this_present_keys = true && this.isSetKeys();
      boolean that_present_keys = true && that.isSetKeys();
      if (this_present_keys || that_present_keys) {
        if (!(this_present_keys && that_present_keys))
          return false;
        if (!this.keys.equals(that.keys))
          return false;
      }

      boolean this_present_column_parent = true && this.isSetColumn_parent();
      boolean that_present_column_parent = true && that.isSetColumn_parent();
      if (this_present_column_parent || that_present_column_parent) {
        if (!(this_present_column_parent && that_present_column_parent))
          return false;
        if (!this.column_parent.equals(that.column_parent))
          return false;
      }

      boolean this_present_predicate = true && this.isSetPredicate();
      boolean that_present_predicate = true && that.isSetPredicate();
      if (this_present_predicate || that_present_predicate) {
        if (!(this_present_predicate && that_present_predicate))
          return false;
        if (!this.predicate.equals(that.predicate))
          return false;
      }

      boolean this_present_consistency_level = true && this.isSetConsistency_level();
      boolean that_present_consistency_level = true && that.isSetConsistency_level();
      if (this_present_consistency_level || that_present_consistency_level) {
        if (!(this_present_consistency_level && that_present_consistency_level))
          return false;
        if (!this.consistency_level.equals(that.consistency_level))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_keys = true && (isSetKeys());
      builder.append(present_keys);
      if (present_keys)
        builder.append(keys);

      boolean present_column_parent = true && (isSetColumn_parent());
      builder.append(present_column_parent);
      if (present_column_parent)
        builder.append(column_parent);

      boolean present_predicate = true && (isSetPredicate());
      builder.append(present_predicate);
      if (present_predicate)
        builder.append(predicate);

      boolean present_consistency_level = true && (isSetConsistency_level());
      builder.append(present_consistency_level);
      if (present_consistency_level)
        builder.append(consistency_level.getValue());

      return builder.toHashCode();
    }

    public int compareTo(multiget_slice_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      multiget_slice_args typedOther = (multiget_slice_args)other;

      lastComparison = Boolean.valueOf(isSetKeys()).compareTo(typedOther.isSetKeys());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKeys()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.keys, typedOther.keys);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumn_parent()).compareTo(typedOther.isSetColumn_parent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn_parent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column_parent, typedOther.column_parent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPredicate()).compareTo(typedOther.isSetPredicate());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPredicate()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.predicate, typedOther.predicate);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConsistency_level()).compareTo(typedOther.isSetConsistency_level());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConsistency_level()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.consistency_level, typedOther.consistency_level);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // KEYS
            if (field.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list99 = iprot.readListBegin();
                this.keys = new ArrayList<ByteBuffer>(_list99.size);
                for (int _i100 = 0; _i100 < _list99.size; ++_i100)
                {
                  ByteBuffer _elem101; // required
                  _elem101 = iprot.readBinary();
                  this.keys.add(_elem101);
                }
                iprot.readListEnd();
              }
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // COLUMN_PARENT
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.column_parent = new ColumnParent();
              this.column_parent.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // PREDICATE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.predicate = new SlicePredicate();
              this.predicate.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4: // CONSISTENCY_LEVEL
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.keys != null) {
        oprot.writeFieldBegin(KEYS_FIELD_DESC);
        {
          oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, this.keys.size()));
          for (ByteBuffer _iter102 : this.keys)
          {
            oprot.writeBinary(_iter102);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      if (this.column_parent != null) {
        oprot.writeFieldBegin(COLUMN_PARENT_FIELD_DESC);
        this.column_parent.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.predicate != null) {
        oprot.writeFieldBegin(PREDICATE_FIELD_DESC);
        this.predicate.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.consistency_level != null) {
        oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
        oprot.writeI32(this.consistency_level.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("multiget_slice_args(");
      boolean first = true;

      sb.append("keys:");
      if (this.keys == null) {
        sb.append("null");
      } else {
        sb.append(this.keys);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column_parent:");
      if (this.column_parent == null) {
        sb.append("null");
      } else {
        sb.append(this.column_parent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("predicate:");
      if (this.predicate == null) {
        sb.append("null");
      } else {
        sb.append(this.predicate);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("consistency_level:");
      if (this.consistency_level == null) {
        sb.append("null");
      } else {
        sb.append(this.consistency_level);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (keys == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'keys' was not present! Struct: " + toString());
      }
      if (column_parent == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'column_parent' was not present! Struct: " + toString());
      }
      if (predicate == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'predicate' was not present! Struct: " + toString());
      }
      if (consistency_level == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'consistency_level' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class multiget_slice_result implements org.apache.thrift.TBase<multiget_slice_result, multiget_slice_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("multiget_slice_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.MAP, (short)0);
    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    public Map<ByteBuffer,List<ColumnOrSuperColumn>> success; // required
    public InvalidRequestException ire; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IRE((short)1, "ire"),
      UE((short)2, "ue"),
      TE((short)3, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IRE
            return IRE;
          case 2: // UE
            return UE;
          case 3: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP,
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true),
              new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST,
                  new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnOrSuperColumn.class)))));
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(multiget_slice_result.class, metaDataMap);
    }

    public multiget_slice_result() {
    }

    public multiget_slice_result(
      Map<ByteBuffer,List<ColumnOrSuperColumn>> success,
      InvalidRequestException ire,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.success = success;
      this.ire = ire;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public multiget_slice_result(multiget_slice_result other) {
      if (other.isSetSuccess()) {
        Map<ByteBuffer,List<ColumnOrSuperColumn>> __this__success = new HashMap<ByteBuffer,List<ColumnOrSuperColumn>>();
        for (Map.Entry<ByteBuffer, List<ColumnOrSuperColumn>> other_element : other.success.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          List<ColumnOrSuperColumn> other_element_value = other_element.getValue();

          ByteBuffer __this__success_copy_key = org.apache.thrift.TBaseHelper.copyBinary(other_element_key);
;

          List<ColumnOrSuperColumn> __this__success_copy_value = new ArrayList<ColumnOrSuperColumn>();
          for (ColumnOrSuperColumn other_element_value_element : other_element_value) {
            __this__success_copy_value.add(new ColumnOrSuperColumn(other_element_value_element));
          }

          __this__success.put(__this__success_copy_key, __this__success_copy_value);
        }
        this.success = __this__success;
      }
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public multiget_slice_result deepCopy() {
      return new multiget_slice_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.ire = null;
      this.ue = null;
      this.te = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public void putToSuccess(ByteBuffer key, List<ColumnOrSuperColumn> val) {
      if (this.success == null) {
        this.success = new HashMap<ByteBuffer,List<ColumnOrSuperColumn>>();
      }
      this.success.put(key, val);
    }

    public Map<ByteBuffer,List<ColumnOrSuperColumn>> getSuccess() {
      return this.success;
    }

    public multiget_slice_result setSuccess(Map<ByteBuffer,List<ColumnOrSuperColumn>> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public multiget_slice_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public multiget_slice_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public multiget_slice_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Map<ByteBuffer,List<ColumnOrSuperColumn>>)value);
        }
        break;

      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IRE:
        return getIre();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IRE:
        return isSetIre();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof multiget_slice_result)
        return this.equals((multiget_slice_result)that);
      return false;
    }

    public boolean equals(multiget_slice_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(multiget_slice_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      multiget_slice_result typedOther = (multiget_slice_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.MAP) {
              {
                org.apache.thrift.protocol.TMap _map103 = iprot.readMapBegin();
                this.success = new HashMap<ByteBuffer,List<ColumnOrSuperColumn>>(2*_map103.size);
                for (int _i104 = 0; _i104 < _map103.size; ++_i104)
                {
                  ByteBuffer _key105; // required
                  List<ColumnOrSuperColumn> _val106; // required
                  _key105 = iprot.readBinary();
                  {
                    org.apache.thrift.protocol.TList _list107 = iprot.readListBegin();
                    _val106 = new ArrayList<ColumnOrSuperColumn>(_list107.size);
                    for (int _i108 = 0; _i108 < _list107.size; ++_i108)
                    {
                      ColumnOrSuperColumn _elem109; // required
                      _elem109 = new ColumnOrSuperColumn();
                      _elem109.read(iprot);
                      _val106.add(_elem109);
                    }
                    iprot.readListEnd();
                  }
                  this.success.put(_key105, _val106);
                }
                iprot.readMapEnd();
              }
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        {
          oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.LIST, this.success.size()));
          for (Map.Entry<ByteBuffer, List<ColumnOrSuperColumn>> _iter110 : this.success.entrySet())
          {
            oprot.writeBinary(_iter110.getKey());
            {
              oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, _iter110.getValue().size()));
              for (ColumnOrSuperColumn _iter111 : _iter110.getValue())
              {
                _iter111.write(oprot);
              }
              oprot.writeListEnd();
            }
          }
          oprot.writeMapEnd();
        }
        oprot.writeFieldEnd();
      } else if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("multiget_slice_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class multiget_count_args implements org.apache.thrift.TBase<multiget_count_args, multiget_count_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("multiget_count_args");

    private static final org.apache.thrift.protocol.TField KEYS_FIELD_DESC = new org.apache.thrift.protocol.TField("keys", org.apache.thrift.protocol.TType.LIST, (short)1);
    private static final org.apache.thrift.protocol.TField COLUMN_PARENT_FIELD_DESC = new org.apache.thrift.protocol.TField("column_parent", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField PREDICATE_FIELD_DESC = new org.apache.thrift.protocol.TField("predicate", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField CONSISTENCY_LEVEL_FIELD_DESC = new org.apache.thrift.protocol.TField("consistency_level", org.apache.thrift.protocol.TType.I32, (short)4);

    public List<ByteBuffer> keys; // required
    public ColumnParent column_parent; // required
    public SlicePredicate predicate; // required
    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistency_level; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEYS((short)1, "keys"),
      COLUMN_PARENT((short)2, "column_parent"),
      PREDICATE((short)3, "predicate"),
      /**
       *
       * @see ConsistencyLevel
       */
      CONSISTENCY_LEVEL((short)4, "consistency_level");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEYS
            return KEYS;
          case 2: // COLUMN_PARENT
            return COLUMN_PARENT;
          case 3: // PREDICATE
            return PREDICATE;
          case 4: // CONSISTENCY_LEVEL
            return CONSISTENCY_LEVEL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEYS, new org.apache.thrift.meta_data.FieldMetaData("keys", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST,
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true))));
      tmpMap.put(_Fields.COLUMN_PARENT, new org.apache.thrift.meta_data.FieldMetaData("column_parent", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnParent.class)));
      tmpMap.put(_Fields.PREDICATE, new org.apache.thrift.meta_data.FieldMetaData("predicate", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, SlicePredicate.class)));
      tmpMap.put(_Fields.CONSISTENCY_LEVEL, new org.apache.thrift.meta_data.FieldMetaData("consistency_level", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ConsistencyLevel.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(multiget_count_args.class, metaDataMap);
    }

    public multiget_count_args() {
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public multiget_count_args(
      List<ByteBuffer> keys,
      ColumnParent column_parent,
      SlicePredicate predicate,
      ConsistencyLevel consistency_level)
    {
      this();
      this.keys = keys;
      this.column_parent = column_parent;
      this.predicate = predicate;
      this.consistency_level = consistency_level;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public multiget_count_args(multiget_count_args other) {
      if (other.isSetKeys()) {
        List<ByteBuffer> __this__keys = new ArrayList<ByteBuffer>();
        for (ByteBuffer other_element : other.keys) {
          ByteBuffer temp_binary_element = org.apache.thrift.TBaseHelper.copyBinary(other_element);
;
          __this__keys.add(temp_binary_element);
        }
        this.keys = __this__keys;
      }
      if (other.isSetColumn_parent()) {
        this.column_parent = new ColumnParent(other.column_parent);
      }
      if (other.isSetPredicate()) {
        this.predicate = new SlicePredicate(other.predicate);
      }
      if (other.isSetConsistency_level()) {
        this.consistency_level = other.consistency_level;
      }
    }

    public multiget_count_args deepCopy() {
      return new multiget_count_args(this);
    }

    @Override
    public void clear() {
      this.keys = null;
      this.column_parent = null;
      this.predicate = null;
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public int getKeysSize() {
      return (this.keys == null) ? 0 : this.keys.size();
    }

    public java.util.Iterator<ByteBuffer> getKeysIterator() {
      return (this.keys == null) ? null : this.keys.iterator();
    }

    public void addToKeys(ByteBuffer elem) {
      if (this.keys == null) {
        this.keys = new ArrayList<ByteBuffer>();
      }
      this.keys.add(elem);
    }

    public List<ByteBuffer> getKeys() {
      return this.keys;
    }

    public multiget_count_args setKeys(List<ByteBuffer> keys) {
      this.keys = keys;
      return this;
    }

    public void unsetKeys() {
      this.keys = null;
    }

    /** Returns true if field keys is set (has been assigned a value) and false otherwise */
    public boolean isSetKeys() {
      return this.keys != null;
    }

    public void setKeysIsSet(boolean value) {
      if (!value) {
        this.keys = null;
      }
    }

    public ColumnParent getColumn_parent() {
      return this.column_parent;
    }

    public multiget_count_args setColumn_parent(ColumnParent column_parent) {
      this.column_parent = column_parent;
      return this;
    }

    public void unsetColumn_parent() {
      this.column_parent = null;
    }

    /** Returns true if field column_parent is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn_parent() {
      return this.column_parent != null;
    }

    public void setColumn_parentIsSet(boolean value) {
      if (!value) {
        this.column_parent = null;
      }
    }

    public SlicePredicate getPredicate() {
      return this.predicate;
    }

    public multiget_count_args setPredicate(SlicePredicate predicate) {
      this.predicate = predicate;
      return this;
    }

    public void unsetPredicate() {
      this.predicate = null;
    }

    /** Returns true if field predicate is set (has been assigned a value) and false otherwise */
    public boolean isSetPredicate() {
      return this.predicate != null;
    }

    public void setPredicateIsSet(boolean value) {
      if (!value) {
        this.predicate = null;
      }
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel getConsistency_level() {
      return this.consistency_level;
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public multiget_count_args setConsistency_level(ConsistencyLevel consistency_level) {
      this.consistency_level = consistency_level;
      return this;
    }

    public void unsetConsistency_level() {
      this.consistency_level = null;
    }

    /** Returns true if field consistency_level is set (has been assigned a value) and false otherwise */
    public boolean isSetConsistency_level() {
      return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
      if (!value) {
        this.consistency_level = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEYS:
        if (value == null) {
          unsetKeys();
        } else {
          setKeys((List<ByteBuffer>)value);
        }
        break;

      case COLUMN_PARENT:
        if (value == null) {
          unsetColumn_parent();
        } else {
          setColumn_parent((ColumnParent)value);
        }
        break;

      case PREDICATE:
        if (value == null) {
          unsetPredicate();
        } else {
          setPredicate((SlicePredicate)value);
        }
        break;

      case CONSISTENCY_LEVEL:
        if (value == null) {
          unsetConsistency_level();
        } else {
          setConsistency_level((ConsistencyLevel)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEYS:
        return getKeys();

      case COLUMN_PARENT:
        return getColumn_parent();

      case PREDICATE:
        return getPredicate();

      case CONSISTENCY_LEVEL:
        return getConsistency_level();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEYS:
        return isSetKeys();
      case COLUMN_PARENT:
        return isSetColumn_parent();
      case PREDICATE:
        return isSetPredicate();
      case CONSISTENCY_LEVEL:
        return isSetConsistency_level();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof multiget_count_args)
        return this.equals((multiget_count_args)that);
      return false;
    }

    public boolean equals(multiget_count_args that) {
      if (that == null)
        return false;

      boolean this_present_keys = true && this.isSetKeys();
      boolean that_present_keys = true && that.isSetKeys();
      if (this_present_keys || that_present_keys) {
        if (!(this_present_keys && that_present_keys))
          return false;
        if (!this.keys.equals(that.keys))
          return false;
      }

      boolean this_present_column_parent = true && this.isSetColumn_parent();
      boolean that_present_column_parent = true && that.isSetColumn_parent();
      if (this_present_column_parent || that_present_column_parent) {
        if (!(this_present_column_parent && that_present_column_parent))
          return false;
        if (!this.column_parent.equals(that.column_parent))
          return false;
      }

      boolean this_present_predicate = true && this.isSetPredicate();
      boolean that_present_predicate = true && that.isSetPredicate();
      if (this_present_predicate || that_present_predicate) {
        if (!(this_present_predicate && that_present_predicate))
          return false;
        if (!this.predicate.equals(that.predicate))
          return false;
      }

      boolean this_present_consistency_level = true && this.isSetConsistency_level();
      boolean that_present_consistency_level = true && that.isSetConsistency_level();
      if (this_present_consistency_level || that_present_consistency_level) {
        if (!(this_present_consistency_level && that_present_consistency_level))
          return false;
        if (!this.consistency_level.equals(that.consistency_level))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_keys = true && (isSetKeys());
      builder.append(present_keys);
      if (present_keys)
        builder.append(keys);

      boolean present_column_parent = true && (isSetColumn_parent());
      builder.append(present_column_parent);
      if (present_column_parent)
        builder.append(column_parent);

      boolean present_predicate = true && (isSetPredicate());
      builder.append(present_predicate);
      if (present_predicate)
        builder.append(predicate);

      boolean present_consistency_level = true && (isSetConsistency_level());
      builder.append(present_consistency_level);
      if (present_consistency_level)
        builder.append(consistency_level.getValue());

      return builder.toHashCode();
    }

    public int compareTo(multiget_count_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      multiget_count_args typedOther = (multiget_count_args)other;

      lastComparison = Boolean.valueOf(isSetKeys()).compareTo(typedOther.isSetKeys());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKeys()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.keys, typedOther.keys);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumn_parent()).compareTo(typedOther.isSetColumn_parent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn_parent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column_parent, typedOther.column_parent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPredicate()).compareTo(typedOther.isSetPredicate());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPredicate()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.predicate, typedOther.predicate);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConsistency_level()).compareTo(typedOther.isSetConsistency_level());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConsistency_level()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.consistency_level, typedOther.consistency_level);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // KEYS
            if (field.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list112 = iprot.readListBegin();
                this.keys = new ArrayList<ByteBuffer>(_list112.size);
                for (int _i113 = 0; _i113 < _list112.size; ++_i113)
                {
                  ByteBuffer _elem114; // required
                  _elem114 = iprot.readBinary();
                  this.keys.add(_elem114);
                }
                iprot.readListEnd();
              }
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // COLUMN_PARENT
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.column_parent = new ColumnParent();
              this.column_parent.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // PREDICATE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.predicate = new SlicePredicate();
              this.predicate.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4: // CONSISTENCY_LEVEL
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.keys != null) {
        oprot.writeFieldBegin(KEYS_FIELD_DESC);
        {
          oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, this.keys.size()));
          for (ByteBuffer _iter115 : this.keys)
          {
            oprot.writeBinary(_iter115);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      if (this.column_parent != null) {
        oprot.writeFieldBegin(COLUMN_PARENT_FIELD_DESC);
        this.column_parent.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.predicate != null) {
        oprot.writeFieldBegin(PREDICATE_FIELD_DESC);
        this.predicate.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.consistency_level != null) {
        oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
        oprot.writeI32(this.consistency_level.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("multiget_count_args(");
      boolean first = true;

      sb.append("keys:");
      if (this.keys == null) {
        sb.append("null");
      } else {
        sb.append(this.keys);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column_parent:");
      if (this.column_parent == null) {
        sb.append("null");
      } else {
        sb.append(this.column_parent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("predicate:");
      if (this.predicate == null) {
        sb.append("null");
      } else {
        sb.append(this.predicate);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("consistency_level:");
      if (this.consistency_level == null) {
        sb.append("null");
      } else {
        sb.append(this.consistency_level);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (keys == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'keys' was not present! Struct: " + toString());
      }
      if (column_parent == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'column_parent' was not present! Struct: " + toString());
      }
      if (predicate == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'predicate' was not present! Struct: " + toString());
      }
      if (consistency_level == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'consistency_level' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class multiget_count_result implements org.apache.thrift.TBase<multiget_count_result, multiget_count_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("multiget_count_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.MAP, (short)0);
    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    public Map<ByteBuffer,Integer> success; // required
    public InvalidRequestException ire; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IRE((short)1, "ire"),
      UE((short)2, "ue"),
      TE((short)3, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IRE
            return IRE;
          case 2: // UE
            return UE;
          case 3: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP,
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true),
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32))));
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(multiget_count_result.class, metaDataMap);
    }

    public multiget_count_result() {
    }

    public multiget_count_result(
      Map<ByteBuffer,Integer> success,
      InvalidRequestException ire,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.success = success;
      this.ire = ire;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public multiget_count_result(multiget_count_result other) {
      if (other.isSetSuccess()) {
        Map<ByteBuffer,Integer> __this__success = new HashMap<ByteBuffer,Integer>();
        for (Map.Entry<ByteBuffer, Integer> other_element : other.success.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          Integer other_element_value = other_element.getValue();

          ByteBuffer __this__success_copy_key = org.apache.thrift.TBaseHelper.copyBinary(other_element_key);
;

          Integer __this__success_copy_value = other_element_value;

          __this__success.put(__this__success_copy_key, __this__success_copy_value);
        }
        this.success = __this__success;
      }
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public multiget_count_result deepCopy() {
      return new multiget_count_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.ire = null;
      this.ue = null;
      this.te = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public void putToSuccess(ByteBuffer key, int val) {
      if (this.success == null) {
        this.success = new HashMap<ByteBuffer,Integer>();
      }
      this.success.put(key, val);
    }

    public Map<ByteBuffer,Integer> getSuccess() {
      return this.success;
    }

    public multiget_count_result setSuccess(Map<ByteBuffer,Integer> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public multiget_count_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public multiget_count_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public multiget_count_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Map<ByteBuffer,Integer>)value);
        }
        break;

      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IRE:
        return getIre();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IRE:
        return isSetIre();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof multiget_count_result)
        return this.equals((multiget_count_result)that);
      return false;
    }

    public boolean equals(multiget_count_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(multiget_count_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      multiget_count_result typedOther = (multiget_count_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.MAP) {
              {
                org.apache.thrift.protocol.TMap _map116 = iprot.readMapBegin();
                this.success = new HashMap<ByteBuffer,Integer>(2*_map116.size);
                for (int _i117 = 0; _i117 < _map116.size; ++_i117)
                {
                  ByteBuffer _key118; // required
                  int _val119; // required
                  _key118 = iprot.readBinary();
                  _val119 = iprot.readI32();
                  this.success.put(_key118, _val119);
                }
                iprot.readMapEnd();
              }
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        {
          oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.I32, this.success.size()));
          for (Map.Entry<ByteBuffer, Integer> _iter120 : this.success.entrySet())
          {
            oprot.writeBinary(_iter120.getKey());
            oprot.writeI32(_iter120.getValue());
          }
          oprot.writeMapEnd();
        }
        oprot.writeFieldEnd();
      } else if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("multiget_count_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_range_slices_args implements org.apache.thrift.TBase<get_range_slices_args, get_range_slices_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_range_slices_args");

    private static final org.apache.thrift.protocol.TField COLUMN_PARENT_FIELD_DESC = new org.apache.thrift.protocol.TField("column_parent", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField PREDICATE_FIELD_DESC = new org.apache.thrift.protocol.TField("predicate", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField RANGE_FIELD_DESC = new org.apache.thrift.protocol.TField("range", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField CONSISTENCY_LEVEL_FIELD_DESC = new org.apache.thrift.protocol.TField("consistency_level", org.apache.thrift.protocol.TType.I32, (short)4);

    public ColumnParent column_parent; // required
    public SlicePredicate predicate; // required
    public KeyRange range; // required
    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistency_level; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      COLUMN_PARENT((short)1, "column_parent"),
      PREDICATE((short)2, "predicate"),
      RANGE((short)3, "range"),
      /**
       *
       * @see ConsistencyLevel
       */
      CONSISTENCY_LEVEL((short)4, "consistency_level");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // COLUMN_PARENT
            return COLUMN_PARENT;
          case 2: // PREDICATE
            return PREDICATE;
          case 3: // RANGE
            return RANGE;
          case 4: // CONSISTENCY_LEVEL
            return CONSISTENCY_LEVEL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.COLUMN_PARENT, new org.apache.thrift.meta_data.FieldMetaData("column_parent", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnParent.class)));
      tmpMap.put(_Fields.PREDICATE, new org.apache.thrift.meta_data.FieldMetaData("predicate", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, SlicePredicate.class)));
      tmpMap.put(_Fields.RANGE, new org.apache.thrift.meta_data.FieldMetaData("range", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, KeyRange.class)));
      tmpMap.put(_Fields.CONSISTENCY_LEVEL, new org.apache.thrift.meta_data.FieldMetaData("consistency_level", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ConsistencyLevel.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_range_slices_args.class, metaDataMap);
    }

    public get_range_slices_args() {
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public get_range_slices_args(
      ColumnParent column_parent,
      SlicePredicate predicate,
      KeyRange range,
      ConsistencyLevel consistency_level)
    {
      this();
      this.column_parent = column_parent;
      this.predicate = predicate;
      this.range = range;
      this.consistency_level = consistency_level;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_range_slices_args(get_range_slices_args other) {
      if (other.isSetColumn_parent()) {
        this.column_parent = new ColumnParent(other.column_parent);
      }
      if (other.isSetPredicate()) {
        this.predicate = new SlicePredicate(other.predicate);
      }
      if (other.isSetRange()) {
        this.range = new KeyRange(other.range);
      }
      if (other.isSetConsistency_level()) {
        this.consistency_level = other.consistency_level;
      }
    }

    public get_range_slices_args deepCopy() {
      return new get_range_slices_args(this);
    }

    @Override
    public void clear() {
      this.column_parent = null;
      this.predicate = null;
      this.range = null;
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public ColumnParent getColumn_parent() {
      return this.column_parent;
    }

    public get_range_slices_args setColumn_parent(ColumnParent column_parent) {
      this.column_parent = column_parent;
      return this;
    }

    public void unsetColumn_parent() {
      this.column_parent = null;
    }

    /** Returns true if field column_parent is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn_parent() {
      return this.column_parent != null;
    }

    public void setColumn_parentIsSet(boolean value) {
      if (!value) {
        this.column_parent = null;
      }
    }

    public SlicePredicate getPredicate() {
      return this.predicate;
    }

    public get_range_slices_args setPredicate(SlicePredicate predicate) {
      this.predicate = predicate;
      return this;
    }

    public void unsetPredicate() {
      this.predicate = null;
    }

    /** Returns true if field predicate is set (has been assigned a value) and false otherwise */
    public boolean isSetPredicate() {
      return this.predicate != null;
    }

    public void setPredicateIsSet(boolean value) {
      if (!value) {
        this.predicate = null;
      }
    }

    public KeyRange getRange() {
      return this.range;
    }

    public get_range_slices_args setRange(KeyRange range) {
      this.range = range;
      return this;
    }

    public void unsetRange() {
      this.range = null;
    }

    /** Returns true if field range is set (has been assigned a value) and false otherwise */
    public boolean isSetRange() {
      return this.range != null;
    }

    public void setRangeIsSet(boolean value) {
      if (!value) {
        this.range = null;
      }
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel getConsistency_level() {
      return this.consistency_level;
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public get_range_slices_args setConsistency_level(ConsistencyLevel consistency_level) {
      this.consistency_level = consistency_level;
      return this;
    }

    public void unsetConsistency_level() {
      this.consistency_level = null;
    }

    /** Returns true if field consistency_level is set (has been assigned a value) and false otherwise */
    public boolean isSetConsistency_level() {
      return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
      if (!value) {
        this.consistency_level = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case COLUMN_PARENT:
        if (value == null) {
          unsetColumn_parent();
        } else {
          setColumn_parent((ColumnParent)value);
        }
        break;

      case PREDICATE:
        if (value == null) {
          unsetPredicate();
        } else {
          setPredicate((SlicePredicate)value);
        }
        break;

      case RANGE:
        if (value == null) {
          unsetRange();
        } else {
          setRange((KeyRange)value);
        }
        break;

      case CONSISTENCY_LEVEL:
        if (value == null) {
          unsetConsistency_level();
        } else {
          setConsistency_level((ConsistencyLevel)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case COLUMN_PARENT:
        return getColumn_parent();

      case PREDICATE:
        return getPredicate();

      case RANGE:
        return getRange();

      case CONSISTENCY_LEVEL:
        return getConsistency_level();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case COLUMN_PARENT:
        return isSetColumn_parent();
      case PREDICATE:
        return isSetPredicate();
      case RANGE:
        return isSetRange();
      case CONSISTENCY_LEVEL:
        return isSetConsistency_level();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_range_slices_args)
        return this.equals((get_range_slices_args)that);
      return false;
    }

    public boolean equals(get_range_slices_args that) {
      if (that == null)
        return false;

      boolean this_present_column_parent = true && this.isSetColumn_parent();
      boolean that_present_column_parent = true && that.isSetColumn_parent();
      if (this_present_column_parent || that_present_column_parent) {
        if (!(this_present_column_parent && that_present_column_parent))
          return false;
        if (!this.column_parent.equals(that.column_parent))
          return false;
      }

      boolean this_present_predicate = true && this.isSetPredicate();
      boolean that_present_predicate = true && that.isSetPredicate();
      if (this_present_predicate || that_present_predicate) {
        if (!(this_present_predicate && that_present_predicate))
          return false;
        if (!this.predicate.equals(that.predicate))
          return false;
      }

      boolean this_present_range = true && this.isSetRange();
      boolean that_present_range = true && that.isSetRange();
      if (this_present_range || that_present_range) {
        if (!(this_present_range && that_present_range))
          return false;
        if (!this.range.equals(that.range))
          return false;
      }

      boolean this_present_consistency_level = true && this.isSetConsistency_level();
      boolean that_present_consistency_level = true && that.isSetConsistency_level();
      if (this_present_consistency_level || that_present_consistency_level) {
        if (!(this_present_consistency_level && that_present_consistency_level))
          return false;
        if (!this.consistency_level.equals(that.consistency_level))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_column_parent = true && (isSetColumn_parent());
      builder.append(present_column_parent);
      if (present_column_parent)
        builder.append(column_parent);

      boolean present_predicate = true && (isSetPredicate());
      builder.append(present_predicate);
      if (present_predicate)
        builder.append(predicate);

      boolean present_range = true && (isSetRange());
      builder.append(present_range);
      if (present_range)
        builder.append(range);

      boolean present_consistency_level = true && (isSetConsistency_level());
      builder.append(present_consistency_level);
      if (present_consistency_level)
        builder.append(consistency_level.getValue());

      return builder.toHashCode();
    }

    public int compareTo(get_range_slices_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_range_slices_args typedOther = (get_range_slices_args)other;

      lastComparison = Boolean.valueOf(isSetColumn_parent()).compareTo(typedOther.isSetColumn_parent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn_parent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column_parent, typedOther.column_parent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPredicate()).compareTo(typedOther.isSetPredicate());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPredicate()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.predicate, typedOther.predicate);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRange()).compareTo(typedOther.isSetRange());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRange()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.range, typedOther.range);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConsistency_level()).compareTo(typedOther.isSetConsistency_level());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConsistency_level()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.consistency_level, typedOther.consistency_level);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // COLUMN_PARENT
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.column_parent = new ColumnParent();
              this.column_parent.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // PREDICATE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.predicate = new SlicePredicate();
              this.predicate.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // RANGE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.range = new KeyRange();
              this.range.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4: // CONSISTENCY_LEVEL
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.column_parent != null) {
        oprot.writeFieldBegin(COLUMN_PARENT_FIELD_DESC);
        this.column_parent.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.predicate != null) {
        oprot.writeFieldBegin(PREDICATE_FIELD_DESC);
        this.predicate.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.range != null) {
        oprot.writeFieldBegin(RANGE_FIELD_DESC);
        this.range.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.consistency_level != null) {
        oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
        oprot.writeI32(this.consistency_level.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_range_slices_args(");
      boolean first = true;

      sb.append("column_parent:");
      if (this.column_parent == null) {
        sb.append("null");
      } else {
        sb.append(this.column_parent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("predicate:");
      if (this.predicate == null) {
        sb.append("null");
      } else {
        sb.append(this.predicate);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("range:");
      if (this.range == null) {
        sb.append("null");
      } else {
        sb.append(this.range);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("consistency_level:");
      if (this.consistency_level == null) {
        sb.append("null");
      } else {
        sb.append(this.consistency_level);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (column_parent == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'column_parent' was not present! Struct: " + toString());
      }
      if (predicate == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'predicate' was not present! Struct: " + toString());
      }
      if (range == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'range' was not present! Struct: " + toString());
      }
      if (consistency_level == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'consistency_level' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_range_slices_result implements org.apache.thrift.TBase<get_range_slices_result, get_range_slices_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_range_slices_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    public List<KeySlice> success; // required
    public InvalidRequestException ire; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IRE((short)1, "ire"),
      UE((short)2, "ue"),
      TE((short)3, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IRE
            return IRE;
          case 2: // UE
            return UE;
          case 3: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST,
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, KeySlice.class))));
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_range_slices_result.class, metaDataMap);
    }

    public get_range_slices_result() {
    }

    public get_range_slices_result(
      List<KeySlice> success,
      InvalidRequestException ire,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.success = success;
      this.ire = ire;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_range_slices_result(get_range_slices_result other) {
      if (other.isSetSuccess()) {
        List<KeySlice> __this__success = new ArrayList<KeySlice>();
        for (KeySlice other_element : other.success) {
          __this__success.add(new KeySlice(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public get_range_slices_result deepCopy() {
      return new get_range_slices_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.ire = null;
      this.ue = null;
      this.te = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<KeySlice> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(KeySlice elem) {
      if (this.success == null) {
        this.success = new ArrayList<KeySlice>();
      }
      this.success.add(elem);
    }

    public List<KeySlice> getSuccess() {
      return this.success;
    }

    public get_range_slices_result setSuccess(List<KeySlice> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public get_range_slices_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public get_range_slices_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public get_range_slices_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<KeySlice>)value);
        }
        break;

      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IRE:
        return getIre();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IRE:
        return isSetIre();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_range_slices_result)
        return this.equals((get_range_slices_result)that);
      return false;
    }

    public boolean equals(get_range_slices_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(get_range_slices_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_range_slices_result typedOther = (get_range_slices_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list121 = iprot.readListBegin();
                this.success = new ArrayList<KeySlice>(_list121.size);
                for (int _i122 = 0; _i122 < _list121.size; ++_i122)
                {
                  KeySlice _elem123; // required
                  _elem123 = new KeySlice();
                  _elem123.read(iprot);
                  this.success.add(_elem123);
                }
                iprot.readListEnd();
              }
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        {
          oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, this.success.size()));
          for (KeySlice _iter124 : this.success)
          {
            _iter124.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      } else if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_range_slices_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_paged_slice_args implements org.apache.thrift.TBase<get_paged_slice_args, get_paged_slice_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_paged_slice_args");

    private static final org.apache.thrift.protocol.TField COLUMN_FAMILY_FIELD_DESC = new org.apache.thrift.protocol.TField("column_family", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField RANGE_FIELD_DESC = new org.apache.thrift.protocol.TField("range", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField START_COLUMN_FIELD_DESC = new org.apache.thrift.protocol.TField("start_column", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField CONSISTENCY_LEVEL_FIELD_DESC = new org.apache.thrift.protocol.TField("consistency_level", org.apache.thrift.protocol.TType.I32, (short)4);

    public String column_family; // required
    public KeyRange range; // required
    public ByteBuffer start_column; // required
    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistency_level; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      COLUMN_FAMILY((short)1, "column_family"),
      RANGE((short)2, "range"),
      START_COLUMN((short)3, "start_column"),
      /**
       *
       * @see ConsistencyLevel
       */
      CONSISTENCY_LEVEL((short)4, "consistency_level");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // COLUMN_FAMILY
            return COLUMN_FAMILY;
          case 2: // RANGE
            return RANGE;
          case 3: // START_COLUMN
            return START_COLUMN;
          case 4: // CONSISTENCY_LEVEL
            return CONSISTENCY_LEVEL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.COLUMN_FAMILY, new org.apache.thrift.meta_data.FieldMetaData("column_family", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.RANGE, new org.apache.thrift.meta_data.FieldMetaData("range", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, KeyRange.class)));
      tmpMap.put(_Fields.START_COLUMN, new org.apache.thrift.meta_data.FieldMetaData("start_column", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.CONSISTENCY_LEVEL, new org.apache.thrift.meta_data.FieldMetaData("consistency_level", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ConsistencyLevel.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_paged_slice_args.class, metaDataMap);
    }

    public get_paged_slice_args() {
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public get_paged_slice_args(
      String column_family,
      KeyRange range,
      ByteBuffer start_column,
      ConsistencyLevel consistency_level)
    {
      this();
      this.column_family = column_family;
      this.range = range;
      this.start_column = start_column;
      this.consistency_level = consistency_level;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_paged_slice_args(get_paged_slice_args other) {
      if (other.isSetColumn_family()) {
        this.column_family = other.column_family;
      }
      if (other.isSetRange()) {
        this.range = new KeyRange(other.range);
      }
      if (other.isSetStart_column()) {
        this.start_column = org.apache.thrift.TBaseHelper.copyBinary(other.start_column);
;
      }
      if (other.isSetConsistency_level()) {
        this.consistency_level = other.consistency_level;
      }
    }

    public get_paged_slice_args deepCopy() {
      return new get_paged_slice_args(this);
    }

    @Override
    public void clear() {
      this.column_family = null;
      this.range = null;
      this.start_column = null;
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public String getColumn_family() {
      return this.column_family;
    }

    public get_paged_slice_args setColumn_family(String column_family) {
      this.column_family = column_family;
      return this;
    }

    public void unsetColumn_family() {
      this.column_family = null;
    }

    /** Returns true if field column_family is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn_family() {
      return this.column_family != null;
    }

    public void setColumn_familyIsSet(boolean value) {
      if (!value) {
        this.column_family = null;
      }
    }

    public KeyRange getRange() {
      return this.range;
    }

    public get_paged_slice_args setRange(KeyRange range) {
      this.range = range;
      return this;
    }

    public void unsetRange() {
      this.range = null;
    }

    /** Returns true if field range is set (has been assigned a value) and false otherwise */
    public boolean isSetRange() {
      return this.range != null;
    }

    public void setRangeIsSet(boolean value) {
      if (!value) {
        this.range = null;
      }
    }

    public byte[] getStart_column() {
      setStart_column(org.apache.thrift.TBaseHelper.rightSize(start_column));
      return start_column == null ? null : start_column.array();
    }

    public ByteBuffer bufferForStart_column() {
      return start_column;
    }

    public get_paged_slice_args setStart_column(byte[] start_column) {
      setStart_column(start_column == null ? (ByteBuffer)null : ByteBuffer.wrap(start_column));
      return this;
    }

    public get_paged_slice_args setStart_column(ByteBuffer start_column) {
      this.start_column = start_column;
      return this;
    }

    public void unsetStart_column() {
      this.start_column = null;
    }

    /** Returns true if field start_column is set (has been assigned a value) and false otherwise */
    public boolean isSetStart_column() {
      return this.start_column != null;
    }

    public void setStart_columnIsSet(boolean value) {
      if (!value) {
        this.start_column = null;
      }
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel getConsistency_level() {
      return this.consistency_level;
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public get_paged_slice_args setConsistency_level(ConsistencyLevel consistency_level) {
      this.consistency_level = consistency_level;
      return this;
    }

    public void unsetConsistency_level() {
      this.consistency_level = null;
    }

    /** Returns true if field consistency_level is set (has been assigned a value) and false otherwise */
    public boolean isSetConsistency_level() {
      return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
      if (!value) {
        this.consistency_level = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case COLUMN_FAMILY:
        if (value == null) {
          unsetColumn_family();
        } else {
          setColumn_family((String)value);
        }
        break;

      case RANGE:
        if (value == null) {
          unsetRange();
        } else {
          setRange((KeyRange)value);
        }
        break;

      case START_COLUMN:
        if (value == null) {
          unsetStart_column();
        } else {
          setStart_column((ByteBuffer)value);
        }
        break;

      case CONSISTENCY_LEVEL:
        if (value == null) {
          unsetConsistency_level();
        } else {
          setConsistency_level((ConsistencyLevel)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case COLUMN_FAMILY:
        return getColumn_family();

      case RANGE:
        return getRange();

      case START_COLUMN:
        return getStart_column();

      case CONSISTENCY_LEVEL:
        return getConsistency_level();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case COLUMN_FAMILY:
        return isSetColumn_family();
      case RANGE:
        return isSetRange();
      case START_COLUMN:
        return isSetStart_column();
      case CONSISTENCY_LEVEL:
        return isSetConsistency_level();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_paged_slice_args)
        return this.equals((get_paged_slice_args)that);
      return false;
    }

    public boolean equals(get_paged_slice_args that) {
      if (that == null)
        return false;

      boolean this_present_column_family = true && this.isSetColumn_family();
      boolean that_present_column_family = true && that.isSetColumn_family();
      if (this_present_column_family || that_present_column_family) {
        if (!(this_present_column_family && that_present_column_family))
          return false;
        if (!this.column_family.equals(that.column_family))
          return false;
      }

      boolean this_present_range = true && this.isSetRange();
      boolean that_present_range = true && that.isSetRange();
      if (this_present_range || that_present_range) {
        if (!(this_present_range && that_present_range))
          return false;
        if (!this.range.equals(that.range))
          return false;
      }

      boolean this_present_start_column = true && this.isSetStart_column();
      boolean that_present_start_column = true && that.isSetStart_column();
      if (this_present_start_column || that_present_start_column) {
        if (!(this_present_start_column && that_present_start_column))
          return false;
        if (!this.start_column.equals(that.start_column))
          return false;
      }

      boolean this_present_consistency_level = true && this.isSetConsistency_level();
      boolean that_present_consistency_level = true && that.isSetConsistency_level();
      if (this_present_consistency_level || that_present_consistency_level) {
        if (!(this_present_consistency_level && that_present_consistency_level))
          return false;
        if (!this.consistency_level.equals(that.consistency_level))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_column_family = true && (isSetColumn_family());
      builder.append(present_column_family);
      if (present_column_family)
        builder.append(column_family);

      boolean present_range = true && (isSetRange());
      builder.append(present_range);
      if (present_range)
        builder.append(range);

      boolean present_start_column = true && (isSetStart_column());
      builder.append(present_start_column);
      if (present_start_column)
        builder.append(start_column);

      boolean present_consistency_level = true && (isSetConsistency_level());
      builder.append(present_consistency_level);
      if (present_consistency_level)
        builder.append(consistency_level.getValue());

      return builder.toHashCode();
    }

    public int compareTo(get_paged_slice_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_paged_slice_args typedOther = (get_paged_slice_args)other;

      lastComparison = Boolean.valueOf(isSetColumn_family()).compareTo(typedOther.isSetColumn_family());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn_family()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column_family, typedOther.column_family);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRange()).compareTo(typedOther.isSetRange());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRange()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.range, typedOther.range);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetStart_column()).compareTo(typedOther.isSetStart_column());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetStart_column()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.start_column, typedOther.start_column);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConsistency_level()).compareTo(typedOther.isSetConsistency_level());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConsistency_level()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.consistency_level, typedOther.consistency_level);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // COLUMN_FAMILY
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.column_family = iprot.readString();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // RANGE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.range = new KeyRange();
              this.range.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // START_COLUMN
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.start_column = iprot.readBinary();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4: // CONSISTENCY_LEVEL
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.column_family != null) {
        oprot.writeFieldBegin(COLUMN_FAMILY_FIELD_DESC);
        oprot.writeString(this.column_family);
        oprot.writeFieldEnd();
      }
      if (this.range != null) {
        oprot.writeFieldBegin(RANGE_FIELD_DESC);
        this.range.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.start_column != null) {
        oprot.writeFieldBegin(START_COLUMN_FIELD_DESC);
        oprot.writeBinary(this.start_column);
        oprot.writeFieldEnd();
      }
      if (this.consistency_level != null) {
        oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
        oprot.writeI32(this.consistency_level.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_paged_slice_args(");
      boolean first = true;

      sb.append("column_family:");
      if (this.column_family == null) {
        sb.append("null");
      } else {
        sb.append(this.column_family);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("range:");
      if (this.range == null) {
        sb.append("null");
      } else {
        sb.append(this.range);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("start_column:");
      if (this.start_column == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.start_column, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("consistency_level:");
      if (this.consistency_level == null) {
        sb.append("null");
      } else {
        sb.append(this.consistency_level);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (column_family == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'column_family' was not present! Struct: " + toString());
      }
      if (range == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'range' was not present! Struct: " + toString());
      }
      if (start_column == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'start_column' was not present! Struct: " + toString());
      }
      if (consistency_level == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'consistency_level' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_paged_slice_result implements org.apache.thrift.TBase<get_paged_slice_result, get_paged_slice_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_paged_slice_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    public List<KeySlice> success; // required
    public InvalidRequestException ire; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IRE((short)1, "ire"),
      UE((short)2, "ue"),
      TE((short)3, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IRE
            return IRE;
          case 2: // UE
            return UE;
          case 3: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST,
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, KeySlice.class))));
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_paged_slice_result.class, metaDataMap);
    }

    public get_paged_slice_result() {
    }

    public get_paged_slice_result(
      List<KeySlice> success,
      InvalidRequestException ire,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.success = success;
      this.ire = ire;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_paged_slice_result(get_paged_slice_result other) {
      if (other.isSetSuccess()) {
        List<KeySlice> __this__success = new ArrayList<KeySlice>();
        for (KeySlice other_element : other.success) {
          __this__success.add(new KeySlice(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public get_paged_slice_result deepCopy() {
      return new get_paged_slice_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.ire = null;
      this.ue = null;
      this.te = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<KeySlice> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(KeySlice elem) {
      if (this.success == null) {
        this.success = new ArrayList<KeySlice>();
      }
      this.success.add(elem);
    }

    public List<KeySlice> getSuccess() {
      return this.success;
    }

    public get_paged_slice_result setSuccess(List<KeySlice> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public get_paged_slice_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public get_paged_slice_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public get_paged_slice_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<KeySlice>)value);
        }
        break;

      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IRE:
        return getIre();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IRE:
        return isSetIre();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_paged_slice_result)
        return this.equals((get_paged_slice_result)that);
      return false;
    }

    public boolean equals(get_paged_slice_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(get_paged_slice_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_paged_slice_result typedOther = (get_paged_slice_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list125 = iprot.readListBegin();
                this.success = new ArrayList<KeySlice>(_list125.size);
                for (int _i126 = 0; _i126 < _list125.size; ++_i126)
                {
                  KeySlice _elem127; // required
                  _elem127 = new KeySlice();
                  _elem127.read(iprot);
                  this.success.add(_elem127);
                }
                iprot.readListEnd();
              }
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        {
          oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, this.success.size()));
          for (KeySlice _iter128 : this.success)
          {
            _iter128.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      } else if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_paged_slice_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_indexed_slices_args implements org.apache.thrift.TBase<get_indexed_slices_args, get_indexed_slices_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_indexed_slices_args");

    private static final org.apache.thrift.protocol.TField COLUMN_PARENT_FIELD_DESC = new org.apache.thrift.protocol.TField("column_parent", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField INDEX_CLAUSE_FIELD_DESC = new org.apache.thrift.protocol.TField("index_clause", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMN_PREDICATE_FIELD_DESC = new org.apache.thrift.protocol.TField("column_predicate", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField CONSISTENCY_LEVEL_FIELD_DESC = new org.apache.thrift.protocol.TField("consistency_level", org.apache.thrift.protocol.TType.I32, (short)4);

    public ColumnParent column_parent; // required
    public IndexClause index_clause; // required
    public SlicePredicate column_predicate; // required
    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistency_level; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      COLUMN_PARENT((short)1, "column_parent"),
      INDEX_CLAUSE((short)2, "index_clause"),
      COLUMN_PREDICATE((short)3, "column_predicate"),
      /**
       *
       * @see ConsistencyLevel
       */
      CONSISTENCY_LEVEL((short)4, "consistency_level");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // COLUMN_PARENT
            return COLUMN_PARENT;
          case 2: // INDEX_CLAUSE
            return INDEX_CLAUSE;
          case 3: // COLUMN_PREDICATE
            return COLUMN_PREDICATE;
          case 4: // CONSISTENCY_LEVEL
            return CONSISTENCY_LEVEL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.COLUMN_PARENT, new org.apache.thrift.meta_data.FieldMetaData("column_parent", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnParent.class)));
      tmpMap.put(_Fields.INDEX_CLAUSE, new org.apache.thrift.meta_data.FieldMetaData("index_clause", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IndexClause.class)));
      tmpMap.put(_Fields.COLUMN_PREDICATE, new org.apache.thrift.meta_data.FieldMetaData("column_predicate", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, SlicePredicate.class)));
      tmpMap.put(_Fields.CONSISTENCY_LEVEL, new org.apache.thrift.meta_data.FieldMetaData("consistency_level", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ConsistencyLevel.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_indexed_slices_args.class, metaDataMap);
    }

    public get_indexed_slices_args() {
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public get_indexed_slices_args(
      ColumnParent column_parent,
      IndexClause index_clause,
      SlicePredicate column_predicate,
      ConsistencyLevel consistency_level)
    {
      this();
      this.column_parent = column_parent;
      this.index_clause = index_clause;
      this.column_predicate = column_predicate;
      this.consistency_level = consistency_level;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_indexed_slices_args(get_indexed_slices_args other) {
      if (other.isSetColumn_parent()) {
        this.column_parent = new ColumnParent(other.column_parent);
      }
      if (other.isSetIndex_clause()) {
        this.index_clause = new IndexClause(other.index_clause);
      }
      if (other.isSetColumn_predicate()) {
        this.column_predicate = new SlicePredicate(other.column_predicate);
      }
      if (other.isSetConsistency_level()) {
        this.consistency_level = other.consistency_level;
      }
    }

    public get_indexed_slices_args deepCopy() {
      return new get_indexed_slices_args(this);
    }

    @Override
    public void clear() {
      this.column_parent = null;
      this.index_clause = null;
      this.column_predicate = null;
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public ColumnParent getColumn_parent() {
      return this.column_parent;
    }

    public get_indexed_slices_args setColumn_parent(ColumnParent column_parent) {
      this.column_parent = column_parent;
      return this;
    }

    public void unsetColumn_parent() {
      this.column_parent = null;
    }

    /** Returns true if field column_parent is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn_parent() {
      return this.column_parent != null;
    }

    public void setColumn_parentIsSet(boolean value) {
      if (!value) {
        this.column_parent = null;
      }
    }

    public IndexClause getIndex_clause() {
      return this.index_clause;
    }

    public get_indexed_slices_args setIndex_clause(IndexClause index_clause) {
      this.index_clause = index_clause;
      return this;
    }

    public void unsetIndex_clause() {
      this.index_clause = null;
    }

    /** Returns true if field index_clause is set (has been assigned a value) and false otherwise */
    public boolean isSetIndex_clause() {
      return this.index_clause != null;
    }

    public void setIndex_clauseIsSet(boolean value) {
      if (!value) {
        this.index_clause = null;
      }
    }

    public SlicePredicate getColumn_predicate() {
      return this.column_predicate;
    }

    public get_indexed_slices_args setColumn_predicate(SlicePredicate column_predicate) {
      this.column_predicate = column_predicate;
      return this;
    }

    public void unsetColumn_predicate() {
      this.column_predicate = null;
    }

    /** Returns true if field column_predicate is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn_predicate() {
      return this.column_predicate != null;
    }

    public void setColumn_predicateIsSet(boolean value) {
      if (!value) {
        this.column_predicate = null;
      }
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel getConsistency_level() {
      return this.consistency_level;
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public get_indexed_slices_args setConsistency_level(ConsistencyLevel consistency_level) {
      this.consistency_level = consistency_level;
      return this;
    }

    public void unsetConsistency_level() {
      this.consistency_level = null;
    }

    /** Returns true if field consistency_level is set (has been assigned a value) and false otherwise */
    public boolean isSetConsistency_level() {
      return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
      if (!value) {
        this.consistency_level = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case COLUMN_PARENT:
        if (value == null) {
          unsetColumn_parent();
        } else {
          setColumn_parent((ColumnParent)value);
        }
        break;

      case INDEX_CLAUSE:
        if (value == null) {
          unsetIndex_clause();
        } else {
          setIndex_clause((IndexClause)value);
        }
        break;

      case COLUMN_PREDICATE:
        if (value == null) {
          unsetColumn_predicate();
        } else {
          setColumn_predicate((SlicePredicate)value);
        }
        break;

      case CONSISTENCY_LEVEL:
        if (value == null) {
          unsetConsistency_level();
        } else {
          setConsistency_level((ConsistencyLevel)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case COLUMN_PARENT:
        return getColumn_parent();

      case INDEX_CLAUSE:
        return getIndex_clause();

      case COLUMN_PREDICATE:
        return getColumn_predicate();

      case CONSISTENCY_LEVEL:
        return getConsistency_level();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case COLUMN_PARENT:
        return isSetColumn_parent();
      case INDEX_CLAUSE:
        return isSetIndex_clause();
      case COLUMN_PREDICATE:
        return isSetColumn_predicate();
      case CONSISTENCY_LEVEL:
        return isSetConsistency_level();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_indexed_slices_args)
        return this.equals((get_indexed_slices_args)that);
      return false;
    }

    public boolean equals(get_indexed_slices_args that) {
      if (that == null)
        return false;

      boolean this_present_column_parent = true && this.isSetColumn_parent();
      boolean that_present_column_parent = true && that.isSetColumn_parent();
      if (this_present_column_parent || that_present_column_parent) {
        if (!(this_present_column_parent && that_present_column_parent))
          return false;
        if (!this.column_parent.equals(that.column_parent))
          return false;
      }

      boolean this_present_index_clause = true && this.isSetIndex_clause();
      boolean that_present_index_clause = true && that.isSetIndex_clause();
      if (this_present_index_clause || that_present_index_clause) {
        if (!(this_present_index_clause && that_present_index_clause))
          return false;
        if (!this.index_clause.equals(that.index_clause))
          return false;
      }

      boolean this_present_column_predicate = true && this.isSetColumn_predicate();
      boolean that_present_column_predicate = true && that.isSetColumn_predicate();
      if (this_present_column_predicate || that_present_column_predicate) {
        if (!(this_present_column_predicate && that_present_column_predicate))
          return false;
        if (!this.column_predicate.equals(that.column_predicate))
          return false;
      }

      boolean this_present_consistency_level = true && this.isSetConsistency_level();
      boolean that_present_consistency_level = true && that.isSetConsistency_level();
      if (this_present_consistency_level || that_present_consistency_level) {
        if (!(this_present_consistency_level && that_present_consistency_level))
          return false;
        if (!this.consistency_level.equals(that.consistency_level))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_column_parent = true && (isSetColumn_parent());
      builder.append(present_column_parent);
      if (present_column_parent)
        builder.append(column_parent);

      boolean present_index_clause = true && (isSetIndex_clause());
      builder.append(present_index_clause);
      if (present_index_clause)
        builder.append(index_clause);

      boolean present_column_predicate = true && (isSetColumn_predicate());
      builder.append(present_column_predicate);
      if (present_column_predicate)
        builder.append(column_predicate);

      boolean present_consistency_level = true && (isSetConsistency_level());
      builder.append(present_consistency_level);
      if (present_consistency_level)
        builder.append(consistency_level.getValue());

      return builder.toHashCode();
    }

    public int compareTo(get_indexed_slices_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_indexed_slices_args typedOther = (get_indexed_slices_args)other;

      lastComparison = Boolean.valueOf(isSetColumn_parent()).compareTo(typedOther.isSetColumn_parent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn_parent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column_parent, typedOther.column_parent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIndex_clause()).compareTo(typedOther.isSetIndex_clause());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIndex_clause()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.index_clause, typedOther.index_clause);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumn_predicate()).compareTo(typedOther.isSetColumn_predicate());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn_predicate()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column_predicate, typedOther.column_predicate);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConsistency_level()).compareTo(typedOther.isSetConsistency_level());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConsistency_level()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.consistency_level, typedOther.consistency_level);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // COLUMN_PARENT
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.column_parent = new ColumnParent();
              this.column_parent.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // INDEX_CLAUSE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.index_clause = new IndexClause();
              this.index_clause.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // COLUMN_PREDICATE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.column_predicate = new SlicePredicate();
              this.column_predicate.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4: // CONSISTENCY_LEVEL
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.column_parent != null) {
        oprot.writeFieldBegin(COLUMN_PARENT_FIELD_DESC);
        this.column_parent.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.index_clause != null) {
        oprot.writeFieldBegin(INDEX_CLAUSE_FIELD_DESC);
        this.index_clause.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.column_predicate != null) {
        oprot.writeFieldBegin(COLUMN_PREDICATE_FIELD_DESC);
        this.column_predicate.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.consistency_level != null) {
        oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
        oprot.writeI32(this.consistency_level.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_indexed_slices_args(");
      boolean first = true;

      sb.append("column_parent:");
      if (this.column_parent == null) {
        sb.append("null");
      } else {
        sb.append(this.column_parent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("index_clause:");
      if (this.index_clause == null) {
        sb.append("null");
      } else {
        sb.append(this.index_clause);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column_predicate:");
      if (this.column_predicate == null) {
        sb.append("null");
      } else {
        sb.append(this.column_predicate);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("consistency_level:");
      if (this.consistency_level == null) {
        sb.append("null");
      } else {
        sb.append(this.consistency_level);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (column_parent == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'column_parent' was not present! Struct: " + toString());
      }
      if (index_clause == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'index_clause' was not present! Struct: " + toString());
      }
      if (column_predicate == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'column_predicate' was not present! Struct: " + toString());
      }
      if (consistency_level == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'consistency_level' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_indexed_slices_result implements org.apache.thrift.TBase<get_indexed_slices_result, get_indexed_slices_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_indexed_slices_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    public List<KeySlice> success; // required
    public InvalidRequestException ire; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IRE((short)1, "ire"),
      UE((short)2, "ue"),
      TE((short)3, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IRE
            return IRE;
          case 2: // UE
            return UE;
          case 3: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST,
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, KeySlice.class))));
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_indexed_slices_result.class, metaDataMap);
    }

    public get_indexed_slices_result() {
    }

    public get_indexed_slices_result(
      List<KeySlice> success,
      InvalidRequestException ire,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.success = success;
      this.ire = ire;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_indexed_slices_result(get_indexed_slices_result other) {
      if (other.isSetSuccess()) {
        List<KeySlice> __this__success = new ArrayList<KeySlice>();
        for (KeySlice other_element : other.success) {
          __this__success.add(new KeySlice(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public get_indexed_slices_result deepCopy() {
      return new get_indexed_slices_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.ire = null;
      this.ue = null;
      this.te = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<KeySlice> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(KeySlice elem) {
      if (this.success == null) {
        this.success = new ArrayList<KeySlice>();
      }
      this.success.add(elem);
    }

    public List<KeySlice> getSuccess() {
      return this.success;
    }

    public get_indexed_slices_result setSuccess(List<KeySlice> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public get_indexed_slices_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public get_indexed_slices_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public get_indexed_slices_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<KeySlice>)value);
        }
        break;

      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IRE:
        return getIre();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IRE:
        return isSetIre();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_indexed_slices_result)
        return this.equals((get_indexed_slices_result)that);
      return false;
    }

    public boolean equals(get_indexed_slices_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(get_indexed_slices_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_indexed_slices_result typedOther = (get_indexed_slices_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list129 = iprot.readListBegin();
                this.success = new ArrayList<KeySlice>(_list129.size);
                for (int _i130 = 0; _i130 < _list129.size; ++_i130)
                {
                  KeySlice _elem131; // required
                  _elem131 = new KeySlice();
                  _elem131.read(iprot);
                  this.success.add(_elem131);
                }
                iprot.readListEnd();
              }
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        {
          oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, this.success.size()));
          for (KeySlice _iter132 : this.success)
          {
            _iter132.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      } else if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_indexed_slices_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class insert_args implements org.apache.thrift.TBase<insert_args, insert_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("insert_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField COLUMN_PARENT_FIELD_DESC = new org.apache.thrift.protocol.TField("column_parent", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMN_FIELD_DESC = new org.apache.thrift.protocol.TField("column", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField CONSISTENCY_LEVEL_FIELD_DESC = new org.apache.thrift.protocol.TField("consistency_level", org.apache.thrift.protocol.TType.I32, (short)4);

    public ByteBuffer key; // required
    public ColumnParent column_parent; // required
    public Column column; // required
    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistency_level; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key"),
      COLUMN_PARENT((short)2, "column_parent"),
      COLUMN((short)3, "column"),
      /**
       *
       * @see ConsistencyLevel
       */
      CONSISTENCY_LEVEL((short)4, "consistency_level");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          case 2: // COLUMN_PARENT
            return COLUMN_PARENT;
          case 3: // COLUMN
            return COLUMN;
          case 4: // CONSISTENCY_LEVEL
            return CONSISTENCY_LEVEL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.COLUMN_PARENT, new org.apache.thrift.meta_data.FieldMetaData("column_parent", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnParent.class)));
      tmpMap.put(_Fields.COLUMN, new org.apache.thrift.meta_data.FieldMetaData("column", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Column.class)));
      tmpMap.put(_Fields.CONSISTENCY_LEVEL, new org.apache.thrift.meta_data.FieldMetaData("consistency_level", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ConsistencyLevel.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(insert_args.class, metaDataMap);
    }

    public insert_args() {
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public insert_args(
      ByteBuffer key,
      ColumnParent column_parent,
      Column column,
      ConsistencyLevel consistency_level)
    {
      this();
      this.key = key;
      this.column_parent = column_parent;
      this.column = column;
      this.consistency_level = consistency_level;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public insert_args(insert_args other) {
      if (other.isSetKey()) {
        this.key = org.apache.thrift.TBaseHelper.copyBinary(other.key);
;
      }
      if (other.isSetColumn_parent()) {
        this.column_parent = new ColumnParent(other.column_parent);
      }
      if (other.isSetColumn()) {
        this.column = new Column(other.column);
      }
      if (other.isSetConsistency_level()) {
        this.consistency_level = other.consistency_level;
      }
    }

    public insert_args deepCopy() {
      return new insert_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
      this.column_parent = null;
      this.column = null;
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public byte[] getKey() {
      setKey(org.apache.thrift.TBaseHelper.rightSize(key));
      return key == null ? null : key.array();
    }

    public ByteBuffer bufferForKey() {
      return key;
    }

    public insert_args setKey(byte[] key) {
      setKey(key == null ? (ByteBuffer)null : ByteBuffer.wrap(key));
      return this;
    }

    public insert_args setKey(ByteBuffer key) {
      this.key = key;
      return this;
    }

    public void unsetKey() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean isSetKey() {
      return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public ColumnParent getColumn_parent() {
      return this.column_parent;
    }

    public insert_args setColumn_parent(ColumnParent column_parent) {
      this.column_parent = column_parent;
      return this;
    }

    public void unsetColumn_parent() {
      this.column_parent = null;
    }

    /** Returns true if field column_parent is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn_parent() {
      return this.column_parent != null;
    }

    public void setColumn_parentIsSet(boolean value) {
      if (!value) {
        this.column_parent = null;
      }
    }

    public Column getColumn() {
      return this.column;
    }

    public insert_args setColumn(Column column) {
      this.column = column;
      return this;
    }

    public void unsetColumn() {
      this.column = null;
    }

    /** Returns true if field column is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn() {
      return this.column != null;
    }

    public void setColumnIsSet(boolean value) {
      if (!value) {
        this.column = null;
      }
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel getConsistency_level() {
      return this.consistency_level;
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public insert_args setConsistency_level(ConsistencyLevel consistency_level) {
      this.consistency_level = consistency_level;
      return this;
    }

    public void unsetConsistency_level() {
      this.consistency_level = null;
    }

    /** Returns true if field consistency_level is set (has been assigned a value) and false otherwise */
    public boolean isSetConsistency_level() {
      return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
      if (!value) {
        this.consistency_level = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unsetKey();
        } else {
          setKey((ByteBuffer)value);
        }
        break;

      case COLUMN_PARENT:
        if (value == null) {
          unsetColumn_parent();
        } else {
          setColumn_parent((ColumnParent)value);
        }
        break;

      case COLUMN:
        if (value == null) {
          unsetColumn();
        } else {
          setColumn((Column)value);
        }
        break;

      case CONSISTENCY_LEVEL:
        if (value == null) {
          unsetConsistency_level();
        } else {
          setConsistency_level((ConsistencyLevel)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return getKey();

      case COLUMN_PARENT:
        return getColumn_parent();

      case COLUMN:
        return getColumn();

      case CONSISTENCY_LEVEL:
        return getConsistency_level();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return isSetKey();
      case COLUMN_PARENT:
        return isSetColumn_parent();
      case COLUMN:
        return isSetColumn();
      case CONSISTENCY_LEVEL:
        return isSetConsistency_level();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof insert_args)
        return this.equals((insert_args)that);
      return false;
    }

    public boolean equals(insert_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.isSetKey();
      boolean that_present_key = true && that.isSetKey();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      boolean this_present_column_parent = true && this.isSetColumn_parent();
      boolean that_present_column_parent = true && that.isSetColumn_parent();
      if (this_present_column_parent || that_present_column_parent) {
        if (!(this_present_column_parent && that_present_column_parent))
          return false;
        if (!this.column_parent.equals(that.column_parent))
          return false;
      }

      boolean this_present_column = true && this.isSetColumn();
      boolean that_present_column = true && that.isSetColumn();
      if (this_present_column || that_present_column) {
        if (!(this_present_column && that_present_column))
          return false;
        if (!this.column.equals(that.column))
          return false;
      }

      boolean this_present_consistency_level = true && this.isSetConsistency_level();
      boolean that_present_consistency_level = true && that.isSetConsistency_level();
      if (this_present_consistency_level || that_present_consistency_level) {
        if (!(this_present_consistency_level && that_present_consistency_level))
          return false;
        if (!this.consistency_level.equals(that.consistency_level))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_key = true && (isSetKey());
      builder.append(present_key);
      if (present_key)
        builder.append(key);

      boolean present_column_parent = true && (isSetColumn_parent());
      builder.append(present_column_parent);
      if (present_column_parent)
        builder.append(column_parent);

      boolean present_column = true && (isSetColumn());
      builder.append(present_column);
      if (present_column)
        builder.append(column);

      boolean present_consistency_level = true && (isSetConsistency_level());
      builder.append(present_consistency_level);
      if (present_consistency_level)
        builder.append(consistency_level.getValue());

      return builder.toHashCode();
    }

    public int compareTo(insert_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      insert_args typedOther = (insert_args)other;

      lastComparison = Boolean.valueOf(isSetKey()).compareTo(typedOther.isSetKey());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKey()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, typedOther.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumn_parent()).compareTo(typedOther.isSetColumn_parent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn_parent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column_parent, typedOther.column_parent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumn()).compareTo(typedOther.isSetColumn());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column, typedOther.column);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConsistency_level()).compareTo(typedOther.isSetConsistency_level());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConsistency_level()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.consistency_level, typedOther.consistency_level);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // KEY
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.key = iprot.readBinary();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // COLUMN_PARENT
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.column_parent = new ColumnParent();
              this.column_parent.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // COLUMN
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.column = new Column();
              this.column.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4: // CONSISTENCY_LEVEL
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.key != null) {
        oprot.writeFieldBegin(KEY_FIELD_DESC);
        oprot.writeBinary(this.key);
        oprot.writeFieldEnd();
      }
      if (this.column_parent != null) {
        oprot.writeFieldBegin(COLUMN_PARENT_FIELD_DESC);
        this.column_parent.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.column != null) {
        oprot.writeFieldBegin(COLUMN_FIELD_DESC);
        this.column.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.consistency_level != null) {
        oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
        oprot.writeI32(this.consistency_level.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("insert_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.key, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column_parent:");
      if (this.column_parent == null) {
        sb.append("null");
      } else {
        sb.append(this.column_parent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column:");
      if (this.column == null) {
        sb.append("null");
      } else {
        sb.append(this.column);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("consistency_level:");
      if (this.consistency_level == null) {
        sb.append("null");
      } else {
        sb.append(this.consistency_level);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (key == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'key' was not present! Struct: " + toString());
      }
      if (column_parent == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'column_parent' was not present! Struct: " + toString());
      }
      if (column == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'column' was not present! Struct: " + toString());
      }
      if (consistency_level == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'consistency_level' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class insert_result implements org.apache.thrift.TBase<insert_result, insert_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("insert_result");

    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    public InvalidRequestException ire; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IRE((short)1, "ire"),
      UE((short)2, "ue"),
      TE((short)3, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IRE
            return IRE;
          case 2: // UE
            return UE;
          case 3: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(insert_result.class, metaDataMap);
    }

    public insert_result() {
    }

    public insert_result(
      InvalidRequestException ire,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.ire = ire;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public insert_result(insert_result other) {
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public insert_result deepCopy() {
      return new insert_result(this);
    }

    @Override
    public void clear() {
      this.ire = null;
      this.ue = null;
      this.te = null;
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public insert_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public insert_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public insert_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case IRE:
        return getIre();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case IRE:
        return isSetIre();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof insert_result)
        return this.equals((insert_result)that);
      return false;
    }

    public boolean equals(insert_result that) {
      if (that == null)
        return false;

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(insert_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      insert_result typedOther = (insert_result)other;

      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("insert_result(");
      boolean first = true;

      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class add_args implements org.apache.thrift.TBase<add_args, add_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("add_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField COLUMN_PARENT_FIELD_DESC = new org.apache.thrift.protocol.TField("column_parent", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMN_FIELD_DESC = new org.apache.thrift.protocol.TField("column", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField CONSISTENCY_LEVEL_FIELD_DESC = new org.apache.thrift.protocol.TField("consistency_level", org.apache.thrift.protocol.TType.I32, (short)4);

    public ByteBuffer key; // required
    public ColumnParent column_parent; // required
    public CounterColumn column; // required
    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistency_level; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key"),
      COLUMN_PARENT((short)2, "column_parent"),
      COLUMN((short)3, "column"),
      /**
       *
       * @see ConsistencyLevel
       */
      CONSISTENCY_LEVEL((short)4, "consistency_level");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          case 2: // COLUMN_PARENT
            return COLUMN_PARENT;
          case 3: // COLUMN
            return COLUMN;
          case 4: // CONSISTENCY_LEVEL
            return CONSISTENCY_LEVEL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.COLUMN_PARENT, new org.apache.thrift.meta_data.FieldMetaData("column_parent", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnParent.class)));
      tmpMap.put(_Fields.COLUMN, new org.apache.thrift.meta_data.FieldMetaData("column", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, CounterColumn.class)));
      tmpMap.put(_Fields.CONSISTENCY_LEVEL, new org.apache.thrift.meta_data.FieldMetaData("consistency_level", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ConsistencyLevel.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(add_args.class, metaDataMap);
    }

    public add_args() {
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public add_args(
      ByteBuffer key,
      ColumnParent column_parent,
      CounterColumn column,
      ConsistencyLevel consistency_level)
    {
      this();
      this.key = key;
      this.column_parent = column_parent;
      this.column = column;
      this.consistency_level = consistency_level;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public add_args(add_args other) {
      if (other.isSetKey()) {
        this.key = org.apache.thrift.TBaseHelper.copyBinary(other.key);
;
      }
      if (other.isSetColumn_parent()) {
        this.column_parent = new ColumnParent(other.column_parent);
      }
      if (other.isSetColumn()) {
        this.column = new CounterColumn(other.column);
      }
      if (other.isSetConsistency_level()) {
        this.consistency_level = other.consistency_level;
      }
    }

    public add_args deepCopy() {
      return new add_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
      this.column_parent = null;
      this.column = null;
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public byte[] getKey() {
      setKey(org.apache.thrift.TBaseHelper.rightSize(key));
      return key == null ? null : key.array();
    }

    public ByteBuffer bufferForKey() {
      return key;
    }

    public add_args setKey(byte[] key) {
      setKey(key == null ? (ByteBuffer)null : ByteBuffer.wrap(key));
      return this;
    }

    public add_args setKey(ByteBuffer key) {
      this.key = key;
      return this;
    }

    public void unsetKey() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean isSetKey() {
      return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public ColumnParent getColumn_parent() {
      return this.column_parent;
    }

    public add_args setColumn_parent(ColumnParent column_parent) {
      this.column_parent = column_parent;
      return this;
    }

    public void unsetColumn_parent() {
      this.column_parent = null;
    }

    /** Returns true if field column_parent is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn_parent() {
      return this.column_parent != null;
    }

    public void setColumn_parentIsSet(boolean value) {
      if (!value) {
        this.column_parent = null;
      }
    }

    public CounterColumn getColumn() {
      return this.column;
    }

    public add_args setColumn(CounterColumn column) {
      this.column = column;
      return this;
    }

    public void unsetColumn() {
      this.column = null;
    }

    /** Returns true if field column is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn() {
      return this.column != null;
    }

    public void setColumnIsSet(boolean value) {
      if (!value) {
        this.column = null;
      }
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel getConsistency_level() {
      return this.consistency_level;
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public add_args setConsistency_level(ConsistencyLevel consistency_level) {
      this.consistency_level = consistency_level;
      return this;
    }

    public void unsetConsistency_level() {
      this.consistency_level = null;
    }

    /** Returns true if field consistency_level is set (has been assigned a value) and false otherwise */
    public boolean isSetConsistency_level() {
      return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
      if (!value) {
        this.consistency_level = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unsetKey();
        } else {
          setKey((ByteBuffer)value);
        }
        break;

      case COLUMN_PARENT:
        if (value == null) {
          unsetColumn_parent();
        } else {
          setColumn_parent((ColumnParent)value);
        }
        break;

      case COLUMN:
        if (value == null) {
          unsetColumn();
        } else {
          setColumn((CounterColumn)value);
        }
        break;

      case CONSISTENCY_LEVEL:
        if (value == null) {
          unsetConsistency_level();
        } else {
          setConsistency_level((ConsistencyLevel)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return getKey();

      case COLUMN_PARENT:
        return getColumn_parent();

      case COLUMN:
        return getColumn();

      case CONSISTENCY_LEVEL:
        return getConsistency_level();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return isSetKey();
      case COLUMN_PARENT:
        return isSetColumn_parent();
      case COLUMN:
        return isSetColumn();
      case CONSISTENCY_LEVEL:
        return isSetConsistency_level();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof add_args)
        return this.equals((add_args)that);
      return false;
    }

    public boolean equals(add_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.isSetKey();
      boolean that_present_key = true && that.isSetKey();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      boolean this_present_column_parent = true && this.isSetColumn_parent();
      boolean that_present_column_parent = true && that.isSetColumn_parent();
      if (this_present_column_parent || that_present_column_parent) {
        if (!(this_present_column_parent && that_present_column_parent))
          return false;
        if (!this.column_parent.equals(that.column_parent))
          return false;
      }

      boolean this_present_column = true && this.isSetColumn();
      boolean that_present_column = true && that.isSetColumn();
      if (this_present_column || that_present_column) {
        if (!(this_present_column && that_present_column))
          return false;
        if (!this.column.equals(that.column))
          return false;
      }

      boolean this_present_consistency_level = true && this.isSetConsistency_level();
      boolean that_present_consistency_level = true && that.isSetConsistency_level();
      if (this_present_consistency_level || that_present_consistency_level) {
        if (!(this_present_consistency_level && that_present_consistency_level))
          return false;
        if (!this.consistency_level.equals(that.consistency_level))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_key = true && (isSetKey());
      builder.append(present_key);
      if (present_key)
        builder.append(key);

      boolean present_column_parent = true && (isSetColumn_parent());
      builder.append(present_column_parent);
      if (present_column_parent)
        builder.append(column_parent);

      boolean present_column = true && (isSetColumn());
      builder.append(present_column);
      if (present_column)
        builder.append(column);

      boolean present_consistency_level = true && (isSetConsistency_level());
      builder.append(present_consistency_level);
      if (present_consistency_level)
        builder.append(consistency_level.getValue());

      return builder.toHashCode();
    }

    public int compareTo(add_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      add_args typedOther = (add_args)other;

      lastComparison = Boolean.valueOf(isSetKey()).compareTo(typedOther.isSetKey());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKey()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, typedOther.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumn_parent()).compareTo(typedOther.isSetColumn_parent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn_parent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column_parent, typedOther.column_parent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumn()).compareTo(typedOther.isSetColumn());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column, typedOther.column);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConsistency_level()).compareTo(typedOther.isSetConsistency_level());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConsistency_level()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.consistency_level, typedOther.consistency_level);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // KEY
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.key = iprot.readBinary();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // COLUMN_PARENT
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.column_parent = new ColumnParent();
              this.column_parent.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // COLUMN
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.column = new CounterColumn();
              this.column.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4: // CONSISTENCY_LEVEL
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.key != null) {
        oprot.writeFieldBegin(KEY_FIELD_DESC);
        oprot.writeBinary(this.key);
        oprot.writeFieldEnd();
      }
      if (this.column_parent != null) {
        oprot.writeFieldBegin(COLUMN_PARENT_FIELD_DESC);
        this.column_parent.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.column != null) {
        oprot.writeFieldBegin(COLUMN_FIELD_DESC);
        this.column.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.consistency_level != null) {
        oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
        oprot.writeI32(this.consistency_level.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("add_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.key, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column_parent:");
      if (this.column_parent == null) {
        sb.append("null");
      } else {
        sb.append(this.column_parent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column:");
      if (this.column == null) {
        sb.append("null");
      } else {
        sb.append(this.column);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("consistency_level:");
      if (this.consistency_level == null) {
        sb.append("null");
      } else {
        sb.append(this.consistency_level);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (key == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'key' was not present! Struct: " + toString());
      }
      if (column_parent == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'column_parent' was not present! Struct: " + toString());
      }
      if (column == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'column' was not present! Struct: " + toString());
      }
      if (consistency_level == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'consistency_level' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class add_result implements org.apache.thrift.TBase<add_result, add_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("add_result");

    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    public InvalidRequestException ire; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IRE((short)1, "ire"),
      UE((short)2, "ue"),
      TE((short)3, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IRE
            return IRE;
          case 2: // UE
            return UE;
          case 3: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(add_result.class, metaDataMap);
    }

    public add_result() {
    }

    public add_result(
      InvalidRequestException ire,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.ire = ire;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public add_result(add_result other) {
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public add_result deepCopy() {
      return new add_result(this);
    }

    @Override
    public void clear() {
      this.ire = null;
      this.ue = null;
      this.te = null;
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public add_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public add_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public add_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case IRE:
        return getIre();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case IRE:
        return isSetIre();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof add_result)
        return this.equals((add_result)that);
      return false;
    }

    public boolean equals(add_result that) {
      if (that == null)
        return false;

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(add_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      add_result typedOther = (add_result)other;

      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("add_result(");
      boolean first = true;

      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class remove_args implements org.apache.thrift.TBase<remove_args, remove_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("remove_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField COLUMN_PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("column_path", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TIMESTAMP_FIELD_DESC = new org.apache.thrift.protocol.TField("timestamp", org.apache.thrift.protocol.TType.I64, (short)3);
    private static final org.apache.thrift.protocol.TField CONSISTENCY_LEVEL_FIELD_DESC = new org.apache.thrift.protocol.TField("consistency_level", org.apache.thrift.protocol.TType.I32, (short)4);

    public ByteBuffer key; // required
    public ColumnPath column_path; // required
    public long timestamp; // required
    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistency_level; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key"),
      COLUMN_PATH((short)2, "column_path"),
      TIMESTAMP((short)3, "timestamp"),
      /**
       *
       * @see ConsistencyLevel
       */
      CONSISTENCY_LEVEL((short)4, "consistency_level");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          case 2: // COLUMN_PATH
            return COLUMN_PATH;
          case 3: // TIMESTAMP
            return TIMESTAMP;
          case 4: // CONSISTENCY_LEVEL
            return CONSISTENCY_LEVEL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TIMESTAMP_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.COLUMN_PATH, new org.apache.thrift.meta_data.FieldMetaData("column_path", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnPath.class)));
      tmpMap.put(_Fields.TIMESTAMP, new org.apache.thrift.meta_data.FieldMetaData("timestamp", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.CONSISTENCY_LEVEL, new org.apache.thrift.meta_data.FieldMetaData("consistency_level", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ConsistencyLevel.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(remove_args.class, metaDataMap);
    }

    public remove_args() {
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public remove_args(
      ByteBuffer key,
      ColumnPath column_path,
      long timestamp,
      ConsistencyLevel consistency_level)
    {
      this();
      this.key = key;
      this.column_path = column_path;
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      this.consistency_level = consistency_level;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public remove_args(remove_args other) {
      __isset_bit_vector.clear();
      __isset_bit_vector.or(other.__isset_bit_vector);
      if (other.isSetKey()) {
        this.key = org.apache.thrift.TBaseHelper.copyBinary(other.key);
;
      }
      if (other.isSetColumn_path()) {
        this.column_path = new ColumnPath(other.column_path);
      }
      this.timestamp = other.timestamp;
      if (other.isSetConsistency_level()) {
        this.consistency_level = other.consistency_level;
      }
    }

    public remove_args deepCopy() {
      return new remove_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
      this.column_path = null;
      setTimestampIsSet(false);
      this.timestamp = 0;
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public byte[] getKey() {
      setKey(org.apache.thrift.TBaseHelper.rightSize(key));
      return key == null ? null : key.array();
    }

    public ByteBuffer bufferForKey() {
      return key;
    }

    public remove_args setKey(byte[] key) {
      setKey(key == null ? (ByteBuffer)null : ByteBuffer.wrap(key));
      return this;
    }

    public remove_args setKey(ByteBuffer key) {
      this.key = key;
      return this;
    }

    public void unsetKey() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean isSetKey() {
      return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public ColumnPath getColumn_path() {
      return this.column_path;
    }

    public remove_args setColumn_path(ColumnPath column_path) {
      this.column_path = column_path;
      return this;
    }

    public void unsetColumn_path() {
      this.column_path = null;
    }

    /** Returns true if field column_path is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn_path() {
      return this.column_path != null;
    }

    public void setColumn_pathIsSet(boolean value) {
      if (!value) {
        this.column_path = null;
      }
    }

    public long getTimestamp() {
      return this.timestamp;
    }

    public remove_args setTimestamp(long timestamp) {
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      return this;
    }

    public void unsetTimestamp() {
      __isset_bit_vector.clear(__TIMESTAMP_ISSET_ID);
    }

    /** Returns true if field timestamp is set (has been assigned a value) and false otherwise */
    public boolean isSetTimestamp() {
      return __isset_bit_vector.get(__TIMESTAMP_ISSET_ID);
    }

    public void setTimestampIsSet(boolean value) {
      __isset_bit_vector.set(__TIMESTAMP_ISSET_ID, value);
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel getConsistency_level() {
      return this.consistency_level;
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public remove_args setConsistency_level(ConsistencyLevel consistency_level) {
      this.consistency_level = consistency_level;
      return this;
    }

    public void unsetConsistency_level() {
      this.consistency_level = null;
    }

    /** Returns true if field consistency_level is set (has been assigned a value) and false otherwise */
    public boolean isSetConsistency_level() {
      return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
      if (!value) {
        this.consistency_level = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unsetKey();
        } else {
          setKey((ByteBuffer)value);
        }
        break;

      case COLUMN_PATH:
        if (value == null) {
          unsetColumn_path();
        } else {
          setColumn_path((ColumnPath)value);
        }
        break;

      case TIMESTAMP:
        if (value == null) {
          unsetTimestamp();
        } else {
          setTimestamp((Long)value);
        }
        break;

      case CONSISTENCY_LEVEL:
        if (value == null) {
          unsetConsistency_level();
        } else {
          setConsistency_level((ConsistencyLevel)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return getKey();

      case COLUMN_PATH:
        return getColumn_path();

      case TIMESTAMP:
        return Long.valueOf(getTimestamp());

      case CONSISTENCY_LEVEL:
        return getConsistency_level();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return isSetKey();
      case COLUMN_PATH:
        return isSetColumn_path();
      case TIMESTAMP:
        return isSetTimestamp();
      case CONSISTENCY_LEVEL:
        return isSetConsistency_level();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof remove_args)
        return this.equals((remove_args)that);
      return false;
    }

    public boolean equals(remove_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.isSetKey();
      boolean that_present_key = true && that.isSetKey();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      boolean this_present_column_path = true && this.isSetColumn_path();
      boolean that_present_column_path = true && that.isSetColumn_path();
      if (this_present_column_path || that_present_column_path) {
        if (!(this_present_column_path && that_present_column_path))
          return false;
        if (!this.column_path.equals(that.column_path))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      boolean this_present_consistency_level = true && this.isSetConsistency_level();
      boolean that_present_consistency_level = true && that.isSetConsistency_level();
      if (this_present_consistency_level || that_present_consistency_level) {
        if (!(this_present_consistency_level && that_present_consistency_level))
          return false;
        if (!this.consistency_level.equals(that.consistency_level))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_key = true && (isSetKey());
      builder.append(present_key);
      if (present_key)
        builder.append(key);

      boolean present_column_path = true && (isSetColumn_path());
      builder.append(present_column_path);
      if (present_column_path)
        builder.append(column_path);

      boolean present_timestamp = true;
      builder.append(present_timestamp);
      if (present_timestamp)
        builder.append(timestamp);

      boolean present_consistency_level = true && (isSetConsistency_level());
      builder.append(present_consistency_level);
      if (present_consistency_level)
        builder.append(consistency_level.getValue());

      return builder.toHashCode();
    }

    public int compareTo(remove_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      remove_args typedOther = (remove_args)other;

      lastComparison = Boolean.valueOf(isSetKey()).compareTo(typedOther.isSetKey());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKey()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, typedOther.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumn_path()).compareTo(typedOther.isSetColumn_path());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn_path()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column_path, typedOther.column_path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTimestamp()).compareTo(typedOther.isSetTimestamp());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTimestamp()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.timestamp, typedOther.timestamp);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConsistency_level()).compareTo(typedOther.isSetConsistency_level());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConsistency_level()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.consistency_level, typedOther.consistency_level);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // KEY
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.key = iprot.readBinary();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // COLUMN_PATH
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.column_path = new ColumnPath();
              this.column_path.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TIMESTAMP
            if (field.type == org.apache.thrift.protocol.TType.I64) {
              this.timestamp = iprot.readI64();
              setTimestampIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4: // CONSISTENCY_LEVEL
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      if (!isSetTimestamp()) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'timestamp' was not found in serialized data! Struct: " + toString());
      }
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.key != null) {
        oprot.writeFieldBegin(KEY_FIELD_DESC);
        oprot.writeBinary(this.key);
        oprot.writeFieldEnd();
      }
      if (this.column_path != null) {
        oprot.writeFieldBegin(COLUMN_PATH_FIELD_DESC);
        this.column_path.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldBegin(TIMESTAMP_FIELD_DESC);
      oprot.writeI64(this.timestamp);
      oprot.writeFieldEnd();
      if (this.consistency_level != null) {
        oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
        oprot.writeI32(this.consistency_level.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("remove_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.key, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column_path:");
      if (this.column_path == null) {
        sb.append("null");
      } else {
        sb.append(this.column_path);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("timestamp:");
      sb.append(this.timestamp);
      first = false;
      if (!first) sb.append(", ");
      sb.append("consistency_level:");
      if (this.consistency_level == null) {
        sb.append("null");
      } else {
        sb.append(this.consistency_level);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (key == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'key' was not present! Struct: " + toString());
      }
      if (column_path == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'column_path' was not present! Struct: " + toString());
      }
      // alas, we cannot check 'timestamp' because it's a primitive and you chose the non-beans generator.
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bit_vector = new BitSet(1);
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class remove_result implements org.apache.thrift.TBase<remove_result, remove_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("remove_result");

    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    public InvalidRequestException ire; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IRE((short)1, "ire"),
      UE((short)2, "ue"),
      TE((short)3, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IRE
            return IRE;
          case 2: // UE
            return UE;
          case 3: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(remove_result.class, metaDataMap);
    }

    public remove_result() {
    }

    public remove_result(
      InvalidRequestException ire,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.ire = ire;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public remove_result(remove_result other) {
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public remove_result deepCopy() {
      return new remove_result(this);
    }

    @Override
    public void clear() {
      this.ire = null;
      this.ue = null;
      this.te = null;
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public remove_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public remove_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public remove_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case IRE:
        return getIre();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case IRE:
        return isSetIre();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof remove_result)
        return this.equals((remove_result)that);
      return false;
    }

    public boolean equals(remove_result that) {
      if (that == null)
        return false;

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(remove_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      remove_result typedOther = (remove_result)other;

      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("remove_result(");
      boolean first = true;

      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class remove_counter_args implements org.apache.thrift.TBase<remove_counter_args, remove_counter_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("remove_counter_args");

    private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField PATH_FIELD_DESC = new org.apache.thrift.protocol.TField("path", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField CONSISTENCY_LEVEL_FIELD_DESC = new org.apache.thrift.protocol.TField("consistency_level", org.apache.thrift.protocol.TType.I32, (short)3);

    public ByteBuffer key; // required
    public ColumnPath path; // required
    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistency_level; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEY((short)1, "key"),
      PATH((short)2, "path"),
      /**
       *
       * @see ConsistencyLevel
       */
      CONSISTENCY_LEVEL((short)3, "consistency_level");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEY
            return KEY;
          case 2: // PATH
            return PATH;
          case 3: // CONSISTENCY_LEVEL
            return CONSISTENCY_LEVEL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.PATH, new org.apache.thrift.meta_data.FieldMetaData("path", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnPath.class)));
      tmpMap.put(_Fields.CONSISTENCY_LEVEL, new org.apache.thrift.meta_data.FieldMetaData("consistency_level", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ConsistencyLevel.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(remove_counter_args.class, metaDataMap);
    }

    public remove_counter_args() {
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public remove_counter_args(
      ByteBuffer key,
      ColumnPath path,
      ConsistencyLevel consistency_level)
    {
      this();
      this.key = key;
      this.path = path;
      this.consistency_level = consistency_level;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public remove_counter_args(remove_counter_args other) {
      if (other.isSetKey()) {
        this.key = org.apache.thrift.TBaseHelper.copyBinary(other.key);
;
      }
      if (other.isSetPath()) {
        this.path = new ColumnPath(other.path);
      }
      if (other.isSetConsistency_level()) {
        this.consistency_level = other.consistency_level;
      }
    }

    public remove_counter_args deepCopy() {
      return new remove_counter_args(this);
    }

    @Override
    public void clear() {
      this.key = null;
      this.path = null;
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public byte[] getKey() {
      setKey(org.apache.thrift.TBaseHelper.rightSize(key));
      return key == null ? null : key.array();
    }

    public ByteBuffer bufferForKey() {
      return key;
    }

    public remove_counter_args setKey(byte[] key) {
      setKey(key == null ? (ByteBuffer)null : ByteBuffer.wrap(key));
      return this;
    }

    public remove_counter_args setKey(ByteBuffer key) {
      this.key = key;
      return this;
    }

    public void unsetKey() {
      this.key = null;
    }

    /** Returns true if field key is set (has been assigned a value) and false otherwise */
    public boolean isSetKey() {
      return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
      if (!value) {
        this.key = null;
      }
    }

    public ColumnPath getPath() {
      return this.path;
    }

    public remove_counter_args setPath(ColumnPath path) {
      this.path = path;
      return this;
    }

    public void unsetPath() {
      this.path = null;
    }

    /** Returns true if field path is set (has been assigned a value) and false otherwise */
    public boolean isSetPath() {
      return this.path != null;
    }

    public void setPathIsSet(boolean value) {
      if (!value) {
        this.path = null;
      }
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel getConsistency_level() {
      return this.consistency_level;
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public remove_counter_args setConsistency_level(ConsistencyLevel consistency_level) {
      this.consistency_level = consistency_level;
      return this;
    }

    public void unsetConsistency_level() {
      this.consistency_level = null;
    }

    /** Returns true if field consistency_level is set (has been assigned a value) and false otherwise */
    public boolean isSetConsistency_level() {
      return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
      if (!value) {
        this.consistency_level = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEY:
        if (value == null) {
          unsetKey();
        } else {
          setKey((ByteBuffer)value);
        }
        break;

      case PATH:
        if (value == null) {
          unsetPath();
        } else {
          setPath((ColumnPath)value);
        }
        break;

      case CONSISTENCY_LEVEL:
        if (value == null) {
          unsetConsistency_level();
        } else {
          setConsistency_level((ConsistencyLevel)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEY:
        return getKey();

      case PATH:
        return getPath();

      case CONSISTENCY_LEVEL:
        return getConsistency_level();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEY:
        return isSetKey();
      case PATH:
        return isSetPath();
      case CONSISTENCY_LEVEL:
        return isSetConsistency_level();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof remove_counter_args)
        return this.equals((remove_counter_args)that);
      return false;
    }

    public boolean equals(remove_counter_args that) {
      if (that == null)
        return false;

      boolean this_present_key = true && this.isSetKey();
      boolean that_present_key = true && that.isSetKey();
      if (this_present_key || that_present_key) {
        if (!(this_present_key && that_present_key))
          return false;
        if (!this.key.equals(that.key))
          return false;
      }

      boolean this_present_path = true && this.isSetPath();
      boolean that_present_path = true && that.isSetPath();
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_consistency_level = true && this.isSetConsistency_level();
      boolean that_present_consistency_level = true && that.isSetConsistency_level();
      if (this_present_consistency_level || that_present_consistency_level) {
        if (!(this_present_consistency_level && that_present_consistency_level))
          return false;
        if (!this.consistency_level.equals(that.consistency_level))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_key = true && (isSetKey());
      builder.append(present_key);
      if (present_key)
        builder.append(key);

      boolean present_path = true && (isSetPath());
      builder.append(present_path);
      if (present_path)
        builder.append(path);

      boolean present_consistency_level = true && (isSetConsistency_level());
      builder.append(present_consistency_level);
      if (present_consistency_level)
        builder.append(consistency_level.getValue());

      return builder.toHashCode();
    }

    public int compareTo(remove_counter_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      remove_counter_args typedOther = (remove_counter_args)other;

      lastComparison = Boolean.valueOf(isSetKey()).compareTo(typedOther.isSetKey());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKey()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, typedOther.key);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPath()).compareTo(typedOther.isSetPath());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPath()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.path, typedOther.path);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConsistency_level()).compareTo(typedOther.isSetConsistency_level());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConsistency_level()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.consistency_level, typedOther.consistency_level);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // KEY
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.key = iprot.readBinary();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // PATH
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.path = new ColumnPath();
              this.path.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // CONSISTENCY_LEVEL
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.key != null) {
        oprot.writeFieldBegin(KEY_FIELD_DESC);
        oprot.writeBinary(this.key);
        oprot.writeFieldEnd();
      }
      if (this.path != null) {
        oprot.writeFieldBegin(PATH_FIELD_DESC);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.consistency_level != null) {
        oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
        oprot.writeI32(this.consistency_level.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("remove_counter_args(");
      boolean first = true;

      sb.append("key:");
      if (this.key == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.key, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("path:");
      if (this.path == null) {
        sb.append("null");
      } else {
        sb.append(this.path);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("consistency_level:");
      if (this.consistency_level == null) {
        sb.append("null");
      } else {
        sb.append(this.consistency_level);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (key == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'key' was not present! Struct: " + toString());
      }
      if (path == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'path' was not present! Struct: " + toString());
      }
      if (consistency_level == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'consistency_level' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class remove_counter_result implements org.apache.thrift.TBase<remove_counter_result, remove_counter_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("remove_counter_result");

    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    public InvalidRequestException ire; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IRE((short)1, "ire"),
      UE((short)2, "ue"),
      TE((short)3, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IRE
            return IRE;
          case 2: // UE
            return UE;
          case 3: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(remove_counter_result.class, metaDataMap);
    }

    public remove_counter_result() {
    }

    public remove_counter_result(
      InvalidRequestException ire,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.ire = ire;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public remove_counter_result(remove_counter_result other) {
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public remove_counter_result deepCopy() {
      return new remove_counter_result(this);
    }

    @Override
    public void clear() {
      this.ire = null;
      this.ue = null;
      this.te = null;
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public remove_counter_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public remove_counter_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public remove_counter_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case IRE:
        return getIre();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case IRE:
        return isSetIre();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof remove_counter_result)
        return this.equals((remove_counter_result)that);
      return false;
    }

    public boolean equals(remove_counter_result that) {
      if (that == null)
        return false;

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(remove_counter_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      remove_counter_result typedOther = (remove_counter_result)other;

      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("remove_counter_result(");
      boolean first = true;

      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class batch_mutate_args implements org.apache.thrift.TBase<batch_mutate_args, batch_mutate_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("batch_mutate_args");

    private static final org.apache.thrift.protocol.TField MUTATION_MAP_FIELD_DESC = new org.apache.thrift.protocol.TField("mutation_map", org.apache.thrift.protocol.TType.MAP, (short)1);
    private static final org.apache.thrift.protocol.TField CONSISTENCY_LEVEL_FIELD_DESC = new org.apache.thrift.protocol.TField("consistency_level", org.apache.thrift.protocol.TType.I32, (short)2);

    public Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map; // required
    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistency_level; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      MUTATION_MAP((short)1, "mutation_map"),
      /**
       *
       * @see ConsistencyLevel
       */
      CONSISTENCY_LEVEL((short)2, "consistency_level");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // MUTATION_MAP
            return MUTATION_MAP;
          case 2: // CONSISTENCY_LEVEL
            return CONSISTENCY_LEVEL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.MUTATION_MAP, new org.apache.thrift.meta_data.FieldMetaData("mutation_map", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP,
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true),
              new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP,
                  new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING),
                  new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST,
                      new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Mutation.class))))));
      tmpMap.put(_Fields.CONSISTENCY_LEVEL, new org.apache.thrift.meta_data.FieldMetaData("consistency_level", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ConsistencyLevel.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(batch_mutate_args.class, metaDataMap);
    }

    public batch_mutate_args() {
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public batch_mutate_args(
      Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map,
      ConsistencyLevel consistency_level)
    {
      this();
      this.mutation_map = mutation_map;
      this.consistency_level = consistency_level;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public batch_mutate_args(batch_mutate_args other) {
      if (other.isSetMutation_map()) {
        Map<ByteBuffer,Map<String,List<Mutation>>> __this__mutation_map = new HashMap<ByteBuffer,Map<String,List<Mutation>>>();
        for (Map.Entry<ByteBuffer, Map<String,List<Mutation>>> other_element : other.mutation_map.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          Map<String,List<Mutation>> other_element_value = other_element.getValue();

          ByteBuffer __this__mutation_map_copy_key = org.apache.thrift.TBaseHelper.copyBinary(other_element_key);
;

          Map<String,List<Mutation>> __this__mutation_map_copy_value = new HashMap<String,List<Mutation>>();
          for (Map.Entry<String, List<Mutation>> other_element_value_element : other_element_value.entrySet()) {

            String other_element_value_element_key = other_element_value_element.getKey();
            List<Mutation> other_element_value_element_value = other_element_value_element.getValue();

            String __this__mutation_map_copy_value_copy_key = other_element_value_element_key;

            List<Mutation> __this__mutation_map_copy_value_copy_value = new ArrayList<Mutation>();
            for (Mutation other_element_value_element_value_element : other_element_value_element_value) {
              __this__mutation_map_copy_value_copy_value.add(new Mutation(other_element_value_element_value_element));
            }

            __this__mutation_map_copy_value.put(__this__mutation_map_copy_value_copy_key, __this__mutation_map_copy_value_copy_value);
          }

          __this__mutation_map.put(__this__mutation_map_copy_key, __this__mutation_map_copy_value);
        }
        this.mutation_map = __this__mutation_map;
      }
      if (other.isSetConsistency_level()) {
        this.consistency_level = other.consistency_level;
      }
    }

    public batch_mutate_args deepCopy() {
      return new batch_mutate_args(this);
    }

    @Override
    public void clear() {
      this.mutation_map = null;
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public int getMutation_mapSize() {
      return (this.mutation_map == null) ? 0 : this.mutation_map.size();
    }

    public void putToMutation_map(ByteBuffer key, Map<String,List<Mutation>> val) {
      if (this.mutation_map == null) {
        this.mutation_map = new HashMap<ByteBuffer,Map<String,List<Mutation>>>();
      }
      this.mutation_map.put(key, val);
    }

    public Map<ByteBuffer,Map<String,List<Mutation>>> getMutation_map() {
      return this.mutation_map;
    }

    public batch_mutate_args setMutation_map(Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map) {
      this.mutation_map = mutation_map;
      return this;
    }

    public void unsetMutation_map() {
      this.mutation_map = null;
    }

    /** Returns true if field mutation_map is set (has been assigned a value) and false otherwise */
    public boolean isSetMutation_map() {
      return this.mutation_map != null;
    }

    public void setMutation_mapIsSet(boolean value) {
      if (!value) {
        this.mutation_map = null;
      }
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel getConsistency_level() {
      return this.consistency_level;
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public batch_mutate_args setConsistency_level(ConsistencyLevel consistency_level) {
      this.consistency_level = consistency_level;
      return this;
    }

    public void unsetConsistency_level() {
      this.consistency_level = null;
    }

    /** Returns true if field consistency_level is set (has been assigned a value) and false otherwise */
    public boolean isSetConsistency_level() {
      return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
      if (!value) {
        this.consistency_level = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case MUTATION_MAP:
        if (value == null) {
          unsetMutation_map();
        } else {
          setMutation_map((Map<ByteBuffer,Map<String,List<Mutation>>>)value);
        }
        break;

      case CONSISTENCY_LEVEL:
        if (value == null) {
          unsetConsistency_level();
        } else {
          setConsistency_level((ConsistencyLevel)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case MUTATION_MAP:
        return getMutation_map();

      case CONSISTENCY_LEVEL:
        return getConsistency_level();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case MUTATION_MAP:
        return isSetMutation_map();
      case CONSISTENCY_LEVEL:
        return isSetConsistency_level();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof batch_mutate_args)
        return this.equals((batch_mutate_args)that);
      return false;
    }

    public boolean equals(batch_mutate_args that) {
      if (that == null)
        return false;

      boolean this_present_mutation_map = true && this.isSetMutation_map();
      boolean that_present_mutation_map = true && that.isSetMutation_map();
      if (this_present_mutation_map || that_present_mutation_map) {
        if (!(this_present_mutation_map && that_present_mutation_map))
          return false;
        if (!this.mutation_map.equals(that.mutation_map))
          return false;
      }

      boolean this_present_consistency_level = true && this.isSetConsistency_level();
      boolean that_present_consistency_level = true && that.isSetConsistency_level();
      if (this_present_consistency_level || that_present_consistency_level) {
        if (!(this_present_consistency_level && that_present_consistency_level))
          return false;
        if (!this.consistency_level.equals(that.consistency_level))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_mutation_map = true && (isSetMutation_map());
      builder.append(present_mutation_map);
      if (present_mutation_map)
        builder.append(mutation_map);

      boolean present_consistency_level = true && (isSetConsistency_level());
      builder.append(present_consistency_level);
      if (present_consistency_level)
        builder.append(consistency_level.getValue());

      return builder.toHashCode();
    }

    public int compareTo(batch_mutate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      batch_mutate_args typedOther = (batch_mutate_args)other;

      lastComparison = Boolean.valueOf(isSetMutation_map()).compareTo(typedOther.isSetMutation_map());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetMutation_map()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.mutation_map, typedOther.mutation_map);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConsistency_level()).compareTo(typedOther.isSetConsistency_level());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConsistency_level()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.consistency_level, typedOther.consistency_level);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // MUTATION_MAP
            if (field.type == org.apache.thrift.protocol.TType.MAP) {
              {
                org.apache.thrift.protocol.TMap _map133 = iprot.readMapBegin();
                this.mutation_map = new HashMap<ByteBuffer,Map<String,List<Mutation>>>(2*_map133.size);
                for (int _i134 = 0; _i134 < _map133.size; ++_i134)
                {
                  ByteBuffer _key135; // required
                  Map<String,List<Mutation>> _val136; // required
                  _key135 = iprot.readBinary();
                  {
                    org.apache.thrift.protocol.TMap _map137 = iprot.readMapBegin();
                    _val136 = new HashMap<String,List<Mutation>>(2*_map137.size);
                    for (int _i138 = 0; _i138 < _map137.size; ++_i138)
                    {
                      String _key139; // required
                      List<Mutation> _val140; // required
                      _key139 = iprot.readString();
                      {
                        org.apache.thrift.protocol.TList _list141 = iprot.readListBegin();
                        _val140 = new ArrayList<Mutation>(_list141.size);
                        for (int _i142 = 0; _i142 < _list141.size; ++_i142)
                        {
                          Mutation _elem143; // required
                          _elem143 = new Mutation();
                          _elem143.read(iprot);
                          _val140.add(_elem143);
                        }
                        iprot.readListEnd();
                      }
                      _val136.put(_key139, _val140);
                    }
                    iprot.readMapEnd();
                  }
                  this.mutation_map.put(_key135, _val136);
                }
                iprot.readMapEnd();
              }
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // CONSISTENCY_LEVEL
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.mutation_map != null) {
        oprot.writeFieldBegin(MUTATION_MAP_FIELD_DESC);
        {
          oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.MAP, this.mutation_map.size()));
          for (Map.Entry<ByteBuffer, Map<String,List<Mutation>>> _iter144 : this.mutation_map.entrySet())
          {
            oprot.writeBinary(_iter144.getKey());
            {
              oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.LIST, _iter144.getValue().size()));
              for (Map.Entry<String, List<Mutation>> _iter145 : _iter144.getValue().entrySet())
              {
                oprot.writeString(_iter145.getKey());
                {
                  oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, _iter145.getValue().size()));
                  for (Mutation _iter146 : _iter145.getValue())
                  {
                    _iter146.write(oprot);
                  }
                  oprot.writeListEnd();
                }
              }
              oprot.writeMapEnd();
            }
          }
          oprot.writeMapEnd();
        }
        oprot.writeFieldEnd();
      }
      if (this.consistency_level != null) {
        oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
        oprot.writeI32(this.consistency_level.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("batch_mutate_args(");
      boolean first = true;

      sb.append("mutation_map:");
      if (this.mutation_map == null) {
        sb.append("null");
      } else {
        sb.append(this.mutation_map);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("consistency_level:");
      if (this.consistency_level == null) {
        sb.append("null");
      } else {
        sb.append(this.consistency_level);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (mutation_map == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'mutation_map' was not present! Struct: " + toString());
      }
      if (consistency_level == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'consistency_level' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class batch_mutate_result implements org.apache.thrift.TBase<batch_mutate_result, batch_mutate_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("batch_mutate_result");

    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    public InvalidRequestException ire; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IRE((short)1, "ire"),
      UE((short)2, "ue"),
      TE((short)3, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IRE
            return IRE;
          case 2: // UE
            return UE;
          case 3: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(batch_mutate_result.class, metaDataMap);
    }

    public batch_mutate_result() {
    }

    public batch_mutate_result(
      InvalidRequestException ire,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.ire = ire;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public batch_mutate_result(batch_mutate_result other) {
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public batch_mutate_result deepCopy() {
      return new batch_mutate_result(this);
    }

    @Override
    public void clear() {
      this.ire = null;
      this.ue = null;
      this.te = null;
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public batch_mutate_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public batch_mutate_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public batch_mutate_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case IRE:
        return getIre();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case IRE:
        return isSetIre();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof batch_mutate_result)
        return this.equals((batch_mutate_result)that);
      return false;
    }

    public boolean equals(batch_mutate_result that) {
      if (that == null)
        return false;

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(batch_mutate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      batch_mutate_result typedOther = (batch_mutate_result)other;

      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("batch_mutate_result(");
      boolean first = true;

      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class atomic_batch_mutate_args implements org.apache.thrift.TBase<atomic_batch_mutate_args, atomic_batch_mutate_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("atomic_batch_mutate_args");

    private static final org.apache.thrift.protocol.TField MUTATION_MAP_FIELD_DESC = new org.apache.thrift.protocol.TField("mutation_map", org.apache.thrift.protocol.TType.MAP, (short)1);
    private static final org.apache.thrift.protocol.TField CONSISTENCY_LEVEL_FIELD_DESC = new org.apache.thrift.protocol.TField("consistency_level", org.apache.thrift.protocol.TType.I32, (short)2);

    public Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map; // required
    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel consistency_level; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      MUTATION_MAP((short)1, "mutation_map"),
      /**
       *
       * @see ConsistencyLevel
       */
      CONSISTENCY_LEVEL((short)2, "consistency_level");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // MUTATION_MAP
            return MUTATION_MAP;
          case 2: // CONSISTENCY_LEVEL
            return CONSISTENCY_LEVEL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.MUTATION_MAP, new org.apache.thrift.meta_data.FieldMetaData("mutation_map", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP,
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true),
              new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP,
                  new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING),
                  new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST,
                      new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Mutation.class))))));
      tmpMap.put(_Fields.CONSISTENCY_LEVEL, new org.apache.thrift.meta_data.FieldMetaData("consistency_level", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, ConsistencyLevel.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(atomic_batch_mutate_args.class, metaDataMap);
    }

    public atomic_batch_mutate_args() {
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public atomic_batch_mutate_args(
      Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map,
      ConsistencyLevel consistency_level)
    {
      this();
      this.mutation_map = mutation_map;
      this.consistency_level = consistency_level;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public atomic_batch_mutate_args(atomic_batch_mutate_args other) {
      if (other.isSetMutation_map()) {
        Map<ByteBuffer,Map<String,List<Mutation>>> __this__mutation_map = new HashMap<ByteBuffer,Map<String,List<Mutation>>>();
        for (Map.Entry<ByteBuffer, Map<String,List<Mutation>>> other_element : other.mutation_map.entrySet()) {

          ByteBuffer other_element_key = other_element.getKey();
          Map<String,List<Mutation>> other_element_value = other_element.getValue();

          ByteBuffer __this__mutation_map_copy_key = org.apache.thrift.TBaseHelper.copyBinary(other_element_key);
;

          Map<String,List<Mutation>> __this__mutation_map_copy_value = new HashMap<String,List<Mutation>>();
          for (Map.Entry<String, List<Mutation>> other_element_value_element : other_element_value.entrySet()) {

            String other_element_value_element_key = other_element_value_element.getKey();
            List<Mutation> other_element_value_element_value = other_element_value_element.getValue();

            String __this__mutation_map_copy_value_copy_key = other_element_value_element_key;

            List<Mutation> __this__mutation_map_copy_value_copy_value = new ArrayList<Mutation>();
            for (Mutation other_element_value_element_value_element : other_element_value_element_value) {
              __this__mutation_map_copy_value_copy_value.add(new Mutation(other_element_value_element_value_element));
            }

            __this__mutation_map_copy_value.put(__this__mutation_map_copy_value_copy_key, __this__mutation_map_copy_value_copy_value);
          }

          __this__mutation_map.put(__this__mutation_map_copy_key, __this__mutation_map_copy_value);
        }
        this.mutation_map = __this__mutation_map;
      }
      if (other.isSetConsistency_level()) {
        this.consistency_level = other.consistency_level;
      }
    }

    public atomic_batch_mutate_args deepCopy() {
      return new atomic_batch_mutate_args(this);
    }

    @Override
    public void clear() {
      this.mutation_map = null;
      this.consistency_level = org.apache.cassandra.thrift.ConsistencyLevel.ONE;

    }

    public int getMutation_mapSize() {
      return (this.mutation_map == null) ? 0 : this.mutation_map.size();
    }

    public void putToMutation_map(ByteBuffer key, Map<String,List<Mutation>> val) {
      if (this.mutation_map == null) {
        this.mutation_map = new HashMap<ByteBuffer,Map<String,List<Mutation>>>();
      }
      this.mutation_map.put(key, val);
    }

    public Map<ByteBuffer,Map<String,List<Mutation>>> getMutation_map() {
      return this.mutation_map;
    }

    public atomic_batch_mutate_args setMutation_map(Map<ByteBuffer,Map<String,List<Mutation>>> mutation_map) {
      this.mutation_map = mutation_map;
      return this;
    }

    public void unsetMutation_map() {
      this.mutation_map = null;
    }

    /** Returns true if field mutation_map is set (has been assigned a value) and false otherwise */
    public boolean isSetMutation_map() {
      return this.mutation_map != null;
    }

    public void setMutation_mapIsSet(boolean value) {
      if (!value) {
        this.mutation_map = null;
      }
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public ConsistencyLevel getConsistency_level() {
      return this.consistency_level;
    }

    /**
     *
     * @see ConsistencyLevel
     */
    public atomic_batch_mutate_args setConsistency_level(ConsistencyLevel consistency_level) {
      this.consistency_level = consistency_level;
      return this;
    }

    public void unsetConsistency_level() {
      this.consistency_level = null;
    }

    /** Returns true if field consistency_level is set (has been assigned a value) and false otherwise */
    public boolean isSetConsistency_level() {
      return this.consistency_level != null;
    }

    public void setConsistency_levelIsSet(boolean value) {
      if (!value) {
        this.consistency_level = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case MUTATION_MAP:
        if (value == null) {
          unsetMutation_map();
        } else {
          setMutation_map((Map<ByteBuffer,Map<String,List<Mutation>>>)value);
        }
        break;

      case CONSISTENCY_LEVEL:
        if (value == null) {
          unsetConsistency_level();
        } else {
          setConsistency_level((ConsistencyLevel)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case MUTATION_MAP:
        return getMutation_map();

      case CONSISTENCY_LEVEL:
        return getConsistency_level();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case MUTATION_MAP:
        return isSetMutation_map();
      case CONSISTENCY_LEVEL:
        return isSetConsistency_level();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof atomic_batch_mutate_args)
        return this.equals((atomic_batch_mutate_args)that);
      return false;
    }

    public boolean equals(atomic_batch_mutate_args that) {
      if (that == null)
        return false;

      boolean this_present_mutation_map = true && this.isSetMutation_map();
      boolean that_present_mutation_map = true && that.isSetMutation_map();
      if (this_present_mutation_map || that_present_mutation_map) {
        if (!(this_present_mutation_map && that_present_mutation_map))
          return false;
        if (!this.mutation_map.equals(that.mutation_map))
          return false;
      }

      boolean this_present_consistency_level = true && this.isSetConsistency_level();
      boolean that_present_consistency_level = true && that.isSetConsistency_level();
      if (this_present_consistency_level || that_present_consistency_level) {
        if (!(this_present_consistency_level && that_present_consistency_level))
          return false;
        if (!this.consistency_level.equals(that.consistency_level))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_mutation_map = true && (isSetMutation_map());
      builder.append(present_mutation_map);
      if (present_mutation_map)
        builder.append(mutation_map);

      boolean present_consistency_level = true && (isSetConsistency_level());
      builder.append(present_consistency_level);
      if (present_consistency_level)
        builder.append(consistency_level.getValue());

      return builder.toHashCode();
    }

    public int compareTo(atomic_batch_mutate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      atomic_batch_mutate_args typedOther = (atomic_batch_mutate_args)other;

      lastComparison = Boolean.valueOf(isSetMutation_map()).compareTo(typedOther.isSetMutation_map());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetMutation_map()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.mutation_map, typedOther.mutation_map);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConsistency_level()).compareTo(typedOther.isSetConsistency_level());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConsistency_level()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.consistency_level, typedOther.consistency_level);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // MUTATION_MAP
            if (field.type == org.apache.thrift.protocol.TType.MAP) {
              {
                org.apache.thrift.protocol.TMap _map147 = iprot.readMapBegin();
                this.mutation_map = new HashMap<ByteBuffer,Map<String,List<Mutation>>>(2*_map147.size);
                for (int _i148 = 0; _i148 < _map147.size; ++_i148)
                {
                  ByteBuffer _key149; // required
                  Map<String,List<Mutation>> _val150; // required
                  _key149 = iprot.readBinary();
                  {
                    org.apache.thrift.protocol.TMap _map151 = iprot.readMapBegin();
                    _val150 = new HashMap<String,List<Mutation>>(2*_map151.size);
                    for (int _i152 = 0; _i152 < _map151.size; ++_i152)
                    {
                      String _key153; // required
                      List<Mutation> _val154; // required
                      _key153 = iprot.readString();
                      {
                        org.apache.thrift.protocol.TList _list155 = iprot.readListBegin();
                        _val154 = new ArrayList<Mutation>(_list155.size);
                        for (int _i156 = 0; _i156 < _list155.size; ++_i156)
                        {
                          Mutation _elem157; // required
                          _elem157 = new Mutation();
                          _elem157.read(iprot);
                          _val154.add(_elem157);
                        }
                        iprot.readListEnd();
                      }
                      _val150.put(_key153, _val154);
                    }
                    iprot.readMapEnd();
                  }
                  this.mutation_map.put(_key149, _val150);
                }
                iprot.readMapEnd();
              }
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // CONSISTENCY_LEVEL
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.consistency_level = ConsistencyLevel.findByValue(iprot.readI32());
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.mutation_map != null) {
        oprot.writeFieldBegin(MUTATION_MAP_FIELD_DESC);
        {
          oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.MAP, this.mutation_map.size()));
          for (Map.Entry<ByteBuffer, Map<String,List<Mutation>>> _iter158 : this.mutation_map.entrySet())
          {
            oprot.writeBinary(_iter158.getKey());
            {
              oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.LIST, _iter158.getValue().size()));
              for (Map.Entry<String, List<Mutation>> _iter159 : _iter158.getValue().entrySet())
              {
                oprot.writeString(_iter159.getKey());
                {
                  oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, _iter159.getValue().size()));
                  for (Mutation _iter160 : _iter159.getValue())
                  {
                    _iter160.write(oprot);
                  }
                  oprot.writeListEnd();
                }
              }
              oprot.writeMapEnd();
            }
          }
          oprot.writeMapEnd();
        }
        oprot.writeFieldEnd();
      }
      if (this.consistency_level != null) {
        oprot.writeFieldBegin(CONSISTENCY_LEVEL_FIELD_DESC);
        oprot.writeI32(this.consistency_level.getValue());
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("atomic_batch_mutate_args(");
      boolean first = true;

      sb.append("mutation_map:");
      if (this.mutation_map == null) {
        sb.append("null");
      } else {
        sb.append(this.mutation_map);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("consistency_level:");
      if (this.consistency_level == null) {
        sb.append("null");
      } else {
        sb.append(this.consistency_level);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (mutation_map == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'mutation_map' was not present! Struct: " + toString());
      }
      if (consistency_level == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'consistency_level' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class atomic_batch_mutate_result implements org.apache.thrift.TBase<atomic_batch_mutate_result, atomic_batch_mutate_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("atomic_batch_mutate_result");

    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    public InvalidRequestException ire; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IRE((short)1, "ire"),
      UE((short)2, "ue"),
      TE((short)3, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IRE
            return IRE;
          case 2: // UE
            return UE;
          case 3: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(atomic_batch_mutate_result.class, metaDataMap);
    }

    public atomic_batch_mutate_result() {
    }

    public atomic_batch_mutate_result(
      InvalidRequestException ire,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.ire = ire;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public atomic_batch_mutate_result(atomic_batch_mutate_result other) {
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public atomic_batch_mutate_result deepCopy() {
      return new atomic_batch_mutate_result(this);
    }

    @Override
    public void clear() {
      this.ire = null;
      this.ue = null;
      this.te = null;
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public atomic_batch_mutate_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public atomic_batch_mutate_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public atomic_batch_mutate_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case IRE:
        return getIre();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case IRE:
        return isSetIre();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof atomic_batch_mutate_result)
        return this.equals((atomic_batch_mutate_result)that);
      return false;
    }

    public boolean equals(atomic_batch_mutate_result that) {
      if (that == null)
        return false;

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(atomic_batch_mutate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      atomic_batch_mutate_result typedOther = (atomic_batch_mutate_result)other;

      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("atomic_batch_mutate_result(");
      boolean first = true;

      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class truncate_args implements org.apache.thrift.TBase<truncate_args, truncate_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("truncate_args");

    private static final org.apache.thrift.protocol.TField CFNAME_FIELD_DESC = new org.apache.thrift.protocol.TField("cfname", org.apache.thrift.protocol.TType.STRING, (short)1);

    public String cfname; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CFNAME((short)1, "cfname");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // CFNAME
            return CFNAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CFNAME, new org.apache.thrift.meta_data.FieldMetaData("cfname", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(truncate_args.class, metaDataMap);
    }

    public truncate_args() {
    }

    public truncate_args(
      String cfname)
    {
      this();
      this.cfname = cfname;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public truncate_args(truncate_args other) {
      if (other.isSetCfname()) {
        this.cfname = other.cfname;
      }
    }

    public truncate_args deepCopy() {
      return new truncate_args(this);
    }

    @Override
    public void clear() {
      this.cfname = null;
    }

    public String getCfname() {
      return this.cfname;
    }

    public truncate_args setCfname(String cfname) {
      this.cfname = cfname;
      return this;
    }

    public void unsetCfname() {
      this.cfname = null;
    }

    /** Returns true if field cfname is set (has been assigned a value) and false otherwise */
    public boolean isSetCfname() {
      return this.cfname != null;
    }

    public void setCfnameIsSet(boolean value) {
      if (!value) {
        this.cfname = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CFNAME:
        if (value == null) {
          unsetCfname();
        } else {
          setCfname((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CFNAME:
        return getCfname();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CFNAME:
        return isSetCfname();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof truncate_args)
        return this.equals((truncate_args)that);
      return false;
    }

    public boolean equals(truncate_args that) {
      if (that == null)
        return false;

      boolean this_present_cfname = true && this.isSetCfname();
      boolean that_present_cfname = true && that.isSetCfname();
      if (this_present_cfname || that_present_cfname) {
        if (!(this_present_cfname && that_present_cfname))
          return false;
        if (!this.cfname.equals(that.cfname))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_cfname = true && (isSetCfname());
      builder.append(present_cfname);
      if (present_cfname)
        builder.append(cfname);

      return builder.toHashCode();
    }

    public int compareTo(truncate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      truncate_args typedOther = (truncate_args)other;

      lastComparison = Boolean.valueOf(isSetCfname()).compareTo(typedOther.isSetCfname());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCfname()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.cfname, typedOther.cfname);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // CFNAME
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.cfname = iprot.readString();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.cfname != null) {
        oprot.writeFieldBegin(CFNAME_FIELD_DESC);
        oprot.writeString(this.cfname);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("truncate_args(");
      boolean first = true;

      sb.append("cfname:");
      if (this.cfname == null) {
        sb.append("null");
      } else {
        sb.append(this.cfname);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (cfname == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'cfname' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class truncate_result implements org.apache.thrift.TBase<truncate_result, truncate_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("truncate_result");

    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UE_FIELD_DESC = new org.apache.thrift.protocol.TField("ue", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TE_FIELD_DESC = new org.apache.thrift.protocol.TField("te", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    public InvalidRequestException ire; // required
    public UnavailableException ue; // required
    public TimedOutException te; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IRE((short)1, "ire"),
      UE((short)2, "ue"),
      TE((short)3, "te");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IRE
            return IRE;
          case 2: // UE
            return UE;
          case 3: // TE
            return TE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.UE, new org.apache.thrift.meta_data.FieldMetaData("ue", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TE, new org.apache.thrift.meta_data.FieldMetaData("te", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(truncate_result.class, metaDataMap);
    }

    public truncate_result() {
    }

    public truncate_result(
      InvalidRequestException ire,
      UnavailableException ue,
      TimedOutException te)
    {
      this();
      this.ire = ire;
      this.ue = ue;
      this.te = te;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public truncate_result(truncate_result other) {
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
      if (other.isSetUe()) {
        this.ue = new UnavailableException(other.ue);
      }
      if (other.isSetTe()) {
        this.te = new TimedOutException(other.te);
      }
    }

    public truncate_result deepCopy() {
      return new truncate_result(this);
    }

    @Override
    public void clear() {
      this.ire = null;
      this.ue = null;
      this.te = null;
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public truncate_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public UnavailableException getUe() {
      return this.ue;
    }

    public truncate_result setUe(UnavailableException ue) {
      this.ue = ue;
      return this;
    }

    public void unsetUe() {
      this.ue = null;
    }

    /** Returns true if field ue is set (has been assigned a value) and false otherwise */
    public boolean isSetUe() {
      return this.ue != null;
    }

    public void setUeIsSet(boolean value) {
      if (!value) {
        this.ue = null;
      }
    }

    public TimedOutException getTe() {
      return this.te;
    }

    public truncate_result setTe(TimedOutException te) {
      this.te = te;
      return this;
    }

    public void unsetTe() {
      this.te = null;
    }

    /** Returns true if field te is set (has been assigned a value) and false otherwise */
    public boolean isSetTe() {
      return this.te != null;
    }

    public void setTeIsSet(boolean value) {
      if (!value) {
        this.te = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      case UE:
        if (value == null) {
          unsetUe();
        } else {
          setUe((UnavailableException)value);
        }
        break;

      case TE:
        if (value == null) {
          unsetTe();
        } else {
          setTe((TimedOutException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case IRE:
        return getIre();

      case UE:
        return getUe();

      case TE:
        return getTe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case IRE:
        return isSetIre();
      case UE:
        return isSetUe();
      case TE:
        return isSetTe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof truncate_result)
        return this.equals((truncate_result)that);
      return false;
    }

    public boolean equals(truncate_result that) {
      if (that == null)
        return false;

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      boolean this_present_ue = true && this.isSetUe();
      boolean that_present_ue = true && that.isSetUe();
      if (this_present_ue || that_present_ue) {
        if (!(this_present_ue && that_present_ue))
          return false;
        if (!this.ue.equals(that.ue))
          return false;
      }

      boolean this_present_te = true && this.isSetTe();
      boolean that_present_te = true && that.isSetTe();
      if (this_present_te || that_present_te) {
        if (!(this_present_te && that_present_te))
          return false;
        if (!this.te.equals(that.te))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      boolean present_ue = true && (isSetUe());
      builder.append(present_ue);
      if (present_ue)
        builder.append(ue);

      boolean present_te = true && (isSetTe());
      builder.append(present_te);
      if (present_te)
        builder.append(te);

      return builder.toHashCode();
    }

    public int compareTo(truncate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      truncate_result typedOther = (truncate_result)other;

      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUe()).compareTo(typedOther.isSetUe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ue, typedOther.ue);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTe()).compareTo(typedOther.isSetTe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.te, typedOther.te);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // UE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ue = new UnavailableException();
              this.ue.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // TE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.te = new TimedOutException();
              this.te.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetUe()) {
        oprot.writeFieldBegin(UE_FIELD_DESC);
        this.ue.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetTe()) {
        oprot.writeFieldBegin(TE_FIELD_DESC);
        this.te.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("truncate_result(");
      boolean first = true;

      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ue:");
      if (this.ue == null) {
        sb.append("null");
      } else {
        sb.append(this.ue);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("te:");
      if (this.te == null) {
        sb.append("null");
      } else {
        sb.append(this.te);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_schema_versions_args implements org.apache.thrift.TBase<describe_schema_versions_args, describe_schema_versions_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_schema_versions_args");



    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_schema_versions_args.class, metaDataMap);
    }

    public describe_schema_versions_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_schema_versions_args(describe_schema_versions_args other) {
    }

    public describe_schema_versions_args deepCopy() {
      return new describe_schema_versions_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_schema_versions_args)
        return this.equals((describe_schema_versions_args)that);
      return false;
    }

    public boolean equals(describe_schema_versions_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      return builder.toHashCode();
    }

    public int compareTo(describe_schema_versions_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_schema_versions_args typedOther = (describe_schema_versions_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_schema_versions_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_schema_versions_result implements org.apache.thrift.TBase<describe_schema_versions_result, describe_schema_versions_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_schema_versions_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.MAP, (short)0);
    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public Map<String,List<String>> success; // required
    public InvalidRequestException ire; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IRE((short)1, "ire");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IRE
            return IRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP,
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING),
              new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST,
                  new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)))));
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_schema_versions_result.class, metaDataMap);
    }

    public describe_schema_versions_result() {
    }

    public describe_schema_versions_result(
      Map<String,List<String>> success,
      InvalidRequestException ire)
    {
      this();
      this.success = success;
      this.ire = ire;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_schema_versions_result(describe_schema_versions_result other) {
      if (other.isSetSuccess()) {
        Map<String,List<String>> __this__success = new HashMap<String,List<String>>();
        for (Map.Entry<String, List<String>> other_element : other.success.entrySet()) {

          String other_element_key = other_element.getKey();
          List<String> other_element_value = other_element.getValue();

          String __this__success_copy_key = other_element_key;

          List<String> __this__success_copy_value = new ArrayList<String>();
          for (String other_element_value_element : other_element_value) {
            __this__success_copy_value.add(other_element_value_element);
          }

          __this__success.put(__this__success_copy_key, __this__success_copy_value);
        }
        this.success = __this__success;
      }
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
    }

    public describe_schema_versions_result deepCopy() {
      return new describe_schema_versions_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.ire = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public void putToSuccess(String key, List<String> val) {
      if (this.success == null) {
        this.success = new HashMap<String,List<String>>();
      }
      this.success.put(key, val);
    }

    public Map<String,List<String>> getSuccess() {
      return this.success;
    }

    public describe_schema_versions_result setSuccess(Map<String,List<String>> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public describe_schema_versions_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Map<String,List<String>>)value);
        }
        break;

      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IRE:
        return getIre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IRE:
        return isSetIre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_schema_versions_result)
        return this.equals((describe_schema_versions_result)that);
      return false;
    }

    public boolean equals(describe_schema_versions_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      return builder.toHashCode();
    }

    public int compareTo(describe_schema_versions_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_schema_versions_result typedOther = (describe_schema_versions_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.MAP) {
              {
                org.apache.thrift.protocol.TMap _map161 = iprot.readMapBegin();
                this.success = new HashMap<String,List<String>>(2*_map161.size);
                for (int _i162 = 0; _i162 < _map161.size; ++_i162)
                {
                  String _key163; // required
                  List<String> _val164; // required
                  _key163 = iprot.readString();
                  {
                    org.apache.thrift.protocol.TList _list165 = iprot.readListBegin();
                    _val164 = new ArrayList<String>(_list165.size);
                    for (int _i166 = 0; _i166 < _list165.size; ++_i166)
                    {
                      String _elem167; // required
                      _elem167 = iprot.readString();
                      _val164.add(_elem167);
                    }
                    iprot.readListEnd();
                  }
                  this.success.put(_key163, _val164);
                }
                iprot.readMapEnd();
              }
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        {
          oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.LIST, this.success.size()));
          for (Map.Entry<String, List<String>> _iter168 : this.success.entrySet())
          {
            oprot.writeString(_iter168.getKey());
            {
              oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, _iter168.getValue().size()));
              for (String _iter169 : _iter168.getValue())
              {
                oprot.writeString(_iter169);
              }
              oprot.writeListEnd();
            }
          }
          oprot.writeMapEnd();
        }
        oprot.writeFieldEnd();
      } else if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_schema_versions_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_keyspaces_args implements org.apache.thrift.TBase<describe_keyspaces_args, describe_keyspaces_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_keyspaces_args");



    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_keyspaces_args.class, metaDataMap);
    }

    public describe_keyspaces_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_keyspaces_args(describe_keyspaces_args other) {
    }

    public describe_keyspaces_args deepCopy() {
      return new describe_keyspaces_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_keyspaces_args)
        return this.equals((describe_keyspaces_args)that);
      return false;
    }

    public boolean equals(describe_keyspaces_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      return builder.toHashCode();
    }

    public int compareTo(describe_keyspaces_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_keyspaces_args typedOther = (describe_keyspaces_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_keyspaces_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_keyspaces_result implements org.apache.thrift.TBase<describe_keyspaces_result, describe_keyspaces_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_keyspaces_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public List<KsDef> success; // required
    public InvalidRequestException ire; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IRE((short)1, "ire");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IRE
            return IRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST,
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, KsDef.class))));
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_keyspaces_result.class, metaDataMap);
    }

    public describe_keyspaces_result() {
    }

    public describe_keyspaces_result(
      List<KsDef> success,
      InvalidRequestException ire)
    {
      this();
      this.success = success;
      this.ire = ire;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_keyspaces_result(describe_keyspaces_result other) {
      if (other.isSetSuccess()) {
        List<KsDef> __this__success = new ArrayList<KsDef>();
        for (KsDef other_element : other.success) {
          __this__success.add(new KsDef(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
    }

    public describe_keyspaces_result deepCopy() {
      return new describe_keyspaces_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.ire = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<KsDef> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(KsDef elem) {
      if (this.success == null) {
        this.success = new ArrayList<KsDef>();
      }
      this.success.add(elem);
    }

    public List<KsDef> getSuccess() {
      return this.success;
    }

    public describe_keyspaces_result setSuccess(List<KsDef> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public describe_keyspaces_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<KsDef>)value);
        }
        break;

      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IRE:
        return getIre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IRE:
        return isSetIre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_keyspaces_result)
        return this.equals((describe_keyspaces_result)that);
      return false;
    }

    public boolean equals(describe_keyspaces_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      return builder.toHashCode();
    }

    public int compareTo(describe_keyspaces_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_keyspaces_result typedOther = (describe_keyspaces_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list170 = iprot.readListBegin();
                this.success = new ArrayList<KsDef>(_list170.size);
                for (int _i171 = 0; _i171 < _list170.size; ++_i171)
                {
                  KsDef _elem172; // required
                  _elem172 = new KsDef();
                  _elem172.read(iprot);
                  this.success.add(_elem172);
                }
                iprot.readListEnd();
              }
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        {
          oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, this.success.size()));
          for (KsDef _iter173 : this.success)
          {
            _iter173.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      } else if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_keyspaces_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_cluster_name_args implements org.apache.thrift.TBase<describe_cluster_name_args, describe_cluster_name_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_cluster_name_args");



    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_cluster_name_args.class, metaDataMap);
    }

    public describe_cluster_name_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_cluster_name_args(describe_cluster_name_args other) {
    }

    public describe_cluster_name_args deepCopy() {
      return new describe_cluster_name_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_cluster_name_args)
        return this.equals((describe_cluster_name_args)that);
      return false;
    }

    public boolean equals(describe_cluster_name_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      return builder.toHashCode();
    }

    public int compareTo(describe_cluster_name_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_cluster_name_args typedOther = (describe_cluster_name_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_cluster_name_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_cluster_name_result implements org.apache.thrift.TBase<describe_cluster_name_result, describe_cluster_name_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_cluster_name_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    public String success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_cluster_name_result.class, metaDataMap);
    }

    public describe_cluster_name_result() {
    }

    public describe_cluster_name_result(
      String success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_cluster_name_result(describe_cluster_name_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
    }

    public describe_cluster_name_result deepCopy() {
      return new describe_cluster_name_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public describe_cluster_name_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_cluster_name_result)
        return this.equals((describe_cluster_name_result)that);
      return false;
    }

    public boolean equals(describe_cluster_name_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      return builder.toHashCode();
    }

    public int compareTo(describe_cluster_name_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_cluster_name_result typedOther = (describe_cluster_name_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.success = iprot.readString();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        oprot.writeString(this.success);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_cluster_name_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_version_args implements org.apache.thrift.TBase<describe_version_args, describe_version_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_version_args");



    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_version_args.class, metaDataMap);
    }

    public describe_version_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_version_args(describe_version_args other) {
    }

    public describe_version_args deepCopy() {
      return new describe_version_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_version_args)
        return this.equals((describe_version_args)that);
      return false;
    }

    public boolean equals(describe_version_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      return builder.toHashCode();
    }

    public int compareTo(describe_version_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_version_args typedOther = (describe_version_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_version_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_version_result implements org.apache.thrift.TBase<describe_version_result, describe_version_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_version_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    public String success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_version_result.class, metaDataMap);
    }

    public describe_version_result() {
    }

    public describe_version_result(
      String success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_version_result(describe_version_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
    }

    public describe_version_result deepCopy() {
      return new describe_version_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public describe_version_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_version_result)
        return this.equals((describe_version_result)that);
      return false;
    }

    public boolean equals(describe_version_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      return builder.toHashCode();
    }

    public int compareTo(describe_version_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_version_result typedOther = (describe_version_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.success = iprot.readString();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        oprot.writeString(this.success);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_version_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_ring_args implements org.apache.thrift.TBase<describe_ring_args, describe_ring_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_ring_args");

    private static final org.apache.thrift.protocol.TField KEYSPACE_FIELD_DESC = new org.apache.thrift.protocol.TField("keyspace", org.apache.thrift.protocol.TType.STRING, (short)1);

    public String keyspace; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEYSPACE((short)1, "keyspace");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEYSPACE
            return KEYSPACE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEYSPACE, new org.apache.thrift.meta_data.FieldMetaData("keyspace", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_ring_args.class, metaDataMap);
    }

    public describe_ring_args() {
    }

    public describe_ring_args(
      String keyspace)
    {
      this();
      this.keyspace = keyspace;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_ring_args(describe_ring_args other) {
      if (other.isSetKeyspace()) {
        this.keyspace = other.keyspace;
      }
    }

    public describe_ring_args deepCopy() {
      return new describe_ring_args(this);
    }

    @Override
    public void clear() {
      this.keyspace = null;
    }

    public String getKeyspace() {
      return this.keyspace;
    }

    public describe_ring_args setKeyspace(String keyspace) {
      this.keyspace = keyspace;
      return this;
    }

    public void unsetKeyspace() {
      this.keyspace = null;
    }

    /** Returns true if field keyspace is set (has been assigned a value) and false otherwise */
    public boolean isSetKeyspace() {
      return this.keyspace != null;
    }

    public void setKeyspaceIsSet(boolean value) {
      if (!value) {
        this.keyspace = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEYSPACE:
        if (value == null) {
          unsetKeyspace();
        } else {
          setKeyspace((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEYSPACE:
        return getKeyspace();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEYSPACE:
        return isSetKeyspace();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_ring_args)
        return this.equals((describe_ring_args)that);
      return false;
    }

    public boolean equals(describe_ring_args that) {
      if (that == null)
        return false;

      boolean this_present_keyspace = true && this.isSetKeyspace();
      boolean that_present_keyspace = true && that.isSetKeyspace();
      if (this_present_keyspace || that_present_keyspace) {
        if (!(this_present_keyspace && that_present_keyspace))
          return false;
        if (!this.keyspace.equals(that.keyspace))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_keyspace = true && (isSetKeyspace());
      builder.append(present_keyspace);
      if (present_keyspace)
        builder.append(keyspace);

      return builder.toHashCode();
    }

    public int compareTo(describe_ring_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_ring_args typedOther = (describe_ring_args)other;

      lastComparison = Boolean.valueOf(isSetKeyspace()).compareTo(typedOther.isSetKeyspace());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKeyspace()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.keyspace, typedOther.keyspace);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // KEYSPACE
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.keyspace = iprot.readString();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.keyspace != null) {
        oprot.writeFieldBegin(KEYSPACE_FIELD_DESC);
        oprot.writeString(this.keyspace);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_ring_args(");
      boolean first = true;

      sb.append("keyspace:");
      if (this.keyspace == null) {
        sb.append("null");
      } else {
        sb.append(this.keyspace);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (keyspace == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'keyspace' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_ring_result implements org.apache.thrift.TBase<describe_ring_result, describe_ring_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_ring_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public List<TokenRange> success; // required
    public InvalidRequestException ire; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IRE((short)1, "ire");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IRE
            return IRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST,
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TokenRange.class))));
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_ring_result.class, metaDataMap);
    }

    public describe_ring_result() {
    }

    public describe_ring_result(
      List<TokenRange> success,
      InvalidRequestException ire)
    {
      this();
      this.success = success;
      this.ire = ire;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_ring_result(describe_ring_result other) {
      if (other.isSetSuccess()) {
        List<TokenRange> __this__success = new ArrayList<TokenRange>();
        for (TokenRange other_element : other.success) {
          __this__success.add(new TokenRange(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
    }

    public describe_ring_result deepCopy() {
      return new describe_ring_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.ire = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<TokenRange> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TokenRange elem) {
      if (this.success == null) {
        this.success = new ArrayList<TokenRange>();
      }
      this.success.add(elem);
    }

    public List<TokenRange> getSuccess() {
      return this.success;
    }

    public describe_ring_result setSuccess(List<TokenRange> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public describe_ring_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<TokenRange>)value);
        }
        break;

      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IRE:
        return getIre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IRE:
        return isSetIre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_ring_result)
        return this.equals((describe_ring_result)that);
      return false;
    }

    public boolean equals(describe_ring_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      return builder.toHashCode();
    }

    public int compareTo(describe_ring_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_ring_result typedOther = (describe_ring_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list174 = iprot.readListBegin();
                this.success = new ArrayList<TokenRange>(_list174.size);
                for (int _i175 = 0; _i175 < _list174.size; ++_i175)
                {
                  TokenRange _elem176; // required
                  _elem176 = new TokenRange();
                  _elem176.read(iprot);
                  this.success.add(_elem176);
                }
                iprot.readListEnd();
              }
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        {
          oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, this.success.size()));
          for (TokenRange _iter177 : this.success)
          {
            _iter177.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      } else if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_ring_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_token_map_args implements org.apache.thrift.TBase<describe_token_map_args, describe_token_map_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_token_map_args");



    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_token_map_args.class, metaDataMap);
    }

    public describe_token_map_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_token_map_args(describe_token_map_args other) {
    }

    public describe_token_map_args deepCopy() {
      return new describe_token_map_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_token_map_args)
        return this.equals((describe_token_map_args)that);
      return false;
    }

    public boolean equals(describe_token_map_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      return builder.toHashCode();
    }

    public int compareTo(describe_token_map_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_token_map_args typedOther = (describe_token_map_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_token_map_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_token_map_result implements org.apache.thrift.TBase<describe_token_map_result, describe_token_map_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_token_map_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.MAP, (short)0);
    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public Map<String,String> success; // required
    public InvalidRequestException ire; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IRE((short)1, "ire");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IRE
            return IRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP,
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING),
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_token_map_result.class, metaDataMap);
    }

    public describe_token_map_result() {
    }

    public describe_token_map_result(
      Map<String,String> success,
      InvalidRequestException ire)
    {
      this();
      this.success = success;
      this.ire = ire;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_token_map_result(describe_token_map_result other) {
      if (other.isSetSuccess()) {
        Map<String,String> __this__success = new HashMap<String,String>();
        for (Map.Entry<String, String> other_element : other.success.entrySet()) {

          String other_element_key = other_element.getKey();
          String other_element_value = other_element.getValue();

          String __this__success_copy_key = other_element_key;

          String __this__success_copy_value = other_element_value;

          __this__success.put(__this__success_copy_key, __this__success_copy_value);
        }
        this.success = __this__success;
      }
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
    }

    public describe_token_map_result deepCopy() {
      return new describe_token_map_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.ire = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public void putToSuccess(String key, String val) {
      if (this.success == null) {
        this.success = new HashMap<String,String>();
      }
      this.success.put(key, val);
    }

    public Map<String,String> getSuccess() {
      return this.success;
    }

    public describe_token_map_result setSuccess(Map<String,String> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public describe_token_map_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Map<String,String>)value);
        }
        break;

      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IRE:
        return getIre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IRE:
        return isSetIre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_token_map_result)
        return this.equals((describe_token_map_result)that);
      return false;
    }

    public boolean equals(describe_token_map_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      return builder.toHashCode();
    }

    public int compareTo(describe_token_map_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_token_map_result typedOther = (describe_token_map_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.MAP) {
              {
                org.apache.thrift.protocol.TMap _map178 = iprot.readMapBegin();
                this.success = new HashMap<String,String>(2*_map178.size);
                for (int _i179 = 0; _i179 < _map178.size; ++_i179)
                {
                  String _key180; // required
                  String _val181; // required
                  _key180 = iprot.readString();
                  _val181 = iprot.readString();
                  this.success.put(_key180, _val181);
                }
                iprot.readMapEnd();
              }
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        {
          oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, this.success.size()));
          for (Map.Entry<String, String> _iter182 : this.success.entrySet())
          {
            oprot.writeString(_iter182.getKey());
            oprot.writeString(_iter182.getValue());
          }
          oprot.writeMapEnd();
        }
        oprot.writeFieldEnd();
      } else if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_token_map_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_partitioner_args implements org.apache.thrift.TBase<describe_partitioner_args, describe_partitioner_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_partitioner_args");



    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_partitioner_args.class, metaDataMap);
    }

    public describe_partitioner_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_partitioner_args(describe_partitioner_args other) {
    }

    public describe_partitioner_args deepCopy() {
      return new describe_partitioner_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_partitioner_args)
        return this.equals((describe_partitioner_args)that);
      return false;
    }

    public boolean equals(describe_partitioner_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      return builder.toHashCode();
    }

    public int compareTo(describe_partitioner_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_partitioner_args typedOther = (describe_partitioner_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_partitioner_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_partitioner_result implements org.apache.thrift.TBase<describe_partitioner_result, describe_partitioner_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_partitioner_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    public String success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_partitioner_result.class, metaDataMap);
    }

    public describe_partitioner_result() {
    }

    public describe_partitioner_result(
      String success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_partitioner_result(describe_partitioner_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
    }

    public describe_partitioner_result deepCopy() {
      return new describe_partitioner_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public describe_partitioner_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_partitioner_result)
        return this.equals((describe_partitioner_result)that);
      return false;
    }

    public boolean equals(describe_partitioner_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      return builder.toHashCode();
    }

    public int compareTo(describe_partitioner_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_partitioner_result typedOther = (describe_partitioner_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.success = iprot.readString();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        oprot.writeString(this.success);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_partitioner_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_snitch_args implements org.apache.thrift.TBase<describe_snitch_args, describe_snitch_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_snitch_args");



    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_snitch_args.class, metaDataMap);
    }

    public describe_snitch_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_snitch_args(describe_snitch_args other) {
    }

    public describe_snitch_args deepCopy() {
      return new describe_snitch_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_snitch_args)
        return this.equals((describe_snitch_args)that);
      return false;
    }

    public boolean equals(describe_snitch_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      return builder.toHashCode();
    }

    public int compareTo(describe_snitch_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_snitch_args typedOther = (describe_snitch_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_snitch_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_snitch_result implements org.apache.thrift.TBase<describe_snitch_result, describe_snitch_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_snitch_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    public String success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_snitch_result.class, metaDataMap);
    }

    public describe_snitch_result() {
    }

    public describe_snitch_result(
      String success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_snitch_result(describe_snitch_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
    }

    public describe_snitch_result deepCopy() {
      return new describe_snitch_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public describe_snitch_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_snitch_result)
        return this.equals((describe_snitch_result)that);
      return false;
    }

    public boolean equals(describe_snitch_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      return builder.toHashCode();
    }

    public int compareTo(describe_snitch_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_snitch_result typedOther = (describe_snitch_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.success = iprot.readString();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        oprot.writeString(this.success);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_snitch_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_keyspace_args implements org.apache.thrift.TBase<describe_keyspace_args, describe_keyspace_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_keyspace_args");

    private static final org.apache.thrift.protocol.TField KEYSPACE_FIELD_DESC = new org.apache.thrift.protocol.TField("keyspace", org.apache.thrift.protocol.TType.STRING, (short)1);

    public String keyspace; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      KEYSPACE((short)1, "keyspace");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // KEYSPACE
            return KEYSPACE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.KEYSPACE, new org.apache.thrift.meta_data.FieldMetaData("keyspace", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_keyspace_args.class, metaDataMap);
    }

    public describe_keyspace_args() {
    }

    public describe_keyspace_args(
      String keyspace)
    {
      this();
      this.keyspace = keyspace;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_keyspace_args(describe_keyspace_args other) {
      if (other.isSetKeyspace()) {
        this.keyspace = other.keyspace;
      }
    }

    public describe_keyspace_args deepCopy() {
      return new describe_keyspace_args(this);
    }

    @Override
    public void clear() {
      this.keyspace = null;
    }

    public String getKeyspace() {
      return this.keyspace;
    }

    public describe_keyspace_args setKeyspace(String keyspace) {
      this.keyspace = keyspace;
      return this;
    }

    public void unsetKeyspace() {
      this.keyspace = null;
    }

    /** Returns true if field keyspace is set (has been assigned a value) and false otherwise */
    public boolean isSetKeyspace() {
      return this.keyspace != null;
    }

    public void setKeyspaceIsSet(boolean value) {
      if (!value) {
        this.keyspace = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case KEYSPACE:
        if (value == null) {
          unsetKeyspace();
        } else {
          setKeyspace((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case KEYSPACE:
        return getKeyspace();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case KEYSPACE:
        return isSetKeyspace();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_keyspace_args)
        return this.equals((describe_keyspace_args)that);
      return false;
    }

    public boolean equals(describe_keyspace_args that) {
      if (that == null)
        return false;

      boolean this_present_keyspace = true && this.isSetKeyspace();
      boolean that_present_keyspace = true && that.isSetKeyspace();
      if (this_present_keyspace || that_present_keyspace) {
        if (!(this_present_keyspace && that_present_keyspace))
          return false;
        if (!this.keyspace.equals(that.keyspace))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_keyspace = true && (isSetKeyspace());
      builder.append(present_keyspace);
      if (present_keyspace)
        builder.append(keyspace);

      return builder.toHashCode();
    }

    public int compareTo(describe_keyspace_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_keyspace_args typedOther = (describe_keyspace_args)other;

      lastComparison = Boolean.valueOf(isSetKeyspace()).compareTo(typedOther.isSetKeyspace());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKeyspace()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.keyspace, typedOther.keyspace);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // KEYSPACE
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.keyspace = iprot.readString();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.keyspace != null) {
        oprot.writeFieldBegin(KEYSPACE_FIELD_DESC);
        oprot.writeString(this.keyspace);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_keyspace_args(");
      boolean first = true;

      sb.append("keyspace:");
      if (this.keyspace == null) {
        sb.append("null");
      } else {
        sb.append(this.keyspace);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (keyspace == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'keyspace' was not present! Struct: " + toString());
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_keyspace_result implements org.apache.thrift.TBase<describe_keyspace_result, describe_keyspace_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_keyspace_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField NFE_FIELD_DESC = new org.apache.thrift.protocol.TField("nfe", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    public KsDef success; // required
    public NotFoundException nfe; // required
    public InvalidRequestException ire; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      NFE((short)1, "nfe"),
      IRE((short)2, "ire");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // NFE
            return NFE;
          case 2: // IRE
            return IRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, KsDef.class)));
      tmpMap.put(_Fields.NFE, new org.apache.thrift.meta_data.FieldMetaData("nfe", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_keyspace_result.class, metaDataMap);
    }

    public describe_keyspace_result() {
    }

    public describe_keyspace_result(
      KsDef success,
      NotFoundException nfe,
      InvalidRequestException ire)
    {
      this();
      this.success = success;
      this.nfe = nfe;
      this.ire = ire;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_keyspace_result(describe_keyspace_result other) {
      if (other.isSetSuccess()) {
        this.success = new KsDef(other.success);
      }
      if (other.isSetNfe()) {
        this.nfe = new NotFoundException(other.nfe);
      }
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
    }

    public describe_keyspace_result deepCopy() {
      return new describe_keyspace_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.nfe = null;
      this.ire = null;
    }

    public KsDef getSuccess() {
      return this.success;
    }

    public describe_keyspace_result setSuccess(KsDef success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public NotFoundException getNfe() {
      return this.nfe;
    }

    public describe_keyspace_result setNfe(NotFoundException nfe) {
      this.nfe = nfe;
      return this;
    }

    public void unsetNfe() {
      this.nfe = null;
    }

    /** Returns true if field nfe is set (has been assigned a value) and false otherwise */
    public boolean isSetNfe() {
      return this.nfe != null;
    }

    public void setNfeIsSet(boolean value) {
      if (!value) {
        this.nfe = null;
      }
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public describe_keyspace_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((KsDef)value);
        }
        break;

      case NFE:
        if (value == null) {
          unsetNfe();
        } else {
          setNfe((NotFoundException)value);
        }
        break;

      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case NFE:
        return getNfe();

      case IRE:
        return getIre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case NFE:
        return isSetNfe();
      case IRE:
        return isSetIre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_keyspace_result)
        return this.equals((describe_keyspace_result)that);
      return false;
    }

    public boolean equals(describe_keyspace_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_nfe = true && this.isSetNfe();
      boolean that_present_nfe = true && that.isSetNfe();
      if (this_present_nfe || that_present_nfe) {
        if (!(this_present_nfe && that_present_nfe))
          return false;
        if (!this.nfe.equals(that.nfe))
          return false;
      }

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
        if (!this.ire.equals(that.ire))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_nfe = true && (isSetNfe());
      builder.append(present_nfe);
      if (present_nfe)
        builder.append(nfe);

      boolean present_ire = true && (isSetIre());
      builder.append(present_ire);
      if (present_ire)
        builder.append(ire);

      return builder.toHashCode();
    }

    public int compareTo(describe_keyspace_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_keyspace_result typedOther = (describe_keyspace_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNfe()).compareTo(typedOther.isSetNfe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNfe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nfe, typedOther.nfe);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIre()).compareTo(typedOther.isSetIre());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIre()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ire, typedOther.ire);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.success = new KsDef();
              this.success.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // NFE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.nfe = new NotFoundException();
              this.nfe.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // IRE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.ire = new InvalidRequestException();
              this.ire.read(iprot);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        this.success.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetNfe()) {
        oprot.writeFieldBegin(NFE_FIELD_DESC);
        this.nfe.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetIre()) {
        oprot.writeFieldBegin(IRE_FIELD_DESC);
        this.ire.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_keyspace_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("nfe:");
      if (this.nfe == null) {
        sb.append("null");
      } else {
        sb.append(this.nfe);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ire:");
      if (this.ire == null) {
        sb.append("null");
      } else {
        sb.append(this.ire);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_splits_args implements org.apache.thrift.TBase<describe_splits_args, describe_splits_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_splits_args");

    private static final org.apache.thrift.protocol.TField CF_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("cfName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField START_TOKEN_FIELD_DESC = new org.apache.thrift.protocol.TField("start_token", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField END_TOKEN_FIELD_DESC = new org.apache.thrift.protocol.TField("end_token", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField KEYS_PER_SPLIT_FIELD_DESC = new org.apache.thrift.protocol.TField("keys_per_split", org.apache.thrift.protocol.TType.I32, (short)4);

    public String cfName; // required
    public String start_token; // required
    public String end_token; // required
    public int keys_per_split; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CF_NAME((short)1, "cfName"),
      START_TOKEN((short)2, "start_token"),
      END_TOKEN((short)3, "end_token"),
      KEYS_PER_SPLIT((short)4, "keys_per_split");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // CF_NAME
            return CF_NAME;
          case 2: // START_TOKEN
            return START_TOKEN;
          case 3: // END_TOKEN
            return END_TOKEN;
          case 4: // KEYS_PER_SPLIT
            return KEYS_PER_SPLIT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __KEYS_PER_SPLIT_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CF_NAME, new org.apache.thrift.meta_data.FieldMetaData("cfName", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.START_TOKEN, new org.apache.thrift.meta_data.FieldMetaData("start_token", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.END_TOKEN, new org.apache.thrift.meta_data.FieldMetaData("end_token", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.KEYS_PER_SPLIT, new org.apache.thrift.meta_data.FieldMetaData("keys_per_split", org.apache.thrift.TFieldRequirementType.REQUIRED,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_splits_args.class, metaDataMap);
    }

    public describe_splits_args() {
    }

    public describe_splits_args(
      String cfName,
      String start_token,
      String end_token,
      int keys_per_split)
    {
      this();
      this.cfName = cfName;
      this.start_token = start_token;
      this.end_token = end_token;
      this.keys_per_split = keys_per_split;
      setKeys_per_splitIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_splits_args(describe_splits_args other) {
      __isset_bit_vector.clear();
      __isset_bit_vector.or(other.__isset_bit_vector);
      if (other.isSetCfName()) {
        this.cfName = other.cfName;
      }
      if (other.isSetStart_token()) {
        this.start_token = other.start_token;
      }
      if (other.isSetEnd_token()) {
        this.end_token = other.end_token;
      }
      this.keys_per_split = other.keys_per_split;
    }

    public describe_splits_args deepCopy() {
      return new describe_splits_args(this);
    }

    @Override
    public void clear() {
      this.cfName = null;
      this.start_token = null;
      this.end_token = null;
      setKeys_per_splitIsSet(false);
      this.keys_per_split = 0;
    }

    public String getCfName() {
      return this.cfName;
    }

    public describe_splits_args setCfName(String cfName) {
      this.cfName = cfName;
      return this;
    }

    public void unsetCfName() {
      this.cfName = null;
    }

    /** Returns true if field cfName is set (has been assigned a value) and false otherwise */
    public boolean isSetCfName() {
      return this.cfName != null;
    }

    public void setCfNameIsSet(boolean value) {
      if (!value) {
        this.cfName = null;
      }
    }

    public String getStart_token() {
      return this.start_token;
    }

    public describe_splits_args setStart_token(String start_token) {
      this.start_token = start_token;
      return this;
    }

    public void unsetStart_token() {
      this.start_token = null;
    }

    /** Returns true if field start_token is set (has been assigned a value) and false otherwise */
    public boolean isSetStart_token() {
      return this.start_token != null;
    }

    public void setStart_tokenIsSet(boolean value) {
      if (!value) {
        this.start_token = null;
      }
    }

    public String getEnd_token() {
      return this.end_token;
    }

    public describe_splits_args setEnd_token(String end_token) {
      this.end_token = end_token;
      return this;
    }

    public void unsetEnd_token() {
      this.end_token = null;
    }

    /** Returns true if field end_token is set (has been assigned a value) and false otherwise */
    public boolean isSetEnd_token() {
      return this.end_token != null;
    }

    public void setEnd_tokenIsSet(boolean value) {
      if (!value) {
        this.end_token = null;
      }
    }

    public int getKeys_per_split() {
      return this.keys_per_split;
    }

    public describe_splits_args setKeys_per_split(int keys_per_split) {
      this.keys_per_split = keys_per_split;
      setKeys_per_splitIsSet(true);
      return this;
    }

    public void unsetKeys_per_split() {
      __isset_bit_vector.clear(__KEYS_PER_SPLIT_ISSET_ID);
    }

    /** Returns true if field keys_per_split is set (has been assigned a value) and false otherwise */
    public boolean isSetKeys_per_split() {
      return __isset_bit_vector.get(__KEYS_PER_SPLIT_ISSET_ID);
    }

    public void setKeys_per_splitIsSet(boolean value) {
      __isset_bit_vector.set(__KEYS_PER_SPLIT_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CF_NAME:
        if (value == null) {
          unsetCfName();
        } else {
          setCfName((String)value);
        }
        break;

      case START_TOKEN:
        if (value == null) {
          unsetStart_token();
        } else {
          setStart_token((String)value);
        }
        break;

      case END_TOKEN:
        if (value == null) {
          unsetEnd_token();
        } else {
          setEnd_token((String)value);
        }
        break;

      case KEYS_PER_SPLIT:
        if (value == null) {
          unsetKeys_per_split();
        } else {
          setKeys_per_split((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CF_NAME:
        return getCfName();

      case START_TOKEN:
        return getStart_token();

      case END_TOKEN:
        return getEnd_token();

      case KEYS_PER_SPLIT:
        return Integer.valueOf(getKeys_per_split());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CF_NAME:
        return isSetCfName();
      case START_TOKEN:
        return isSetStart_token();
      case END_TOKEN:
        return isSetEnd_token();
      case KEYS_PER_SPLIT:
        return isSetKeys_per_split();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_splits_args)
        return this.equals((describe_splits_args)that);
      return false;
    }

    public boolean equals(describe_splits_args that) {
      if (that == null)
        return false;

      boolean this_present_cfName = true && this.isSetCfName();
      boolean that_present_cfName = true && that.isSetCfName();
      if (this_present_cfName || that_present_cfName) {
        if (!(this_present_cfName && that_present_cfName))
          return false;
        if (!this.cfName.equals(that.cfName))
          return false;
      }

      boolean this_present_start_token = true && this.isSetStart_token();
      boolean that_present_start_token = true && that.isSetStart_token();
      if (this_present_start_token || that_present_start_token) {
        if (!(this_present_start_token && that_present_start_token))
          return false;
        if (!this.start_token.equals(that.start_token))
          return false;
      }

      boolean this_present_end_token = true && this.isSetEnd_token();
      boolean that_present_end_token = true && that.isSetEnd_token();
      if (this_present_end_token || that_present_end_token) {
        if (!(this_present_end_token && that_present_end_token))
          return false;
        if (!this.end_token.equals(that.end_token))
          return false;
      }

      boolean this_present_keys_per_split = true;
      boolean that_present_keys_per_split = true;
      if (this_present_keys_per_split || that_present_keys_per_split) {
        if (!(this_present_keys_per_split && that_present_keys_per_split))
          return false;
        if (this.keys_per_split != that.keys_per_split)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_cfName = true && (isSetCfName());
      builder.append(present_cfName);
      if (present_cfName)
        builder.append(cfName);

      boolean present_start_token = true && (isSetStart_token());
      builder.append(present_start_token);
      if (present_start_token)
        builder.append(start_token);

      boolean present_end_token = true && (isSetEnd_token());
      builder.append(present_end_token);
      if (present_end_token)
        builder.append(end_token);

      boolean present_keys_per_split = true;
      builder.append(present_keys_per_split);
      if (present_keys_per_split)
        builder.append(keys_per_split);

      return builder.toHashCode();
    }

    public int compareTo(describe_splits_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      describe_splits_args typedOther = (describe_splits_args)other;

      lastComparison = Boolean.valueOf(isSetCfName()).compareTo(typedOther.isSetCfName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCfName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.cfName, typedOther.cfName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetStart_token()).compareTo(typedOther.isSetStart_token());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetStart_token()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.start_token, typedOther.start_token);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEnd_token()).compareTo(typedOther.isSetEnd_token());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEnd_token()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.end_token, typedOther.end_token);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetKeys_per_split()).compareTo(typedOther.isSetKeys_per_split());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKeys_per_split()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.keys_per_split, typedOther.keys_per_split);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (field.id) {
          case 1: // CF_NAME
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.cfName = iprot.readString();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // START_TOKEN
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.start_token = iprot.readString();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // END_TOKEN
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.end_token = iprot.readString();
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4: // KEYS_PER_SPLIT
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.keys_per_split = iprot.readI32();
              setKeys_per_splitIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      if (!isSetKeys_per_split()) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'keys_per_split' was not found in serialized data! Struct: " + toString());
      }
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.cfName != null) {
        oprot.writeFieldBegin(CF_NAME_FIELD_DESC);
        oprot.writeString(this.cfName);
        oprot.writeFieldEnd();
      }
      if (this.start_token != null) {
        oprot.writeFieldBegin(START_TOKEN_FIELD_DESC);
        oprot.writeString(this.start_token);
        oprot.writeFieldEnd();
      }
      if (this.end_token != null) {
        oprot.writeFieldBegin(END_TOKEN_FIELD_DESC);
        oprot.writeString(this.end_token);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldBegin(KEYS_PER_SPLIT_FIELD_DESC);
      oprot.writeI32(this.keys_per_split);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("describe_splits_args(");
      boolean first = true;

      sb.append("cfName:");
      if (this.cfName == null) {
        sb.append("null");
      } else {
        sb.append(this.cfName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("start_token:");
      if (this.start_token == null) {
        sb.append("null");
      } else {
        sb.append(this.start_token);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("end_token:");
      if (this.end_token == null) {
        sb.append("null");
      } else {
        sb.append(this.end_token);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("keys_per_split:");
      sb.append(this.keys_per_split);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (cfName == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'cfName' was not present! Struct: " + toString());
      }
      if (start_token == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'start_token' was not present! Struct: " + toString());
      }
      if (end_token == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'end_token' was not present! Struct: " + toString());
      }
      // alas, we cannot check 'keys_per_split' because it's a primitive and you chose the non-beans generator.
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bit_vector = new BitSet(1);
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class describe_splits_result implements org.apache.thrift.TBase<describe_splits_result, describe_splits_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("describe_splits_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IRE_FIELD_DESC = new org.apache.thrift.protocol.TField("ire", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public List<String> success; // required
    public InvalidRequestException ire; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IRE((short)1, "ire");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IRE
            return IRE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST,
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      tmpMap.put(_Fields.IRE, new org.apache.thrift.meta_data.FieldMetaData("ire", org.apache.thrift.TFieldRequirementType.DEFAULT,
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(describe_splits_result.class, metaDataMap);
    }

    public describe_splits_result() {
    }

    public describe_splits_result(
      List<String> success,
      InvalidRequestException ire)
    {
      this();
      this.success = success;
      this.ire = ire;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public describe_splits_result(describe_splits_result other) {
      if (other.isSetSuccess()) {
        List<String> __this__success = new ArrayList<String>();
        for (String other_element : other.success) {
          __this__success.add(other_element);
        }
        this.success = __this__success;
      }
      if (other.isSetIre()) {
        this.ire = new InvalidRequestException(other.ire);
      }
    }

    public describe_splits_result deepCopy() {
      return new describe_splits_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.ire = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<String> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(String elem) {
      if (this.success == null) {
        this.success = new ArrayList<String>();
      }
      this.success.add(elem);
    }

    public List<String> getSuccess() {
      return this.success;
    }

    public describe_splits_result setSuccess(List<String> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidRequestException getIre() {
      return this.ire;
    }

    public describe_splits_result setIre(InvalidRequestException ire) {
      this.ire = ire;
      return this;
    }

    public void unsetIre() {
      this.ire = null;
    }

    /** Returns true if field ire is set (has been assigned a value) and false otherwise */
    public boolean isSetIre() {
      return this.ire != null;
    }

    public void setIreIsSet(boolean value) {
      if (!value) {
        this.ire = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<String>)value);
        }
        break;

      case IRE:
        if (value == null) {
          unsetIre();
        } else {
          setIre((InvalidRequestException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IRE:
        return getIre();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IRE:
        return isSetIre();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof describe_splits_result)
        return this.equals((describe_splits_result)that);
      return false;
    }

    public boolean equals(describe_splits_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ire = true && this.isSetIre();
      boolean that_present_ire = true && that.isSetIre();
      if (this_present_ire || that_present_ire) {
        if (!(this_present_ire && that_present_ire))
          return false;
  