/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.mail.PasswordAuthentication;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.axis2.transport.mail.EMailSender;
import org.apache.axis2.transport.mail.MailBasedOutTransportInfo;
import org.apache.axis2.util.Utils;

public class MailTransportSender
extends AbstractHandler
implements TransportSender {
    private final Properties smtpProperties = new Properties();
    private PasswordAuthentication passwordAuthentication;
    private ByteArrayOutputStream byteArrayOutputStream;
    private static final String NAME = "MailTransportSender";

    public MailTransportSender() {
        this.init(new HandlerDescription(NAME));
    }

    public void init(ConfigurationContext configurationContext, TransportOutDescription transportOut) throws AxisFault {
        ArrayList mailParameters = transportOut.getParameters();
        String password = "";
        String username = "";
        Iterator iterator = mailParameters.iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            String paramKey = param.getName();
            String paramValue = Utils.getParameterValue(param);
            if (paramKey == null || paramValue == null) {
                throw new AxisFault(Messages.getMessage("canNotBeNull", "Parameter name and value"));
            }
            this.smtpProperties.setProperty(paramKey, paramValue);
            if (paramKey.equals("mail.smtp.user")) {
                username = paramValue;
            }
            if (!paramKey.equals("transport.mail.smtp.password")) continue;
            password = paramValue;
        }
        this.passwordAuthentication = new PasswordAuthentication(username, password);
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    private void mailProperties(MessageContext msgContext) {
        Object obj = msgContext.getProperty("_MAIL_SMTP_");
        if (obj != null) {
            if (obj instanceof HttpTransportProperties.MailProperties) {
                HttpTransportProperties.MailProperties props = (HttpTransportProperties.MailProperties)obj;
                this.smtpProperties.clear();
                this.smtpProperties.putAll((Map<?, ?>)props.getProperties());
                String username = (String)this.smtpProperties.get("mail.smtp.user");
                String passwd = props.getPassword();
                this.passwordAuthentication = new PasswordAuthentication(username, passwd);
            } else if (obj instanceof Properties) {
                this.smtpProperties.clear();
                Properties props = (Properties)obj;
                this.smtpProperties.putAll((Map<?, ?>)props);
            }
        }
    }

    public void sendMimeMessage(MessageContext msgContext) throws AxisFault {
        try {
            this.mailProperties(msgContext);
            EMailSender sender = new EMailSender();
            sender.setOutputStream(this.byteArrayOutputStream);
            sender.setMessageContext(msgContext);
            sender.setProperties(this.smtpProperties);
            sender.setPasswordAuthentication(this.passwordAuthentication);
            String charSet = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
            if (charSet == null) {
                charSet = "UTF-8";
            }
            OMOutputFormat format = new OMOutputFormat();
            format.setSOAP11(msgContext.isSOAP11());
            format.setCharSetEncoding(charSet);
            OutTransportInfo transportInfo = (OutTransportInfo)msgContext.getProperty("OutTransportInfo");
            if (transportInfo != null && transportInfo instanceof MailBasedOutTransportInfo) {
                MailBasedOutTransportInfo mailTransportInfo = (MailBasedOutTransportInfo)transportInfo;
                sender.setInReplyTo(mailTransportInfo.getInReplyTo());
                sender.setFrom(mailTransportInfo.getFrom());
            }
            sender.setFormat(format);
            sender.send();
        }
        catch (IOException e) {
            throw new AxisFault(e.getMessage(), e);
        }
    }

    public void writeMimeMessage(MessageContext msgContext, OutputStream out) throws AxisFault {
        try {
            OMOutputFormat format = new OMOutputFormat();
            MessageFormatter messageFormatter = TransportUtils.getMessageFormatter(msgContext);
            format.setDoOptimize(msgContext.isDoingMTOM());
            format.setCharSetEncoding(null);
            messageFormatter.writeTo(msgContext, format, out, false);
            out.flush();
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), e);
        }
    }

    public void stop() {
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
        msgContext.setDoingSwA(HTTPTransportUtils.doWriteSwA(msgContext));
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeMimeMessage(msgContext, this.byteArrayOutputStream);
        this.sendMimeMessage(msgContext);
        return Handler.InvocationResponse.CONTINUE;
    }
}

