/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class EMailSender {
    private Properties properties;
    private MessageContext messageContext;
    private PasswordAuthentication passwordAuthentication;

    public void setMessageContext(MessageContext messageContext) {
        this.messageContext = messageContext;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setPasswordAuthentication(PasswordAuthentication passwordAuthentication) {
        this.passwordAuthentication = passwordAuthentication;
    }

    public void send(String subject, String targetEmail, String message, OMOutputFormat format) throws AxisFault {
        try {
            String contentType;
            Session session = Session.getInstance((Properties)this.properties, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return EMailSender.this.passwordAuthentication;
                }
            });
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(this.passwordAuthentication.getUserName()));
            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(targetEmail));
            msg.setSubject(subject);
            String string = contentType = format.getContentType() != null ? format.getContentType() : "text/xml";
            if (contentType.indexOf("text/xml") > -1 && this.messageContext.getSoapAction() != null) {
                msg.setHeader("mail.soapaction", this.messageContext.getSoapAction());
                msg.setHeader("Content-Transfer-Encoding", "QUOTED-PRINTABLE");
            }
            if (contentType.indexOf("application/soap+xml") > -1) {
                if (this.messageContext.getSoapAction() != null) {
                    msg.setContent((Object)message, contentType + "; charset=" + format.getCharSetEncoding() + " ; action=" + this.messageContext.getSoapAction());
                }
            } else {
                msg.setContent((Object)message, contentType + "; charset=" + format.getCharSetEncoding());
            }
            Transport.send((Message)msg);
        }
        catch (AddressException e) {
            throw new AxisFault(e);
        }
        catch (MessagingException e) {
            throw new AxisFault(e);
        }
    }
}

