/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;

public class HTTPTransportUtils {
    public static SOAPEnvelope createEnvelopeFromGetRequest(String requestUrl, Map map, ConfigurationContext configCtx) throws AxisFault {
        String[] values = Utils.parseRequestURLForServiceAndOperation(requestUrl, configCtx.getServiceContextPath());
        if (values == null) {
            return new SOAP11Factory().getDefaultEnvelope();
        }
        if (values[1] != null && values[0] != null) {
            String srvice = values[0];
            AxisService service = configCtx.getAxisConfiguration().getService(srvice);
            if (service == null) {
                throw new AxisFault("service not found: " + srvice);
            }
            String operation = values[1];
            SOAP11Factory soapFactory = new SOAP11Factory();
            SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
            OMNamespace omNs = soapFactory.createOMNamespace(service.getSchematargetNamespace(), service.getSchematargetNamespacePrefix());
            soapFactory.createOMNamespace(service.getSchematargetNamespace(), service.getSchematargetNamespacePrefix());
            OMElement opElement = soapFactory.createOMElement(operation, omNs);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                String value = (String)map.get(name);
                OMElement omEle = soapFactory.createOMElement(name, omNs);
                omEle.setText(value);
                opElement.addChild((OMNode)omEle);
            }
            envelope.getBody().addChild((OMNode)opElement);
            return envelope;
        }
        return null;
    }

    public static boolean doWriteMTOM(MessageContext msgContext) {
        boolean enableMTOM = false;
        if (msgContext.getParameter("enableMTOM") != null) {
            enableMTOM = JavaUtils.isTrueExplicitly(msgContext.getParameter("enableMTOM").getValue());
        }
        if (msgContext.getProperty("enableMTOM") != null) {
            enableMTOM = JavaUtils.isTrueExplicitly(msgContext.getProperty("enableMTOM"));
        }
        return enableMTOM;
    }

    public static boolean doWriteSwA(MessageContext msgContext) {
        boolean enableSwA = false;
        if (msgContext.getParameter("enableSwA") != null) {
            enableSwA = JavaUtils.isTrueExplicitly(msgContext.getParameter("enableSwA").getValue());
        }
        if (msgContext.getProperty("enableSwA") != null) {
            enableSwA = JavaUtils.isTrueExplicitly(msgContext.getProperty("enableSwA"));
        }
        return enableSwA;
    }

    public static boolean processHTTPGetRequest(MessageContext msgContext, OutputStream out, String soapAction, String requestURI, ConfigurationContext configurationContext, Map requestParameters) throws AxisFault {
        if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        msgContext.setSoapAction(soapAction);
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setProperty("TRANSPORT_OUT", out);
        msgContext.setServerSide(true);
        SOAPEnvelope envelope = HTTPTransportUtils.createEnvelopeFromGetRequest(requestURI, requestParameters, configurationContext);
        if (envelope == null) {
            return false;
        }
        msgContext.setDoingREST(true);
        msgContext.setEnvelope(envelope);
        AxisEngine engine = new AxisEngine(configurationContext);
        engine.receive(msgContext);
        return true;
    }

    public static void processHTTPPostRequest(MessageContext msgContext, InputStream in, OutputStream out, String contentType, String soapActionHeader, String requestURI) throws AxisFault {
        boolean soap11 = false;
        try {
            String charsetEncoding;
            XMLStreamReader xmlreader;
            Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
            if (headers != null && ("gzip".equals(headers.get("Content-Encoding")) || "gzip".equals(headers.get("Content-Encoding".toLowerCase())))) {
                in = new GZIPInputStream(in);
            }
            if (soapActionHeader != null && soapActionHeader.startsWith("\"") && soapActionHeader.endsWith("\"")) {
                soapActionHeader = soapActionHeader.substring(1, soapActionHeader.length() - 1);
            }
            msgContext.setSoapAction(soapActionHeader);
            msgContext.setTo(new EndpointReference(requestURI));
            msgContext.setProperty("TRANSPORT_OUT", out);
            msgContext.setServerSide(true);
            SOAPEnvelope envelope = null;
            StAXBuilder builder = null;
            if (contentType != null) {
                if (contentType.toLowerCase().indexOf("multipart/related") > -1) {
                    builder = TransportUtils.selectBuilderForMIME(msgContext, in, contentType, true);
                    envelope = (SOAPEnvelope)builder.getDocumentElement();
                } else {
                    if (TransportUtils.getCharSetEncoding(contentType) == null) {
                        xmlreader = StAXUtils.createXMLStreamReader((InputStream)in, (String)"UTF-8");
                        msgContext.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
                    } else {
                        String charSetEnc = TransportUtils.getCharSetEncoding(contentType);
                        xmlreader = StAXUtils.createXMLStreamReader((InputStream)in, (String)charSetEnc);
                        msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
                    }
                    if (contentType.indexOf("application/soap+xml") > -1) {
                        soap11 = false;
                        int index = contentType.indexOf("action");
                        if (index > -1) {
                            String transientString = contentType.substring(index, contentType.length());
                            int equal = transientString.indexOf("=");
                            int firstSemiColon = transientString.indexOf(";");
                            String soapAction = firstSemiColon > -1 ? transientString.substring(equal + 1, firstSemiColon) : transientString.substring(equal + 1, transientString.length());
                            if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
                                soapAction = soapAction.substring(1, soapAction.length() - 1);
                            }
                            msgContext.setSoapAction(soapAction);
                        }
                        builder = new StAXSOAPModelBuilder(xmlreader, "http://www.w3.org/2003/05/soap-envelope");
                        envelope = (SOAPEnvelope)builder.getDocumentElement();
                    } else if (contentType.indexOf("text/xml") > -1) {
                        soap11 = true;
                        Parameter enable = msgContext.getParameter("enableREST");
                        if (soapActionHeader == null && enable != null) {
                            if ("true".equals(enable.getValue())) {
                                msgContext.setDoingREST(true);
                                SOAP11Factory soapFactory = new SOAP11Factory();
                                builder = new StAXOMBuilder(xmlreader);
                                builder.setOMBuilderFactory((OMFactory)soapFactory);
                                envelope = soapFactory.getDefaultEnvelope();
                                envelope.getBody().addChild((OMNode)builder.getDocumentElement());
                            }
                        } else {
                            builder = new StAXSOAPModelBuilder(xmlreader, "http://schemas.xmlsoap.org/soap/envelope/");
                            envelope = (SOAPEnvelope)builder.getDocumentElement();
                        }
                    }
                }
            }
            if (builder == null) {
                xmlreader = StAXUtils.createXMLStreamReader((InputStream)in, (String)"UTF-8");
                msgContext.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
                builder = new StAXSOAPModelBuilder(xmlreader, "http://schemas.xmlsoap.org/soap/envelope/");
                envelope = (SOAPEnvelope)builder.getDocumentElement();
            }
            if ((charsetEncoding = builder.getDocument().getCharsetEncoding()) != null && !"".equals(charsetEncoding) && !charsetEncoding.equalsIgnoreCase((String)msgContext.getProperty("CHARACTER_SET_ENCODING"))) {
                String faultCode = "http://www.w3.org/2003/05/soap-envelope".equals(envelope.getNamespace().getNamespaceURI()) ? "Sender" : "Client";
                throw new AxisFault("Character Set Encoding from transport information do not match with character set encoding in the received SOAP message", faultCode);
            }
            msgContext.setEnvelope(envelope);
            AxisEngine engine = new AxisEngine(msgContext.getConfigurationContext());
            if (envelope.getBody().hasFault()) {
                engine.receiveFault(msgContext);
            } else {
                engine.receive(msgContext);
            }
        }
        catch (SOAPProcessingException e) {
            throw new AxisFault(e);
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
        catch (OMException e) {
            throw new AxisFault(e);
        }
        catch (XMLStreamException e) {
            throw new AxisFault(e);
        }
        catch (FactoryConfigurationError e) {
            throw new AxisFault(e);
        }
        finally {
            if (msgContext.getEnvelope() == null && !soap11) {
                msgContext.setEnvelope(new SOAP12Factory().getDefaultEnvelope());
            }
        }
    }

    public static boolean isDoingREST(MessageContext msgContext) {
        boolean enableREST = false;
        if (msgContext.isDoingREST()) {
            return true;
        }
        Object enableRESTProperty = msgContext.getProperty("enableREST");
        if (enableRESTProperty != null) {
            enableREST = JavaUtils.isTrueExplicitly(enableRESTProperty);
        }
        msgContext.setDoingREST(enableREST);
        return enableREST;
    }
}

