/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;

public class ServiceContext
extends AbstractContext {
    public static final String SERVICE_OBJECT = "serviceObject";
    private EndpointReference targetEPR;
    private EndpointReference myEPR;
    private transient AxisService axisService;
    private ServiceGroupContext serviceGroupContext;
    private ConfigurationContext configContext;

    public ServiceContext(AxisService serviceConfig, ServiceGroupContext serviceGroupContext) {
        super(serviceGroupContext);
        this.serviceGroupContext = serviceGroupContext;
        this.axisService = serviceConfig;
        this.configContext = (ConfigurationContext)this.parent.getParent();
    }

    public OperationContext createOperationContext(QName name) {
        AxisOperation axisOp = this.axisService.getOperation(name);
        return new OperationContext(axisOp, this);
    }

    public AxisService getAxisService() {
        return this.axisService;
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configContext;
    }

    public ServiceGroupContext getServiceGroupContext() {
        return this.serviceGroupContext;
    }

    public EndpointReference getMyEPR(String transport) throws AxisFault {
        this.axisService.isEnableAllTransports();
        ConfigurationContext configctx = this.configContext;
        if (configctx != null) {
            ListenerManager lm = configctx.getListenerManager();
            if (!lm.isListenerRunning(transport)) {
                TransportInDescription trsin = configctx.getAxisConfiguration().getTransportIn(new QName(transport));
                if (trsin != null) {
                    lm.addListener(trsin, false);
                } else {
                    throw new AxisFault(Messages.getMessage("transportnotfound", transport));
                }
            }
            if (!lm.isStopped()) {
                return lm.getEPRforService(this.axisService.getName(), null, transport);
            }
        }
        return null;
    }

    public EndpointReference getTargetEPR() {
        return this.targetEPR;
    }

    public void setTargetEPR(EndpointReference targetEPR) {
        this.targetEPR = targetEPR;
    }

    public EndpointReference getMyEPR() {
        if (this.myEPR == null) {
            try {
                if (ListenerManager.defaultConfigurationContext != null) {
                    ListenerManager listenerManager = ListenerManager.defaultConfigurationContext.getListenerManager();
                    this.myEPR = listenerManager.getEPRforService(this.axisService.getName(), null, null);
                }
            }
            catch (AxisFault axisFault) {
                this.myEPR = null;
            }
        }
        return this.myEPR;
    }

    public void setMyEPR(EndpointReference myEPR) {
        this.myEPR = myEPR;
    }
}

