/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.https;

import java.io.IOException;
import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.transport.http.HttpClientTransport;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpsClientTransport
extends HttpClientTransport {
    public HttpsClientTransport(TextWireFormat wireFormat, URI remoteUrl) {
        super(wireFormat, remoteUrl);
    }

    @Override
    protected HttpClientConnectionManager createClientConnectionManager() {
        return new PoolingHttpClientConnectionManager(this.createRegistry());
    }

    private Registry<ConnectionSocketFactory> createRegistry() {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        try {
            SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(this.createSocketFactory(), (HostnameVerifier)new DefaultHostnameVerifier());
            registryBuilder.register("https", (Object)sslConnectionFactory);
            return registryBuilder.build();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failure trying to create scheme registry", e);
        }
    }

    protected SSLSocketFactory createSocketFactory() throws IOException {
        if (SslContext.getCurrentSslContext() != null) {
            SslContext ctx = SslContext.getCurrentSslContext();
            try {
                return ctx.getSSLContext().getSocketFactory();
            }
            catch (Exception e) {
                throw IOExceptionSupport.create((Exception)e);
            }
        }
        return (SSLSocketFactory)SSLSocketFactory.getDefault();
    }
}

