/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import nl.knaw.dans.common.dbflib.CorruptedTableException;
import nl.knaw.dans.common.dbflib.IfNonExistent;
import nl.knaw.dans.common.dbflib.Util;
import nl.knaw.dans.common.dbflib.Version;

class Memo {
    private static final int OFFSET_NEXT_AVAILABLE_BLOCK_INDEX = 0;
    private static final int OFFSET_BLOCK_SIZE = 20;
    private static final int DEFAULT_LENGTH_MEMO_BLOCK = 512;
    private static final int LENGTH_FILE_NAME = 8;
    private static final byte MARKER_MEMO_END = 26;
    private final File memoFile;
    private RandomAccessFile raf = null;
    private int nextAvailableBlock = 0;
    private int blockLength = 512;
    private final Version version;

    Memo(File memoFile, Version version) throws IllegalArgumentException {
        if (memoFile == null) {
            throw new IllegalArgumentException("Memo file must not be null");
        }
        this.memoFile = memoFile;
        this.version = version;
    }

    void open(IfNonExistent ifNonExistent) throws IOException {
        if (this.memoFile.exists()) {
            this.raf = new RandomAccessFile(this.memoFile, "rw");
            if (this.version == Version.FOXPRO_26) {
                this.raf.skipBytes(4);
                this.blockLength = this.raf.readInt();
            }
        } else if (ifNonExistent.isCreate()) {
            this.raf = new RandomAccessFile(this.memoFile, "rw");
            this.nextAvailableBlock = this.version == Version.CLIPPER_5 ? 2 : 1;
            this.writeMemoHeader();
        } else if (ifNonExistent.isError()) {
            throw new FileNotFoundException("Cannot find memo file");
        }
    }

    void close() throws IOException {
        if (this.raf == null) {
            return;
        }
        this.raf.close();
    }

    void delete() throws IOException {
        this.close();
        this.memoFile.delete();
    }

    byte[] readMemo(int blockIndex) throws IOException, CorruptedTableException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int memoLength = 0;
        int c = 0;
        this.raf.seek(blockIndex * this.blockLength);
        switch (this.version) {
            case DBASE_3: 
            case CLIPPER_5: {
                while ((c = this.raf.read()) != 26) {
                    if (c == -1) {
                        throw new CorruptedTableException("Corrupted memo file, EOF exception");
                    }
                    bos.write(c);
                }
                break;
            }
            case DBASE_4: 
            case DBASE_5: 
            case FOXPRO_26: {
                this.raf.skipBytes(4);
                memoLength = this.version == Version.FOXPRO_26 ? this.raf.readInt() : Util.changeEndianness(this.raf.readInt()) - this.version.getMemoDataOffset();
                for (int i = 0; i < memoLength; ++i) {
                    c = this.raf.read();
                    if (c == -1) {
                        throw new CorruptedTableException("Corrupted memo file, EOF exception");
                    }
                    bos.write(c);
                }
                break;
            }
            default: {
                assert (false) : "Programming error, did not handle version " + this.version.toString();
                break;
            }
        }
        return bos.toByteArray();
    }

    int writeMemo(byte[] memoBytes) throws IOException {
        int nrBytesToWrite = memoBytes.length + this.version.getMemoFieldEndMarkerLength() + this.version.getMemoDataOffset();
        int nrBlocksToWrite = nrBytesToWrite / this.blockLength + 1;
        int nrSpacesToPadLastBlock = this.blockLength - nrBytesToWrite % this.blockLength;
        if (nrSpacesToPadLastBlock == this.blockLength) {
            nrSpacesToPadLastBlock = -this.blockLength;
            --nrBlocksToWrite;
        }
        int blockIndex = this.nextAvailableBlock;
        this.raf.seek(blockIndex * this.blockLength);
        if (this.version == Version.DBASE_4 || this.version == Version.DBASE_5) {
            this.raf.writeInt(-63488);
            this.raf.writeInt(Util.changeEndianness(memoBytes.length + this.version.getMemoDataOffset()));
        } else if (this.version == Version.FOXPRO_26) {
            this.raf.writeInt(1);
            this.raf.writeInt(memoBytes.length);
        }
        this.raf.write(memoBytes);
        if (this.version.getMemoFieldEndMarkerLength() != 0) {
            if (this.version.getMemoFieldEndMarkerLength() == 1) {
                this.raf.writeByte(this.version.getMemoFieldEndMarker());
            } else {
                this.raf.writeShort(this.version.getMemoFieldEndMarker());
            }
        }
        for (int i = 0; i < nrSpacesToPadLastBlock; ++i) {
            this.raf.writeByte(0);
        }
        this.raf.seek(0L);
        this.nextAvailableBlock += nrBlocksToWrite;
        if (this.version == Version.FOXPRO_26) {
            this.raf.writeInt(this.nextAvailableBlock);
        } else {
            this.raf.writeInt(Util.changeEndianness(this.nextAvailableBlock));
        }
        return blockIndex;
    }

    private void writeMemoHeader() throws IOException {
        this.raf.writeInt(0);
        if (this.version == Version.FOXPRO_26) {
            this.raf.writeInt(this.blockLength);
        } else {
            this.raf.writeInt(0);
        }
        Util.writeString(this.raf, Util.stripExtension(this.memoFile.getName()).toUpperCase(), 8);
        if (this.version == Version.DBASE_4 || this.version == Version.DBASE_5) {
            this.raf.writeByte(0);
            this.raf.writeByte(0);
            this.raf.writeByte(2);
            this.raf.writeByte(1);
            this.raf.writeShort(Util.changeEndianness((short)this.blockLength));
        } else {
            this.raf.writeByte(0);
            this.raf.writeByte(0);
            this.raf.writeByte(0);
            this.raf.writeByte(0);
            this.raf.writeShort(0);
        }
        for (int i = 22; i < this.blockLength; ++i) {
            this.raf.writeByte(0);
        }
    }
}

