/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import nl.knaw.dans.common.dbflib.DataFormatValidatorFactory;
import nl.knaw.dans.common.dbflib.DataValidator;
import nl.knaw.dans.common.dbflib.DbfLibException;
import nl.knaw.dans.common.dbflib.Type;

public class Field {
    private final String name;
    private final Type type;
    private final int length;
    private final int decimalCount;
    private final DataValidator validator;

    public Field(String name, Type type) {
        this(name, type, 1, 0);
    }

    public Field(String name, Type type, int length) {
        this(name, type, length, 0);
    }

    public Field(String name, Type type, int length, int decimalCount) {
        this.name = name;
        this.type = type;
        this.length = type.getLength() == -1 ? length : type.getLength();
        this.decimalCount = decimalCount;
        this.validator = DataFormatValidatorFactory.createValidator(this);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int getDecimalCount() {
        return this.decimalCount;
    }

    void validateTypedValue(Object aTypedValue) throws DbfLibException {
        this.validator.validate(aTypedValue);
    }

    public boolean equals(Object other) {
        if (other instanceof Field) {
            Field otherField = (Field)other;
            return this.decimalCount == otherField.decimalCount && this.length == otherField.length && this.name.equals(otherField.name) && this.type == otherField.type;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() / 2 + this.type.hashCode() / 2;
    }
}

