/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import nl.knaw.dans.common.dbflib.Field;
import nl.knaw.dans.common.dbflib.Value;
import nl.knaw.dans.common.dbflib.ValueTooLargeException;

public class DateValue
extends Value {
    private static final int RECORD_DATE_LENGTH = 8;
    private static final Format dateFormat = new SimpleDateFormat("yyyyMMdd");

    public DateValue(Date dateValue) {
        super(dateValue);
    }

    DateValue(Field field, byte[] rawValue) {
        super(field, rawValue);
    }

    @Override
    protected Object doGetTypedValue(byte[] rawValue) {
        String yearString = new String(rawValue, 0, 4);
        String monthString = new String(rawValue, 4, 2);
        String dayString = new String(rawValue, 6, 2);
        Calendar cal = Calendar.getInstance();
        if (yearString.trim().isEmpty()) {
            return null;
        }
        int year = Integer.parseInt(yearString);
        int month = Integer.parseInt(monthString) - 1;
        int day = Integer.parseInt(dayString);
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    @Override
    protected byte[] doGetRawValue(Field field) throws ValueTooLargeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        try {
            byteArrayOutputStream.write(dateFormat.format(this.typed).getBytes());
        }
        catch (IOException ioException) {
            assert (false) : "Writing to ByteArrayOutputStream should not cause an IOException";
            throw new RuntimeException(ioException);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

