/*
 * Decompiled with CFR 0.152.
 */
package com.formos.tapestry.testify.internal;

import com.formos.tapestry.testify.core.ForComponents;
import com.formos.tapestry.testify.internal.ObjectAccessor;
import com.formos.tapestry.testify.internal.ObjectsForComponentsStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleObjectsForComponentsStore
implements ObjectsForComponentsStore {
    private final Map<String, ObjectAccessor> accessorsById = new HashMap<String, ObjectAccessor>();
    private final Collection<ObjectAccessor> accessors = new ArrayList<ObjectAccessor>();

    @Override
    public void put(ObjectAccessor objectAccessor, String id) {
        if (!"".equals(id)) {
            this.accessorsById.put(id, objectAccessor);
        }
        this.accessors.add(objectAccessor);
    }

    @Override
    public <T> T get(Class<T> type, String id) {
        if ("".equals(id)) {
            return this.getByType(type);
        }
        ObjectAccessor accessor = this.accessorsById.get(id);
        return accessor == null ? null : (T)type.cast(accessor.get());
    }

    private <T> T getByType(Class<T> type) {
        ArrayList<T> candidates = new ArrayList<T>(1);
        for (ObjectAccessor accessor : this.accessors) {
            Object object = accessor.get();
            if (!type.isInstance(object)) continue;
            candidates.add(type.cast(object));
        }
        if (candidates.size() > 1) {
            throw new RuntimeException("Found more than one object marked as @" + ForComponents.class.getSimpleName() + " of type " + type.getName());
        }
        return candidates.isEmpty() ? null : (T)candidates.get(0);
    }
}

