package com.formos.tapestry.testify.internal;

import com.formos.tapestry.testify.core.TestifyConstants;


/**
 * Stores objects that are needed for the duration of a test.
 * 
 * @see TestifyConstants#PERTEST
 */
public interface PerTestDataStore {

    /**
     * Immediately performs a cleanup of the test data.
     */
    void cleanup();


    /**
     * Returns an object stored in the per-test map. When the object is a string, the expected name is <em>service
     * id</em>.<em>subkey</em>. Unlike most of Tapestry, such keys <em>will</em> be case sensitive.
     *
     * @param key key used to retrieve object
     * @return corresponding per-test object, or null
     */
    Object get(Object key);


    /**
     * Stores a value into the per-test map.
     */
    void put(Object key, Object value);
}
