package com.formos.tapestry.testify.core;

import static java.lang.annotation.ElementType.FIELD;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.apache.tapestry5.annotations.Service;
import org.apache.tapestry5.ioc.annotations.Inject;

import com.formos.tapestry.testify.internal.ObjectsForComponentsStore;


/**
 * Marks a field as containing a value that should be injected into any Tapestry pages/components
 * rather than the usual value that Tapestry would provide.
 *
 * @see Inject
 */
@Target( { FIELD })
@Retention(RetentionPolicy.RUNTIME)
public @interface ForComponents {
    /**
     * If a component field has the {@link Service} annotation to differentiate different services
     * with the same interface, set this value to the service id and the test object will
     * be injected into that field.
     * 
     * @return a service id (or the special string {@link ObjectsForComponentsStore#NO_ID})
     */
    String value()   default ObjectsForComponentsStore.NO_ID;
}
