/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import net.sf.saxon.Version;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.XPathException;

public abstract class RegexFunction
extends SystemFunction {
    private RegularExpression staticRegex;

    public RegularExpression getStaticRegex() {
        return this.staticRegex;
    }

    private void tryToBindRegularExpression(Expression[] arguments) {
        if (arguments[1] instanceof Literal && arguments[arguments.length - 1] instanceof Literal) {
            try {
                String hostLang;
                String re = ((Literal)arguments[1]).getValue().getStringValue();
                String flags = ((Literal)arguments[arguments.length - 1]).getValue().getStringValue();
                String string = hostLang = this.getRetainedStaticContext().getXPathVersion() >= 30 ? "XP30" : "XP20";
                if (this.getRetainedStaticContext().getConfiguration().getXsdVersion() == 11) {
                    hostLang = hostLang + "/XSD11";
                }
                ArrayList<String> warnings = new ArrayList<String>(1);
                this.staticRegex = Version.platform.compileRegularExpression(re, flags, hostLang, warnings);
                if (!this.allowRegexMatchingEmptyString() && this.staticRegex.matches("")) {
                    this.staticRegex = null;
                }
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
    }

    protected abstract boolean allowRegexMatchingEmptyString();

    public Expression makeFunctionCall(Expression ... arguments) {
        this.tryToBindRegularExpression(arguments);
        return super.makeFunctionCall(arguments);
    }

    protected RegularExpression getRegularExpression(Sequence[] args) throws XPathException {
        String hostLang;
        if (this.staticRegex != null) {
            return this.staticRegex;
        }
        String re = args[1].head().getStringValue();
        String flags = args[args.length - 1].head().getStringValue();
        String string = hostLang = this.getRetainedStaticContext().getXPathVersion() >= 30 ? "XP30" : "XP20";
        if (this.getRetainedStaticContext().getConfiguration().getXsdVersion() == 11) {
            hostLang = hostLang + "/XSD11";
        }
        ArrayList<String> warnings = new ArrayList<String>(1);
        RegularExpression regex = Version.platform.compileRegularExpression(re, flags, hostLang, warnings);
        if (!this.allowRegexMatchingEmptyString() && regex.matches("")) {
            throw new XPathException("The regular expression must not be one that matches a zero-length string", "FORX0003");
        }
        return regex;
    }
}

