/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public class SerializeJsonFn
extends SystemFunction
implements Callable {
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        MapItem options = this.getArity() == 2 ? (MapItem)arguments[1].head() : new HashTrieMap(context);
        return this.evalSerializeJson(arguments[0], options, context);
    }

    private StringValue evalSerializeJson(Sequence value, MapItem options, XPathContext context) throws XPathException {
        Sequence fv;
        Flags flags = new Flags();
        flags.escape = SerializeJsonFn.getBooleanOption(options, "escape", context, true);
        flags.indent = SerializeJsonFn.getBooleanOption(options, "indent", context, false);
        String spec = SerializeJsonFn.getOption(options, "spec", context, "RFC4627");
        if (spec != null) {
            flags.spec = spec;
        }
        if ((fv = options.get(new StringValue("fallback"))) != null) {
            GroundedValue fvv = SequenceTool.toGroundedValue(fv);
            if (fvv.getLength() != 1) {
                throw new XPathException("fallback option in serialize-json() call must be a single item", "FOJS0002");
            }
            Item fvi = fvv.head();
            if (fvi instanceof Function) {
                flags.fallback = (Function)fvi;
            } else {
                throw new XPathException("fallback option in serialize-json() call must be a function item", "FOJS0002");
            }
        }
        FastStringBuffer buffer = new FastStringBuffer(256);
        this.writeSequence(value, flags, buffer, context);
        return new StringValue(buffer.condense());
    }

    private void writeSequence(Sequence value, Flags flags, FastStringBuffer buffer, XPathContext context) throws XPathException {
        GroundedValue val = SequenceTool.toGroundedValue(value);
        if (val.getLength() == 0) {
            this.testTopLevel(flags);
            buffer.append("null");
        } else if (val.getLength() == 1) {
            this.writeItem(SequenceTool.asItem(val), flags, buffer, context);
        } else {
            Item member;
            SequenceIterator iter = value.iterate();
            buffer.append('[');
            this.indent(flags, buffer);
            boolean first = true;
            while ((member = iter.next()) != null) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                    this.nextline(flags, buffer);
                }
                this.writeItem(member, flags, buffer, context);
            }
            this.outdent(flags, buffer);
            buffer.append(']');
        }
    }

    private static String getOption(MapItem options, String option, XPathContext context, String defaultValue) throws XPathException {
        StringValue ov = new StringValue(option);
        Sequence opt = options.get(ov);
        if (opt == null) {
            return defaultValue;
        }
        try {
            Item val = SequenceTool.asItem(opt);
            return val.getStringValue();
        }
        catch (Exception err) {
            throw new XPathException("Value of " + option + " option must be an xs:string", "FOJS0002");
        }
    }

    private static boolean getBooleanOption(MapItem options, String option, XPathContext context, boolean defaultValue) throws XPathException {
        StringValue ov = new StringValue(option);
        Sequence opt = options.get(ov);
        if (opt == null) {
            return defaultValue;
        }
        try {
            Item val = SequenceTool.asItem(opt);
            return ((BooleanValue)val).getBooleanValue();
        }
        catch (Exception err) {
            throw new XPathException("Value of " + option + " option must be an xs:boolean", "FOJS0002");
        }
    }

    private void writeItem(Item input, Flags flags, FastStringBuffer buffer, XPathContext context) throws XPathException {
        SequenceExtent value;
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        if (input == null) {
            this.testTopLevel(flags);
            buffer.append("null");
            return;
        }
        if (input instanceof BooleanValue) {
            this.testTopLevel(flags);
            buffer.append(((BooleanValue)input).getBooleanValue() ? "true" : "false");
            return;
        }
        if (input instanceof NumericValue) {
            this.testTopLevel(flags);
            String s = input.getStringValue();
            if (s.equals("NaN") || s.equals("INF") || s.equals("-INF")) {
                buffer.append('\"');
                buffer.append(s);
                buffer.append('\"');
            } else {
                buffer.append(s);
            }
            return;
        }
        if (input instanceof StringValue && !(input instanceof AnyURIValue)) {
            this.testTopLevel(flags);
            this.escape(input.getStringValue(), flags, buffer);
            return;
        }
        if (input instanceof MapItem) {
            if (((MapItem)input).get(IntegerValue.MINUS_ONE) != null) {
                this.writeArray((MapItem)input, flags, buffer, context);
                return;
            }
            if (((MapItem)input).size() == 0) {
                buffer.append("{}");
                return;
            }
            AtomicType keyType = ((MapItem)input).getKeyType();
            if (keyType.equals(BuiltInAtomicType.INTEGER)) {
                this.writeArray((MapItem)input, flags, buffer, context);
                return;
            }
            if (keyType.equals(BuiltInAtomicType.STRING)) {
                this.writeMap((MapItem)input, flags, buffer, context);
                return;
            }
        }
        if (flags.fallback != null) {
            AtomicType keyType;
            Item iValue;
            Sequence result = flags.fallback.call(context, new Sequence[]{input});
            value = new SequenceExtent(result.iterate());
            if (!(value.getLength() != 1 || (iValue = SequenceTool.asItem(value)) instanceof StringValue || iValue instanceof NumericValue || iValue instanceof BooleanValue || iValue instanceof MapItem && ((keyType = ((MapItem)iValue).getKeyType()).equals(BuiltInAtomicType.INTEGER) || keyType.equals(BuiltInAtomicType.STRING)))) {
                throw new XPathException("No JSON mapping defined for fallback value " + UType.getUType(input), "FOJS0002");
            }
        } else {
            throw new XPathException("No JSON mapping defined for " + UType.getUType(input), "FOJS0002");
        }
        this.writeSequence(value, flags, buffer, context);
    }

    private void testTopLevel(Flags flags) throws XPathException {
        if (flags.depth == 0 && flags.spec.equals("RFC4627")) {
            throw new XPathException("Top level item in RFC 4627 JSON structure must be an object or array", "FOJS0002");
        }
    }

    private void escape(String string, Flags flags, FastStringBuffer buffer) {
        buffer.append('\"');
        if (flags.escape) {
            block9: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\"': {
                        buffer.append("\\\"");
                        continue block9;
                    }
                    case '\\': {
                        buffer.append("\\\\");
                        continue block9;
                    }
                    case '\b': {
                        buffer.append("\\b");
                        continue block9;
                    }
                    case '\f': {
                        buffer.append("\\f");
                        continue block9;
                    }
                    case '\n': {
                        buffer.append("\\n");
                        continue block9;
                    }
                    case '\r': {
                        buffer.append("\\r");
                        continue block9;
                    }
                    case '\t': {
                        buffer.append("\\t");
                        continue block9;
                    }
                    default: {
                        if (UTF16CharacterSet.isSurrogate(c)) {
                            buffer.append("\\u");
                            buffer.append(Integer.toHexString(c));
                            continue block9;
                        }
                        buffer.append(c);
                    }
                }
            }
        } else {
            buffer.append(string);
        }
        buffer.append('\"');
    }

    private void writeArray(MapItem input, Flags flags, FastStringBuffer buffer, XPathContext context) throws XPathException {
        buffer.append('[');
        this.indent(flags, buffer);
        long max = Long.MIN_VALUE;
        for (KeyValuePair pair : input) {
            long val = ((IntegerValue)pair.key).longValue();
            if (val == 0L || val < -1L) {
                throw new XPathException("Cannot serialize a map with non-positive integer keys", "FOJS0002");
            }
            if (val <= max) continue;
            max = val;
        }
        for (long k = 1L; k <= max; ++k) {
            Int64Value key;
            Sequence val;
            if (k != 1L) {
                buffer.append(',');
                this.nextline(flags, buffer);
            }
            if ((val = input.get(key = Int64Value.makeIntegerValue(k))) == null) {
                buffer.append("null");
                continue;
            }
            this.writeSequence(val, flags, buffer, context);
        }
        this.outdent(flags, buffer);
        buffer.append(']');
    }

    private void writeMap(MapItem input, Flags flags, FastStringBuffer buffer, XPathContext context) throws XPathException {
        buffer.append('{');
        this.indent(flags, buffer);
        boolean first = true;
        for (KeyValuePair pair : input) {
            if (!(pair.key instanceof StringValue)) {
                throw new XPathException("Key in map must be a string");
            }
            if (first) {
                first = false;
            } else {
                buffer.append(',');
                this.nextline(flags, buffer);
            }
            this.escape(pair.key.getStringValue(), flags, buffer);
            if (flags.indent) {
                buffer.append(" : ");
            } else {
                buffer.append(':');
            }
            this.writeSequence(pair.value, flags, buffer, context);
        }
        this.outdent(flags, buffer);
        buffer.append('}');
    }

    public void indent(Flags flags, FastStringBuffer buffer) {
        ++flags.depth;
        if (flags.indent) {
            buffer.append('\n');
            flags.indentation += 2;
            for (int i = 0; i < flags.indentation; ++i) {
                buffer.append(' ');
            }
        }
    }

    public void nextline(Flags flags, FastStringBuffer buffer) {
        if (flags.indent) {
            buffer.append('\n');
            for (int i = 0; i < flags.indentation; ++i) {
                buffer.append(' ');
            }
        }
    }

    public void outdent(Flags flags, FastStringBuffer buffer) {
        if (flags.indent) {
            buffer.append('\n');
            flags.indentation -= 2;
            for (int i = 0; i < flags.indentation; ++i) {
                buffer.append(' ');
            }
        }
        --flags.depth;
    }

    private static class Flags {
        public boolean escape = true;
        public boolean indent = false;
        public String spec = "RFC4627";
        public Function fallback = null;
        public int indentation = 0;
        public int depth = 0;

        private Flags() {
        }
    }
}

