/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.PseudoExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.Current;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.MultipleNodeKindTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.PatternParser;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.PrependIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pattern
extends PseudoExpression {
    private double priority = 0.5;

    public static Pattern make(String pattern, StaticContext env, PackageData packageData) throws XPathException {
        int languageLevel = 20;
        if (packageData.getXPathVersion() >= 30 && env.getXPathVersion() >= 30) {
            languageLevel = 30;
        }
        int lineNumber = env instanceof ExpressionContext ? ((ExpressionContext)env).getStyleElement().getLineNumber() : -1;
        PatternParser parser = (PatternParser)((Object)env.getConfiguration().newExpressionParser("PATTERN", false, languageLevel));
        ((XPathParser)((Object)parser)).setLanguage(1, env.getXPathVersion());
        Pattern pat = parser.parsePattern(pattern, env, lineNumber);
        pat.setRetainedStaticContext(env.makeRetainedStaticContext());
        pat.setOriginalText(pattern);
        pat = pat.simplify();
        return pat;
    }

    protected static void replaceCurrent(Expression exp, LocalBinding binding) {
        for (Operand o : exp.operands()) {
            Expression child = o.getChildExpression();
            if (child.isCallOn(Current.class)) {
                LocalVariableReference ref = new LocalVariableReference(binding);
                o.setChildExpression(ref);
                continue;
            }
            Pattern.replaceCurrent(child, binding);
        }
    }

    public void bindCurrent(LocalBinding binding) {
    }

    public void setOriginalText(String text) {
    }

    @Override
    public Pattern simplify() throws XPathException {
        return this;
    }

    @Override
    public Pattern typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        return this;
    }

    @Override
    public int getDependencies() {
        return 0;
    }

    public Iterator<Expression> iterateSubExpressions() {
        List list = Collections.emptyList();
        return list.iterator();
    }

    public int allocateSlots(SlotManager slotManager, int nextFree) {
        return nextFree;
    }

    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
    }

    public boolean isMotionless(boolean allowExtensions) {
        return true;
    }

    @Override
    public final boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.matches(context.getContextItem(), context);
    }

    public abstract boolean matches(Item var1, XPathContext var2) throws XPathException;

    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        return this.matches(node, context);
    }

    public SequenceIterator selectNodes(TreeInfo document, final XPathContext context) throws XPathException {
        NodeInfo doc = document.getRootNode();
        UType uType = this.getUType();
        if (UType.DOCUMENT.subsumes(uType)) {
            if (this.matches(doc, context)) {
                return SingletonIterator.makeIterator(doc);
            }
            return EmptyIterator.getInstance();
        }
        if (UType.ATTRIBUTE.subsumes(uType)) {
            AxisIterator allElements = doc.iterateAxis((byte)4, NodeKindTest.ELEMENT);
            MappingFunction<NodeInfo, NodeInfo> atts = new MappingFunction<NodeInfo, NodeInfo>(){

                @Override
                public SequenceIterator map(NodeInfo item) {
                    return item.iterateAxis((byte)2);
                }
            };
            MappingIterator<NodeInfo, NodeInfo> allAttributes = new MappingIterator<NodeInfo, NodeInfo>(allElements, atts);
            ItemMappingFunction<NodeInfo, NodeInfo> test = new ItemMappingFunction<NodeInfo, NodeInfo>(){

                @Override
                public NodeInfo mapItem(NodeInfo item) throws XPathException {
                    if (Pattern.this.matches(item, context)) {
                        return item;
                    }
                    return null;
                }
            };
            return new ItemMappingIterator<NodeInfo, NodeInfo>(allAttributes, test);
        }
        if (UType.NAMESPACE.subsumes(uType)) {
            AxisIterator allElements = doc.iterateAxis((byte)4, NodeKindTest.ELEMENT);
            MappingFunction<NodeInfo, NodeInfo> atts = new MappingFunction<NodeInfo, NodeInfo>(){

                @Override
                public SequenceIterator map(NodeInfo item) {
                    return item.iterateAxis((byte)8);
                }
            };
            MappingIterator<NodeInfo, NodeInfo> allNamespaces = new MappingIterator<NodeInfo, NodeInfo>(allElements, atts);
            ItemMappingFunction<NodeInfo, NodeInfo> test = new ItemMappingFunction<NodeInfo, NodeInfo>(){

                @Override
                public NodeInfo mapItem(NodeInfo item) throws XPathException {
                    if (Pattern.this.matches(item, context)) {
                        return item;
                    }
                    return null;
                }
            };
            return new ItemMappingIterator<NodeInfo, NodeInfo>(allNamespaces, test);
        }
        if (UType.CHILD_NODE_KINDS.subsumes(uType)) {
            AxisIterator allChildren = doc.iterateAxis((byte)4, new MultipleNodeKindTest(uType));
            ItemMappingFunction test = new ItemMappingFunction(){

                public Item mapItem(Item item) throws XPathException {
                    if (Pattern.this.matches(item, context)) {
                        return item;
                    }
                    return null;
                }
            };
            return new ItemMappingIterator(allChildren, test);
        }
        AxisIterator allChildren = doc.iterateAxis((byte)4);
        MappingFunction<NodeInfo, NodeInfo> attsOrSelf = new MappingFunction<NodeInfo, NodeInfo>(){

            @Override
            public SequenceIterator map(NodeInfo item) {
                return new PrependIterator(item, item.iterateAxis((byte)2));
            }
        };
        MappingIterator<NodeInfo, NodeInfo> attributesOrSelf = new MappingIterator<NodeInfo, NodeInfo>(allChildren, attsOrSelf);
        ItemMappingFunction test = new ItemMappingFunction(){

            public Item mapItem(Item item) throws XPathException {
                if (Pattern.this.matches(item, context)) {
                    return item;
                }
                return null;
            }
        };
        return new ItemMappingIterator(attributesOrSelf, test);
    }

    public abstract UType getUType();

    public int getFingerprint() {
        return -1;
    }

    @Override
    public abstract ItemType getItemType();

    public void setPriority(double priority) {
        this.priority = priority;
    }

    public double getDefaultPriority() {
        return this.priority;
    }

    @Override
    public String toString() {
        return "pattern matching " + this.getItemType().toString();
    }

    @Override
    public int getHostLanguage() {
        return 50;
    }

    public Pattern convertToTypedPattern(String val) throws XPathException {
        return null;
    }

    @Override
    public abstract void export(ExpressionPresenter var1) throws XPathException;

    @Override
    public abstract Pattern copy();

    @Override
    public Pattern optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        return this;
    }
}

