/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceExpression
extends Instruction
implements InstructionInfo {
    private Operand baseOp;
    private StructuredQName objectName;
    private int constructType;
    private NamespaceResolver namespaceResolver = null;
    private HashMap<String, Object> properties = new HashMap(10);

    public TraceExpression(Expression child) {
        this.baseOp = new Operand(this, child, OperandRole.SAME_FOCUS_ACTION);
        this.setProperty("expression", child);
    }

    public Expression getChild() {
        return this.baseOp.getChildExpression();
    }

    public void setChild(Expression child) {
        this.baseOp.setChildExpression(child);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.baseOp;
    }

    public void setConstructType(int type) {
        this.constructType = type;
    }

    @Override
    public int getConstructType() {
        return this.constructType;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void setObjectName(StructuredQName qName) {
        this.objectName = qName;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.objectName;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Iterator<String> getProperties() {
        return this.properties.keySet().iterator();
    }

    public InstructionInfo getInstructionInfo() {
        return this;
    }

    @Override
    public Expression copy() {
        TraceExpression t = new TraceExpression(this.getChild().copy());
        ExpressionTool.copyLocationInfo(this, t);
        t.objectName = this.objectName;
        t.namespaceResolver = this.namespaceResolver;
        t.constructType = this.constructType;
        return t;
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.getChild().isUpdatingExpression();
    }

    @Override
    public boolean isVacuousExpression() {
        return this.getChild().isVacuousExpression();
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        this.getChild().checkForUpdatingSubexpressions();
    }

    @Override
    public int getImplementationMethod() {
        return this.getChild().getImplementationMethod();
    }

    @Override
    public Expression promote(PromotionOffer offer) throws XPathException {
        Expression newChild = this.getChild().promote(offer);
        if (newChild != this.getChild()) {
            this.setChild(newChild);
            this.adoptChildExpression(this.getChild());
            return this;
        }
        return this;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        TraceListener listener = controller.getTraceListener();
        if (controller.isTracing()) {
            assert (listener != null);
            listener.enter(this.getInstructionInfo(), context);
        }
        this.getChild().process(context);
        if (controller.isTracing()) {
            assert (listener != null);
            listener.leave(this.getInstructionInfo());
        }
        return null;
    }

    @Override
    public ItemType getItemType() {
        return this.getChild().getItemType();
    }

    @Override
    public int getCardinality() {
        return this.getChild().getCardinality();
    }

    @Override
    public int getDependencies() {
        return this.getChild().getDependencies();
    }

    @Override
    public final boolean createsNewNodes() {
        return (this.getChild().getSpecialProperties() & 0x400000) == 0;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), context);
        }
        Item result = this.getChild().evaluateItem(context);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
        return result;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), context);
        }
        SequenceIterator result = this.getChild().iterate(context);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
        return result;
    }

    @Override
    public int getInstructionNameCode() {
        if (this.getChild() instanceof Instruction) {
            return ((Instruction)this.getChild()).getInstructionNameCode();
        }
        return -1;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        this.getChild().export(out);
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), context);
        }
        this.getChild().evaluatePendingUpdates(context, pul);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
    }

    @Override
    public int getColumnNumber() {
        return this.getLocation().getColumnNumber();
    }

    @Override
    public String getPublicId() {
        return this.getLocation().getPublicId();
    }

    @Override
    public int getLineNumber() {
        return this.getLocation().getLineNumber();
    }

    @Override
    public Location saveLocation() {
        return this;
    }
}

