/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SingleItemFilter;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.NumericValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptExpression
extends SingleItemFilter {
    private Operand subscriptOp;

    public SubscriptExpression(Expression base, Expression subscript) {
        super(base);
        this.subscriptOp = new Operand(this, subscript, OperandRole.SINGLE_ATOMIC);
    }

    public Expression getSubscript() {
        return this.subscriptOp.getChildExpression();
    }

    public void setSubscript(Expression subscript) {
        this.subscriptOp.setChildExpression(subscript);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.optimizeChildren(visitor, contextInfo);
        if (Literal.isConstantOne(this.getSubscript())) {
            return FirstItemExpression.makeFirstItemExpression(this.getBaseExpression());
        }
        return this;
    }

    @Override
    public Expression copy() {
        SubscriptExpression exp = new SubscriptExpression(this.getBaseExpression().copy(), this.getSubscript().copy());
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.getOperand(), this.subscriptOp);
    }

    public Expression getSubscriptExpression() {
        return this.getSubscript();
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof SubscriptExpression && this.getBaseExpression().equals(((SubscriptExpression)other).getBaseExpression()) && this.getSubscript() == ((SubscriptExpression)other).getSubscript();
    }

    @Override
    public int hashCode() {
        return this.getBaseExpression().hashCode() ^ this.getSubscript().hashCode();
    }

    @Override
    public int computeCardinality() {
        return 24576;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        NumericValue index = (NumericValue)this.getSubscript().evaluateItem(context);
        if (index == null) {
            return null;
        }
        if (index.compareTo(Integer.MAX_VALUE) <= 0 && index.isWholeNumber()) {
            Item item;
            int intindex = (int)index.longValue();
            if (intindex < 1) {
                return null;
            }
            SequenceIterator iter = this.getBaseExpression().iterate(context);
            if (intindex == 1) {
                item = iter.next();
            } else if (iter instanceof MemoClosure.ProgressiveIterator) {
                MemoClosure mem = ((MemoClosure.ProgressiveIterator)iter).getMemoClosure();
                item = mem.itemAt(intindex - 1);
            } else if ((iter.getProperties() & 1) != 0) {
                GroundedValue value = ((GroundedIterator)iter).materialize();
                item = value.itemAt(intindex - 1);
            } else {
                SequenceIterator tail = TailIterator.make(iter, intindex);
                item = tail.next();
                tail.close();
            }
            return item;
        }
        return null;
    }

    @Override
    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("subscript", this);
        this.getBaseExpression().export(destination);
        this.getSubscript().export(destination);
        destination.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.getBaseExpression()) + "[" + this.getSubscript().toString() + "]";
    }
}

