/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.net.URI;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.lib.ErrorGatherer;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.StaticError;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltPackage;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.PackageVersion;
import net.sf.saxon.style.PackageVersionRanges;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.XSLTTraceCodeInjector;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.IPackageLoader;
import net.sf.saxon.trans.PackageLibrary;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.value.NestedIntegerValue;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltCompiler {
    private Processor processor;
    private Configuration config;
    private CompilerInfo compilerInfo;

    protected XsltCompiler(Processor processor) {
        this.processor = processor;
        this.config = processor.getUnderlyingConfiguration();
        this.compilerInfo = new CompilerInfo(this.config.getDefaultXsltCompilerInfo());
        this.compilerInfo.setGenerateByteCode(this.config.isGenerateByteCode(50));
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setURIResolver(URIResolver resolver) {
        this.compilerInfo.setURIResolver(resolver);
    }

    public void setParameter(QName name, XdmValue value) {
        this.compilerInfo.setParameter(name.getStructuredQName(), value.getUnderlyingValue());
    }

    public void clearParameters() {
        this.compilerInfo.clearParameters();
    }

    public URIResolver getURIResolver() {
        return this.compilerInfo.getURIResolver();
    }

    public void setErrorListener(ErrorListener listener) {
        this.compilerInfo.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.compilerInfo.getErrorListener();
    }

    public void setSchemaAware(boolean schemaAware) {
        this.compilerInfo.setSchemaAware(schemaAware);
    }

    public boolean isSchemaAware() {
        return this.compilerInfo.isSchemaAware();
    }

    public void declareCollation(String uri, Collator collation) {
        this.getProcessor().declareCollation(uri, collation);
    }

    public void declareDefaultCollation(String uri) {
        StringCollator c;
        try {
            c = this.getProcessor().getUnderlyingConfiguration().getCollation(uri);
        }
        catch (XPathException e) {
            c = null;
        }
        if (c == null) {
            throw new IllegalStateException("Unknown collation " + uri);
        }
        this.compilerInfo.setDefaultCollation(uri);
    }

    public String getDefaultCollation() {
        return this.compilerInfo.getDefaultCollation();
    }

    public void setXsltLanguageVersion(String version) {
        int v = 0;
        if ("2.0".equals(version)) {
            v = 20;
        } else if ("3.0".equals(version)) {
            v = 30;
        } else if ("0.0".equals(version)) {
            v = 0;
        } else {
            throw new IllegalArgumentException("XSLT version must be 0.0, 2.0, or 3.0");
        }
        this.compilerInfo.setXsltVersion(v);
    }

    public String getXsltLanguageVersion() {
        int v = this.compilerInfo.getXsltVersion();
        switch (v) {
            case 0: {
                return "0.0";
            }
            case 20: {
                return "2.0";
            }
            case 30: {
                return "3.0";
            }
        }
        return "" + v;
    }

    public boolean isAssertionsEnabled() {
        return this.compilerInfo.isAssertionsEnabled();
    }

    public void setAssertionsEnabled(boolean enabled) {
        this.compilerInfo.setAssertionsEnabled(enabled);
    }

    public void setCompileWithTracing(boolean option) {
        if (option) {
            this.compilerInfo.setCodeInjector(new XSLTTraceCodeInjector());
        } else {
            this.compilerInfo.setCodeInjector(null);
        }
    }

    public boolean isCompileWithTracing() {
        return this.compilerInfo.isCompileWithTracing();
    }

    public void setGenerateByteCode(boolean option) {
        this.compilerInfo.setGenerateByteCode(option);
    }

    public boolean isGenerateByteCode() {
        return this.compilerInfo.isGenerateByteCode();
    }

    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws SaxonApiException {
        try {
            return StylesheetModule.getAssociatedStylesheet(this.config, this.compilerInfo.getURIResolver(), source, media, title, charset);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XsltPackage compilePackage(Source source) throws SaxonApiException {
        try {
            Compilation compilation = source instanceof DocumentImpl && ((DocumentImpl)source).getDocumentElement() instanceof StyleElement ? ((StyleElement)((DocumentImpl)source).getDocumentElement()).getCompilation() : new Compilation(this.config, this.compilerInfo);
            XsltPackage pack = new XsltPackage(this.processor, compilation.compilePackage(source).getStylesheetPackage());
            if (compilation.getErrorCount() > 0) {
                throw new SaxonApiException("Package compilation failed: " + compilation.getErrorCount() + " errors reported");
            }
            return pack;
        }
        catch (XPathException e) {
            throw new SaxonApiException(e.getMessage());
        }
    }

    public void newPackageLibrary() {
        this.compilerInfo.setPackageLibrary(new PackageLibrary());
    }

    public PackageLibrary getPackageLibrary() {
        return this.compilerInfo.getPackageLibrary();
    }

    public void setPackageLibrary(PackageLibrary packageLibrary) {
        this.compilerInfo.setPackageLibrary(packageLibrary);
    }

    public Iterable<XsltPackage> compilePackages(Iterable<Source> sources) throws SaxonApiException, XPathException {
        Compilation compilation = new Compilation(this.config, this.compilerInfo);
        this.compilerInfo.setPackageLibrary(new PackageLibrary());
        ArrayList<XsltPackage> result = new ArrayList<XsltPackage>();
        ArrayList<PackDepends> depends = new ArrayList<PackDepends>();
        for (Source s : sources) {
            DocumentImpl document = StylesheetModule.loadStylesheetModule(s, true, compilation, NestedIntegerValue.TWO);
            ElementImpl packageElement = document.getDocumentElement();
            String packageName = packageElement.getAttributeValue("", "name");
            if (packageName == null) {
                throw new SaxonApiException("Outermost element must be an xsl:package element with a name attribute");
            }
            depends.add(new PackDepends(document));
        }
        for (PackDepends p : this.resolveDependencies(depends)) {
            XsltPackage packagei = this.compilePackage(p.doc);
            this.compilerInfo.getPackageLibrary().addPackage(packagei.getName(), packagei.getUnderlyingPreparedPackage());
            result.add(packagei);
        }
        return result;
    }

    public Iterable<XsltPackage> addCompilePackages(Iterable<Source> sources, boolean link) throws SaxonApiException, XPathException {
        Compilation compilation = new Compilation(this.config, this.compilerInfo);
        ArrayList<XsltPackage> result = new ArrayList<XsltPackage>();
        ArrayList<PackDepends> depends = new ArrayList<PackDepends>();
        for (Source s : sources) {
            DocumentImpl document = StylesheetModule.loadStylesheetModule(s, true, compilation, NestedIntegerValue.TWO);
            ElementImpl packageElement = document.getDocumentElement();
            String packageName = packageElement.getAttributeValue("", "name");
            if (packageName == null) {
                throw new SaxonApiException("Outermost element must be an xsl:package element with a name attribute");
            }
            depends.add(new PackDepends(document));
        }
        PackageLibrary pl = this.compilerInfo.getPackageLibrary();
        ArrayList<PackDepends> resolved = this.resolveDependencies(depends);
        for (PackDepends p : resolved) {
            if (p.doc == null) continue;
            XsltPackage packagei = this.compilePackage(p.doc);
            pl.addPackage(packagei.getName(), packagei.getUnderlyingPreparedPackage());
            if (link) {
                packagei.link();
            }
            result.add(packagei);
        }
        return result;
    }

    ArrayList<PackDepends> resolveDependencies(ArrayList<PackDepends> in) throws SaxonApiException {
        ArrayList<PackDepends> resolved = new ArrayList<PackDepends>();
        this.resolveDependencies(in, resolved);
        return resolved;
    }

    private void resolveDependencies(ArrayList<PackDepends> in, ArrayList<PackDepends> resolved) throws SaxonApiException {
        if (in.isEmpty()) {
            return;
        }
        ArrayList<PackDepends> unresolved = new ArrayList<PackDepends>();
        boolean changed = false;
        for (PackDepends p : in) {
            if (this.allDependenciesSatisfied(p, resolved)) {
                resolved.add(p);
                changed = true;
                continue;
            }
            unresolved.add(p);
        }
        if (!changed) {
            String message = "Unable to resolve package dependencies for " + unresolved.get((int)0).packageName;
            throw new SaxonApiException(message);
        }
        this.resolveDependencies(unresolved, resolved);
    }

    private boolean allDependenciesSatisfied(PackDepends packDepends, List<PackDepends> resolved) {
        PackageLibrary lib = this.getPackageLibrary();
        for (UsePack u : packDepends.uses) {
            boolean found = false;
            if (lib.getPackage(u.packageName, u.ranges) != null) continue;
            for (PackDepends pd : resolved) {
                if (!pd.packageName.equals(u.packageName) || !u.ranges.contains(pd.packageVersion)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public XsltPackage loadLibraryPackage(URI location) throws SaxonApiException {
        try {
            StreamSource input = new StreamSource(location.toString());
            IPackageLoader loader = this.processor.getUnderlyingConfiguration().makePackageLoader();
            if (loader != null) {
                StylesheetPackage pack = loader.loadPackage(input);
                return new XsltPackage(this.processor, pack);
            }
            throw new SaxonApiException("Loading library package requires Saxon PE or higher");
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XsltExecutable loadExecutablePackage(URI location) throws SaxonApiException {
        return this.loadLibraryPackage(location).link();
    }

    public void importPackage(XsltPackage thePackage) throws SaxonApiException {
        if (thePackage.getProcessor() != this.processor) {
            throw new SaxonApiException("The imported package and the XsltCompiler must belong to the same Processor");
        }
        this.compilerInfo.getPackageLibrary().addPackage(thePackage.getName(), thePackage.getUnderlyingPreparedPackage());
    }

    public XsltExecutable compile(Source source) throws SaxonApiException {
        try {
            PreparedStylesheet pss = Compilation.compileSingletonPackage(this.config, this.compilerInfo, source);
            return new XsltExecutable(this.processor, pss);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public CompilerInfo getUnderlyingCompilerInfo() {
        return this.compilerInfo;
    }

    public void setErrorList(List<StaticError> errorList) {
        this.compilerInfo.setErrorListener(new ErrorGatherer(errorList));
    }

    private class UsePack {
        String packageName;
        PackageVersionRanges ranges;

        UsePack(NodeInfo current) throws XPathException {
            this.packageName = Whitespace.trim(current.getAttributeValue("", "name"));
            String pvr = Whitespace.trim(current.getAttributeValue("", "package-version"));
            this.ranges = new PackageVersionRanges(pvr == null ? "*" : pvr);
        }
    }

    private class PackDepends {
        DocumentImpl doc;
        StylesheetPackage pack;
        String packageName;
        PackageVersion packageVersion;
        ArrayList<UsePack> uses;

        PackDepends(StylesheetPackage p) {
            this.pack = p;
            this.packageName = p.getPackageName();
            this.packageVersion = p.getPackageVersion();
        }

        PackDepends(DocumentImpl d) throws XPathException {
            NodeInfo current;
            this.doc = d;
            ElementImpl packageElement = this.doc.getDocumentElement();
            this.packageName = packageElement.getAttributeValue("", "name");
            String pv = packageElement.getAttributeValue("", "package-version");
            this.packageVersion = pv == null ? PackageVersion.ONE_ZERO : new PackageVersion(pv);
            this.uses = new ArrayList();
            AxisIterator iter = this.doc.iterateAxis((byte)4, new NameTest(1, 204, XsltCompiler.this.config.getNamePool()));
            while ((current = iter.next()) != null) {
                this.uses.add(new UsePack(current));
            }
        }

        boolean equals(UsePack u) {
            return u.packageName.equals(this.packageName) && u.ranges.contains(this.packageVersion);
        }
    }
}

