/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.Configuration;
import net.sf.saxon.functions.Nilled_1;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.UType;

public class ContentTypeTest
extends NodeTest {
    private int kind;
    private SchemaType schemaType;
    private Configuration config;
    private boolean nillable = false;

    public ContentTypeTest(int nodeKind, SchemaType schemaType, Configuration config, boolean nillable) {
        this.kind = nodeKind;
        this.schemaType = schemaType;
        this.config = config;
        this.nillable = nillable;
    }

    public UType getUType() {
        return this.kind == 1 ? UType.ELEMENT : UType.ATTRIBUTE;
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public int getNodeKind() {
        return this.kind;
    }

    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        return this.kind == nodeKind && this.matchesAnnotation(annotation);
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        return this.kind == tree.getNodeKind(nodeNr) && this.matchesAnnotation(tree.getSchemaType(nodeNr)) && (this.nillable || !tree.isNilled(nodeNr));
    }

    public boolean matchesNode(NodeInfo node) {
        return node.getNodeKind() == this.kind && this.matchesAnnotation(node.getSchemaType()) && (this.nillable || !Nilled_1.isNilled(node));
    }

    private boolean matchesAnnotation(SchemaType annotation) {
        if (this.schemaType == AnyType.getInstance()) {
            return true;
        }
        if (annotation.equals(this.schemaType)) {
            return true;
        }
        if (annotation == null) {
            return false;
        }
        int r = this.config.getTypeHierarchy().schemaTypeRelationship(annotation, this.schemaType);
        return r == 0 || r == 2;
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getPrimitiveType() {
        return this.kind;
    }

    public int getNodeKindMask() {
        return 1 << this.kind;
    }

    public SchemaType getContentType() {
        return this.schemaType;
    }

    public AtomicType getAtomizedItemType() {
        SchemaType type = this.schemaType;
        try {
            if (type.isAtomicType()) {
                return (AtomicType)type;
            }
            if (type instanceof ListType) {
                SimpleType mem = ((ListType)type).getItemType();
                if (mem.isAtomicType()) {
                    return (AtomicType)mem;
                }
            } else if (type instanceof ComplexType && ((ComplexType)type).isSimpleContent()) {
                SimpleType mem;
                SimpleType ctype = ((ComplexType)type).getSimpleContentType();
                assert (ctype != null);
                if (ctype.isAtomicType()) {
                    return (AtomicType)ctype;
                }
                if (ctype instanceof ListType && (mem = ((ListType)ctype).getItemType()).isAtomicType()) {
                    return (AtomicType)mem;
                }
            }
        }
        catch (MissingComponentException e) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public boolean isAtomizable() {
        return !this.schemaType.isComplexType() || ((ComplexType)this.schemaType).getVariety() != 2;
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
        visitor.visitSchemaComponent(this.schemaType);
    }

    public String toString() {
        return (this.kind == 1 ? "element(*, " : "attribute(*, ") + this.schemaType.getEQName() + ')';
    }

    public int hashCode() {
        return this.kind << 20 ^ this.schemaType.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ContentTypeTest && ((ContentTypeTest)other).kind == this.kind && ((ContentTypeTest)other).schemaType == this.schemaType && ((ContentTypeTest)other).nillable == this.nillable;
    }
}

