/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.IAccumulatorRegistry;
import net.sf.saxon.trans.KeyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageData {
    protected Configuration config;
    private int hostLanguage;
    private int xPathVersion;
    private boolean isSchemaAware;
    private DecimalFormatManager decimalFormatManager = null;
    protected KeyManager keyManager = null;
    private IAccumulatorRegistry accumulatorRegistry = null;
    private List<GlobalVariable> globalVariables = new ArrayList<GlobalVariable>();
    private SlotManager globalSlotManager = new SlotManager();
    private int localLicenseId = -1;

    public PackageData(Configuration config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int hostLanguage) {
        this.hostLanguage = hostLanguage;
    }

    public void setXPathVersion(int version) {
        this.xPathVersion = version;
    }

    public int getXPathVersion() {
        return this.xPathVersion;
    }

    public void setLocalLicenseId(int id) {
        this.localLicenseId = id;
    }

    public int getLocalLicenseId() {
        return this.localLicenseId;
    }

    public boolean isSchemaAware() {
        return this.isSchemaAware;
    }

    public void setSchemaAware(boolean schemaAware) {
        this.isSchemaAware = schemaAware;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager(this.hostLanguage, this.xPathVersion);
        }
        return this.decimalFormatManager;
    }

    public void setDecimalFormatManager(DecimalFormatManager manager) {
        this.decimalFormatManager = manager;
    }

    public KeyManager getKeyManager() {
        if (this.keyManager == null) {
            this.keyManager = new KeyManager(this.getConfiguration(), this);
        }
        return this.keyManager;
    }

    public void setKeyManager(KeyManager manager) {
        this.keyManager = manager;
    }

    public IAccumulatorRegistry getAccumulatorRegistry() {
        return this.accumulatorRegistry;
    }

    public void setAccumulatorRegistry(IAccumulatorRegistry accumulatorRegistry) {
        this.accumulatorRegistry = accumulatorRegistry;
    }

    public SlotManager getGlobalSlotManager() {
        return this.globalSlotManager;
    }

    public void setGlobalSlotManager(SlotManager manager) {
        this.globalSlotManager = manager;
    }

    public void addGlobalVariable(GlobalVariable variable) {
        this.globalVariables.add(variable);
    }

    public List<GlobalVariable> getGlobalVariableList() {
        return this.globalVariables;
    }
}

