/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.tree.util.Navigator;

public class AttributeLocation
implements Location {
    String systemId;
    int lineNumber;
    int columnNumber;
    StructuredQName elementName;
    StructuredQName attributeName;

    public AttributeLocation(NodeInfo element, StructuredQName attributeName) {
        this.systemId = element.getSystemId();
        this.lineNumber = element.getLineNumber();
        this.columnNumber = element.getColumnNumber();
        this.elementName = Navigator.getNodeName(element);
        this.attributeName = attributeName;
    }

    public AttributeLocation(StructuredQName elementName, StructuredQName attributeName, Location location) {
        this.systemId = location.getSystemId();
        this.lineNumber = location.getLineNumber();
        this.columnNumber = location.getColumnNumber();
        this.elementName = elementName;
        this.attributeName = attributeName;
    }

    public StructuredQName getElementName() {
        return this.elementName;
    }

    public StructuredQName getAttributeName() {
        return this.attributeName;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Location saveLocation() {
        return this;
    }
}

