/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GlobalVariableReference;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLTStaticContext;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.AttributeLocation;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionContext
implements XSLTStaticContext {
    private StyleElement element;
    private StructuredQName attributeName;
    private Location containingLocation = null;
    private NamespaceResolver namespaceResolver = null;
    private RetainedStaticContext retainedStaticContext = null;

    public ExpressionContext(StyleElement styleElement, StructuredQName attributeName) {
        this.element = styleElement;
        this.attributeName = attributeName;
    }

    @Override
    public Configuration getConfiguration() {
        return this.element.getConfiguration();
    }

    @Override
    public StylesheetPackage getPackageData() {
        return this.element.getPackageData();
    }

    public boolean isSchemaAware() {
        return this.element.isSchemaAware();
    }

    @Override
    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration());
    }

    @Override
    public RetainedStaticContext makeRetainedStaticContext() {
        if (this.retainedStaticContext == null) {
            this.retainedStaticContext = this.element.changesRetainedStaticContext() || !(this.element.getParent() instanceof StyleElement) ? new RetainedStaticContext(this) : ((StyleElement)this.element.getParent()).getStaticContext().makeRetainedStaticContext();
        }
        return this.retainedStaticContext;
    }

    @Override
    public Location getContainingLocation() {
        if (this.containingLocation == null) {
            this.containingLocation = new AttributeLocation(this.element, this.attributeName);
        }
        return this.containingLocation;
    }

    @Override
    public void issueWarning(String s, Location locator) {
        this.element.issueWarning(new XPathException(s, "SXWN9000", locator));
    }

    @Override
    public String getSystemId() {
        return this.element.getSystemId();
    }

    @Override
    public String getStaticBaseURI() {
        return this.element.getBaseURI();
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        if (this.namespaceResolver == null) {
            this.namespaceResolver = this.element.makeNamespaceContext();
        }
        return this.namespaceResolver;
    }

    @Override
    public ItemType getRequiredContextItemType() {
        return AnyItemType.getInstance();
    }

    @Override
    public DecimalFormatManager getDecimalFormatManager() {
        return this.element.getCompilation().getPrincipalStylesheetModule().getDecimalFormatManager();
    }

    @Override
    public Expression bindVariable(StructuredQName qName) throws XPathException {
        SourceBinding xslVariableDeclaration = this.element.bindVariable(qName);
        if (xslVariableDeclaration == null) {
            AxisIterator catchers;
            StyleElement catcher;
            if (qName.hasURI("http://www.w3.org/1999/XSL/Transform") && qName.getLocalPart().equals("original")) {
                this.element.getXslOriginal(206);
                return new GlobalVariableReference(qName);
            }
            SymbolicName sn = new SymbolicName(206, qName);
            Component comp = this.element.getCompilation().getPrincipalStylesheetModule().getComponent(sn);
            if (comp != null && comp.getDeclaringPackage() != this.element.getContainingPackage()) {
                GlobalVariable var = (GlobalVariable)comp.getCode();
                GlobalVariableReference vref = new GlobalVariableReference(var);
                vref.setStaticType(var.getRequiredType(), null, 0);
                return vref;
            }
            if (this.getXPathVersion() >= 30 && qName.hasURI("http://www.w3.org/2005/xqt-errors") && (catcher = (StyleElement)(catchers = this.element.iterateAxis((byte)1, new NameTest(1, 139, this.element.getNamePool()))).next()) != null) {
                for (StructuredQName errorVariable : StandardNames.errorVariables) {
                    if (!errorVariable.getLocalPart().equals(qName.getLocalPart())) continue;
                    VendorFunctionLibrary lib = this.getConfiguration().getVendorFunctionLibrary();
                    StructuredQName functionName = new StructuredQName("saxon", "http://saxon.sf.net/", "dynamic-error-info");
                    SymbolicName fsn = new SymbolicName(158, functionName, 1);
                    Expression[] args = new Expression[]{new StringLiteral(qName.getLocalPart())};
                    return lib.bind(fsn, args, this);
                }
            }
            XPathException err = new XPathException("Variable " + qName.getDisplayName() + " has not been declared (or its declaration is not in scope)");
            err.setErrorCode("XPST0008");
            err.setIsStaticError(true);
            throw err;
        }
        if (xslVariableDeclaration.hasProperty(8192)) {
            return new SuppliedParameterReference(0);
        }
        VariableReference var = xslVariableDeclaration.hasProperty(2) ? new GlobalVariableReference(qName) : new LocalVariableReference(qName);
        xslVariableDeclaration.registerReference(var);
        return var;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        FunctionLibraryList lib = this.element.getContainingPackage().getFunctionLibrary();
        StyleElement containingOverride = this.element.findAncestorElement(186);
        if (containingOverride != null) {
            FunctionLibraryList libList = new FunctionLibraryList();
            libList.addFunctionLibrary(lib);
            containingOverride.addXSLOverrideFunctionLibrary(libList);
            return libList;
        }
        return lib;
    }

    @Override
    public boolean isElementAvailable(String qname) throws XPathException {
        try {
            String[] parts = NameChecker.getQNameParts(qname);
            String uri = parts[0].isEmpty() ? this.getDefaultElementNamespace() : this.element.getURIForPrefix(parts[0], false);
            return this.element.getCompilation().getStyleNodeFactory(true).isElementAvailable(uri, parts[1], true);
        }
        catch (QNameException e) {
            XPathException err = new XPathException("Invalid element name. " + e.getMessage());
            err.setErrorCode("XTDE1440");
            throw err;
        }
    }

    @Override
    public String getDefaultCollationName() {
        return this.element.getDefaultCollationName();
    }

    @Override
    public String getDefaultElementNamespace() {
        return this.element.getDefaultXPathNamespace();
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return "http://www.w3.org/2005/xpath-functions";
    }

    @Override
    public boolean isInBackwardsCompatibleMode() {
        return this.element.xPath10ModeIsEnabled();
    }

    @Override
    public int getXPathVersion() {
        return this.element.getPackageData().getXPathVersion();
    }

    @Override
    public boolean isImportedSchema(String namespace) {
        return this.element.getPrincipalStylesheetModule().isImportedSchema(namespace);
    }

    @Override
    public Set<String> getImportedSchemaNamespaces() {
        return this.element.getPrincipalStylesheetModule().getImportedSchemaTable();
    }

    @Override
    public KeyManager getKeyManager() {
        return this.element.getCompilation().getPrincipalStylesheetModule().getKeyManager();
    }

    public StyleElement getStyleElement() {
        return this.element;
    }
}

