/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.ArrayList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class ArraySubarray
extends ExtensionFunctionDefinition {
    private static final StructuredQName name = new StructuredQName("array", "http://www.w3.org/2005/xpath-functions/array", "subarray");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{ArrayItem.SINGLE_ARRAY_TYPE, SequenceType.SINGLE_INTEGER, SequenceType.SINGLE_INTEGER};

    public StructuredQName getFunctionQName() {
        return name;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 3;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return ArrayItem.SINGLE_ARRAY_TYPE;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                ArrayItem array = (ArrayItem)arguments[0].head();
                assert (array != null);
                int start = (int)((IntegerValue)arguments[1].head()).longValue();
                int length = arguments.length == 3 ? (int)((IntegerValue)arguments[2].head()).longValue() : array.size() - start + 1;
                if (start < 1) {
                    throw new XPathException("Start position is less than one", "FOAY0001");
                }
                if (length < 0) {
                    throw new XPathException("Specified length of subarray is less than zero", "FOAY0002");
                }
                if (start + length > array.size() + 1) {
                    throw new XPathException("Specified length of subarray is too great for start position given", "FOAY0001");
                }
                ArrayList<Sequence> list = new ArrayList<Sequence>(1);
                for (int i = 0; i < length; ++i) {
                    list.add(array.get(start - 1 + i));
                }
                return new SimpleArrayItem(list);
            }
        };
    }
}

