/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.oper.OperandArray;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayBlock
extends Expression {
    private OperandArray operanda;

    public ArrayBlock(List<Expression> children) {
        Expression[] kids = children.toArray(new Expression[children.size()]);
        this.setOperanda(new OperandArray((Expression)this, kids, OperandRole.SAME_FOCUS_ACTION));
    }

    protected void setOperanda(OperandArray operanda) {
        this.operanda = operanda;
    }

    public OperandArray getOperanda() {
        return this.operanda;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operanda.operands();
    }

    @Override
    public String getExpressionName() {
        return "arrayBlock";
    }

    @Override
    public int computeSpecialProperties() {
        return 0;
    }

    private boolean mayReturnTypedNodes(TypeHierarchy th) {
        for (Operand o : this.operands()) {
            ItemType it;
            Expression exp = o.getChildExpression();
            if ((exp.getSpecialProperties() & 0x4000000) != 0 || th.relationship(it = exp.getItemType(), NodeKindTest.ELEMENT) == 4 && th.relationship(it, NodeKindTest.ATTRIBUTE) == 4 && th.relationship(it, NodeKindTest.ATTRIBUTE) == 4) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ArrayBlock)) {
            return false;
        }
        ArrayBlock ab2 = (ArrayBlock)other;
        if (ab2.getOperanda().getNumberOfOperands() != this.getOperanda().getNumberOfOperands()) {
            return false;
        }
        for (int i = 0; i < this.getOperanda().getNumberOfOperands(); ++i) {
            if (this.getOperanda().getOperand(i).equals(ab2.getOperanda().getOperand(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = -2020896096;
        for (Operand o : this.operands()) {
            h ^= o.getChildExpression().hashCode();
        }
        return h;
    }

    @Override
    public Expression copy() {
        ArrayList<Expression> m2 = new ArrayList<Expression>(this.getOperanda().getNumberOfOperands());
        for (Operand o : this.operands()) {
            m2.add(o.getChildExpression().copy());
        }
        ArrayBlock b2 = new ArrayBlock(m2);
        ExpressionTool.copyLocationInfo(this, b2);
        return b2;
    }

    @Override
    public final ItemType getItemType() {
        return ArrayItemType.ANY_ARRAY_TYPE;
    }

    @Override
    public final int computeCardinality() {
        return 16384;
    }

    public final boolean createsNewNodes() {
        for (Operand o : this.operands()) {
            int props = o.getChildExpression().getSpecialProperties();
            if ((props & 0x400000) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void export(ExpressionPresenter out) {
        out.startElement("arrayBlock", this);
        for (Operand o : this.operands()) {
            o.getChildExpression().export(out);
        }
        out.endElement();
    }

    @Override
    public String toShortString() {
        if (this.getOperanda().getNumberOfOperands() == 0) {
            return "[]";
        }
        return "[" + this.getOperanda().getOperand(0).getChildExpression().toShortString() + ", ...]";
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        ArrayList<Sequence> value = new ArrayList<Sequence>(this.getOperanda().getNumberOfOperands());
        for (Operand o : this.operands()) {
            Sequence s = ExpressionTool.eagerEvaluate(o.getChildExpression(), context);
            value.add(s);
        }
        return new SimpleArrayItem(value);
    }
}

