/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SystemProperty
extends SystemFunction
implements Callable {
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue name = (StringValue)arguments[0].head();
        try {
            boolean is30 = this.getRetainedStaticContext().getXPathVersion() >= 30;
            StructuredQName qName = StructuredQName.fromLexicalQName(name.getStringValue(), false, is30, this.getRetainedStaticContext());
            return new StringValue(SystemProperty.getProperty(qName.getURI(), qName.getLocalPart(), this.getRetainedStaticContext()));
        }
        catch (XPathException err) {
            throw new XPathException("Invalid system property name. " + err.getMessage(), "XTDE1390", context);
        }
    }

    public static String getProperty(String uri, String local, RetainedStaticContext rsc) {
        Configuration config = rsc.getConfiguration();
        if (uri.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (local.equals("version")) {
                return rsc.getXPathVersion() >= 30 ? "3.0" : "2.0";
            }
            if (local.equals("vendor")) {
                return Version.getProductVendor();
            }
            if (local.equals("vendor-url")) {
                return Version.getWebSiteAddress();
            }
            if (local.equals("product-name")) {
                return Version.getProductName();
            }
            if (local.equals("product-version")) {
                return Version.getProductVariantAndVersion(rsc.getConfiguration());
            }
            if (local.equals("is-schema-aware")) {
                boolean schemaAware = rsc.getPackageData().isSchemaAware();
                return schemaAware ? "yes" : "no";
            }
            if (local.equals("supports-serialization")) {
                return "yes";
            }
            if (local.equals("supports-backwards-compatibility")) {
                return "yes";
            }
            if (local.equals("supports-namespace-axis")) {
                return "yes";
            }
            if (local.equals("supports-streaming")) {
                return rsc.getXPathVersion() >= 30 && config.isLicensedFeature(2) && !config.getConfigurationProperty("http://saxon.sf.net/feature/streamability").equals("off") ? "yes" : "no";
            }
            if (local.equals("supports-dynamic-evaluation")) {
                return rsc.getXPathVersion() >= 30 && config.isLicensedFeature(8) ? "yes" : "no";
            }
            if (local.equals("supports-higher-order-functions")) {
                return rsc.getXPathVersion() >= 30 && config.isLicensedFeature(8) ? "yes" : "no";
            }
            if (local.equals("xpath-version")) {
                String v = rsc.getXPathVersion() + "";
                return v.charAt(0) + "." + v.charAt(1);
            }
            if (local.equals("xsd-version")) {
                return rsc.getConfiguration().getXsdVersion() == 10 ? "1.0" : "1.1";
            }
            return "";
        }
        if (uri.isEmpty() && config.getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions")) {
            String val = System.getProperty(local);
            return val == null ? "" : val;
        }
        return "";
    }
}

