/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Arrays;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.om.AbstractItem;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

public abstract class AbstractFunction
extends AbstractItem
implements Function {
    public OperandRole[] getOperandRoles() {
        Object[] roles = new OperandRole[this.getArity()];
        Arrays.fill(roles, new OperandRole(0, OperandUsage.NAVIGATION));
        return roles;
    }

    public AtomicSequence atomize() throws XPathException {
        throw new XPathException("Function items (other than arrays) cannot be atomized", "FOTY0013");
    }

    public boolean isArray() {
        return false;
    }

    public boolean isMap() {
        return false;
    }

    public String getStringValue() {
        throw new UnsupportedOperationException("The string value of a function is not defined");
    }

    public CharSequence getStringValueCS() {
        throw new UnsupportedOperationException("The string value of a function is not defined");
    }

    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("A function has no effective boolean value", "XPTY0004");
    }

    public void simplify() throws XPathException {
    }

    public void typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
    }

    public void optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
    }

    public boolean deepEquals(Function other, XPathContext context, AtomicComparer comparer, int flags) throws XPathException {
        throw new XPathException("Argument to deep-equal() contains a function item", "FOTY0015");
    }

    public void export(ExpressionPresenter out) {
        out.startElement("abstractFunction");
        out.emitAttribute("class", this.getClass().getSimpleName());
        if (this.getFunctionName() != null) {
            out.emitAttribute("name", this.getFunctionName());
        }
        out.emitAttribute("arity", this.getArity() + "");
        out.endElement();
    }
}

