/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CastToList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class CastableToList
extends UnaryExpression {
    private ListType targetType;
    private boolean allowEmpty;

    public CastableToList(Expression source, ListType targetType, boolean allowEmpty) {
        super(source);
        this.targetType = targetType;
        this.allowEmpty = allowEmpty;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public ListType getTargetType() {
        return this.targetType;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        boolean maybeUntyped;
        this.typeCheckChildren(visitor, contextInfo);
        SequenceType atomicType = SequenceType.makeSequenceType(BuiltInAtomicType.STRING, this.allowEmpty ? 24576 : 16384);
        RoleDiagnostic role = new RoleDiagnostic(2, "castable as", 0);
        Expression operand = TypeChecker.staticTypeCheck(this.getBaseExpression(), atomicType, false, role, visitor);
        this.setBaseExpression(operand);
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        boolean maybeString = th.relationship(operand.getItemType(), BuiltInAtomicType.STRING) != 4;
        boolean bl = maybeUntyped = th.relationship(operand.getItemType(), BuiltInAtomicType.UNTYPED_ATOMIC) != 4;
        if (!maybeString && !maybeUntyped) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        if (operand instanceof Literal) {
            GroundedValue literalOperand = ((Literal)operand).getValue();
            if (literalOperand instanceof AtomicValue) {
                return Literal.makeLiteral(BooleanValue.get(this.effectiveBooleanValue(visitor.getStaticContext().makeEarlyEvaluationContext())));
            }
            if (literalOperand.getLength() == 0) {
                return Literal.makeLiteral(BooleanValue.get(this.allowEmpty));
            }
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        Expression e2 = super.optimize(visitor, contextInfo);
        if (e2 != this) {
            return e2;
        }
        if (!Cardinality.allowsZero(this.getBaseExpression().getCardinality())) {
            this.allowEmpty = false;
            this.resetLocalStaticProperties();
        }
        return this;
    }

    public int computeCardinality() {
        return 16384;
    }

    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy() {
        CastableToList c = new CastableToList(this.getBaseExpression().copy(), this.targetType, this.allowEmpty);
        ExpressionTool.copyLocationInfo(this, c);
        return c;
    }

    public int getImplementationMethod() {
        return 1;
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        AtomicValue value = (AtomicValue)this.getBaseExpression().evaluateItem(context);
        if (value == null) {
            return this.allowEmpty;
        }
        try {
            CastToList.cast(value.getStringValue(), this.targetType, this.getRetainedStaticContext(), context.getConfiguration().getConversionRules());
            return true;
        }
        catch (XPathException err) {
            return false;
        }
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.targetType == ((CastableToList)other).targetType && this.allowEmpty == ((CastableToList)other).allowEmpty;
    }

    public int hashCode() {
        return super.hashCode() ^ this.targetType.hashCode();
    }

    public String toString() {
        return this.getBaseExpression().toString() + " castable as " + this.targetType.getEQName();
    }

    public void export(ExpressionPresenter out) {
        out.startElement("castableToList", this);
        out.emitAttribute("as", this.targetType.toString());
        this.getBaseExpression().export(out);
        out.endElement();
    }
}

