/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.TypeCheckerEnvironment;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionVisitor
implements TypeCheckerEnvironment {
    private Stack<Expression> expressionStack = new Stack();
    private StaticContext staticContext;
    private Configuration configuration;
    private boolean optimizeForStreaming = false;

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Stack<Expression> getExpressionStack() {
        return this.expressionStack;
    }

    public void setExpressionStack(Stack<Expression> expressionStack) {
        this.expressionStack = expressionStack;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public Expression getCurrentExpression() {
        return this.expressionStack.peek();
    }

    public static ExpressionVisitor make(StaticContext env) {
        ExpressionVisitor visitor = new ExpressionVisitor();
        visitor.setStaticContext(env);
        visitor.setConfiguration(env.getConfiguration());
        return visitor;
    }

    @Override
    public void issueWarning(String message, SourceLocator locator) {
        this.staticContext.issueWarning(message, locator);
    }

    @Override
    public XPathContext makeDynamicContext() {
        return this.staticContext.makeEarlyEvaluationContext();
    }

    @Override
    public Expression simplify(Expression exp) throws XPathException {
        if (exp != null) {
            Expression exp2 = exp.simplify(this);
            if (exp2 != exp) {
                ExpressionTool.copyLocationInfo(exp, exp2);
            }
            return exp2;
        }
        return null;
    }

    @Override
    public Expression typeCheck(Expression exp, ContextItemStaticInfo contextInfo) throws XPathException {
        if (exp != null) {
            Expression exp2;
            this.expressionStack.push(exp);
            try {
                exp2 = exp.typeCheck(this, contextInfo);
            }
            catch (XPathException e) {
                if (!e.isReportableStatically()) {
                    this.getStaticContext().issueWarning("Evaluation will always throw a dynamic error: " + e.getMessage(), exp);
                    exp2 = new ErrorExpression(e);
                }
                throw e;
            }
            if (exp2 != exp) {
                ExpressionTool.copyLocationInfo(exp, exp2);
            }
            this.expressionStack.pop();
            return exp2;
        }
        return null;
    }

    public void setOptimizeForStreaming(boolean option) {
        this.optimizeForStreaming = option;
    }

    public boolean isOptimizeForStreaming() {
        return this.optimizeForStreaming;
    }

    public Expression optimize(Expression exp, ContextItemStaticInfo contextItemType) throws XPathException {
        if (exp != null) {
            this.expressionStack.push(exp);
            Expression exp2 = null;
            try {
                exp2 = exp.optimize(this, contextItemType);
            }
            catch (XPathException e) {
                if (!e.isReportableStatically()) {
                    this.getStaticContext().issueWarning("Evaluation will always throw a dynamic error: " + e.getMessage(), exp);
                    exp2 = new ErrorExpression(e);
                }
                throw e;
            }
            if (exp2 != exp) {
                ExpressionTool.copyLocationInfo(exp, exp2);
            }
            this.expressionStack.pop();
            return exp2;
        }
        return null;
    }

    public Expression getParentExpression() {
        int pos = this.expressionStack.size() - 2;
        if (pos > 0) {
            return (Expression)this.expressionStack.get(pos);
        }
        return null;
    }

    public boolean isLoopingSubexpression(Expression ancestor) {
        int top = this.expressionStack.size() - 1;
        while (top > 0) {
            Expression parent = (Expression)this.expressionStack.get(top - 1);
            if (ExpressionVisitor.hasLoopingSubexpression(parent, (Expression)this.expressionStack.get(top))) {
                return true;
            }
            if (parent == ancestor) {
                return false;
            }
            --top;
        }
        return false;
    }

    public boolean isLoopingReference(Binding binding, VariableReference ref) {
        int top = this.expressionStack.size() - 1;
        while (top > 0) {
            Expression parent = (Expression)this.expressionStack.get(top - 1);
            if (parent instanceof FLWORExpression) {
                if (parent.hasVariableBinding(binding)) {
                    return ((FLWORExpression)parent).hasLoopingVariableReference(binding);
                }
                if (ExpressionVisitor.hasLoopingSubexpression(parent, (Expression)this.expressionStack.get(top))) {
                    return true;
                }
            } else {
                if (parent.getExpressionName().equals("tryCatch")) {
                    return true;
                }
                Expression child = (Expression)this.expressionStack.get(top);
                if (parent instanceof ForEachGroup && parent.hasVariableBinding(binding)) {
                    return false;
                }
                if (ExpressionVisitor.hasLoopingSubexpression(parent, (Expression)this.expressionStack.get(top))) {
                    return true;
                }
                if (parent instanceof Instruction && ((Instruction)parent).getInstructionNameCode() == 164 && ExpressionVisitor.childHasDifferentFocus(parent, child)) {
                    return true;
                }
                if (parent.hasVariableBinding(binding)) {
                    return false;
                }
            }
            --top;
        }
        return true;
    }

    private static boolean hasLoopingSubexpression(Expression parent, Expression child) {
        for (Operand info : parent.operands()) {
            if (info.getExpression() != child) continue;
            return info.isEvaluatedRepeatedly();
        }
        return false;
    }

    private static boolean childHasDifferentFocus(Expression parent, Expression child) {
        for (Operand o : parent.operands()) {
            if (o.getExpression() != child || o.hasSameFocus()) continue;
            return true;
        }
        return false;
    }

    public final void resetStaticProperties() {
        for (Expression exp : this.expressionStack) {
            exp.resetLocalStaticProperties();
        }
    }
}

