/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.number.NumberFormatter;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberInstruction
extends Expression {
    private static final int SINGLE = 0;
    private static final int MULTI = 1;
    private static final int ANY = 2;
    private static final int SIMPLE = 3;
    private static final int SELECT = 0;
    private static final int VALUE = 1;
    private static final int FORMAT = 2;
    private static final int GROUP_SIZE = 3;
    private static final int GROUP_SEPARATOR = 4;
    private static final int LETTER_VALUE = 5;
    private static final int ORDINAL = 6;
    private static final int START_AT = 7;
    private static final int LANG = 8;
    private Expression[] subExpressions = new Expression[9];
    private int level;
    private Pattern count = null;
    private Pattern from = null;
    private NumberFormatter formatter = null;
    private Numberer numberer = null;
    private boolean hasVariablesInPatterns;
    private boolean backwardsCompatible;

    public NumberInstruction(Expression select, int level, Pattern count, Pattern from, Expression value, Expression format, Expression groupSize, Expression groupSeparator, Expression letterValue, Expression ordinal, Expression startAt, Expression lang, NumberFormatter formatter, Numberer numberer, boolean hasVariablesInPatterns, boolean backwardsCompatible) {
        this.subExpressions[0] = select;
        this.subExpressions[1] = value;
        this.subExpressions[2] = format;
        this.subExpressions[3] = groupSize;
        this.subExpressions[4] = groupSeparator;
        this.subExpressions[5] = letterValue;
        this.subExpressions[6] = ordinal;
        this.subExpressions[7] = startAt;
        this.subExpressions[8] = lang;
        this.level = level;
        this.count = count;
        this.from = from;
        this.formatter = formatter;
        this.numberer = numberer;
        this.hasVariablesInPatterns = hasVariablesInPatterns;
        this.backwardsCompatible = backwardsCompatible;
        if (this.subExpressions[1] != null && !this.subExpressions[1].getItemType().isPlainType()) {
            this.subExpressions[1] = Atomizer.makeAtomizer(this.subExpressions[1]);
        }
        for (Operand o : this.operands()) {
            this.adoptChildExpression(o.getExpression());
        }
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        for (int i = 0; i < this.subExpressions.length; ++i) {
            if (this.subExpressions[i] == null) continue;
            this.subExpressions[i] = visitor.typeCheck(this.subExpressions[i], contextInfo);
        }
        if (this.subExpressions[0] == null && this.subExpressions[1] == null) {
            XPathException err = null;
            if (contextInfo == null || contextInfo.getItemType() == null) {
                err = new XPathException("xsl:number requires a select attribute, a value attribute, or a context item");
            } else if (contextInfo.getItemType().isPlainType()) {
                err = new XPathException("xsl:number requires the context item to be a node, but it is an atomic value");
            }
            if (err != null) {
                err.setIsTypeError(true);
                err.setErrorCode("XTTE0990");
                err.setLocator(this);
                throw err;
            }
        }
        if (this.count != null) {
            visitor.typeCheck(new PatternSponsor(this.count), contextInfo);
        }
        if (this.from != null) {
            visitor.typeCheck(new PatternSponsor(this.from), contextInfo);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        for (int i = 0; i < this.subExpressions.length; ++i) {
            if (this.subExpressions[i] == null) continue;
            this.subExpressions[i] = visitor.optimize(this.subExpressions[i], contextInfo);
        }
        return this;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> sub = new ArrayList<Operand>(9);
        for (Expression subExpression : this.subExpressions) {
            if (subExpression == null) continue;
            sub.add(new Operand(subExpression, OperandRole.SINGLE_ATOMIC));
        }
        if (this.count != null) {
            sub.add(new Operand(new PatternSponsor(this.count), OperandRole.INSPECT));
        }
        if (this.from != null) {
            sub.add(new Operand(new PatternSponsor(this.from), OperandRole.INSPECT));
        }
        return sub;
    }

    @Override
    public Expression copy() {
        return new NumberInstruction(this.copy(this.subExpressions[0]), this.level, this.count, this.from, this.copy(this.subExpressions[1]), this.copy(this.subExpressions[2]), this.copy(this.subExpressions[3]), this.copy(this.subExpressions[4]), this.copy(this.subExpressions[5]), this.copy(this.subExpressions[6]), this.copy(this.subExpressions[7]), this.copy(this.subExpressions[8]), this.formatter, this.numberer, this.hasVariablesInPatterns, this.backwardsCompatible);
    }

    private Expression copy(Expression exp) {
        return exp == null ? null : exp.copy();
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        for (int i = 0; i < this.subExpressions.length; ++i) {
            if (this.subExpressions[i] != original) continue;
            this.subExpressions[i] = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int getIntrinsicDependencies() {
        return this.subExpressions[0] == null ? 2 : 0;
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.STRING;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        for (int i = 0; i < this.subExpressions.length; ++i) {
            if (this.subExpressions[i] == null) continue;
            this.subExpressions[i] = this.doPromotion(this.subExpressions[i], offer);
        }
        if (this.count != null) {
            this.count.promote(offer, this);
        }
        if (this.from != null) {
            this.from.promote(offer, this);
        }
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        NumberFormatter nf;
        String letterVal;
        long startValue;
        long value = -1L;
        List<Object> vec = null;
        ConversionRules rules = context.getConfiguration().getConversionRules();
        String startAv = this.subExpressions[7].evaluateAsString(context).toString();
        try {
            startValue = Integer.parseInt(startAv);
        }
        catch (NumberFormatException e) {
            XPathException err = new XPathException("Value of start-at attribute must be an integer", "XTDE1001");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        --startValue;
        if (this.subExpressions[1] != null) {
            AtomicValue val;
            SequenceIterator iter = this.subExpressions[1].iterate(context);
            vec = new ArrayList<String>(4);
            while ((val = (AtomicValue)iter.next()) != null && (!this.backwardsCompatible || vec.isEmpty())) {
                try {
                    NumericValue num = val instanceof NumericValue ? (NumericValue)val : NumberFn.convert(val, context.getConfiguration());
                    if (num.isNaN()) {
                        throw new XPathException("NaN");
                    }
                    if ((num = num.round(0)).compareTo(Int64Value.MAX_LONG) > 0) {
                        BigInteger bi = ((BigIntegerValue)Converter.convert(num, BuiltInAtomicType.INTEGER, rules).asAtomic()).asBigInteger();
                        if (startValue != 0L) {
                            bi = bi.add(BigInteger.valueOf(startValue));
                        }
                        vec.add(bi);
                        continue;
                    }
                    if (num.compareTo(Int64Value.ZERO) < 0) {
                        throw new XPathException("The numbers to be formatted must not be negative");
                    }
                    long i = ((NumericValue)Converter.convert(num, BuiltInAtomicType.INTEGER, rules).asAtomic()).longValue();
                    vec.add(i += startValue);
                }
                catch (XPathException err) {
                    if (this.backwardsCompatible) {
                        vec.add("NaN");
                        continue;
                    }
                    vec.add(val.getStringValue());
                    XPathException e = new XPathException("Cannot convert supplied value to an integer. " + err.getMessage());
                    e.setErrorCode("XTDE0980");
                    e.setLocator(this);
                    e.setXPathContext(context);
                    throw e;
                }
            }
            if (this.backwardsCompatible && vec.isEmpty()) {
                vec.add("NaN");
            }
        } else {
            Object item;
            NodeInfo source;
            if (this.subExpressions[0] != null) {
                source = (NodeInfo)this.subExpressions[0].evaluateItem(context);
            } else {
                item = context.getContextItem();
                if (!(item instanceof NodeInfo)) {
                    XPathException err = new XPathException("context item for xsl:number must be a node");
                    err.setErrorCode("XTTE0990");
                    err.setIsTypeError(true);
                    err.setXPathContext(context);
                    err.setLocator(this);
                    throw err;
                }
                source = (NodeInfo)item;
            }
            if (this.level == 3) {
                value = Navigator.getNumberSimple(source, context);
                value += startValue;
            } else if (this.level == 0) {
                value = Navigator.getNumberSingle(source, this.count, this.from, context);
                if (value == 0L) {
                    vec = Collections.emptyList();
                } else {
                    value += startValue;
                }
            } else if (this.level == 2) {
                value = Navigator.getNumberAny(this, source, this.count, this.from, context, this.hasVariablesInPatterns);
                if (value == 0L) {
                    vec = Collections.emptyList();
                } else {
                    value += startValue;
                }
            } else if (this.level == 1) {
                vec = new ArrayList();
                item = Navigator.getNumberMulti(source, this.count, this.from, context).iterator();
                while (item.hasNext()) {
                    long n = (Long)item.next();
                    vec.add(n + startValue);
                }
            }
        }
        int gpsize = 0;
        String gpseparator = "";
        String ordinalVal = null;
        if (this.subExpressions[3] != null) {
            String g = this.subExpressions[3].evaluateAsString(context).toString();
            try {
                gpsize = Integer.parseInt(g);
            }
            catch (NumberFormatException err) {
                XPathException e = new XPathException("grouping-size must be numeric");
                e.setXPathContext(context);
                e.setErrorCode("XTDE0030");
                e.setLocator(this);
                throw e;
            }
        }
        if (this.subExpressions[4] != null) {
            gpseparator = this.subExpressions[4].evaluateAsString(context).toString();
        }
        if (this.subExpressions[6] != null) {
            ordinalVal = this.subExpressions[6].evaluateAsString(context).toString();
        }
        if (vec == null && this.subExpressions[2] == null && gpsize == 0 && this.subExpressions[8] == null) {
            return new StringValue("" + value);
        }
        Numberer numb = this.numberer;
        if (numb == null) {
            String language = this.subExpressions[8].evaluateAsString(context).toString();
            ValidationFailure vf = StringConverter.STRING_TO_LANGUAGE.validate(language);
            if (vf != null) {
                throw new XPathException("The lang attribute of xsl:number must be a valid language code", "XTDE0030");
            }
            numb = context.getConfiguration().makeNumberer(language, null);
        }
        if (this.subExpressions[5] == null) {
            letterVal = "";
        } else {
            letterVal = this.subExpressions[5].evaluateAsString(context).toString();
            if (!"alphabetic".equals(letterVal) && !"traditional".equals(letterVal)) {
                XPathException e = new XPathException("letter-value must be \"traditional\" or \"alphabetic\"");
                e.setXPathContext(context);
                e.setErrorCode("XTDE0030");
                e.setLocator(this);
                throw e;
            }
        }
        if (vec == null) {
            vec = new ArrayList(1);
            vec.add(value);
        }
        if (this.formatter == null) {
            nf = new NumberFormatter();
            nf.prepare(this.subExpressions[2].evaluateAsString(context).toString());
        } else {
            nf = this.formatter;
        }
        CharSequence s = nf.format(vec, gpsize, gpseparator, letterVal, ordinalVal, numb);
        return new StringValue(s);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("xslNumber");
        out.emitAttribute("level", this.level == 2 ? "any" : (this.level == 0 ? "single" : "multi"));
        if (this.count != null) {
            out.emitAttribute("count", this.count.toString());
        }
        if (this.from != null) {
            out.emitAttribute("from", this.from.toString());
        }
        if (this.subExpressions[0] != null) {
            out.startSubsidiaryElement("select");
            this.subExpressions[0].explain(out);
            out.endSubsidiaryElement();
        }
        if (this.subExpressions[1] != null) {
            out.startSubsidiaryElement("value");
            this.subExpressions[1].explain(out);
            out.endSubsidiaryElement();
        }
        if (this.subExpressions[2] != null) {
            out.startSubsidiaryElement("format");
            this.subExpressions[2].explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }
}

