<?xml version="1.0" encoding="UTF-8"?>
          <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:math="http://www.w3.org/2005/xpath-functions/math" xmlns:map="http://www.w3.org/2005/xpath-functions/map" xmlns:doc="http://www.saxonica.com/ns/doc"
    xmlns:f="MyFunctions" xmlns:svg="http://www.w3.org/2000/svg" xmlns:jwl="http://jwlresearch.net/" xmlns:saxon="http://saxon.sf.net/"
    exclude-result-prefixes="xs math f doc" version="3.0">

    <xsl:import href="grid.xsl"/>
    <xsl:include href="svg-graphics.xsl"/>
    <xsl:include href="../lib/css2xslt.xsl"/>
    
    <xsl:variable name="USE-OLD-MAP" select="starts-with(system-property('xsl:product-version'),'9.6')" static="yes"/>
    <xsl:variable name="USE-NEW-MAP" select="not($USE-OLD-MAP)" static="yes"/>
    
    <xsl:variable name="width" as="xs:integer" select="1000"/>
    <xsl:variable name="height" as="xs:integer" select="500"/>

    <xsl:template name="svg:makeFile" expand-text="yes">
        <xsl:param name="svg.root" as="xs:string"/>
        <xsl:param name="name" as="xs:string"/>
        <xsl:param name="mode" as="xs:string"/>
        <xsl:param name="CSS.file" select="$CSS.file" tunnel="yes"/>
        <xsl:param name="g" as="map(*)"/>
        <xsl:param name="content" select="()"/>
        <xsl:param name="content.unscaled"/>
        <xsl:param name="date.stamp" as="xs:boolean" select="true()"/>
        <xsl:param name="width" as="xs:integer" select="$width"/>
        <xsl:param name="height" as="xs:integer" select="$height"/>
        <xsl:param name="margin" as="xs:integer" select="40"/>
        <xsl:variable name="margin.top"
            select="
                if ($date.stamp) then
                    $margin
                else
                    $margin div 2"/>
        <xsl:variable name="margin.left" select="$margin"/>
        <xsl:variable name="grid" select="($g('grid'),svg:makeGrid#3)[1]" as="function(*)" doc:doc="The default is a full grid"/>

        <xsl:variable name="svg" as="element()">
            <svg xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" viewBox="0 0 {xs:integer(1.1 * $width)} {xs:integer(1.15 *$height)}">
                <desc/>
                <xsl:if test="$date.stamp">
                    <text x="20" y="20" font-size="10">
                        <xsl:value-of select="current-dateTime()"/>
                    </text>
                </xsl:if>
                <g alignment-baseline="baseline" transform="translate({$margin.left},{$margin.top})">
                    <xsl:if test="exists($content)">
                        <xsl:sequence select="$grid($g, $width, $height)"/>
                    </xsl:if>
                    <g transform="translate({($g('label.x'),$width div 2)[1]},{($g('label.y'),$height div 2)[1]})">
                        <!--<text class="label" x="0" y="0">TEMPORARY TITLE</text>-->
                        <xsl:for-each select="$g('label')">
                            <text class="label" x="0" y="{20 * position()}">
                                <xsl:value-of select="."/>
                            </text>
                        </xsl:for-each>
                    </g>
                    <xsl:sequence select="$g('ABCDEF')"/>
                    <g>
                        <xsl:apply-templates select="$content" mode="svg:scale">
                            <xsl:with-param name="x.scale" select="$g('scale.x')" tunnel="yes"/>
                            <xsl:with-param name="y.scale" select="-$g('scale.y')" tunnel="yes"/>
                            <xsl:with-param name="y.offset" select="$height" tunnel="yes"/>
                        </xsl:apply-templates>
                        <!--<xsl:sequence select="$content"/>-->
                    </g>
                    <xsl:sequence select="$content.unscaled"/>
                </g>
            </svg>
        </xsl:variable>
        <xsl:variable name="stylesheet.attributes" as="attribute()*">
            <xsl:attribute name="xpath-default-namespace">http://www.w3.org/2000/svg</xsl:attribute>
        </xsl:variable>
        <xsl:variable name="compiled.css"
            select="jwl:compileCSS(resolve-uri($CSS.file, resolve-uri(concat($svg.root, '/modes/name/'), $base-uri)), $stylesheet.attributes)"/>
        <xsl:variable name="flat" select="saxon:transform($compiled.css, $svg)/*"/>

        <output href="{$svg.root}/modes/{f:modeFile($mode)}/{$name}.flat.svg"/>

        <xsl:result-document href="{$svg.root}/modes/{f:modeFile($mode)}/{$name}.flat.svg">
            <xsl:sequence select="$flat"/>
        </xsl:result-document>

        <xsl:result-document href="{$svg.root}/modes/{f:modeFile($mode)}/{$name}.svg">
            <xsl:processing-instruction name="xml-stylesheet">href="{$CSS.file}" type=""text/css"</xsl:processing-instruction>
            <xsl:sequence select="$svg"/>
        </xsl:result-document>
    </xsl:template>

    <xsl:function name="f:modeFile" as="xs:string" doc:doc="produce a safe filename from a mode name">
        <xsl:param name="mode" as="xs:string"/>
        <xsl:value-of select="replace($mode, '[:_#]+', '-')"/>
    </xsl:function>

    <xsl:function name="f:graphics.vals" as="map(*)">
        <xsl:param name="graphics"/>
        <xsl:sequence select="
                map:new((f:graphics.vals($graphics, $width, $height),
                $labelling.defaults))"/>
    </xsl:function>
    <xsl:function name="f:graphics.vals" as="map(*)">
        <xsl:param name="graphics"/>
        <xsl:param name="width" as="xs:double"/>
        <xsl:param name="height" as="xs:double"/>

        <xsl:variable name="max.y" select="xs:integer(svg:max.y($graphics))"/>
        <xsl:variable name="unit.y" select="max((svg:axis-minor-tick(0, $max.y),1))"/>
        <xsl:variable name="n.units.y" select="$max.y idiv $unit.y + 1"/>
        <xsl:variable name="max.y" select="$unit.y * $n.units.y"/>

        <xsl:variable name="max.x" select="xs:integer(svg:max.x($graphics))"/>
        <xsl:variable name="unit.x" select="max((svg:axis-minor-tick(0, $max.x),1))"/>
        <xsl:variable name="n.units.x" select="$max.x idiv $unit.x + 1"/>
        <xsl:variable name="max.x" select="$unit.x * $n.units.x"/>

        <xsl:variable name="scale.x" select="$width div $max.x"/>
        <xsl:variable name="scale.y" select="$height div $max.y"/>
        <xsl:sequence
            select="map{ 
            'scale.x' := $scale.x,
            'scale.y' := $scale.y,
            'max.x' := $max.x,
            'unit.x' := $unit.x,
            'n.units.x' := $n.units.x,
            'max.y' := $max.y,
            'unit.y' := $unit.y,
            'n.units.y' := $n.units.y      
            }"
            use-when="$USE-OLD-MAP"/>
        <xsl:sequence
            select="map{ 
                'scale.x' : $scale.x,
                'scale.y' : $scale.y,
                'max.x' : $max.x,
                'unit.x' : $unit.x,
                'n.units.x' : $n.units.x,
                'max.y' : $max.y,
                'unit.y' : $unit.y,
                'n.units.y' : $n.units.y      
                }"
            use-when="$USE-NEW-MAP"/>
    </xsl:function>

    <xsl:variable name="labelling.defaults"
        select="
        map{
        'axis.x.format':= format-number(?,'0'),
        'axis.y.format':= format-number(?,'0'),
        'axis.x.label' := '',
        'axis.y.label' := '',
        'label' := ''
        }"
        use-when="$USE-OLD-MAP"/>
    <xsl:variable name="labelling.defaults"
        select="
        map{
        'axis.x.format': format-number(?,'0'),
        'axis.y.format': format-number(?,'0'),
        'axis.x.label' : '',
        'axis.y.label' : '',
        'label' : ''
        }"
        use-when="$USE-NEW-MAP"/>
</xsl:stylesheet>
